{$I DEFINE.INC}

program DemoPal2;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program shows some easy-to-make palette effects.
  Palette effects are an easy way to create great-looking
  effects that require nearly no CPU time. }

uses FastVGA,FastFonts,FastGFX,Crt;

var Pal:PaletteType;

procedure MakeBackground;
 { This procedure draws the background used in
   the demo's first part, and sets up the
   palette used. Note that normally, you'll use
   calculations like these to draw the background
   and set the palette only once, and then save
   it to a .PCX file. }

 var x,y:Word;

 begin
  GetActivePalette (Pal,0,255);
  { We slide from dark red ... }
  Pal[64][RGBRed]:=20;
  Pal[64][RGBGreen]:=0;
  Pal[64][RGBBlue]:=0;
  { ... to orange ... }
  Pal[79][RGBRed]:=53;
  Pal[79][RGBGreen]:=32;
  Pal[79][RGBBlue]:=10;
  { ... and from orange ... }
  Pal[80]:=Pal[79];
  { ... to dark red again. }
  Pal[95]:=Pal[64];
  Gradient (Pal,64,79);
  Gradient (Pal,80,95);
  { Let's activate our changes: }
  SetActivePalette (Pal,64,95);  { Note that there's no need to update the
                                   entire active palette (0 thru 255) when
                                   we only changed part of it. That would
                                   be a waste of time ... }
  { Now, we do the actual drawing: }
  for y:=0 to 199 do   { Line after line ... }
   for x:=0 to 319 do   { Pixel after pixel ... }
    VGAScreen[y][x]:=64+(x mod 32);  { We range from 64 to 95. }
 end;

procedure ShadowWrite (x,y,c:Word; S:String);
 begin
  VGAColor:=0;  { First, we use black to draw the shadow. }
  FontWrite (x+1,y+1,S);
  VGAColor:=c; { And now, we use the normal color. }
  FontWrite (x,y,S);
 end;

var i,j:Word;

begin
 GoVGA256;

 MakeBackground;
 { For the wipe-out effect, we'll need
   the background image on Page 2, too: }
 CopyToPage2;

 SystemFontInit;
 ShadowWrite ( 40, 80,11,'Fast');
 ShadowWrite ( 76, 80, 3,'VGA');
 ShadowWrite (112, 80,15,'1.0');
 ShadowWrite ( 40,100,15,'makes this real easy ...');

 { Now that the image is ready,
   first we slide in one direction. }

 repeat
  SlidePalette (Pal,64,95);
  VSync;
  SetActivePalette (Pal,64,95);
 until KeyPressed;
 ReadKey;

 { Now we erase the text by copying
   the image stored in Page 2, while
   still cycling the palette: }

 for i:=40 to 270 do { Rough edges of text in x-axis }
  begin
   SlidePalette (Pal,64,95);
   VSync;
   SetActivePalette (Pal,64,95);
   CopyBlockFromPage2 (i,80,i,120);  { Rough edges of text in y-axis }
  end;

 ShadowWrite (40,90,15,'... any way you look at it!');
 { And now, in the opposide direction ... }

 repeat
  SlidePalette (Pal,95,64);
  VSync;
  SetActivePalette (Pal,64,95);
 until KeyPressed;
 ReadKey;

 { We also erase in the other direction: }

 for i:=280 downto 40 do { Rough edges of text in x-axis }
  begin
   SlidePalette (Pal,95,64);
   VSync;
   SetActivePalette (Pal,64,95);
   CopyBlockFromPage2 (i,90,i,110);  { Rough edges of text in y-axis }
  end;

 TextMode (Co80);
end.
