@echo off
rem %1 is the user provided path
if %1!==! goto MSG
if not exist %1\NUL goto MSG
goto START

:START
cls
echo =====================================================================
echo =                XingMPEG Player Version 3.12                        =
echo =                 Installation File Verifier                        =
echo =====================================================================
echo.

goto CHK_DIR1

:CHK_DIR1
echo SEARCHING FOR INSTALLATION FILES...
goto file1

:file1
If Exist %1\setup.exe goto file2
echo    SETUP.EXE >xmp_tmp.err
goto file2

:file2
If Exist %1\xmreadme.txt goto CHK_DIR2
echo    XMREADME.TXT >>xmp_tmp.err
goto CHK_DIR2

:CHK_DIR2
If Exist xmp_tmp.err goto ERR_CHK_DIR
echo      All files found.
echo.
goto MAKE_LST


:ERR_CHK_DIR
echo.
echo    ERROR:  Incomplete installation directory:
echo               (%1)
echo            The following files are missing:
echo.
type xmp_tmp.err
echo.
echo Exiting program...
echo.
del xmp_tmp.err
goto END

:MAKE_LST
rem create the temporary file containg the checksum list.
echo VERIFYING FILE CHECKSUMS...
echo      Creating temporary files...
rem  The following data is for version 3.12

echo 3512635575b     %1\setup.exe >xmp_tmp.lst
echo  103875141b     %1\xmreadme.txt >>xmp_tmp.lst

If Not Exist xmp_tmp.lst goto ERR_MAKE_LST
goto DO_CRC

:ERR_MAKE_LST
echo.
echo    ERROR:  File creation error.
echo.
echo Exiting program...
echo.
goto END

:DO_CRC
echo      Verifying...
echo.

brik -C -v xmp_tmp.lst

if ERRORLEVEL 1 goto ERR_CRC

echo.
ECHO FILE CHECKSUMS OK
del xmp_tmp.lst

goto END

:ERR_CRC
echo.
echo    ERROR:  File Checksums incorrect.
del xmp_tmp.lst

GOTO END

:MSG
echo -----------------------------------------------------------
echo -- Batch Command:   %0.BAT
echo -- Purpose:         Verify integrity of installation files
echo --                  for the XingMPEG Player version 3.12
echo -- 
echo -- Command Syntax:  %0 {path}
echo --                  Where {path} is the full drive and
echo --                  directory path containing the
echo --                  XingMPEG Player Installation files.
echo --                  (e.g.  %0 a:\)
echo -----------------------------------------------------------
goto END

:END
