// DisableATIMacrovisionDetection.cpp
//
// This probably came with a file called "DisableATIMacrovisionDetection.html",
// which you should read for more information.
//
// I hereby place this code in the public domain.


#include <windows.h>
#include <imagehlp.h>
#include <stdlib.h>
#include <ctype.h>


const char myname[] = "DisableATIMacrovisionDetection";


void Error(LPSTR msg, LPSTR subst) {
	static char buf[65536];
	wsprintf(buf, msg, subst);
	MessageBox(NULL, buf, myname, MB_ICONERROR | MB_OK);
	exit(1);
}

HANDLE Open(LPSTR filename) {
	HANDLE h = CreateFile(filename, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
	return h==INVALID_HANDLE_VALUE ? 0 : h;
}

UCHAR *FindBytes(UCHAR *buf, int len, UCHAR a, UCHAR b, UCHAR c, UCHAR d) {
	long i;
	for (i=0; i<=len-4; ++i)
		if (buf[i] == a && buf[i+1] == b && buf[i+2] == c && buf[i+3] == d)
			return &buf[i];
	return 0;
}

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR filename, int) {
	HANDLE h;

	if (IDYES != MessageBox(NULL, "This program will attempt to patch the \"ATI Specialized MVD Codec\" so that it no longer performs its (entirely useless) function.  A backup of the original, unpatched driver will be saved with a \".ori\" extension.\n\nDo you want to continue?", myname, MB_ICONWARNING | MB_DEFBUTTON2 | MB_YESNO))
		return 0;

	while (isspace(*filename)) filename++;
	if (filename[0] == 0) {
		static char filename_buf[512];
		int sys_dir_length = GetSystemDirectory(filename_buf, 400);
		if (sys_dir_length >= 400)
			Error("Your system is too perverse to patch.", 0);
		lstrcpy(filename_buf + sys_dir_length, "\\..\\system32\\drivers\\atinmdxx.sys");
		h = Open(filename_buf);
		if (h == 0) {
			lstrcpy(filename_buf + sys_dir_length, "\\..\\system32\\drivers\\ativmdxx.sys");
			h = Open(filename_buf);
			if (h == 0)
				Error("I couldn't find the ATI Macrovision detection driver.  Try finding it yourself and dragging it onto this executable icon.  It should be in your system32\\drivers folder and it should be called \"atinmdxx.sys\" or \"ativmdxx.sys\".", 0);
		}
		filename = filename_buf;
	} else {
		if (lstrlen(filename) > 500)
			Error("Your system is too perverse to patch.", 0);
		h = Open(filename);
		if (h == 0)
			Error("I couldn't open the file \"%s\".", filename);
	}

	DWORD length = GetFileSize(h, NULL);

	HANDLE hmap = CreateFileMapping(h, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (hmap == NULL)
		Error("I couldn't mmap the file \"%s\".", filename);

	UCHAR *pe_image = (UCHAR *)MapViewOfFile(hmap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (pe_image == 0)
		Error("I couldn't mmap the file \"%s\".", filename);

	// Here's the relevant code from the StrMiniReceiveStreamDataPacket
	// entry point in the driver.  I search for the lines marked with
        // *** and replace the conditional jump with an unconditional jump.

	// 8B442404                 mov   eax,[esp+04h]
	// 53                       push  ebx
	// 56                       push  esi
	// 33DB                     xor   ebx,ebx
	// 8B480C                   mov   ecx,[eax+0Ch]
	// 8B7004                   mov   esi,[eax+04h]
	// 57                       push  edi
	// 8B7810                   mov   edi,[eax+10h]
	// 8B5108                   mov   edx,[ecx+08h]
	// 8B4904                   mov   ecx,[ecx+04h]
	// 3BF3                     cmp   esi,ebx
	// 895808                   mov   [eax+08h],ebx
	// 895820                   mov   [eax+20h],ebx
	// 7C22                     jl    label2
	// 83FE01                   cmp   esi,1
	// 7F1D                     jg    label2
	// 395A64                   cmp   [edx+64h],ebx   ; ***
	// 741F                     je    ...             ; ***
	// 2BCB                     sub   ecx,ebx
	// 7408                     je    label1
	// 49                       dec   ecx
	// 7511                     jne   label2
	// 894270                   mov   [edx+70h],eax
	// EB1E                     jmps  ...
	// 52              label1:  push  edx
	// 57                       push  edi
	// 894270                   mov   [edx+70h],eax
	// E81DFDFFFF               call  ...
	// EB12                     jmp   ...
	// C74008020000C0  label2:  mov   [eax+08h],0C0000002h
	//                 label3:  ...

	UCHAR *pattern = FindBytes(pe_image, length, 0x39, 0x5a, 0x64, 0x74);
	UCHAR *pattern_dupe = !pattern ? 0 : FindBytes(pattern+1, length - (pattern+1-pe_image), 0x39, 0x5a, 0x64, 0x74);
	UCHAR *already_patched = FindBytes(pe_image, length, 0x39, 0x5a, 0x64, 0xeb);

	int num_matches = !!pattern + !!pattern_dupe + !!already_patched;
	if (num_matches == 0)
		Error("I couldn't find the appropriate code fragment in \"%s\".", filename);
	if (num_matches > 1)
		Error("The code fragment to be patched appears more than once in \"%s\".  The patch cannot be applied.", filename);
	if (already_patched)
		Error("The file \"%s\" appears already to have been patched by this program.  Use the backup file if you want to restore the original version.", filename);

	char backup_filename[512];
	lstrcpy(backup_filename, filename);
	char *p;
	for (p = backup_filename+lstrlen(backup_filename); p >= backup_filename; --p)
		if (*p == '.' || *p == '\\' || *p == '/') break;
	if (p >= backup_filename && *p == '.')
		lstrcpy(p, ".ori");
	else
		lstrcat(backup_filename, ".ori");

	if (!CopyFile(filename, backup_filename, FALSE))
		Error("The attempt to back up the driver to \"%s\" failed.  The driver will not be patched.", backup_filename);

	pattern[3] = 0xeb;

	DWORD checksum, original_checksum;
	PIMAGE_NT_HEADERS pe_header = CheckSumMappedFile(pe_image, length, &original_checksum, &checksum);
	if (pe_header == 0) {
		pattern[3] = 0x74;
		Error("Unable to calculate a new PE checksum.  Backing out the changes.", 0);
	}

	pe_header->OptionalHeader.CheckSum = checksum;

	MessageBox(NULL, "The patch was successful.  Changes will not take effect until you reboot.", myname,MB_ICONINFORMATION | MB_OK);

	return 0;
}
