// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"



LPDIRECTDRAWSURFACE4	DDS[XGLLOCK_MAX];
XGLLock					locktemp[XGLLOCK_MAX];
uint32					lockwritemode[XGLLOCK_MAX];
int						locked[XGLLOCK_MAX] = {0, 0};


LPDIRECTDRAWSURFACE4 getbuffer(uint32 buffer) {
	switch (buffer) {
	case XGLBUF_FRONT:		return DX.DDSPrimary;
	case XGLBUF_BACK:		return DX.DDSRender;
	case XGLBUF_AUX:
	case XGLBUF_DEPTH:
	case XGLBUF_ALPHA:
	case XGLBUF_TRIPLE:
	default:				return DX.DDSRender;
	}
}


int unlock(uint32 type) {
	if (!locked) return XGLTRUE;

	if (DDS->Unlock(0) != D3D_OK) {
		log("  Error unlocking surface unlock()");
		return XGLFALSE;
	}
	locked = 0;

	return XGLTRUE;
}


DDSURFACEDESC2 getlock(uint32 dst_buffer, uint32 type) {
	_exebuffer->Flush();

	if (locked) unlock();

	DWORD dwFlags = DDLOCK_WAIT;
	DDSURFACEDESC2 DDSD;

	if (type == XGLLOCK_READONLY) dwFlags |= DDLOCK_READONLY;
	if (type == XGLLOCK_WRITEONLY) dwFlags |= DDLOCK_WRITEONLY;

	DDS = getbuffer(dst_buffer);

	DDSD.dwSize = sizeof(DDSURFACEDESC2);

	if (DDS->Lock(0, &DDSD, DDLOCK_WRITEONLY|DDLOCK_WAIT, 0) != D3D_OK) {
		log("  Error locking surface in getlock()"); 
	}
	locked = 1;

	return DDSD;
}





XGLLINK uint32 XGLCALL grLfbLock(uint32 type, uint32 buffer, uint32 mode, uint32 origin, uint32 temp, XGLLock *lock) {

	uint32 i, j;

	log("Called grLfbLock");
	log("  type=" << type);
	log("  buffer=" << buffer);
	log("  mode=" << mode);
	log("  origin=" << origin);

	// We can do a normal, optimized lock
//	if (mode == XGLLFB_FMT_RGB565 || mode == XGLLFB_FMT_ANY) {
	if (0) {
		DDSURFACEDESC2 DDSD = getlock(buffer, type);

		lock->size = sizeof(XGLLock);
		lock->surface = DDSD.lpSurface;
		lock->pitch = DDSD.lPitch;
		lock->mode = mode;
		lock->origin = origin;

		locktemp = *lock;
	} else {
		// Must emulate the 3dfx pixel pipeline.
		// Copy screen to a buffer and convert color format.

		DDSURFACEDESC2 DDSD = getlock(buffer, type);

		int dbpp = getLfbBytesPerPixel(mode);
		int sbpp = 2;

		lock->size = sizeof(XGLLock);
		lock->surface = (void *)new char[Voodoo.width*Voodoo.height*dbpp];
		lock->pitch = Voodoo.width*dbpp;
		lock->mode = mode;
		lock->origin = origin;

		locktemp = *lock;
		lockwritemode = mode;

		void (*bufcolorconv)(uchar *, uchar *);

		switch (mode) {
		case XGLLFB_FMT_RGB565:		bufcolorconv = RGB565toRGB565;		break;
		case XGLLFB_FMT_RGB555:		bufcolorconv = RGB565toRGB555;		break;
		case XGLLFB_FMT_ARGB1555:	bufcolorconv = RGB565toARGB1555;	break;
		case XGLLFB_FMT_ANY:		bufcolorconv = RGB565toRGB565;		break; 
		default:
			bufcolorconv = RGB565toRGB565;
			log("   Unsupported writeMode=" << mode << " in grLfbLock");
		}


		// Needs to be optimized, currently does one pixel at a time.
		for (i=0; i<Voodoo.height; i++) {
			for (j=0; j<Voodoo.width; j++) {
				bufcolorconv((uchar *)lock->surface+(i*Voodoo.width+j)*dbpp, (uchar *)DDSD.lpSurface+(i*DDSD.lPitch+j*sbpp));
			}
		}

		unlock();
	}

	return XGLTRUE;
}


XGLLINK uint32 XGLCALL grLfbUnlock(uint32 type, uint32 buffer) {
	log("Called grLfbUnlock: type=" << type << " buffer=" << buffer);

	unsigned int i, j;

	_exebuffer->Flush();

//	if (locktemp.mode == XGLLFB_FMT_RGB565 || locktemp.mode == XGLLFB_FMT_ANY) {
	if (0) {
		LPDIRECTDRAWSURFACE4 DDS;

		DDS = getbuffer(buffer);

		DDS->Unlock(0);

	} else {
		DDSURFACEDESC2 DDSD = getlock(buffer, type);

		int sbpp = getLfbBytesPerPixel(lockwritemode);
		int dbpp = 2;

		void (*bufcolorconv)(uchar *, uchar *);

		switch (lockwritemode) {
		case XGLLFB_FMT_RGB565:		bufcolorconv = RGB565toRGB565;		break;
		case XGLLFB_FMT_RGB555:		bufcolorconv = RGB555toRGB565;		break;
		case XGLLFB_FMT_ARGB1555:	bufcolorconv = ARGB1555toRGB565;	break;
		case XGLLFB_FMT_ANY:		bufcolorconv = RGB565toRGB565;		break; 
		default:
			bufcolorconv = RGB565toRGB565;
			log("   Unsupported lockwritemode=" << lockwritemode << " in grLfbUnlock");
		}

		// Needs to be optimized, currently does one pixel at a time.
		for (i=0; i<Voodoo.height; i++) {
			for (j=0; j<Voodoo.width; j++) {
				bufcolorconv((uchar *)DDSD.lpSurface+(i*DDSD.lPitch+j*dbpp), (uchar *)locktemp.surface+(i*Voodoo.width+j)*sbpp);
			}
		}

		delete [] locktemp.surface;

		unlock();
	}

	return XGLTRUE;
}


XGLLINK uint32 XGLCALL grLfbWriteRegion(uint32 buffer,
										 uint32 xoffset,
										 uint32 yoffset,
										 uint32 format,
										 uint32 width,
										 uint32 height,
										 uint32 pitch,
										 uchar *data ) {

	log("Called grLfbWriteRegion");
	log("  buffer=" << buffer);
	log("  xoffset=" << xoffset);
	log("  yoffset=" << yoffset);
	log("  format=" << format);
	log("  width=" << width);
	log("  height=" << height);
	log("  pitch=" << pitch);

	DDSURFACEDESC2 DDSD = getlock(buffer, XGLLOCK_WRITEONLY);
	unsigned int i, j;

	void (*bufcolorconv)(uchar *, uchar *);

	switch (format) {
	case XGLLFB_FMT_RGB565:		bufcolorconv = RGB565toRGB565;		break;
	case XGLLFB_FMT_RGB555:		bufcolorconv = RGB555toRGB565;		break;
	case XGLLFB_FMT_ARGB1555:	bufcolorconv = ARGB1555toRGB565;	break;
	default:
		log("   Unsupported format=" << format << " in grLfbWriteRegion");
		break;
	}

	if (format == XGLLFB_FMT_RGB565 || format == XGLLFB_FMT_ANY) {
		for (i=0; i<height; i++) {
			memcpy(&((char *)DDSD.lpSurface)[(i+yoffset)*DDSD.lPitch+xoffset], data+(i*pitch), width*2);
		}
	} else {
		for (i=0; i<height; i++) {
			for (j=0; j<width; j++) {
				bufcolorconv((uchar *)DDSD.lpSurface+((i+yoffset)*DDSD.lPitch+(xoffset+j)*2), (uchar *)data+(i*pitch)+j*2);
			}
		}
	}

	unlock();

	return XGLTRUE;
}


XGLLINK uint32 XGLCALL grLfbReadRegion(uint32 buffer,
										uint32 xoffset,
										uint32 yoffset,
										uint32 width,
										uint32 height,
										uint32 pitch,
										uchar *data) {

	log("  Called grLfbReadRegion");

	_exebuffer->Flush();

	DDSURFACEDESC2 DDSD = getlock(buffer, XGLLOCK_READONLY);
	uint32 i;

	int sbpp = 2;

	for (i=0; i<height; i++) {
		memcpy(&data[i*pitch], &((char *)DDSD.lpSurface)[(i+yoffset)*DDSD.lPitch+xoffset], width*sbpp);
	}

	if (!unlock()) return XGLFALSE;

	return XGLTRUE;
}
