// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"



void (*ckcolorconv)(uchar *, uchar *);


#define SetPixelFormatRGB565() \
	_bpp = 2; \
	_paletted = 0; \
	DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB; \
	DDSDesc.ddpfPixelFormat.dwRGBBitCount = 16; \
	DDSDesc.ddpfPixelFormat.dwRBitMask = 0xF800; \
	DDSDesc.ddpfPixelFormat.dwGBitMask = 0x07E0; \
	DDSDesc.ddpfPixelFormat.dwBBitMask = 0x001F; \
	DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0x0000; \
	ckcolorconv = ARGB8888toRGB565;

#define SetPixelFormatARGB1555() \
	_bpp = 2; \
	_paletted = 0; \
	DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS; \
	DDSDesc.ddpfPixelFormat.dwRGBBitCount = 16; \
	DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0x8000; \
	DDSDesc.ddpfPixelFormat.dwRBitMask = 0x7C00; \
	DDSDesc.ddpfPixelFormat.dwGBitMask = 0x03E0; \
	DDSDesc.ddpfPixelFormat.dwBBitMask = 0x001F; \
	ckcolorconv = ARGB8888toARGB1555;

#define SetPixelFormatARGB4444() \
	_bpp = 2; \
	_paletted = 0; \
	DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS; \
	DDSDesc.ddpfPixelFormat.dwRGBBitCount = 16; \
	DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0xF000; \
	DDSDesc.ddpfPixelFormat.dwRBitMask = 0x0F00; \
	DDSDesc.ddpfPixelFormat.dwGBitMask = 0x00F0; \
	DDSDesc.ddpfPixelFormat.dwBBitMask = 0x000F; \
	ckcolorconv = 0;

#define SetPixelFormatP8() \
	_bpp = 1; \
	_paletted = 1; \
	DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB | DDPF_PALETTEINDEXED8; \
	DDSDesc.ddpfPixelFormat.dwRGBBitCount = 8; \
	DDSDesc.ddpfPixelFormat.dwRBitMask = 0x00; \
	DDSDesc.ddpfPixelFormat.dwGBitMask = 0x00; \
	DDSDesc.ddpfPixelFormat.dwBBitMask = 0x00; \
	DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0x00; \
	ckcolorconv = 0; 


Tex::Tex(const uint32 address, const XGLTexture &tex) {
	DDSURFACEDESC2 DDSDesc;
	int width, height;

	vlog("Called Tex::Tex");

	vlog("  Texture:");
	vlog("    smalllod=" << tex.smalllod);
	vlog("    largelod=" << tex.largelod);
	vlog("    aspect=" << tex.aspect);
	vlog("    format=" << tex.format);


	_palnum = -1;
	_base = address;
	_aspect = tex.aspect;
	_format = tex.format;


	switch (tex.largelod) {
	case XGLLOD_256:	width=256;	height=256;	break;
	case XGLLOD_128:	width=128;	height=128;	break;
	case XGLLOD_64:		width=64;	height=64;	break;
	case XGLLOD_32:		width=32;	height=32;	break;
	case XGLLOD_16:		width=16;	height=16;	break;
	case XGLLOD_8:		width=8;	height=8;	break;
	case XGLLOD_4:		width=4;	height=4;	break;
	case XGLLOD_2:		width=2;	height=2;	break;
	case XGLLOD_1:		width=1;	height=1;	break;
	default:
		log("  Error in large LOD Tex::Tex: " << tex.largelod);
		width=1; height=1;
		break;
	}

	switch(tex.aspect)	{
	case XGLASPECT_8x1:		height >>= 3; 	break;
	case XGLASPECT_4x1:		height >>= 2; 	break;
	case XGLASPECT_2x1:		height >>= 1; 	break;
	case XGLASPECT_1x1:		break;
	case XGLASPECT_1x2:		width >>= 1; 	break;
	case XGLASPECT_1x4:		width >>= 2; 	break;
	case XGLASPECT_1x8:		width >>= 3; 	break;
	default:
		log("  Error in aspect ratio in Tex::Tex: " << _aspect);
		_aspect = XGLASPECT_1x1;
		break;
	}

	memset(&DDSDesc, 0, sizeof(DDSURFACEDESC2));
	DDSDesc.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);

	switch (tex.format) {
	case XGLTEX_I8:
		vlog("  pixel format: XGLTEX_I8");
		_bpp = 1;
		_paletted = 0;
		DDSDesc.ddpfPixelFormat.dwFlags = DDPF_LUMINANCE;
		DDSDesc.ddpfPixelFormat.dwLuminanceBitCount = 8;
		DDSDesc.ddpfPixelFormat.dwLuminanceBitMask = 0xFF;
		ckcolorconv = 0;
		_texcc = 0;
		break;
	case XGLTEX_RGB332:
		vlog("  pixel format: XGLTEX_RGB332");
		_sbpp = 1;
		SetPixelFormatRGB565();
		_texcc = RGB332toRGB565;
		break;
	case XGLTEX_A8:
		vlog("  pixel format: XGLTEX_A8");
		_bpp = 1;
		_paletted = 0;
		DDSDesc.ddpfPixelFormat.dwFlags = DDPF_ALPHA;
		DDSDesc.ddpfPixelFormat.dwAlphaBitDepth = 8;
		ckcolorconv = 0;
		_texcc = 0;
		break;
	case XGLTEX_AI44:
		vlog("  pixel format: XGLTEX_AI44");
		_sbpp = 1;
		SetPixelFormatARGB4444();
		_texcc = AI44toARGB4444;
		break;
	case XGLTEX_P8: 
		vlog("  pixel format: XGLTEX_P8");
//		DDSDesc.ddpfPixelFormat.dwFlags = DDPF_PALETTEINDEXED8;
		SetPixelFormatP8();
		_texcc = 0;
		break;
	case XGLTEX_ARGB8332:
		vlog("  pixel format: XGLTEX_ARGB8332");
		_bpp = 2;
		_paletted = 0;
		DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
		DDSDesc.ddpfPixelFormat.dwRGBBitCount = 16;
		DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0xFF00;
		DDSDesc.ddpfPixelFormat.dwRBitMask = 0x00E0;
		DDSDesc.ddpfPixelFormat.dwGBitMask = 0x001C;
		DDSDesc.ddpfPixelFormat.dwBBitMask = 0x0003;
		ckcolorconv = ARGB8888toARGB8332;
		_texcc = 0;
		break;
	case XGLTEX_RGB565:
		vlog("  pixel format: XGLTEX_RGB565");
		SetPixelFormatRGB565();

		_texcc = 0;
		break;
	case XGLTEX_ARGB1555:
		vlog("  pixel format: XGLTEX_ARGB1555");
		SetPixelFormatARGB1555();

//		bpp = 2; 
//		_paletted = 0; 
//		DDSDesc.ddpfPixelFormat = {sizeof(DDPIXELFORMAT), DDPF_RGB, 0, 16, 0xF800, 0x07E0, 0x001F, 0x0000};
//		ckcolorconv = ARGB8888toRGB565;
		_texcc = 0;
		break;
	case XGLTEX_ARGB4444:
		vlog("  pixel format: XGLTEX_ARGB4444");
		SetPixelFormatARGB4444();
		_texcc = 0;
		break;
	case XGLTEX_AI88:
		vlog("  pixel format: XGLTEX_AI88");

		_bpp = 32;
		_sbpp = 16;
		_paletted = 0;
		DDSDesc.ddpfPixelFormat.dwFlags = DDPF_RGB | DDPF_ALPHAPIXELS;
		DDSDesc.ddpfPixelFormat.dwRGBBitCount = 32;
		DDSDesc.ddpfPixelFormat.dwRGBAlphaBitMask = 0xFF000000;
		DDSDesc.ddpfPixelFormat.dwRBitMask = 0x00FF0000;
		DDSDesc.ddpfPixelFormat.dwGBitMask = 0x0000FF00;
		DDSDesc.ddpfPixelFormat.dwBBitMask = 0x000000FF;
		ckcolorconv = 0;
		_texcc = AI88toARGB8888;

		break;
	case XGLTEX_YIQ422:
		vlog("  pixel format: XGLTEX_YIQ422");

		_sbpp = 1;
		SetPixelFormatRGB565();
		_texcc = YIQ422toRGB565;

		break;
	default:
		log("  Unknown texture format " << tex.format << " in Tex::Tex");
		break;
	}

	DDSDesc.dwSize = sizeof(DDSURFACEDESC2);
	DDSDesc.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
//	DDSDesc.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT | DDSD_MIPMAPCOUNT;
	DDSDesc.dwMipMapCount = 5; 
	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE;
//	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY;
//	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE | DDSCAPS_MIPMAP | DDSCAPS_COMPLEX;
	DDSDesc.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
	DDSDesc.dwWidth = _width = width;
	DDSDesc.dwHeight = _height = height;
	DDSDesc.dwTextureStage = 0;
	DDSDesc.lPitch = width * _bpp;
	DDSDesc.dwMipMapCount = tex.largelod - tex.smalllod + 1;
//	DDSDesc.dwMipMapCount = 1;

	HRESULT href;

	if ((href = DX.DD->CreateSurface(&DDSDesc, &_texDDS, 0)) != DD_OK) {
		_tex = 0;
		log("Error code " << (href&0xFF) << " in Tex::Tex on CreateSurface, line " << __LINE__ << ", file " << __FILE__);
	}


	copytexture(tex);


	if (_paletted) createpalette();

	if (ckcolorconv) setcolorkey(ckcolorconv);

	if (_texDDS->QueryInterface(IID_IDirect3DTexture2, (void**)&_tex) != D3D_OK) {
		_tex = 0;
		log("Error querying interface");
	}


}


void Tex::copytexture(const XGLTexture &tex) {
	// Ok, now we copy the texture to the surface
	DDSURFACEDESC2 DDSD;
	RECT r = {0, 0, _width, _height};

	DDSD.dwSize = sizeof(DDSURFACEDESC2);

	if (_texDDS->Lock(&r, &DDSD, DDLOCK_WAIT, 0) == DD_OK) {

		vlog("   width=" << DDSD.dwWidth);
		vlog("   height=" << DDSD.dwHeight);
		vlog("   pitch=" << DDSD.lPitch);

		if (_texcc) {
			for (uint32 i=0; i<DDSD.dwHeight; i++) {
				for (uint32 j=0; j<DDSD.dwWidth; j++) {
					_texcc((uchar *)DDSD.lpSurface+(i*DDSD.lPitch)+j*_bpp, (uchar *)tex.data+((i*DDSD.dwWidth+j)*_sbpp));
				}
			}

		} else {
			for (uint32 i=0; i<DDSD.dwHeight; i++) {
				memcpy((char *)DDSD.lpSurface+(i*DDSD.lPitch), (char *)tex.data+(i*DDSD.dwWidth*_bpp), DDSD.dwWidth*_bpp);
			}
		}
		
		if (_texDDS->Unlock(&r) != DD_OK) log("Could not unlock surface on line " << __LINE__ << ", file " << __FILE__);

	} else {
		_tex = 0;
		log("Could not lock texture surface on line " << __LINE__);
		return;
	}
}


void Tex::createpalette() {
	LPDIRECTDRAWPALETTE DDP;

	if (DX.DD->CreatePalette(DDPCAPS_8BIT | DDPCAPS_ALLOW256 | DDPCAPS_INITIALIZE , Voodoo.palette, &DDP, 0) != DD_OK) {
		_tex = 0;
		log("Error creating palette");
	}
	if (_texDDS->SetPalette(DDP) != DD_OK) {
		_tex = 0;
		log("Error setting palette");
	}
	DDP->Release();
}

void Tex::setcolorkey(void (*ckcolorconv)(uchar *, uchar *)) {
	DDCOLORKEY colorKey;
	DWORD c = 0;

	ckcolorconv((uchar *)&c, (uchar *)&Voodoo.colorKey);

	colorKey.dwColorSpaceLowValue = c;
	colorKey.dwColorSpaceHighValue = c;

	_texDDS->SetColorKey(DDCKEY_SRCBLT, &colorKey);
}


Tex::~Tex() {
	vlog("Called Tex::~Tex");
	_tex->Release();
	_texDDS->Release();
}



void Tex::setpalette() {
	LPDIRECTDRAWPALETTE DDP;

	if (Voodoo.palnum != _palnum) {
		if (_texDDS->GetPalette(&DDP) != DD_OK) log("Error getting palette");
		if (DDP->SetEntries(0, 0, 256, Voodoo.palette) != DD_OK) log("Error setting palette");
		DDP->Release();
		_palnum = Voodoo.palnum;
	}
}


