// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


// Go through the 4 given D3D modes, trying each in sequence 
// until one that fits the capabilities is found.
#define fill_lut(table, caps, caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	if (caps & caps_lut[d3dmode1]) { \
		table[glidemode] = d3dmode1; \
	} else if (caps & caps_lut[d3dmode2]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode2); \
		table[glidemode] = d3dmode2; \
	} else if (caps & caps_lut[d3dmode3]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode3); \
		table[glidemode] = d3dmode3; \
	} else if (caps & caps_lut[d3dmode4]) { \
		log("Mode " #d3dmode1 " not supported in " #table "--reverting to mode " #d3dmode4); \
		table[glidemode] = d3dmode4; \
	} else { \
		log("No alternative blend modes found for mode " #d3dmode1 " in " #table ".  Please contact the author."); \
		table[glidemode] = 0; \
	}


// The next 3 #define's call fill_lut() with appropriate parameters

#define fill_src_blend_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(src_blend_lut, DX.D3DHD.dpcTriCaps.dwSrcBlendCaps, blend_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)

#define fill_dst_blend_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(dst_blend_lut, DX.D3DHD.dpcTriCaps.dwDestBlendCaps, blend_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)

#define fill_atest_lut(glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4) \
	fill_lut(atest_lut, DX.D3DHD.dpcTriCaps.dwAlphaCmpCaps, atest_caps_lut, glidemode, d3dmode1, d3dmode2, d3dmode3, d3dmode4)



XGLLINK void XGLCALL grGlideInit() {
	log("Called grGlideInit");

	loadsettings();

	Voodoo.tmumem = Settings.tmumem;


	Voodoo.colorkeyon = 0;
	Voodoo.palnum = -1;

	_texlist = new TexList();
	_exebuffer = new ExeBuffer();

}

XGLLINK void XGLCALL grGlideGetVersion(char *ver) {
	log("Called grGlideGetVersion");

	strcpy(ver, "Scott Cutler's Direct3D to Glide Wrapper v" XGLVER);
}



XGLLINK void XGLCALL grGlideShutdown() {
	log("Called grGlideShutdown");

	grSstWinClose();
}


XGLLINK void XGLCALL grGlideGetState(void *state) {
	vlog("Called grGlideGetState");

}

XGLLINK void XGLCALL grGlideSetState(void *state) {
	vlog("Called grGlideSetState");

}


// Set all color combine modes to beundefined, so we can detect if
// a new mode is used that we haven't seen yet.
void clear_cc_lut() {
	int i, j, k, l;

	for (i=0; i<XGLCOMBINEFUNC_MAX; i++) {
		for (j=0; j<XGLCOMBINEFACTOR_MAX; j++) {
			for (k=0; k<XGLLOCAL_MAX; k++) {
				for (l=0; l<XGLOTHER_MAX; l++) {
					colorcombine_lut[i][j][k][l].set = 0;
				}
			}
		}
	}
}


// Fill the color combine lut with inputted values.  If any of the inputted 
// Glide constants are -1 (actually, less than zero), then fill all combinations
// of that factor in the lut with the info.
void fill_cc_lut(int32 func, int32 factor, int32 local, int32 other, D3DCOLOR (*getcolor)(const XGLVertex &), D3DTEXTUREOP colorop, uint32 colorarg1, uint32 colorarg2) {
	int i, j, k, l;
	int imax, jmax, kmax, lmax;
	int imin, jmin, kmin, lmin;


	if (func < 0) {
		imin = 0;
		imax = XGLCOMBINEFUNC_MAX;
	} else {
		imin = func;
		imax = func+1;
	}
	for (i=imin; i<imax; i++) {

		if (factor < 0) {
			jmin = 0;
			jmax = XGLCOMBINEFACTOR_MAX;
		} else {
			jmin = factor;
			jmax = factor+1;
		}
		for (j=jmin; j<jmax; j++) {

			if (local < 0) {
				kmin = 0;
				kmax = XGLLOCAL_MAX;
			} else {
				kmin = local;
				kmax = local+1;
			}
			for (k=kmin; k<kmax; k++) {

				if (other < 0) {
					lmin = 0;
					lmax = XGLOTHER_MAX;
				} else {
					lmin = other;
					lmax = other+1;
				}
				for (l=lmin; l<lmax; l++) {
					colorcombine_lut[i][j][k][l].set = 1;
					colorcombine_lut[i][j][k][l].getcolor = getcolor;
					colorcombine_lut[i][j][k][l].colorop = colorop;
					colorcombine_lut[i][j][k][l].colorarg1 = colorarg1;
					colorcombine_lut[i][j][k][l].colorarg2 = colorarg2;
				}
			}
		}
	}
}


void table_init() {
	clear_cc_lut();


	if (!Settings.atifix) 
		fill_cc_lut(XGLCOMBINEFUNC_LOCAL, -1, XGLLOCAL_GOURAUD, -1, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	else
		fill_cc_lut(XGLCOMBINEFUNC_LOCAL, -1, XGLLOCAL_GOURAUD, -1, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_LOCAL, -1, XGLLOCAL_CONSTANT, -1, constant, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ZERO, -1, -1, black, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_GOURAUD, iterated2, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterconst, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_GOURAUD, iterconst, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, constant, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_CONSTANT, constant2, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_GOURAUD, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_CONSTANT, constant, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);


	
	if (Settings.colorop_blendtexturealpha == 0) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_ALPHA, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else if (Settings.colorop_blendtexturealpha == 1) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_ALPHA, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_BLENDTEXTUREALPHA, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else {
		if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_BLENDTEXTUREALPHA) {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_ALPHA, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_BLENDTEXTUREALPHA, D3DTA_TEXTURE, D3DTA_CURRENT);
		} else {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_ALPHA, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
		}
	}


	if (Settings.colorop_add == 0) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else if (Settings.colorop_add == 1) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else {
		if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_ADD) {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
		} else {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
		}
	}

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_CONSTANT, XGLOTHER_GOURAUD, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);



	if (Settings.colorop_add == 0) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else if (Settings.colorop_add == 1) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else {
		if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_ADD) {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
		} else {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
		}
	}


	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL_ALPHA, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);


	// Gods
	fill_cc_lut(XGLCOMBINEFUNC_BLEND_OTHER, XGLCOMBINEFACTOR_LOCAL_ALPHA, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);


	// Init texture scaling vars for different aspect ratios
	smul = new float[XGLASPECT_MAX];
	tmul = new float[XGLASPECT_MAX];

	smul[XGLASPECT_8x1] = 1.0f / 256.0f;
	smul[XGLASPECT_4x1] = 1.0f / 256.0f;
	smul[XGLASPECT_2x1] = 1.0f / 256.0f;
	smul[XGLASPECT_1x1] = 1.0f / 256.0f;
	smul[XGLASPECT_1x2] = 1.0f / 128.0f;
	smul[XGLASPECT_1x4] = 1.0f / 64.0f;
	smul[XGLASPECT_1x8] = 1.0f / 32.0f;
	tmul[XGLASPECT_8x1] = 1.0f / 32.0f;
	tmul[XGLASPECT_4x1] = 1.0f / 64.0f;
	tmul[XGLASPECT_2x1] = 1.0f / 128.0f;
	tmul[XGLASPECT_1x1] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x2] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x4] = 1.0f / 256.0f;
	tmul[XGLASPECT_1x8] = 1.0f / 256.0f;



	src_blend_lut = new uint32[16];
	blend_caps_lut = new uint32[16];
	dst_blend_lut = new uint32[16];


	blend_caps_lut[0] =							0;
	blend_caps_lut[D3DBLEND_ZERO] =				D3DPBLENDCAPS_ZERO;
	blend_caps_lut[D3DBLEND_ONE] =				D3DPBLENDCAPS_ONE;
	blend_caps_lut[D3DBLEND_SRCCOLOR] =			D3DPBLENDCAPS_SRCCOLOR;
	blend_caps_lut[D3DBLEND_INVSRCCOLOR] =		D3DPBLENDCAPS_INVSRCCOLOR;
	blend_caps_lut[D3DBLEND_SRCALPHA] =			D3DPBLENDCAPS_SRCALPHA;
	blend_caps_lut[D3DBLEND_INVSRCALPHA] =		D3DPBLENDCAPS_INVSRCALPHA;
	blend_caps_lut[D3DBLEND_DESTALPHA] =		D3DPBLENDCAPS_DESTALPHA;
	blend_caps_lut[D3DBLEND_INVDESTALPHA] =		D3DPBLENDCAPS_INVDESTALPHA;
	blend_caps_lut[D3DBLEND_DESTCOLOR] =		D3DPBLENDCAPS_DESTCOLOR;
	blend_caps_lut[D3DBLEND_INVDESTCOLOR] =		D3DPBLENDCAPS_INVDESTCOLOR;
	blend_caps_lut[D3DBLEND_SRCALPHASAT] =		D3DPBLENDCAPS_SRCALPHASAT;
	blend_caps_lut[D3DBLEND_BOTHSRCALPHA] =		D3DPBLENDCAPS_BOTHSRCALPHA;
	blend_caps_lut[D3DBLEND_BOTHINVSRCALPHA] =	D3DPBLENDCAPS_BOTHINVSRCALPHA;

	

	fill_src_blend_lut(XGLBLEND_ZERO,			D3DBLEND_ZERO,			0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_ONE,			D3DBLEND_ONE,			0,						0, D3DBLEND_ONE);
//	fill_src_blend_lut(XGLBLEND_SRCCOLOR,		D3DBLEND_SRCCOLOR,		D3DBLEND_DESTCOLOR,		0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCCOLOR,		D3DBLEND_DESTCOLOR,		0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVSRCCOLOR,	D3DBLEND_INVSRCCOLOR,	D3DBLEND_INVDESTCOLOR,	0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCALPHA,		D3DBLEND_SRCALPHA,		0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVSRCALPHA,	D3DBLEND_INVSRCALPHA,	0,						0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_DESTALPHA,		D3DBLEND_DESTALPHA,		D3DBLEND_SRCALPHA,		0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_INVDESTALPHA,	D3DBLEND_INVDESTALPHA,	D3DBLEND_INVSRCALPHA,	0, D3DBLEND_ONE);
	fill_src_blend_lut(XGLBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHA,		0, D3DBLEND_ONE);


	fill_dst_blend_lut(XGLBLEND_ZERO,			D3DBLEND_ZERO,			0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_ONE,			D3DBLEND_ONE,			0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_DESTCOLOR,		D3DBLEND_DESTCOLOR,		D3DBLEND_SRCCOLOR,		0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVDESTCOLOR,	D3DBLEND_INVDESTCOLOR,	D3DBLEND_INVSRCCOLOR,	0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_SRCALPHA,		D3DBLEND_SRCALPHA,		0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVSRCALPHA,	D3DBLEND_INVSRCALPHA,	0,						0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_DESTALPHA,		D3DBLEND_DESTALPHA,		D3DBLEND_SRCALPHA,		0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_INVDESTALPHA,	D3DBLEND_INVDESTALPHA,	D3DBLEND_INVSRCALPHA,	0, XGLBLEND_ZERO);
	fill_dst_blend_lut(XGLBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHASAT,	D3DBLEND_SRCALPHA,		0, XGLBLEND_ZERO);



	atest_caps_lut = new uint32[8];

	atest_caps_lut[0]						= 0;
	atest_caps_lut[D3DCMP_NEVER]			= D3DPCMPCAPS_NEVER;
	atest_caps_lut[D3DCMP_LESS]				= D3DPCMPCAPS_LESS;
	atest_caps_lut[D3DCMP_EQUAL]			= D3DPCMPCAPS_EQUAL;
	atest_caps_lut[D3DCMP_LESSEQUAL]		= D3DPCMPCAPS_LESSEQUAL;
	atest_caps_lut[D3DCMP_GREATER]			= D3DPCMPCAPS_GREATER;
	atest_caps_lut[D3DCMP_NOTEQUAL]			= D3DPCMPCAPS_NOTEQUAL;
	atest_caps_lut[D3DCMP_GREATEREQUAL]		= D3DPCMPCAPS_GREATEREQUAL;
	atest_caps_lut[D3DCMP_ALWAYS]			= D3DPCMPCAPS_ALWAYS;

	atest_lut = new uint32[8];

	fill_atest_lut(XGLCMP_NEVER,		D3DCMP_NEVER,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_LESS,			D3DCMP_LESS,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_EQUAL,		D3DCMP_EQUAL,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_LESSEQUAL,	D3DCMP_LESSEQUAL,		D3DCMP_LESS,		0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_GREATER,		D3DCMP_GREATER,			0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_NOTEQUAL,		D3DCMP_NOTEQUAL,		0,					0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_GREATEREQUAL,	D3DCMP_GREATEREQUAL,	D3DCMP_GREATER,		0, D3DCMP_ALWAYS);
	fill_atest_lut(XGLCMP_ALWAYS,		D3DCMP_ALWAYS,			0,					0, D3DCMP_ALWAYS);






	vconv_lut[DEPTH_D][XGLORIGIN_UL][TEXTURE]			= vconv_D_UL_T;
	vconv_lut[DEPTH_W][XGLORIGIN_UL][TEXTURE]			= vconv_W_UL_T;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z16_UL_T;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z24_UL_T;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_UL][TEXTURE]		= vconv_W_Z32_UL_T;
	vconv_lut[DEPTH_Z][XGLORIGIN_UL][TEXTURE]			= vconv_Z_UL_T;

	vconv_lut[DEPTH_D][XGLORIGIN_LL][TEXTURE]			= vconv_D_LL_T;
	vconv_lut[DEPTH_W][XGLORIGIN_LL][TEXTURE]			= vconv_W_LL_T;	
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z16_LL_T;	
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z24_LL_T;	
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_LL][TEXTURE]		= vconv_W_Z32_LL_T;	
	vconv_lut[DEPTH_Z][XGLORIGIN_LL][TEXTURE]			= vconv_Z_LL_T;	
	
	vconv_lut[DEPTH_D][XGLORIGIN_UL][NO_TEXTURE]		= vconv_D_UL_NT;
	vconv_lut[DEPTH_W][XGLORIGIN_UL][NO_TEXTURE]		= vconv_W_UL_NT;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z16_UL_NT;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z24_UL_NT;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_UL][NO_TEXTURE]	= vconv_W_Z32_UL_NT;
	vconv_lut[DEPTH_Z][XGLORIGIN_UL][NO_TEXTURE]		= vconv_Z_UL_NT;

	vconv_lut[DEPTH_D][XGLORIGIN_LL][NO_TEXTURE]		= vconv_D_LL_NT;
	vconv_lut[DEPTH_W][XGLORIGIN_LL][NO_TEXTURE]		= vconv_W_LL_NT;
	vconv_lut[DEPTH_W_Z16][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z16_LL_NT;
	vconv_lut[DEPTH_W_Z24][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z24_LL_NT;
	vconv_lut[DEPTH_W_Z32][XGLORIGIN_LL][NO_TEXTURE]	= vconv_W_Z32_LL_NT;
	vconv_lut[DEPTH_Z][XGLORIGIN_LL][NO_TEXTURE]		= vconv_Z_LL_NT;

	int yab;
	float r, g, b, y1, a1, b1;
	for (yab=0; yab<256; yab++) {
		y1 = ((yab >> 4) & 0xF) / 15.0f;
		a1 = ((yab >> 2) & 0x3) / 3.0f;
		b1 = (yab & 0x3) / 3.0f;

		r = y1 + 0.95f*a1 + 0.62f*b1;
		g = y1 - 0.28f*a1 + 0.64f*b1;
		b = y1 - 1.11f*a1 + 1.73f*b1;

		if (r > 1.0f) r = 1.0f;
		if (g > 1.0f) g = 1.0f;
		if (b > 1.0f) b = 1.0f;
		if (r < 0.0f) r = 0.0f;
		if (g < 0.0f) g = 0.0f;
		if (b < 0.0f) b = 0.0f;

		yiq_lut[yab] = (int(r * 31) << 11) | (int(g * 63) << 5) | (int(b * 31));
	}
}

