#include "include.h"

int loadsettings() {
	HKEY regkey = 0;
	DWORD type;
	char str[256];
	DWORD size = sizeof(str);

	RegCreateKey(HKEY_CURRENT_USER, "Software\\XGl200", &regkey);

	if ((RegQueryValueEx(regkey, "ver", 0, &type, (LPBYTE)&str, &size) == ERROR_SUCCESS) &&
		(strcmp((char *)str, XGLVER) == 0)) {

		size = sizeof(DWORD);

		RegQueryValueEx(regkey, "aa", 0, &type, (LPBYTE)&Settings.aa, &size);
		RegQueryValueEx(regkey, "alphaop_modulate", 0, &type, (LPBYTE)&Settings.alphaop_modulate, &size);
		RegQueryValueEx(regkey, "clamp", 0, &type, (LPBYTE)&Settings.clamp, &size);
		RegQueryValueEx(regkey, "colorop_add", 0, &type, (LPBYTE)&Settings.colorop_add, &size);
		RegQueryValueEx(regkey, "colorop_blendtexturealpha", 0, &type, (LPBYTE)&Settings.colorop_blendtexturealpha, &size);
		RegQueryValueEx(regkey, "vsync", 0, &type, (LPBYTE)&Settings.vsync, &size);
		RegQueryValueEx(regkey, "zbits", 0, &type, (LPBYTE)&Settings.zbits, &size);
		RegQueryValueEx(regkey, "model", 0, &type, (LPBYTE)&Settings.model, &size);
		RegQueryValueEx(regkey, "tmumem", 0, &type, (LPBYTE)&Settings.tmumem, &size);
		RegQueryValueEx(regkey, "backbuffers", 0, &type, (LPBYTE)&Settings.backbuffers, &size);
		RegQueryValueEx(regkey, "fps", 0, &type, (LPBYTE)&Settings.fps, &size);
		RegQueryValueEx(regkey, "priority", 0, &type, (LPBYTE)&Settings.priority, &size);
		RegQueryValueEx(regkey, "logging", 0, &type, (LPBYTE)&Settings.logging, &size);
		RegQueryValueEx(regkey, "atifix", 0, &type, (LPBYTE)&Settings.atifix, &size);
		RegQueryValueEx(regkey, "automipmap", 0, &type, (LPBYTE)&Settings.automipmap, &size);

		if (!Settings.tmumem) Settings.tmumem = 4;
	} else {
		MessageBox(0, "Please run the XGl200 Configurator", "Error", MB_OK);

		return XGLFALSE;
	}

	return XGLTRUE;
}

int getcaps() {
	LPDIRECT3DDEVICE3 D3DD;

	if (DX.D3D->CreateDevice(IID_IDirect3DHALDevice, DX.DDSRender, &D3DD, NULL)) {
		log("  Error in CreateDevice");
		return XGLFALSE;
	}

	DX.D3DHD.dwSize = sizeof(D3DDEVICEDESC);
	DX.D3DSD.dwSize = sizeof(D3DDEVICEDESC);
	if (D3DD->GetCaps(&DX.D3DHD, &DX.D3DSD)) {
		log("  Error retrieving caps");
		return XGLFALSE;
	}

	D3DD->Release();

	log("  Caps:");
	log("    dwDevCaps=               0x" << hex << setw(8) << setfill('0') << DX.D3DHD.dwDevCaps);
	log("    dpcTriCaps:");
	log("      dwMiscCaps=            0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwMiscCaps);
	log("      dwRasterCaps=          0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwRasterCaps);
	log("      dwZCmpCaps=            0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwZCmpCaps);
	log("      dwSrcBlendCaps=        0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwSrcBlendCaps);
	log("      dwDestBlendCaps=       0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwDestBlendCaps);
	log("      dwAlphaCmpCaps=        0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwAlphaCmpCaps);
	log("      dwShadeCaps=           0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwShadeCaps);
	log("      dwTextureCaps=         0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwTextureCaps);
	log("      dwTextureFilterCaps=   0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwTextureFilterCaps);
	log("      dwTextureBlendCaps=    0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwTextureBlendCaps);
	log("      dwTextureAddressCaps=  0x" << setw(8) << setfill('0') << DX.D3DHD.dpcTriCaps.dwTextureAddressCaps);
	log("      dwStippleWidth=        " << dec << DX.D3DHD.dpcTriCaps.dwStippleWidth);
	log("      dwStippleHeight=       " << DX.D3DHD.dpcTriCaps.dwStippleHeight);
	log("    dwDeviceRenderBitDepth=  " << DX.D3DHD.dwDeviceRenderBitDepth);
	log("    dwDeviceZBufferBitDepth= " << DX.D3DHD.dwDeviceZBufferBitDepth);
	log("    dwStencilCaps=           0x" << hex << setw(8) << setfill('0') << DX.D3DHD.dwStencilCaps);
	log("    dwFVFCaps=               0x" << setw(8) << setfill('0') << DX.D3DHD.dwFVFCaps);
	log("    dwTextureOpCaps=         0x" << setw(8) << setfill('0') << DX.D3DHD.dwTextureOpCaps);
	log("    wMaxTextureBlendStages=  " << dec << DX.D3DHD.wMaxTextureBlendStages);
	log("    wMaxSimultaneousTextures=" << dec << DX.D3DHD.wMaxSimultaneousTextures);

	return XGLTRUE;
}

static HRESULT WINAPI EnumZBufferCallback(DDPIXELFORMAT *pddpf, void *pddpfDesired) {

	DDPIXELFORMAT *ddpf = (DDPIXELFORMAT *)pddpfDesired;;

	if( pddpf->dwFlags == DDPF_ZBUFFER )    {
		log("  Found a Z-buffer format");

        // Return with D3DENUMRET_CANCEL to end the search.
		if( pddpf->dwZBufferBitDepth == ddpf->dwZBufferBitDepth ) {
			memcpy( pddpfDesired, pddpf, sizeof(DDPIXELFORMAT) );
			return D3DENUMRET_CANCEL;
		}
	} 

    // Return with D3DENUMRET_OK to continue the search.
    return D3DENUMRET_OK;
}


int getzbuffer(DDPIXELFORMAT & ddpfZBuffer) {

	ddpfZBuffer.dwSize = 0;

	if (Settings.zbits == -1) {
		ddpfZBuffer.dwZBufferBitDepth = 16;
		DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);

		if (ddpfZBuffer.dwSize == 0) {
			log("  Could not create 16-bit W-Buffer");
			return XGLFALSE;
		}

		depthbuf_lut[XGLDB_WBUF] = DEPTH_W;
		depthbuf_lut[XGLDB_WBUF2] = DEPTH_W;
	} else if (Settings.zbits) {
		ddpfZBuffer.dwZBufferBitDepth = Settings.zbits;
		DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);

		if (ddpfZBuffer.dwSize == 0) {
			log("  Could not create " << Settings.zbits << " bit depth buffer");
			return XGLFALSE;
		}

		int type;
		switch (Settings.zbits) {
		case 16: type = DEPTH_W_Z16; break;
		case 24: type = DEPTH_W_Z24; break;
		case 32: type = DEPTH_W_Z32; break;
		default: log("Bad registry entry: zbits (needs to be 16, 24, or 32 decimal)"); return XGLFALSE;
		};

		depthbuf_lut[XGLDB_WBUF] = type;
		depthbuf_lut[XGLDB_WBUF2] = type;

	} else {
		if (DX.D3DHD.dpcTriCaps.dwRasterCaps & D3DPRASTERCAPS_WBUFFER) {
			ddpfZBuffer.dwZBufferBitDepth = 16;
			DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);
	
			if (ddpfZBuffer.dwSize == 0) {
				log("  Could not create 16-bit W-Buffer");
				return XGLFALSE;
			}
	
			depthbuf_lut[XGLDB_WBUF] = DEPTH_W;
			depthbuf_lut[XGLDB_WBUF2] = DEPTH_W;
		} else {
			ddpfZBuffer.dwZBufferBitDepth = 24;
			DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);
	
			if (ddpfZBuffer.dwSize > 0) {
				Voodoo.Zdepth = 24;
				depthbuf_lut[XGLDB_WBUF] = DEPTH_W_Z24;
				depthbuf_lut[XGLDB_WBUF2] = DEPTH_W_Z24;
				log("  Found a 24 bit depth buffer");
			} else {
				ddpfZBuffer.dwZBufferBitDepth = 32;
				DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);
		
				if (ddpfZBuffer.dwSize > 0) {
					Voodoo.Zdepth = 32;
					depthbuf_lut[XGLDB_WBUF] = DEPTH_W_Z32;
					depthbuf_lut[XGLDB_WBUF2] = DEPTH_W_Z32;
					log("  Found a 32 bit depth buffer");
				} else {
					ddpfZBuffer.dwZBufferBitDepth = 16;
					DX.D3D->EnumZBufferFormats(IID_IDirect3DHALDevice, EnumZBufferCallback, (VOID*)&ddpfZBuffer);
		
					if (ddpfZBuffer.dwSize > 0) {
						Voodoo.Zdepth = 16;
						depthbuf_lut[XGLDB_WBUF] = DEPTH_W_Z16;
						depthbuf_lut[XGLDB_WBUF2] = DEPTH_W_Z16;
						log("  Found a 16 bit depth buffer");
					} else {
						log("  Error: could not find a depth buffer!");
						return XGLFALSE;
					}
				}
			}
		}
	}

	depthbuf_lut[XGLDB_DISABLE] = DEPTH_D;
	depthbuf_lut[XGLDB_ZBUF] = DEPTH_Z;
	depthbuf_lut[XGLDB_ZBUF2] = DEPTH_Z;

	return XGLTRUE;
}