// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


TexList::TexList() {
	vlog("Called TexList::TexList");

	int i;

	for (i=0; i<MAX_TEXTURES; i++) _list[i] = 0;
}

TexList::~TexList() {
	vlog("Called TexList::~TexList");

	ReleaseAll();
}

void TexList::ReleaseAll() {

	for (int i=0; i<MAX_TEXTURES; i++) {
		if (_list[i]) {
			delete _list[i];
			_list[i] = 0;
		}
	}
}


void TexList::AddTex(const uint32 address, const XGLTexture &tex) {
	vlog("Called TexList::AddTex");

	if (_list[address>>10]->sameformat(tex)) {
		_list[address>>10]->copytexture(tex);
		log("Reused texture");
	} else {
		Tex *newtex = new Tex(address, tex);

		if (newtex->tex()) {
			DeleteTex(address);

			_list[address>>10] = newtex;
		}
	}
}

Tex * TexList::GetTex(const uint32 address, const XGLTexture &tex) {
	vlog("Called TexList::GetTex");

	return _list[address>>10];
}

void TexList::DeleteTex(const uint32 address) {
	vlog("Called TexList::DeleteTex: address=" << address);

	if (_list[address>>10]) {
		vlog("Deleted texture at address " << _list[address>>10]);

		delete _list[address>>10];

		if (Voodoo.curtex == _list[address>>10]) {
			Voodoo.curtex = 0;
			Voodoo.texture = NO_TEXTURE;
			SetVconv();
		}

		_list[address>>10] = 0;
	}

//	vvlog("Done with TexList::DeleteTex");

}

