// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


D3DTLVERTEX vert;
D3DTLVERTEX *tri;



inline void drawtriangle(XGLVertex *a, XGLVertex *b, XGLVertex *c ) {

#ifdef FRAMESKIP_BETA
	if (frame) {
#endif

	tri = _exebuffer->GetBuffer(1);

	vconv(*a, tri[0]);
	vconv(*b, tri[1]);
	vconv(*c, tri[2]);

#ifdef FRAMESKIP_BETA
	}
#endif

}

XGLLINK void XGLCALL grDrawTriangle(XGLVertex *a, XGLVertex *b, XGLVertex *c) {
	vvlog("Called grDrawTriangle");

	drawtriangle(a, b, c);
}

XGLLINK void XGLCALL grAADrawTriangle(XGLVertex *a, XGLVertex *b, XGLVertex *c, uint32 t1, uint32 t2, uint32 t3) {
	vvlog("Called grAADrawTriangle");

	drawtriangle(a, b, c);
}

XGLLINK void XGLCALL guDrawTriangleWithClip(XGLVertex *a, XGLVertex *b, XGLVertex *c) {
	vvlog("Called guDrawTriangleWithClip");

	drawtriangle(a, b, c);
}

/////////////////////////////////////////

inline void drawline(XGLVertex *v1, XGLVertex *v2) {
	_exebuffer->Flush();

	DX.D3DD->Begin(D3DPT_LINELIST, D3DFVF_TLVERTEX, D3DDP_DONOTLIGHT);
		vconv(*v1, vert);
		DX.D3DD->Vertex((LPVOID)&vert);
		vconv(*v2, vert);
		DX.D3DD->Vertex((LPVOID)&vert);
	DX.D3DD->End(0);
}

XGLLINK void XGLCALL grDrawLine(XGLVertex *v1, XGLVertex *v2) {
	vvlog("Called grDrawLine");

	drawline(v1, v2);
}

XGLLINK void XGLCALL grAADrawLine(XGLVertex *v1, XGLVertex *v2) {
	vvlog("Called grDrawLine");

	drawline(v1, v2);
}

////////////////////////////////////////

inline void drawpoint(XGLVertex *p) {
	_exebuffer->Flush();

	DX.D3DD->Begin(D3DPT_POINTLIST, D3DFVF_TLVERTEX, D3DDP_DONOTLIGHT);
		vconv(*p, vert);
		DX.D3DD->Vertex((LPVOID)&vert);
	DX.D3DD->End(0);
}

XGLLINK void XGLCALL grDrawPoint(XGLVertex *p) {
	vvlog("Called grDrawPoint");

	drawpoint(p);
}

XGLLINK void XGLCALL grAADrawPoint(XGLVertex *p) {
	vvlog("Called grDrawPoint");

	drawpoint(p);
}

//////////////////////////////////////

inline void drawpolygonvertexlist(uint32 num, XGLVertex *verts) {
	_exebuffer->Flush();
/*
	DX.D3DD->SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DBLEND_ONE);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DBLEND_ZERO);
	DX.D3DD->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
	DX.D3DD->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
	DX.D3DD->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_SELECTARG1);
*/

	DX.D3DD->Begin(D3DPT_TRIANGLEFAN, D3DFVF_TLVERTEX, D3DDP_DONOTLIGHT);
	for (uint32 i=0; i<num; i++) {
		vconv(verts[i], vert);
		DX.D3DD->Vertex((LPVOID)&vert);
	}
	DX.D3DD->End(0);
}

XGLLINK void XGLCALL grDrawPolygonVertexList(uint32 num, XGLVertex *verts) {
	vvlog("Called grDrawPolygonVertexList");

	drawpolygonvertexlist(num, verts);
}

XGLLINK void XGLCALL grDrawPlanarPolygonVertexList(uint32 num, XGLVertex *verts) {
	vvlog("Called grDrawPlanarPolygonVertexList");

	drawpolygonvertexlist(num, verts);
}


XGLLINK void XGLCALL grAADrawPolygonVertexList(uint32 num, XGLVertex *verts) {
	vvlog("Called grDrawPolygonVertexList");

	drawpolygonvertexlist(num, verts);
}

/////////////////////////////////////

inline void drawpolygon(uint32 num, uint32 *index, XGLVertex *verts) {
	_exebuffer->Flush();

	DX.D3DD->Begin(D3DPT_TRIANGLEFAN, D3DFVF_TLVERTEX, D3DDP_DONOTLIGHT);
	for (uint32 i=0; i<num; i++) {
		vconv(verts[index[i]], vert);
		DX.D3DD->Vertex((LPVOID)&vert);
	}
	DX.D3DD->End(0);
}

XGLLINK void XGLCALL grDrawPolygon(uint32 num, uint32 *index, XGLVertex *verts) {
	vvlog("Called grDrawPlanarPolygon");

	drawpolygon(num, index, verts);
}

XGLLINK void XGLCALL grDrawPlanarPolygon(uint32 num, uint32 *index, XGLVertex *verts) {
	vvlog("Called grDrawPlanarPolygon");

	drawpolygon(num, index, verts);
}

XGLLINK void XGLCALL grAADrawPolygon(uint32 num, uint32 *index, XGLVertex *verts) {
	vvlog("Called grDrawPlanarPolygon");

	drawpolygon(num, index, verts);
}

