/*****************************************************************************
 *****************************************************************************
 Copyright (c) 2001 - 2002, VIA Technologies, Inc.

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of VIA Technologies, Inc. nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/
#ifndef	RHINE_VMNS_H
#define RHINE_VMNS_H

#include "rhine.h"
#include "vmns_drv.h"
#include "rhine_cfg.h"


#define	GET_VMNS_PRIVATE(pInfo) ((pInfo)->vmns_priv)

typedef
struct _vmns_drv_private {	
	unsigned long		mode;
	VMNS_CALLBACK_FUNC	notify;
} VMNS_DRV_PRIVATE, *PVMNS_DRV_PRIVATE;

#define	GET_DRV_PRIVATE(dev) ((PDRV_PRIVATE) ((dev)->priv)
typedef struct netdev_private DRV_PRIVATE, *PDRV_PRIVATE;

int vmns_process_ioctl(struct net_device* dev, PVMNS_DRV_SIOC_HEADER pParams);
void vmns_set_mode(struct net_device* dev,PVMNS_DRV_PRIVATE vpriv,unsigned long);
#endif
