#!/bin/sh
KERN=`uname -r | sed 's/BOOT//'`
KERN_VER=$1
KERN_DIR=$1$3
DRIVER=sii6514
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD

# changes depending when your run
# e.g. /mnt/sysimage/root at fresh install time
#      or /root if run after installation
# WKR=/root
# WKR =/mnt/sysimage/root
WK=$2
WKR=$2root

$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""

echo "you are running $KERN  version of kernel (it may not matter)"
$SETCOLOR_WARNING
echo "Trying to find the correct driver for kernel $KERN_DIR"
echo "              THIS IS THE TARGET KERNEL"
$SETCOLOR_NORMAL
echo "MUST BE ROOT TO RUN THIS PROGRAM"
#echo "add 'smp' or 'custom' if necessary."
echo "Current working directory will be $WKR root if you have not rebooted"
#echo "e.g.  'sh ./setup-update smp' "
echo "Type carriage return to continue"
read nothing

echo "installing.."

mkdir -p $WKR/$DRIVER
cd       $WKR/$DRIVER
cp   -f  $INIDIR/modules.cgz  modules.cgz
gzip -dc modules.cgz > modules.cpio
cpio -idumv < modules.cpio
if [ ! -d $KERN_DIR ];then
    $SETCOLOR_FAILURE
    echo ""
    echo "####################################################################"
    echo "# SiI Driver for this kernel $KERN_DIR not found. Aborting...      #"
    echo "####################################################################"
    $SETCOLOR_NORMAL
    echo ""
    exit 1
fi


# install
cd $KERN_DIR

cp -f ./$DRIVER.o /lib/modules/$KERN_DIR/kernel/drivers/scsi/$DRIVER.o
echo "cp -f  /lib/modules/$KERN_DIR/kernel/drivers/scsi/scsi_mod.o scsi_mod.o" 
cp -f  /lib/modules/$KERN_DIR/kernel/drivers/scsi/scsi_mod.o scsi_mod.o 
echo $PWD
ls -al *
echo "Type carriage return to continue"
read nothing

#modify /etc/modules.conf file
#echo "current dir is $PWD. MODIFYING /etc/modules.conf"
#if [ -f /etc/rc.modules.bak ]; then
#echo "/etc/modules.conf already backep up"
#else
#cp /etc/modules.conf /etc/modules.conf.bak
#fi

#cp /etc/modules.conf tempf 
#source /root/$DRIVER/$KERN_DIR/cleanmodconf
#rm -rf tempf
#echo "current dir is $PWD ADDING TO /etc/modules.conf"
#mv /etc/modules.conf tempf
#cat tempf modules.inf >> /etc/modules.conf
# rm -rf tempf
#################################################

#create initrd image
INITRD_NAME=/boot/initrd-$KERN_DIR.$DRIVER

#echo "/sbin/depmod -ae System.map"
#/sbin/depmod -ae System.map

rm -rf $INITRD_NAME
#echo "$WK/sbin/mkinitrd -f -v $INITRD_NAME $KERN_DIR"
#$WK/sbin/mkinitrd -f -v $INITRD_NAME $KERN_DIR

#echo "$WK/sbin/mkinitrd --builtin=sii6514 --with=scsi_mod --with=$DRIVER $INITRD_NAME $KERN_DIR"
echo "$WK/sbin/mkinitrd --builtin=sii6514 --with=scsi_mod --with=$DRIVER $INITRD_NAME $KERN_DIR"

#$WK/sbin/mkinitrd --builtin=sii6514 --with=scsi_mod --with=$DRIVER $INITRD_NAME $KERN_DIR
$WK/sbin/mkinitrd --with=scsi_mod --with=$DRIVER $INITRD_NAME $KERN_DIR
echo "Type carriage return to continue.."
read nothing


echo "deleting loadable module $DRIVER.o (not needed)"
rm -rf /lib/modules/$KERN_DIR/kernel/drivers/scsi/$DRIVER.o

$SETCOLOR_WARNING
echo "INITRD_NAME is $INITRD_NAME"
echo "##########################################################"
echo "#  The next section will modify the boot loader           "
echo "#  If you prefer to do it manually please exit now        "
echo "#  The boot configuration file in use will be backep up   "
echo "##########################################################"
$SETCOLOR_NORMAL
echo "Type carrigae return to continue.."
read nothing

if [ -f /etc/lilo.conf ];then
    echo "LILO boot loader detected..."
    sed '/initrd=\/boot\/initrd-'$KERN_DIR'.img''$/c\
    initrd=/boot/initrd-'$KERN_DIR'.'$DRIVER'' /etc/lilo.conf > /tmp/lilo.tmp
    echo ""
    cat /tmp/lilo.tmp
    echo ""
    echo "Type carriage return to continue.."
    read nothing
    mv -f /etc/lilo.conf /etc/lilo.conf.old
    mv -f /tmp/lilo.tmp /etc/lilo.conf
 else
    echo "GRUB boot loader detected..."
    target=`/bin/awk '/vmlinuz-'$KERN_DIR' / {print $2}' /boot/grub/grub.conf|sed 's/vmlinuz/initrd/'`
    sed '/initrd \/initrd-'$KERN_DIR'.img''$/c\
    initrd '$target'.'$DRIVER'' /boot/grub/grub.conf > /tmp/grub.tmp
    mv -f /boot/grub/grub.conf /boot/grub/grub.conf.old
    mv -f /tmp/grub.tmp /boot/grub/grub.conf
fi

if [ -f /etc/lilo.conf ];then
/sbin/lilo
else
echo "GRUB may require more steps.. please check grub.conf, etc.
echo "Type carriage return to continue..
read nothing
fi

$SETCOLOR_WARNING
echo "INITRD_NAME is $INITRD_NAME"
echo "################################################################"
echo "#  Make sure Lilo and/or GRUB config file are correct           "
echo "#  Run Lilo if again necessary. Please inspect files visually   "
echo "################################################################"
$SETCOLOR_SUCCESS

echo "$DRIVER is now inside the bootable kernel image"


#output result
$SETCOLOR_SUCCESS
echo ""
echo "##########################################################"
echo "#        SiI driver installed on your system             #"
echo "##########################################################"
echo ""
echo "  Created image:  $INITRD_NAME"
echo ""
echo "  old /etc/modules.conf was backep up to /etc/modules.conf.bak"
echo "  Please Manually check /etc/modules.conf to make sure is OK"
echo "                  check lilo.conf and grub.conf             "
echo "  To test current VERSION of driver.. 'reboot'"
$SETCOLOR_NORMAL
 
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
