#!/bin/sh
KERN=`uname -r | sed 's/BOOT//'`
KERN_VER=$1
KERN_DIR=$1$3
DRIVER=sii6514
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD
WK=$2

$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""

echo "you are running $KERN  version of kernel (it may not matter)"
$SETCOLOR_WARNING
$SETCOLOR_NORMAL
echo "MUST BE ROOT TO RUN THIS PROGRAM"
echo "Type carriage return to continue"
read nothing

#mkdir -p $WKR/$DRIVER
#cd       $WKR/$DRIVER
# install
#cd $KERN_DIR 

if [ -f /mnt/sysimage/etc/lilo.conf ];then
 WRK="/mnt/sysimage" 
fi

echo "found $WRK/etc/lilo.conf"

if [ -f $WRK/etc/lilo.conf ];then
    echo "LILO boot loader detected..."
    sed -f $INIDIR/lilosii.sed $WRK/etc/lilo.conf > /tmp/lilo.tmp
    echo "-----------ORIGINAL FILE --------------"
    cat $WRK/etc/lilo.conf
    echo "-----------NEW LILO FILE --------------"
    cat /tmp/lilo.tmp
    echo "---------------------------------------"
    echo ""  
    echo "Type carriage return to continue or control-c to exit"
    read nothing
    cp -rf $WRK/etc/lilo.conf $WRK/etc/lilo.bak
    cp -rf /tmp/lilo.tmp $WRK/etc/lilo.conf
    echo "Running Lilo"
    $WRK/sbin/lilo
    $INIDIR/cleanup_9.0
else 

  if [ -f /mnt/sysimage/boot/grub/grub.conf ];then
   WRK2="/mnt/sysimage" 
  fi

  echo "found $WRK2/boot/grub/grub.conf"

  if [ -f $WRK2/boot/grub/grub.conf ];then

    echo "GRUB boot loader detected..."

    sed -f $INIDIR/grubsii.sed $WRK2/boot/grub/grub.conf > /tmp/grub.tmp
    echo "-----------ORIGINAL FILE --------------"
    cat $WRK2/boot/grub/grub.conf
    echo "-----------NEW KERNEL FILE ------------"
    cat /tmp/grub.tmp
    echo "---------------------------------------"
    echo ""  
    echo "Type carriage return to continue or control-c to exit"
    read nothing
    cp -rf $WRK2/boot/grub/grub.conf $WRK2/boot/grub/grub.bak
    cp -rf /tmp/grub.tmp $WRK2/boot/grub/grub.conf

    echo "Installing GRUB .92"
    mkdir -p $WRK2/usr/share/grub/i386-pc 
    cp -rf  $INIDIR/grub/i386-pc/* $WRK2/usr/share/grub/i386-pc
    cp -rf  $INIDIR/grub/* $WRK2/sbin/
    $WRK2/sbin/grub-install /dev/sda 
    $WRK2/sbin/grub-install -v
    echo "Cleaning up unused modules"
    $INIDIR/cleanup_9.0
  fi

fi

$SETCOLOR_WARNING
echo "################################################################"
echo "#  IF you have UNUSUAL CONFIGURATIONS..                         "
echo "#  Make sure Lilo and/or GRUB config file are correct           "
echo "#  Run Lilo again if necessary. Please inspect files visually   "
echo "#  BACKEP UP files are /etc/lilo.bak or /boot/grub/grub.bak     "
echo "################################################################"
$SETCOLOR_SUCCESS

echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"

