#!/bin/sh
KERN=`uname -r | sed 's/BOOT//'`
KERN_VER=$1
KERN_DIR=$1$2
DRIVER=sii6514
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD
$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""
echo "you are running $KERN version of kernel"
$SETCOLOR_WARNING
echo "Trying to find the correct driver for kernel $KERN_DIR"
echo " Will look for directory /root/$DRIVER/$KERN_DIR on the floppy"
$SETCOLOR_NORMAL
echo "MUST BE ROOT TO RUN THIS PROGRAM"
echo "add 'smp' or 'custom' if necessary."
echo "e.g.  'sh ./load.sh 2.4.18-14 smp' "
echo "Type any char to continue"
read nothing

echo "installing.."

rm   -rf /root/$DRIVER
mkdir -p /root/$DRIVER
cd       /root/$DRIVER
cp   -fu $INIDIR/modules.cgz  modules.cgz
gzip -dc modules.cgz > modules.cpio
cpio -idumv < modules.cpio
if [ ! -d /root/$DRIVER/$KERN_DIR ];then
    $SETCOLOR_FAILURE
    echo ""
    echo "####################################################################"
    echo "# SiI Driver $KERN_DIR for this kernel not found. Aborting...  " 
    echo "####################################################################"
    $SETCOLOR_NORMAL
    echo ""
    exit 1
fi

echo "Copying 'inf' files TO WORKING DIRECTORY"
cp  -fu  $INIDIR/modules.inf /root/$DRIVER/$KERN_DIR
cp  -fu  $INIDIR/driver.inf /root/$DRIVER/$KERN_DIR
echo "Copying cleanmodconf TO WORKING DIRECTORY"
rm -rf /root/$DRIVER/$KERN_DIR/cleanmodconf
cp  -fu $INIDIR/cleanmodconf /root/$DRIVER/$KERN_DIR/

# build driver and install
cd $KERN_DIR

rm -rf /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
echo "Copying driver from $PWD to /lib/modules/$KERN_DIR/kernel/drivers/scsi/$DRIVER.o"
echo "Copying driver from $PWD to /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o"
cp -fu ./$DRIVER.o /lib/modules/$KERN_DIR/kernel/drivers/scsi/$DRIVER.o
cp -fu ./$DRIVER.o /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
echo ".. At least ONE of these copies should be successful"
echo "    It seems to vary with a particular distribution"

################################################### 
#modify /etc/modules.conf file
echo "current dir is $PWD. MODIFYING /etc/modules.conf"
if [ -f /etc/rc.modules.bak ]; then
echo "/etc/modules.conf already backep up"
else
cp /etc/modules.conf /etc/modules.conf.bak
fi

cp /etc/modules.conf tempf 
source /root/$DRIVER/$KERN_DIR/cleanmodconf
rm -rf tempf
#echo "current dir is $PWD ADDING TO /etc/modules.conf"

# Due to unresolved symbols problem add insmod to init scripts
# @@@ mv /etc/modules.conf tempf
# @@@ cat tempf modules.inf >> /etc/modules.conf
# @@@ rm -rf tempf
#################################################

$SETCOLOR_SUCCESS
echo ""
echo "###################################################################"
echo "#        SiI loadable driver installed on your system             #"
echo "###################################################################"
echo ""
echo "  To test current VERSION of driver.. 'reboot'"
$SETCOLOR_NORMAL
 
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
