/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

class TaskDatabase
extends AbstractDatabase {
    private long maxTaskNumber;
    private long minTaskNumber;
    private ListTable taskTable = new ListTable();

    TaskDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Task");
        Timer timer = new Timer(5000, new TimerActionListener());
        timer.start();
        this.maxTaskNumber = -1L;
        this.minTaskNumber = 0L;
    }

    public synchronized void deleteTask(String task) {
        this.taskTable.remove(task);
        this.notifyListeners();
    }

    public synchronized long getMinTaskNumber() {
        return this.minTaskNumber;
    }

    private String getTaskId(String elementValue) {
        XmlData xmlData = new XmlData(elementValue);
        while (xmlData.getNextElement()) {
            if (!xmlData.element.equals("Task")) continue;
            return xmlData.elementValue;
        }
        return "";
    }

    public synchronized ArrayList getTaskList() {
        this.slowInitMode = false;
        ArrayList<Object> newTaskList = new ArrayList<Object>();
        int index = 0;
        while (index < this.taskTable.size()) {
            TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskTable.get(index);
            if (!taskDescriptor.status.equalsIgnoreCase("Unused")) {
                newTaskList.add(taskDescriptor.clone());
            }
            ++index;
        }
        return newTaskList;
    }

    public void initialize() {
        super.initialize();
        this.slowInitMode = true;
        this.maxTaskNumber = -1L;
        this.taskTable.clear();
        this.getFirst();
    }

    public synchronized void nuke(int controller) {
        super.nuke();
        this.taskTable.clear();
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing && faultDescriptor.reason.equals("None Found")) {
                        this.initializationComplete();
                    }
                } else if (xmlData.element.equals("TaskInfo")) {
                    TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskTable.get(this.getTaskId(xmlData.elementValue));
                    if (taskDescriptor != null) {
                        taskDescriptor.parseXml(xmlData.elementValue);
                        if (taskDescriptor.status.equals("Unused")) {
                            this.taskTable.remove(Long.toString(taskDescriptor.task));
                        }
                    } else {
                        taskDescriptor = new TaskDescriptor(xmlData.elementValue);
                        this.taskTable.put(this.taskTable.size(), Long.toString(taskDescriptor.task), taskDescriptor);
                        if (taskDescriptor.task > this.maxTaskNumber) {
                            this.maxTaskNumber = taskDescriptor.task;
                        }
                    }
                    if (this.initializing) {
                        this.getNext(taskDescriptor.task);
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "TaskDatabase Exception\nMessage " + message.response);
        }
    }

    public void processUpdateCount(long latestUpdateCount) {
        if (latestUpdateCount != this.updateCount) {
            String request = "<si:Request><si:Type>" + this.updateCountType + "UpdateCounts</si:Type>" + "</si:Request>";
            this.databaseManager.commManager.sendMessage("Get", request, this.countsMessageHandler);
            this.updateCount = latestUpdateCount;
            this.minTaskNumber = this.maxTaskNumber;
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            int index = 0;
            while (index < this.taskTable.size()) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskTable.get(index);
                taskDescriptor.receivedUpdateCount = false;
                ++index;
            }
            XmlData xmlData = new XmlData(data);
            System.out.println("task counts " + data);
            while (xmlData.getNextElement()) {
                long taskLong;
                if (!xmlData.element.equals("TaskUpdateCount")) continue;
                String task = null;
                String updateCount = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("Task")) {
                        task = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    updateCount = updateXmlData.elementValue;
                }
                if (task == null || updateCount == null) continue;
                TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskTable.get(task);
                if (taskDescriptor != null) {
                    taskDescriptor.receivedUpdateCount = true;
                }
                if (taskDescriptor == null || !taskDescriptor.updateCount.equals(updateCount)) {
                    this.getThis(task);
                }
                if ((taskLong = Long.parseLong(task)) >= this.minTaskNumber) continue;
                this.minTaskNumber = taskLong;
            }
            int index2 = 0;
            while (index2 < this.taskTable.size()) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskTable.get(index2);
                if (!taskDescriptor.receivedUpdateCount) {
                    taskDescriptor.valid = false;
                    if (this.minTaskNumber < taskDescriptor.task) {
                        this.getThis(taskDescriptor.task);
                    }
                }
                ++index2;
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "Task Database Process Update Counts Exception\n " + data);
        }
    }

    class TimerActionListener
    implements ActionListener {
        TimerActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (!TaskDatabase.this.valid || TaskDatabase.this.initializing) {
                return;
            }
            int index = 0;
            while (index < TaskDatabase.this.taskTable.size()) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)TaskDatabase.this.taskTable.get(index);
                if (taskDescriptor.status.equals("Active")) {
                    TaskDatabase.this.getThis(taskDescriptor.task);
                }
                ++index;
            }
        }
    }
}

