/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class StorageManagementUtility
extends KFrame
implements GlobalConstants {
    public boolean advancedRaidOption;
    CommLinkUpdateListener commLinkUpdateListener;
    CommManager commManager;
    private static Preferences configPreferences;
    ControllerUpdateListener controllerUpdateListener;
    public int createdRaidGroupCount;
    DatabaseManager databaseManager;
    public boolean deleteMemberOption;
    DeviceChannelPanel deviceChannelPanel;
    static boolean firstTime;
    HostConnectionManager hostConnectionManager;
    public boolean legacySupportOption;
    JLabel link0Label;
    public boolean logFileGen;
    public String logFilePath;
    MenuBar menubar;
    ArrayList openWindows = new ArrayList();
    public String popUpLevel;
    public String purgeFilePath;
    public boolean resourceInfoOption;
    static StorageManagementUtility storageManagementUtility;
    JLabel subsystemStatusLabel;
    UpdateListener updateListener;
    int waitCount;

    static {
        firstTime = true;
        configPreferences = Preferences.userRoot().node("/Sam/System/Configuration");
    }

    public StorageManagementUtility(String[] arguments) {
        this.beginFrameInit(this.databaseManager, this, "SAM (SiI Array Manager)");
        this.hostConnectionManager = new HostConnectionManager(this);
        this.commManager = this.hostConnectionManager.getCommManager();
        this.databaseManager = new DatabaseManager(this, this.hostConnectionManager);
        this.commManager.addDatabaseManager(this.databaseManager);
        this.loadConfigurationPreferences();
        this.waitCount = 0;
        this.enableEvents(64L);
    }

    static /* synthetic */ boolean access$600(StorageManagementUtility x0, String x1) {
        return x0.alreadyOpen(x1);
    }

    private boolean alreadyOpen(String title) {
        int index = 0;
        while (index < this.openWindows.size()) {
            JFrame frame = (JFrame)this.openWindows.get(index);
            if (frame.getTitle().equals(title)) {
                frame.toFront();
                return true;
            }
            ++index;
        }
        return false;
    }

    private void buildStatusBar() {
        JPanel statusBar = new JPanel();
        GridBagLayout statusBarLayout = new GridBagLayout();
        statusBar.setLayout(statusBarLayout);
        this.getContentPane().add((Component)statusBar, "South");
        ControllerDescriptor connectedController = this.databaseManager.controllerDatabase.getConnectedController();
        this.subsystemStatusLabel = new JLabel(" Controller: " + connectedController.chipType);
        Utility.setLabelAtrributes(this.subsystemStatusLabel, 10, 0, 1, 2, statusBarLayout);
        statusBar.add(this.subsystemStatusLabel);
        this.link0Label = new JLabel(" Link Status: Connected");
        Utility.setLabelAtrributes(this.link0Label, 4, 1, 0, 0, statusBarLayout);
        statusBar.add(this.link0Label);
    }

    public synchronized void clearWait() {
        if (--this.waitCount == 0) {
            this.setCursor(new Cursor(0));
        }
    }

    public synchronized void closeNotification(Object closingObject) {
        int index = 0;
        while (index < this.openWindows.size()) {
            if (closingObject == this.openWindows.get(index)) {
                this.openWindows.remove(index);
                break;
            }
            ++index;
        }
    }

    public void databaseInitialized() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!firstTime) {
                    StorageManagementUtility.this.updateStatusBar();
                    return;
                }
                StorageManagementUtility.this.menubar = new MenuBar();
                StorageManagementUtility.this.setJMenuBar(StorageManagementUtility.this.menubar);
                StorageManagementUtility.this.buildStatusBar();
                StorageManagementUtility.this.deviceChannelPanel = new DeviceChannelPanel(StorageManagementUtility.this, StorageManagementUtility.this.databaseManager);
                JScrollPane deviceChannelPane = new JScrollPane(StorageManagementUtility.this.deviceChannelPanel);
                deviceChannelPane.setHorizontalScrollBarPolicy(31);
                deviceChannelPane.getVerticalScrollBar().setUnitIncrement(StorageManagementUtility.this.deviceChannelPanel.getVerticalScrollUnitIncrement());
                Dimension dim = deviceChannelPane.getPreferredSize();
                dim.width = StorageManagementUtility.this.deviceChannelPanel.getPreferredWidth();
                deviceChannelPane.setPreferredSize(dim);
                RaidGroupTreePane treePanel = new RaidGroupTreePane(StorageManagementUtility.this, StorageManagementUtility.this.databaseManager);
                JScrollPane raidTreePane = new JScrollPane(treePanel);
                raidTreePane.setHorizontalScrollBarPolicy(31);
                JSplitPane mainPane = new JSplitPane(1, raidTreePane, deviceChannelPane);
                mainPane.setResizeWeight(0.5);
                dim = mainPane.getPreferredSize();
                dim.height = 360;
                dim.width = StorageManagementUtility.this.deviceChannelPanel.getPreferredWidth() + treePanel.getPreferredSize().width + 20;
                mainPane.setPreferredSize(dim);
                StorageManagementUtility.this.getContentPane().add((Component)mainPane, "Center");
                StorageManagementUtility.this.pack();
                mainPane.setDividerLocation(StorageManagementUtility.this.getBounds().width - (StorageManagementUtility.this.deviceChannelPanel.getPreferredSize().width + 0));
                StorageManagementUtility.this.completeFrameInit();
                StorageManagementUtility.this.updateListener = new UpdateListener();
                StorageManagementUtility.this.databaseManager.raidGroupDatabase.addUpdateListener(StorageManagementUtility.this.updateListener);
                StorageManagementUtility.this.databaseManager.deviceDatabase.addUpdateListener(StorageManagementUtility.this.updateListener);
                StorageManagementUtility.this.databaseManager.eventDatabase.addUpdateListener(StorageManagementUtility.this.updateListener);
                StorageManagementUtility.this.commLinkUpdateListener = new CommLinkUpdateListener();
                StorageManagementUtility.this.commManager.addUpdateListener(StorageManagementUtility.this.commLinkUpdateListener);
                StorageManagementUtility.this.commLinkUpdateListener.run();
                StorageManagementUtility.this.controllerUpdateListener = new ControllerUpdateListener();
                StorageManagementUtility.this.databaseManager.controllerDatabase.addUpdateListener(StorageManagementUtility.this.controllerUpdateListener);
                StorageManagementUtility.this.controllerUpdateListener.run();
                firstTime = false;
            }
        });
    }

    public void fileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void loadConfigurationPreferences() {
        this.logFileGen = configPreferences.getBoolean("logfilegen", false);
        this.logFilePath = configPreferences.get("logfilepath", "");
        if (this.logFilePath.equals("")) {
            this.logFilePath = GlobalConstants.userDirectory + GlobalConstants.separatorChar + "eventlog.evl";
        }
        this.purgeFilePath = configPreferences.get("purgefilepath", "");
        if (this.purgeFilePath.equals("")) {
            this.purgeFilePath = GlobalConstants.userDirectory + GlobalConstants.separatorChar + "eventlog.bak";
        }
        System.out.println("loadConfigurationPreferences(): logFileGen    = '" + this.logFileGen + "'");
        System.out.println("loadConfigurationPreferences(): logFilePath   = '" + this.logFilePath + "'");
        System.out.println("loadConfigurationPreferences(): purgeFilePath = '" + this.purgeFilePath + "'");
        this.popUpLevel = configPreferences.get("popUpLevel", "");
        if (this.popUpLevel.equals("")) {
            this.popUpLevel = "Error";
        }
        this.legacySupportOption = configPreferences.getBoolean("legacySupportOption", false);
        this.deleteMemberOption = configPreferences.getBoolean("deleteMemberOption", false);
        this.resourceInfoOption = configPreferences.getBoolean("resourceInfoOption", false);
        this.advancedRaidOption = configPreferences.getBoolean("advancedRaidOption", false);
    }

    public static void main(String[] arguments) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                UIManager.put("ScrollBar.track", new Color(230, 230, 230));
                UIDefaults defaults = UIManager.getDefaults();
                Font newFont = new Font("Dialog", 0, 12);
                Enumeration enumeration = defaults.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    Object value = defaults.get(key);
                    String name = key.toString();
                    if (!name.endsWith("font") || !value.toString().endsWith("[family=sansserif,name=MS Sans Serif,style=plain,size=11]")) continue;
                    UIManager.put(name, new FontUIResource(newFont));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error: unable to load application look and feel \nDetails: " + e);
        }
        storageManagementUtility = new StorageManagementUtility(arguments);
    }

    private boolean previouslyOpen(String title) {
        Preferences preferences = Preferences.userRoot().node("/Sam/" + title);
        return preferences.getBoolean("Frame Open", false);
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    public void saveConfigurationPreferences() {
        System.out.println("saveConfigurationPreferences(): logFileGen    = '" + this.logFileGen + "'");
        System.out.println("saveConfigurationPreferences(): logFilePath   = '" + this.logFilePath + "'");
        System.out.println("saveConfigurationPreferences(): purgeFilePath = '" + this.purgeFilePath + "'");
        System.out.println("saveConfigurationPreferences(): popUpLevel    = '" + this.popUpLevel + "'");
        configPreferences.putBoolean("logfilegen", this.logFileGen);
        configPreferences.put("logfilepath", this.logFilePath);
        configPreferences.put("purgefilepath", this.purgeFilePath);
        configPreferences.put("popUpLevel", this.popUpLevel);
        configPreferences.putBoolean("legacySupportOption", this.legacySupportOption);
        configPreferences.putBoolean("deleteMemberOption", this.deleteMemberOption);
        configPreferences.putBoolean("resourceInfoOption", this.resourceInfoOption);
        configPreferences.putBoolean("advancedRaidOption", this.advancedRaidOption);
    }

    public void saveLogFilePathConfiguration(String newLogFilePath) {
        this.logFilePath = newLogFilePath;
        configPreferences.put("logfilepath", this.logFilePath);
    }

    public void savePurgeFilePathConfiguration(String newPurgeFilePath) {
        this.purgeFilePath = newPurgeFilePath;
        configPreferences.put("logfilepath", this.purgeFilePath);
    }

    public synchronized void setWait() {
        if (this.waitCount++ == 0) {
            this.setCursor(new Cursor(3));
        }
    }

    private void updateStatusBar() {
        ControllerDescriptor connectedController = this.databaseManager.controllerDatabase.getConnectedController();
        this.subsystemStatusLabel.setText(connectedController.chipType);
    }

    private class CommLinkUpdateListener
    implements Runnable {
        private CommLinkUpdateListener() {
        }

        public void run() {
            StorageManagementUtility.this.link0Label.setText(" Link Status: " + StorageManagementUtility.this.commManager.commLink.upDownStatus);
        }
    }

    private class ControllerUpdateListener
    implements Runnable {
        private ControllerUpdateListener() {
        }

        public void run() {
            StorageManagementUtility.this.menubar.update();
        }
    }

    protected class UpdateListener
    implements Runnable {
        protected UpdateListener() {
        }

        public void run() {
            StorageManagementUtility.this.menubar.update();
        }
    }

    class MenuBar
    extends JMenuBar {
        JMenuItem breakpointMenuItem;
        JMenuItem checkRaidSetMenuItem;
        JMenuItem convertLegacyRaidGroupMenuItem;
        JMenuItem convertLegacySpareMenuItem;
        JMenuItem createLegacyRaidGroupMenuItem;
        JMenuItem createLegacySpareMenuItem;
        JMenuItem createRaidGroupMenuItem;
        JMenuItem createSpareMenuItem;
        JMenu debugMenu;
        JMenuItem deleteLegacyRaidGroupMenuItem;
        JMenuItem deleteLegacySpareMenuItem;
        JMenuItem deleteMemberMenuItem;
        JMenuItem deleteOrphanMenuItem;
        JMenuItem deleteRaidGroupMenuItem;
        JMenuItem deleteSpareMenuItem;
        JMenu deviceMenu;
        JMenuItem deviceSummaryMenuItem;
        JMenuItem eventLogMenuItem;
        JMenu fileMenu = this.buildFileMenu();
        JMenuItem firmwareMenuItem;
        JMenu helpMenu;
        JMenu legacyMenu;
        JMenuItem nukeMetadataMenuItem;
        JMenuItem performanceMenuItem;
        JMenuItem processInfoMenuItem;
        JMenu raidGroupMenu;
        JMenuItem raidGroupParametersMenuItem;
        JMenuItem raidGroupSummaryMenuItem;
        JMenuItem rebuildLegacyRaidGroupMenuItem;
        JMenuItem rebuildRaidGroupMenuItem;
        JMenuItem reconfigureRaidSetMenuItem;
        JMenuItem resourceInfoMenuItem;
        JMenuItem shutdownMenuItem;
        JMenu systemMenu;
        JMenuItem taskManagerMenuItem;
        JMenu windowMenu;

        public MenuBar() {
            this.deviceMenu = this.buildDeviceMenu();
            this.raidGroupMenu = this.buildRaidGroupMenu();
            this.windowMenu = this.buildWindowMenu();
            this.legacyMenu = this.buildLegacySupportMenu();
            this.debugMenu = this.buildDebugMenu();
            this.helpMenu = this.buildHelpMenu();
            this.createMenuBar();
            this.update();
        }

        static /* synthetic */ StorageManagementUtility access$400(MenuBar x0) {
            return x0.StorageManagementUtility.this;
        }

        static /* synthetic */ void access$500(MenuBar x0) {
            x0.updateMenuBar();
        }

        public JMenu buildDebugMenu() {
            this.debugMenu = new JMenu("Debug");
            this.debugMenu.setMnemonic(71);
            this.nukeMetadataMenuItem = new JMenuItem("Nuke Metadata", 78);
            this.debugMenu.add(this.nukeMetadataMenuItem);
            this.nukeMetadataMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(MenuBar.access$400(this.this$1), "Are you sure you want to Clear All Metadata?", "Clear All Metadata", 0);
                    if (answer == 0 && (answer = JOptionPane.showConfirmDialog(MenuBar.access$400(this.this$1), "Last chance!!! Are you REALLY sure you want to Clear All Metadata? All data will be irretrievably lost!!!", "Clear All Metadata", 0)) == 0) {
                        String request = "<si:Request><si:Type>NukeAllMetadata</si:Type></si:Request>";
                        MenuBar.access$400((MenuBar)this.this$1).databaseManager.commManager.sendMessage("Execute", request, null);
                    }
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            return this.debugMenu;
        }

        public JMenu buildDeviceMenu() {
            this.deviceMenu = new JMenu("Device");
            this.deviceMenu.setMnemonic(68);
            this.createSpareMenuItem = new JMenuItem("Create Spare", 67);
            this.deleteSpareMenuItem = new JMenuItem("Delete Spare", 68);
            this.deleteMemberMenuItem = new JMenuItem("Delete Member", 77);
            this.deleteOrphanMenuItem = new JMenuItem("Delete Orphan", 79);
            this.deviceSummaryMenuItem = new JMenuItem("Device Summary", 86);
            this.createSpareMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new CreateSpareBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Create Spare");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteSpareMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeleteSpareBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Delete Spare", "New");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteMemberMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeleteRaidGroupMemberBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Delete RAID Group Member");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteOrphanMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeleteOrphanBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Delete Orphan Segment", "New");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deviceSummaryMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeviceSummaryPage(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Device Summary");
                }
            });
            this.deviceMenu.add(this.createSpareMenuItem);
            this.deviceMenu.add(this.deleteSpareMenuItem);
            if (StorageManagementUtility.this.deleteMemberOption) {
                this.deviceMenu.add(this.deleteMemberMenuItem);
            }
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deleteOrphanMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deviceSummaryMenuItem);
            return this.deviceMenu;
        }

        public JMenu buildFileMenu() {
            this.fileMenu = new JMenu("File");
            this.fileMenu.setMnemonic(70);
            JMenuItem connectionMenuItem = new JMenuItem("Connections...", 67);
            JMenuItem configurationMenuItem = new JMenuItem("Configuration...", 75);
            JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
            this.fileMenu.add(configurationMenuItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(exitMenuItem);
            connectionMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new PostponedConnectionTableBox(MenuBar.access$400(this.this$1), MenuBar.access$400((MenuBar)this.this$1).hostConnectionManager);
                }
            });
            configurationMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new ConfigurationBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Configuration Screen");
                    MenuBar.access$500(MenuBar.access$400((MenuBar)this.this$1).menubar);
                    MenuBar.access$400(this.this$1).setJMenuBar(MenuBar.access$400((MenuBar)this.this$1).menubar);
                }
            });
            exitMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            return this.fileMenu;
        }

        public JMenu buildHelpMenu() {
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            JMenuItem helpTopicsMenuItem = new JMenuItem("Help Topics", 84);
            this.breakpointMenuItem = new JMenuItem("Breakpoint", 66);
            JMenuItem AboutMenuItem = new JMenuItem("About", 65);
            helpTopicsMenuItem.setEnabled(false);
            helpMenu.add(helpTopicsMenuItem);
            helpMenu.addSeparator();
            helpMenu.add(AboutMenuItem);
            AboutMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new AboutBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager);
                }
            });
            return helpMenu;
        }

        public JMenu buildLegacySupportMenu() {
            String rebuildOldRaidGroupMetaDataStr = "Rebuild Legacy RAID Group";
            String deleteOldRaidGroupMetaDataStr = "Delete Legacy RAID Group";
            this.legacyMenu = new JMenu("Legacy Support");
            this.legacyMenu.setMnemonic(87);
            this.createLegacyRaidGroupMenuItem = new JMenuItem("Create Legacy RAID Group", 82);
            this.rebuildLegacyRaidGroupMenuItem = new JMenuItem("Rebuild Legacy RAID Group", 71);
            this.deleteLegacyRaidGroupMenuItem = new JMenuItem("Delete Legacy RAID Group", 69);
            this.convertLegacyRaidGroupMenuItem = new JMenuItem("Convert Legacy RAID Group", 67);
            this.createLegacySpareMenuItem = new JMenuItem("Create Legacy Spare", 65);
            this.deleteLegacySpareMenuItem = new JMenuItem("Delete Legacy Spare", 68);
            this.convertLegacySpareMenuItem = new JMenuItem("Convert Legacy Spare", 79);
            this.legacyMenu.add(this.createLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.rebuildLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.deleteLegacyRaidGroupMenuItem);
            this.legacyMenu.add(this.convertLegacyRaidGroupMenuItem);
            this.legacyMenu.addSeparator();
            this.legacyMenu.add(this.createLegacySpareMenuItem);
            this.legacyMenu.add(this.deleteLegacySpareMenuItem);
            this.legacyMenu.add(this.convertLegacySpareMenuItem);
            this.createLegacyRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new CreateLegacyRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Create Legacy RAID Group");
                    if (MenuBar.access$400((MenuBar)this.this$1).createdRaidGroupCount > 0) {
                        new ScanPopUpBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Registering new RAID Groups");
                        MenuBar.access$400((MenuBar)this.this$1).createdRaidGroupCount = 0;
                    }
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.rebuildLegacyRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new RebuildRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Rebuild Legacy RAID Group", "Old");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteLegacyRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeleteRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Delete Legacy RAID Group", "Old");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.convertLegacyRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new ConvertLegacyRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Convert Legacy RAID Group");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.createLegacySpareMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new CreateLegacySpareBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Create Legacy Spare");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteLegacySpareMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new DeleteSpareBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Delete Legacy Spare", "Old");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.convertLegacySpareMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new ConvertLegacySpareBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Convert Legacy Spare");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            return this.legacyMenu;
        }

        public JMenu buildRaidGroupMenu() {
            this.raidGroupMenu = new JMenu("RAID Group");
            this.raidGroupMenu.setMnemonic(82);
            this.raidGroupParametersMenuItem = new JMenuItem("RAID Group Parameters", 80);
            this.createRaidGroupMenuItem = new JMenuItem("Create RAID Group", 67);
            this.reconfigureRaidSetMenuItem = new JMenuItem("Reconfigure RAID Group", 71);
            this.rebuildRaidGroupMenuItem = new JMenuItem("Rebuild RAID Group", 82);
            this.checkRaidSetMenuItem = new JMenuItem("Check RAID Group", 72);
            this.deleteRaidGroupMenuItem = new JMenuItem("Delete RAID Group", 68);
            this.raidGroupSummaryMenuItem = new JMenuItem("RAID Group Summary", 83);
            this.createRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    int answer = 0;
                    if (MenuBar.access$400((MenuBar)this.this$1).databaseManager.deviceDatabase.legacyBootSupportable()) {
                        answer = JOptionPane.showConfirmDialog(MenuBar.access$400(this.this$1), "Creation of RAID Group(s) now may prevent you from creating Bootable RAID Group(s) at a later time.\nOperating System can only be stored on and started from a Bootable RAID Group.\nTo create Bootable RAID Group(s), use the Create Legacy RAID Group option under the Legacy Support.\nAre you sure you want to continue?", "RAID Group Creation Verification", 0);
                    }
                    if (answer == 0) {
                        new CreateRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Create RAID Group");
                        if (MenuBar.access$400((MenuBar)this.this$1).createdRaidGroupCount > 0) {
                            new ScanPopUpBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Registering new RAID Groups");
                            MenuBar.access$400((MenuBar)this.this$1).createdRaidGroupCount = 0;
                        }
                        MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                    }
                }
            });
            this.rebuildRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String title = "Rebuild RAID Group";
                    new RebuildRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, title, "New");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.deleteRaidGroupMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String title = "Delete RAID Group";
                    new DeleteRaidGroupBox(MenuBar.access$400((MenuBar)this.this$1).databaseManager, title, "New");
                    MenuBar.access$400((MenuBar)this.this$1).menubar.update();
                }
            });
            this.raidGroupSummaryMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String title = "RAID Group Summary";
                    if (!StorageManagementUtility.access$600(MenuBar.access$400(this.this$1), title)) {
                        MenuBar.access$400((MenuBar)this.this$1).openWindows.add(new RaidGroupSummaryPage(MenuBar.access$400((MenuBar)this.this$1).databaseManager, title));
                    }
                }
            });
            this.raidGroupMenu.add(this.createRaidGroupMenuItem);
            this.raidGroupMenu.add(this.rebuildRaidGroupMenuItem);
            this.raidGroupMenu.add(this.deleteRaidGroupMenuItem);
            this.raidGroupMenu.addSeparator();
            this.raidGroupMenu.add(this.raidGroupSummaryMenuItem);
            return this.raidGroupMenu;
        }

        public JMenu buildSystemMenu() {
            this.systemMenu = new JMenu("System");
            this.systemMenu.setMnemonic(83);
            JMenuItem parametersMenuItem = new JMenuItem("System Parameters", 80);
            JMenuItem deviceParametersMenuItem = new JMenuItem("Device Parameters", 68);
            JMenuItem flashMenuItem = new JMenuItem("Flash Images", 70);
            this.firmwareMenuItem = new JMenuItem("Update Firmware", 85);
            this.shutdownMenuItem = new JMenuItem("Shutdown System", 83);
            this.systemMenu.add(parametersMenuItem);
            this.systemMenu.add(deviceParametersMenuItem);
            this.systemMenu.add(flashMenuItem);
            this.systemMenu.add(this.firmwareMenuItem);
            this.systemMenu.add(this.shutdownMenuItem);
            return this.systemMenu;
        }

        public JMenu buildWindowMenu() {
            this.windowMenu = new JMenu("Window");
            this.windowMenu.setMnemonic(87);
            this.taskManagerMenuItem = new JMenuItem("Task Manager", 84);
            this.eventLogMenuItem = new JMenuItem("Event Log", 69);
            this.performanceMenuItem = new JMenuItem("I/O Statistics", 73);
            this.resourceInfoMenuItem = new JMenuItem("Resources", 82);
            this.processInfoMenuItem = new JMenuItem("Processes", 80);
            this.windowMenu.add(this.taskManagerMenuItem);
            this.windowMenu.add(this.eventLogMenuItem);
            if (StorageManagementUtility.this.resourceInfoOption) {
                this.windowMenu.add(this.resourceInfoMenuItem);
            }
            this.taskManagerMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String title = "Task Summary";
                    if (!StorageManagementUtility.access$600(MenuBar.access$400(this.this$1), title)) {
                        MenuBar.access$400((MenuBar)this.this$1).openWindows.add(new TaskManagerPage(MenuBar.access$400((MenuBar)this.this$1).databaseManager, title));
                    }
                }
            });
            this.eventLogMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new EventSummaryPage(MenuBar.access$400((MenuBar)this.this$1).databaseManager, "Event Log");
                }
            });
            this.resourceInfoMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuBar this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    String title = "Resource Information";
                    if (!StorageManagementUtility.access$600(MenuBar.access$400(this.this$1), title)) {
                        MenuBar.access$400((MenuBar)this.this$1).openWindows.add(new ResourcePage(MenuBar.access$400((MenuBar)this.this$1).databaseManager, title));
                    }
                }
            });
            return this.windowMenu;
        }

        private void createMenuBar() {
            this.add(this.fileMenu);
            this.add(this.deviceMenu);
            this.add(this.raidGroupMenu);
            this.add(this.windowMenu);
            if (StorageManagementUtility.this.legacySupportOption) {
                this.add(this.legacyMenu);
            }
            this.add(this.helpMenu);
        }

        private void rebuildDeviceMenu() {
            this.deviceMenu.removeAll();
            this.deviceMenu.add(this.createSpareMenuItem);
            this.deviceMenu.add(this.deleteSpareMenuItem);
            if (StorageManagementUtility.this.deleteMemberOption) {
                this.deviceMenu.add(this.deleteMemberMenuItem);
            }
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deleteOrphanMenuItem);
            this.deviceMenu.addSeparator();
            this.deviceMenu.add(this.deviceSummaryMenuItem);
        }

        private void rebuildWindowMenu() {
            this.windowMenu.removeAll();
            this.windowMenu.add(this.taskManagerMenuItem);
            this.windowMenu.add(this.eventLogMenuItem);
            if (StorageManagementUtility.this.resourceInfoOption) {
                this.windowMenu.add(this.resourceInfoMenuItem);
            }
        }

        public void update() {
            if (!StorageManagementUtility.this.commManager.commLink.enabled) {
                return;
            }
            this.reconfigureRaidSetMenuItem.setEnabled(false);
            this.checkRaidSetMenuItem.setEnabled(false);
            this.deleteRaidGroupMenuItem.setEnabled(false);
            this.deleteMemberMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.newRaidGroupExists()) {
                this.rebuildRaidGroupMenuItem.setEnabled(true);
                this.deleteRaidGroupMenuItem.setEnabled(true);
                String[] raidGroupStatuses = new String[]{"Online"};
                if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.getRaidGroupList(raidGroupStatuses, true, "New").size() > 0) {
                    this.deleteMemberMenuItem.setEnabled(true);
                }
            }
            this.deleteOrphanMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.orphanedSegmentExists()) {
                this.deleteOrphanMenuItem.setEnabled(true);
            }
            this.rebuildRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.newReducedRaidGroupExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.availableSegmentExists()) {
                this.rebuildRaidGroupMenuItem.setEnabled(true);
            }
            this.createRaidGroupMenuItem.setEnabled(false);
            this.createSpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.availableSegmentExists()) {
                if (StorageManagementUtility.this.databaseManager.deviceDatabase.getNumberOfNewSpares() < StorageManagementUtility.this.databaseManager.maximumRaidGroups) {
                    this.createSpareMenuItem.setEnabled(true);
                }
                if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.getNextAvailableRaidGroup() != -1) {
                    this.createRaidGroupMenuItem.setEnabled(true);
                }
            }
            this.deleteSpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.newSpareExists()) {
                this.deleteSpareMenuItem.setEnabled(true);
            }
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.legacyBootSupportable() && !StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupMaxReached()) {
                this.createLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.createLegacySpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.getBootableSegmentCount() > 0) {
                this.createLegacySpareMenuItem.setEnabled(true);
            }
            this.convertLegacyRaidGroupMenuItem.setEnabled(false);
            this.deleteLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyRaidGroupExists()) {
                this.convertLegacyRaidGroupMenuItem.setEnabled(true);
                this.deleteLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.rebuildLegacyRaidGroupMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.raidGroupDatabase.legacyReducedRaidGroupExists() && StorageManagementUtility.this.databaseManager.deviceDatabase.availableLbn0SegmentExists()) {
                this.rebuildLegacyRaidGroupMenuItem.setEnabled(true);
            }
            this.convertLegacySpareMenuItem.setEnabled(false);
            this.deleteLegacySpareMenuItem.setEnabled(false);
            if (StorageManagementUtility.this.databaseManager.deviceDatabase.legacySpareExists()) {
                this.convertLegacySpareMenuItem.setEnabled(true);
                this.deleteLegacySpareMenuItem.setEnabled(true);
            }
            StorageManagementUtility.this.databaseManager.eventDatabase.refreshPopUpBox();
        }

        private void updateMenuBar() {
            this.removeAll();
            this.rebuildDeviceMenu();
            this.rebuildWindowMenu();
            this.createMenuBar();
        }
    }
}

