/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SpareTable
extends JPanel
implements SortInterface,
GlobalConstants {
    Object[] defaultColumns;
    DeviceDatabase deviceDatabase;
    String metadataFormat;
    Preferences preferences;
    JScrollPane scrollPane;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;
    SpareDatabaseUpdateListener spareDatabaseUpdateListener;
    String spareFields = "Device,Type,RAID Group,Starting LBN,Capacity";
    ArrayList spareList;
    KTable spareTable;
    SpareManagerTableModel spareTableModel;

    public SpareTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String metadataFormat) {
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.preferences = preferences;
        this.metadataFormat = metadataFormat;
        if (metadataFormat.equals("Old")) {
            this.spareFields = "Device,Type,Starting LBN,Capacity";
        }
        this.loadPreferences();
        this.buildTable(rowCount);
        this.spareDatabaseUpdateListener = new SpareDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.spareDatabaseUpdateListener);
        this.spareDatabaseUpdateListener.run();
        this.savePreferences();
    }

    private JScrollPane buildTable(int rowCount) {
        this.spareList = this.getSpareList();
        this.spareTableModel = new SpareManagerTableModel();
        this.spareTable = new KTable(this.spareTableModel, rowCount);
        this.spareTable.getColumnModel().addColumnModelListener(new SpareTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SpareTable.this.spareTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SpareTable.this.spareTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = SpareTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = SpareTable.this.spareTableModel.getColumnName(column);
                    int count = 0;
                    while (count < SpareDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(SpareDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < SpareDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        SpareTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.spareTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.spareTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.spareTable);
        this.scrollPane.getViewport().setBackground(this.spareTable.getBackground());
        return this.scrollPane;
    }

    public void dispose() {
        this.deviceDatabase.removeUpdateListener(this.spareDatabaseUpdateListener);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public ArrayList getSelectedSpares() {
        ArrayList<SpareDescriptor> selectedList = new ArrayList<SpareDescriptor>();
        int[] selectedRows = this.spareTable.getSelectedRows();
        int count = 0;
        while (count < selectedRows.length) {
            SpareDescriptor spareDescriptor = (SpareDescriptor)this.spareList.get(selectedRows[count]);
            selectedList.add(spareDescriptor);
            ++count;
        }
        return selectedList;
    }

    public synchronized ArrayList getSpareList() {
        ArrayList<SpareDescriptor> newSpareList = new ArrayList<SpareDescriptor>();
        ArrayList<SpareDescriptor> sortedList = new ArrayList<SpareDescriptor>();
        ArrayList deviceList = this.deviceDatabase.getDeviceList();
        int deviceIndex = 0;
        while (deviceIndex < deviceList.size()) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (!deviceDescriptor.status.equals("Unused")) {
                int segmentIndex = 0;
                while (segmentIndex < deviceDescriptor.segmentArray.size()) {
                    SpareDescriptor spareDescriptor;
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segmentIndex);
                    if (this.metadataFormat.equals("New")) {
                        if (segmentDescriptor.status.equals("Dedicated Spare") || segmentDescriptor.status.equals("Global Spare")) {
                            spareDescriptor = new SpareDescriptor();
                            spareDescriptor.device = Integer.toString(deviceDescriptor.device);
                            spareDescriptor.type = segmentDescriptor.status;
                            spareDescriptor.raidGroup = segmentDescriptor.raidGroup;
                            spareDescriptor.startingPlbn = segmentDescriptor.startingPlbn;
                            spareDescriptor.capacity = segmentDescriptor.capacity;
                            newSpareList.add(spareDescriptor);
                        }
                    } else if (segmentDescriptor.status.equals("Legacy Spare")) {
                        spareDescriptor = new SpareDescriptor();
                        spareDescriptor.device = Integer.toString(deviceDescriptor.device);
                        spareDescriptor.type = segmentDescriptor.status;
                        spareDescriptor.raidGroup = segmentDescriptor.raidGroup;
                        spareDescriptor.startingPlbn = segmentDescriptor.startingPlbn;
                        spareDescriptor.capacity = segmentDescriptor.capacity;
                        newSpareList.add(spareDescriptor);
                    }
                    ++segmentIndex;
                }
            }
            ++deviceIndex;
        }
        int sourceIndex = 0;
        while (sourceIndex < newSpareList.size()) {
            SpareDescriptor sourceSpare = (SpareDescriptor)newSpareList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                SpareDescriptor destSpare = (SpareDescriptor)sortedList.get(destIndex);
                int result = sourceSpare.compare(destSpare, this.sortDescriptors[0]);
                if (result >= 1 || result == 0 && ((result = sourceSpare.compare(destSpare, this.sortDescriptors[1])) >= 1 || result == 0 && sourceSpare.compare(destSpare, this.sortDescriptors[2]) >= 1)) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceSpare);
            ++sourceIndex;
        }
        return sortedList;
    }

    private void loadPreferences() {
        String[] fieldNames = SpareDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.spareFields != null ? this.spareFields : this.preferences.get("Table Columns", "Device,Type,RAID Group,Starting LBN,Capacity");
            System.out.println("columns = \"" + columns + "\"");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                System.out.println("columnName = " + columnName);
                int index = 0;
                while (index < fieldNames.length) {
                    if (fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            System.out.println("done with column name extraction");
            if (fieldList.size() > 0) break;
            if (this.spareFields != null) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Device,Status,Capacity");
        }
        System.out.println("fieldList size = " + fieldList.size());
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        String[] defaultFields = new String[]{"Device", "Type", "RAID Group", "Starting LBN", "Capacity"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.spareFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            int index2 = 0;
            while (index2 < fieldNames.length) {
                if (fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        String columns = "";
        TableColumnModel tableColumnModel = this.spareTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.spareDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class SpareManagerTableModel
    extends KTableModel {
        public SpareManagerTableModel() {
            this.setColumns(SpareDescriptor.fieldNames, SpareDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return SpareTable.this.defaultColumns;
        }

        public int getRowCount() {
            return SpareTable.this.spareList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= SpareTable.this.spareList.size()) {
                value = "";
            } else {
                SpareDescriptor spare = (SpareDescriptor)SpareTable.this.spareList.get(row);
                value = spare.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (SpareTable.this.spareList.size() > 0) {
                this.fireTableRowsInserted(0, SpareTable.this.spareList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class SpareTableColumnModelListener
    implements TableColumnModelListener {
        SpareTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            SpareTable.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            SpareTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = SpareTable.this.spareTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < SpareTable.this.spareTable.getRowCount()) {
                SpareTable.this.spareTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                SpareDescriptor spareDescriptor = (SpareDescriptor)SpareTable.this.spareList.get(mouseSelectedRow);
            }
        }
    }

    protected class SpareDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newSpareList = SpareTable.this.getSpareList();
            if (SpareTable.this.spareTable.getSelectedRow() == -1) {
                SpareTable.this.spareList = newSpareList;
                SpareTable.this.spareTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = SpareTable.this.spareList.size();
                int oldTableSize = SpareTable.this.spareTableModel.getRowCount();
                int[] selectedRows = SpareTable.this.spareTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    SpareDescriptor spareDescriptor = (SpareDescriptor)SpareTable.this.spareList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newSpareList.size()) {
                        SpareDescriptor newSpareDescriptor = (SpareDescriptor)newSpareList.get(newRow);
                        if (newSpareDescriptor.device.equals(spareDescriptor.device) && newSpareDescriptor.type.equals(spareDescriptor.type) && newSpareDescriptor.raidGroup.equals(spareDescriptor.raidGroup) && newSpareDescriptor.startingPlbn.equals(spareDescriptor.startingPlbn) && newSpareDescriptor.capacity.equals(spareDescriptor.capacity)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                SpareTable.this.spareList = newSpareList;
                SpareTable.this.spareTable.clearSelection();
                SpareTable.this.spareTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        SpareTable.this.spareTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void terminate() {
            this.active = false;
        }
    }
}

