/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SegmentTable
extends JPanel
implements SortInterface,
GlobalConstants {
    CreateUpdateListener createUpdateListener;
    DatabaseManager databaseManager;
    Object[] defaultColumns;
    JLabel deviceCountLabel;
    DeviceDatabase deviceDatabase;
    DeviceDatabaseUpdateListener deviceDatabaseUpdateListener;
    String metadataFormat;
    Preferences preferences;
    JScrollPane scrollPane;
    String segmentFields;
    ArrayList segmentList;
    String[] segmentStatuses;
    KTable segmentTable;
    SegmentTableModel segmentTableModel;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;
    SpareUpdateListener spareUpdateListener;

    public SegmentTable(DatabaseManager databaseManager, Preferences preferences, String segmentFields, String[] segmentStatuses, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.segmentFields = segmentFields;
        this.segmentStatuses = segmentStatuses;
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.metadataFormat = metadataFormat;
        this.loadPreferences();
        this.buildTable(rowCount);
        this.deviceDatabaseUpdateListener = new DeviceDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.deviceDatabaseUpdateListener);
        this.deviceDatabaseUpdateListener.run();
        this.createUpdateListener = new CreateUpdateListener();
        this.spareUpdateListener = new SpareUpdateListener();
    }

    public void addRowSelectionInterval(int selectionIndex0, int selectionIndex1) {
        this.segmentTable.addRowSelectionInterval(selectionIndex0, selectionIndex1);
    }

    private void buildTable(int rowCount) {
        this.segmentList = this.getSegmentList();
        this.segmentTableModel = new SegmentTableModel();
        this.segmentTable = new KTable(this.segmentTableModel, rowCount);
        this.segmentTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SegmentTable.this.segmentTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SegmentTable.this.segmentTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = SegmentTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = SegmentTable.this.segmentTableModel.getColumnName(column);
                    int count = 0;
                    while (count < SegmentDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(SegmentDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < SegmentDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        SegmentTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.segmentTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.segmentTable);
        this.scrollPane.getViewport().setBackground(this.segmentTable.getBackground());
    }

    public void dispose() {
        this.deviceDatabase.removeUpdateListener(this.deviceDatabaseUpdateListener);
        this.savePreferences();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public synchronized ArrayList getSegmentList() {
        ArrayList newSegmentList = this.metadataFormat.equals("New") ? this.deviceDatabase.getSegmentList(this.segmentStatuses) : this.deviceDatabase.getLegacySegmentList(this.segmentStatuses);
        ArrayList<SegmentDescriptor> sortedList = new ArrayList<SegmentDescriptor>();
        int sourceIndex = 0;
        while (sourceIndex < newSegmentList.size()) {
            SegmentDescriptor sourceDevice = (SegmentDescriptor)newSegmentList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                SegmentDescriptor destDevice = (SegmentDescriptor)sortedList.get(destIndex);
                int result = sourceDevice.compare(destDevice, this.sortDescriptors[0]);
                if (result >= 1 || result == 0 && ((result = sourceDevice.compare(destDevice, this.sortDescriptors[1])) >= 1 || result == 0 && sourceDevice.compare(destDevice, this.sortDescriptors[2]) >= 1)) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceDevice);
            ++sourceIndex;
        }
        return sortedList;
    }

    public int getSelectedRow() {
        return this.segmentTable.getSelectedRow();
    }

    public ArrayList getSelectedSegments() {
        ArrayList<SegmentDescriptor> selectedList = new ArrayList<SegmentDescriptor>();
        int[] selectedRows = this.segmentTable.getSelectedRows();
        System.out.println("selected row count " + selectedRows.length);
        int count = 0;
        while (count < selectedRows.length) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)this.segmentList.get(selectedRows[count]);
            selectedList.add(segmentDescriptor);
            ++count;
        }
        return selectedList;
    }

    public KTable getTable() {
        return this.segmentTable;
    }

    public SegmentTableModel getTableModel() {
        return this.segmentTableModel;
    }

    private void loadPreferences() {
        String[] fieldNames = SegmentDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.segmentFields != null ? this.segmentFields : (this.preferences != null ? this.preferences.get("Table Columns", "Device,Status,Capacity,Starting LBN") : "Device,Status,Capacity,Starting LBN");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                int index = 0;
                while (index < fieldNames.length) {
                    if (fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            if (fieldList.size() > 0) break;
            if (this.segmentFields == null || this.preferences == null) continue;
            this.preferences.put("Table Columns", "Device,Status,Capacity,Starting LBN");
        }
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        String[] defaultFields = new String[]{"Device", "Status", "Capacity"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.segmentFields == null && this.preferences != null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            int index2 = 0;
            while (index2 < fieldNames.length) {
                if (fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        if (this.segmentFields == null || this.preferences == null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.segmentTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 3) {
            this.preferences.put("Table Sort Field" + index2, SegmentDescriptor.fieldNames[this.sortDescriptors[index2].field]);
            this.preferences.put("Table Sort Direction" + index2, this.sortDescriptors[index2].direction == 1 ? "Ascending" : "Descending");
            ++index2;
        }
    }

    public synchronized void segmentTableCreateUpdate(int maxContRaidGrpsPerDev) {
        System.out.println("segmentTableCreateUpdate(" + maxContRaidGrpsPerDev + ") entered");
        this.createUpdateListener.setArgument(maxContRaidGrpsPerDev);
        this.createUpdateListener.run();
    }

    public synchronized void segmentTableSpareUpdate(int raidGroup) {
        System.out.println("segmentTableSpareUpdate(" + raidGroup + ") entered");
        this.spareUpdateListener.setArgument(raidGroup);
        this.spareUpdateListener.run();
    }

    public synchronized void segmentTableUpdate() {
        System.out.println("segmentTableUpdate() entered");
        this.deviceDatabaseUpdateListener.run();
    }

    public void setSelectionMode(int selectionMode) {
        this.segmentTable.setSelectionMode(selectionMode);
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.deviceDatabaseUpdateListener.run();
        this.segmentList = this.getSegmentList();
        this.segmentTableModel.updateDisplay();
        this.savePreferences();
    }

    class SegmentTableModel
    extends KTableModel {
        public SegmentTableModel() {
            this.setColumns(SegmentDescriptor.fieldNames, SegmentDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return SegmentTable.this.defaultColumns;
        }

        public int getRowCount() {
            return SegmentTable.this.segmentList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= SegmentTable.this.segmentList.size()) {
                value = "";
            } else {
                SegmentDescriptor segment = (SegmentDescriptor)SegmentTable.this.segmentList.get(row);
                value = segment.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (SegmentTable.this.segmentList.size() > 0) {
                this.fireTableRowsInserted(0, SegmentTable.this.segmentList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    protected class SpareUpdateListener
    implements Runnable {
        int raidGroup;

        protected SpareUpdateListener() {
        }

        public void run() {
            ArrayList newSegmentList = SegmentTable.this.getSegmentList();
            int index = 0;
            while (index < newSegmentList.size()) {
                SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(index);
                DeviceDescriptor deviceDescriptor = SegmentTable.this.deviceDatabase.getDevice(Integer.parseInt(newSegmentDescriptor.device));
                if (deviceDescriptor.status.equals("Healthy")) {
                    int segment = 0;
                    while (segment < deviceDescriptor.segmentArray.size()) {
                        SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                        if (!devSegmentDescriptor.raidGroup.equals("N/A")) {
                            RaidGroupDescriptor raidGroupDescriptor = SegmentTable.this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                            if (raidGroupDescriptor.raidGroup == this.raidGroup && (raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced"))) {
                                newSegmentList.remove(index--);
                                break;
                            }
                        }
                        ++segment;
                    }
                }
                ++index;
            }
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newSegmentList.size()) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (segmentDescriptor.same(newSegmentDescriptor)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void setArgument(int raidGroup) {
            this.raidGroup = raidGroup;
        }
    }

    protected class CreateUpdateListener
    implements Runnable {
        int maxContRaidGrpsPerDev;

        protected CreateUpdateListener() {
        }

        public void run() {
            int contigCount = 0;
            ArrayList newSegmentList = SegmentTable.this.getSegmentList();
            int index = 0;
            while (index < newSegmentList.size()) {
                SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(index);
                DeviceDescriptor deviceDescriptor = SegmentTable.this.deviceDatabase.getDevice(Integer.parseInt(newSegmentDescriptor.device));
                if (deviceDescriptor.status.equals("Healthy")) {
                    int segment = 0;
                    while (segment < deviceDescriptor.segmentArray.size()) {
                        SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                        if (!devSegmentDescriptor.raidGroup.equals("N/A")) {
                            RaidGroupDescriptor raidGroupDescriptor = SegmentTable.this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                            if (raidGroupDescriptor.status.equals("Online") && raidGroupDescriptor.configuration.equals("Contiguous") && ++contigCount >= this.maxContRaidGrpsPerDev) {
                                newSegmentList.remove(index--);
                                break;
                            }
                        }
                        ++segment;
                    }
                }
                ++index;
            }
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newSegmentList.size()) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (segmentDescriptor.same(newSegmentDescriptor)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void setArgument(int maxContRaidGrpsPerDev) {
            this.maxContRaidGrpsPerDev = maxContRaidGrpsPerDev;
        }
    }

    protected class DeviceDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newSegmentList = SegmentTable.this.getSegmentList();
            if (SegmentTable.this.segmentTable.getSelectedRow() == -1) {
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = SegmentTable.this.segmentList.size();
                int oldTableSize = SegmentTable.this.segmentTableModel.getRowCount();
                int[] selectedRows = SegmentTable.this.segmentTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)SegmentTable.this.segmentList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newSegmentList.size()) {
                        SegmentDescriptor newSegmentDescriptor = (SegmentDescriptor)newSegmentList.get(newRow);
                        if (segmentDescriptor.same(newSegmentDescriptor)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                SegmentTable.this.segmentList = newSegmentList;
                SegmentTable.this.segmentTable.clearSelection();
                SegmentTable.this.segmentTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        SegmentTable.this.segmentTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void terminate() {
            this.active = false;
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            SegmentTable.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            SegmentTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

