/*
 * Decompiled with CFR 0.152.
 */
public class SegmentDescriptor
extends AbstractDescriptor {
    public String capacity;
    public String capacityInBlocks;
    public String device;
    private String[] fieldNameLookUp = new String[]{"Device", "device", "Status", "status", "StartingPlbn", "startingPlbn", "Capacity", "capacity", "RaidGroup", "raidGroup"};
    public static final String[] fieldNames = new String[]{"Device", "Status", "Starting LBN", "Capacity", "Raid Group"};
    public static final String[] maxFieldText = new String[]{"XDevice", "X0123456789X", "X0123456789X", "X01234567", "X01234567X"};
    public String raidGroup;
    public String startingPlbn;
    public String status;

    SegmentDescriptor(int device, String data) {
        this.nuke();
        this.device = Integer.toString(device);
        this.parseXml(data);
    }

    SegmentDescriptor() {
        this.nuke();
    }

    public synchronized Object clone() {
        SegmentDescriptor newDescriptor = new SegmentDescriptor();
        newDescriptor.device = this.device;
        newDescriptor.status = this.status;
        newDescriptor.startingPlbn = this.startingPlbn;
        newDescriptor.capacity = this.capacity;
        newDescriptor.capacityInBlocks = this.capacityInBlocks;
        newDescriptor.raidGroup = this.raidGroup;
        return newDescriptor;
    }

    public int compare(SegmentDescriptor compareDevice, SortDescriptor sortDescriptor) {
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareDevice);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public void nuke() {
        this.device = "Unknown";
        this.status = "Unknown";
        this.startingPlbn = "Unknown";
        this.capacity = "Unknown";
        this.capacityInBlocks = "Unknown";
        this.raidGroup = "N/A";
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue);
        }
        this.capacityInBlocks = this.capacity;
        this.capacity = Utility.blocksToBytes(Long.parseLong(this.capacityInBlocks));
    }

    public synchronized boolean same(SegmentDescriptor descriptor) {
        if (!descriptor.status.equals(this.status)) {
            return false;
        }
        if (!descriptor.startingPlbn.equals(this.startingPlbn)) {
            return false;
        }
        if (!descriptor.capacity.equals(this.capacity)) {
            return false;
        }
        if (!descriptor.capacityInBlocks.equals(this.capacityInBlocks)) {
            return false;
        }
        if (!descriptor.raidGroup.equals(this.raidGroup)) {
            return false;
        }
        return descriptor.device.equals(this.device);
    }
}

