/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RaidGroupTreePane
extends JScrollPane
implements GlobalConstants,
TreeSelectionListener {
    private ImageIcon controllerGreenIcon;
    private JPopupMenu controllerPopupMenu;
    private JMenuItem convertLegacyRaidGroupMenuItem;
    private JMenuItem createLegacyRaidGroupMenuItem;
    private JMenuItem createRaidGroupMenuItem;
    private DatabaseManager databaseManager;
    private JMenuItem deleteLegacyRaidGroupMenuItem;
    private JMenuItem deleteRaidGroupMenuItem;
    private JPopupMenu legacyRaidGroupPopupMenu;
    private ImageIcon raidGroupGreenIcon;
    private ArrayList raidGroupList;
    private JPopupMenu raidGroupPopupMenu;
    private RaidGroupDescriptor[] raidGroupTable;
    private ImageIcon raidGroupYellowIcon;
    private JMenuItem rebuildLegacyRaidGroupMenuItem;
    private JMenuItem rebuildRaidGroupMenuItem;
    private DefaultMutableTreeNode rootNode;
    private RaidGroupDescriptor selectedRaidGroupDescriptor;
    private StorageManagementUtility storageManagementUtility;
    private JTree tree;
    private DefaultTreeModel treeModel;

    public RaidGroupTreePane(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.controllerGreenIcon = imageIconLoader.loadImageIcon("controllerGreen.gif");
        this.raidGroupGreenIcon = imageIconLoader.loadImageIcon("raidGroupGreen.gif");
        this.raidGroupYellowIcon = imageIconLoader.loadImageIcon("raidGroupYellow.gif");
        this.buildTree();
        this.buildPopupMenus();
        AbstractListener databaseChangeHandler = new AbstractListener(){

            public void processChange() {
                RaidGroupTreePane.this.updateRaidGroupNodes();
            }
        };
        databaseManager.deviceDatabase.addUpdateListener(databaseChangeHandler);
        databaseManager.raidGroupDatabase.addUpdateListener(databaseChangeHandler);
        databaseManager.controllerDatabase.addUpdateListener(databaseChangeHandler);
        databaseChangeHandler.processChange();
    }

    public void buildPopupMenus() {
        this.controllerPopupMenu = new JPopupMenu();
        this.createRaidGroupMenuItem = new JMenuItem("Create RAID Group", 67);
        this.createLegacyRaidGroupMenuItem = new JMenuItem("Create Legacy RAID Group", 76);
        this.createRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CreateRaidGroupBox(RaidGroupTreePane.this.databaseManager, "Create RAID Group");
            }
        });
        this.createLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CreateLegacyRaidGroupBox(RaidGroupTreePane.this.databaseManager, "Create Legacy RAID Group");
            }
        });
        this.controllerPopupMenu.add(this.createRaidGroupMenuItem);
        this.controllerPopupMenu.add(this.createLegacyRaidGroupMenuItem);
        this.raidGroupPopupMenu = new JPopupMenu();
        this.rebuildRaidGroupMenuItem = new JMenuItem("Rebuild RAID Group", 82);
        this.deleteRaidGroupMenuItem = new JMenuItem("Delete RAID Group", 68);
        this.rebuildRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                int member = 0;
                while (member < ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.size()) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (memberDescriptor.status.equals("Failed")) {
                        ++failedMemberCount;
                        failedMember = Integer.toString(member);
                    }
                    ++member;
                }
                new RebuildRaidGroupBox(RaidGroupTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "New");
            }
        });
        this.deleteRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(RaidGroupTreePane.this, "Are you sure you want to delete specified RAID Group?", "Delete RAID Group Verification", 0);
                if (answer == 0) {
                    new DeleteRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup, "New");
                }
            }
        });
        this.raidGroupPopupMenu.add(this.rebuildRaidGroupMenuItem);
        this.raidGroupPopupMenu.add(this.deleteRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu = new JPopupMenu();
        this.rebuildLegacyRaidGroupMenuItem = new JMenuItem("Rebuild Legacy RAID Group", 82);
        this.deleteLegacyRaidGroupMenuItem = new JMenuItem("Delete Legacy RAID Group", 68);
        this.convertLegacyRaidGroupMenuItem = new JMenuItem("Convert Legacy RAID Group", 67);
        this.rebuildLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String failedMember = "";
                String title = "Rebuild Legacy RAID Group";
                ArrayList selectedList = new ArrayList();
                RaidGroupDescriptor rebuildRaidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTreePane.this.selectedRaidGroupDescriptor.clone();
                rebuildRaidGroupDescriptor.memberArray.clear();
                String reducedRaidGroup = Integer.toString(rebuildRaidGroupDescriptor.raidGroup);
                int failedMemberCount = 0;
                int member = 0;
                while (member < ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.size()) {
                    MemberDescriptor memberDescriptor = (MemberDescriptor)((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.memberArray.get(member);
                    if (memberDescriptor.status.equals("Failed")) {
                        ++failedMemberCount;
                        failedMember = Integer.toString(member);
                    }
                    ++member;
                }
                new RebuildRaidGroupBox(RaidGroupTreePane.this.databaseManager, title, reducedRaidGroup, failedMember, "Old");
            }
        });
        this.deleteLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(RaidGroupTreePane.this, "Are you sure you want to delete specified Legacy RAID Group?", "Delete Legacy RAID Group Verification", 0);
                if (answer == 0) {
                    new DeleteRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup, "Old");
                }
            }
        });
        this.convertLegacyRaidGroupMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ConvertLegacyRaidGroupBox(RaidGroupTreePane.this.databaseManager, ((RaidGroupTreePane)RaidGroupTreePane.this).selectedRaidGroupDescriptor.raidGroup);
            }
        });
        this.legacyRaidGroupPopupMenu.add(this.rebuildLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.deleteLegacyRaidGroupMenuItem);
        this.legacyRaidGroupPopupMenu.add(this.convertLegacyRaidGroupMenuItem);
    }

    private void buildTree() {
        this.raidGroupList = new ArrayList();
        this.raidGroupList.clear();
        this.raidGroupTable = new RaidGroupDescriptor[16];
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.title = "Controller " + Integer.toString(this.databaseManager.getNexusController());
        nodeInfo.type = nodeInfo.CONTROLLER_TYPE;
        nodeInfo.raidGroup = -1;
        nodeInfo.icon = this.controllerGreenIcon;
        this.rootNode = new DefaultMutableTreeNode(nodeInfo);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        int raidGroup = 0;
        while (raidGroup < this.databaseManager.getSelectedController().maxRaidGroups) {
            RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(raidGroup);
            if (raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) {
                nodeInfo = new NodeInfo();
                nodeInfo.title = raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")";
                if (raidGroupDescriptor.label.equals("") && raidGroupDescriptor.metadataFormat.equals("Old")) {
                    nodeInfo.title = "Legacy RG " + raidGroupDescriptor.raidGroup;
                }
                nodeInfo.type = nodeInfo.RAID_GROUP_TYPE;
                nodeInfo.raidGroup = raidGroupDescriptor.raidGroup;
                if (raidGroupDescriptor.status.equals("Online")) {
                    nodeInfo.icon = this.raidGroupGreenIcon;
                } else if (raidGroupDescriptor.status.equals("Reduced")) {
                    nodeInfo.icon = this.raidGroupYellowIcon;
                }
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo);
                this.treeModel.insertNodeInto(node, this.rootNode, this.rootNode.getChildCount());
                TreePath treePath = new TreePath(node.getPath());
                this.tree.scrollPathToVisible(treePath);
            }
            ++raidGroup;
        }
        this.raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseTreeListener());
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setRowHeight(18);
        Dimension d = this.tree.getPreferredSize();
        d.width = (int)((double)d.width * 1.25);
        this.tree.setPreferredSize(d);
        this.setViewportView(this.tree);
    }

    private void updateControllerPopupMenu() {
        if (this.databaseManager.raidGroupDatabase.getNextAvailableRaidGroup() == -1) {
            this.createRaidGroupMenuItem.setEnabled(false);
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
        } else {
            this.createRaidGroupMenuItem.setEnabled(true);
            this.createLegacyRaidGroupMenuItem.setEnabled(false);
            if (this.databaseManager.deviceDatabase.legacyBootSupportable()) {
                this.createLegacyRaidGroupMenuItem.setEnabled(true);
            }
        }
    }

    private void updateLegacyPopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        this.rebuildLegacyRaidGroupMenuItem.setEnabled(false);
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.availableLbn0SegmentExists()) {
            this.rebuildLegacyRaidGroupMenuItem.setEnabled(true);
        }
        this.deleteLegacyRaidGroupMenuItem.setEnabled(true);
        this.convertLegacyRaidGroupMenuItem.setEnabled(true);
    }

    private void updatePopupMenu(RaidGroupDescriptor raidGroupDescriptor) {
        if (raidGroupDescriptor.status.equals("Reduced") && this.databaseManager.deviceDatabase.rebuildSegmentExists(raidGroupDescriptor.raidGroup)) {
            this.rebuildRaidGroupMenuItem.setEnabled(true);
        } else {
            this.rebuildRaidGroupMenuItem.setEnabled(false);
        }
        this.deleteRaidGroupMenuItem.setEnabled(true);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private synchronized void updateRaidGroupNodes() {
        NodeInfo nodeInfo;
        RaidGroupDescriptor newRaidGroupDescriptor;
        int newIndex;
        RaidGroupDescriptor raidGroupDescriptor;
        Object topNode = this.rootNode.getUserObject();
        NodeInfo topNodeInfo = (NodeInfo)topNode;
        String currentControllerTitle = "Controller " + Integer.toString(this.databaseManager.getNexusController());
        if (!topNodeInfo.title.equals(currentControllerTitle)) {
            topNodeInfo.title = currentControllerTitle;
        }
        ArrayList newRaidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(false);
        int newIndex2 = 0;
        while (newIndex2 < newRaidGroupList.size()) {
            this.raidGroupTable[raidGroupDescriptor.raidGroup] = raidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex2);
            ++newIndex2;
        }
        ArrayList<RaidGroupDescriptor> removeList = new ArrayList<RaidGroupDescriptor>();
        int index = 0;
        while (index < this.raidGroupList.size()) {
            raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
            boolean found = false;
            newIndex = 0;
            while (newIndex < newRaidGroupList.size()) {
                newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
                if (raidGroupDescriptor.raidGroup == newRaidGroupDescriptor.raidGroup && raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) {
                    found = true;
                    break;
                }
                ++newIndex;
            }
            if (!found) {
                removeList.add(raidGroupDescriptor);
            }
            ++index;
        }
        ArrayList<RaidGroupDescriptor> addList = new ArrayList<RaidGroupDescriptor>();
        newIndex = 0;
        while (newIndex < newRaidGroupList.size()) {
            newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newIndex);
            boolean found = false;
            index = 0;
            while (index < this.raidGroupList.size()) {
                raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(index);
                if (raidGroupDescriptor.raidGroup == newRaidGroupDescriptor.raidGroup && raidGroupDescriptor.label.equals(newRaidGroupDescriptor.label)) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                addList.add(newRaidGroupDescriptor);
            }
            ++newIndex;
        }
        int count = 0;
        while (count < removeList.size()) {
            raidGroupDescriptor = (RaidGroupDescriptor)removeList.get(count);
            DefaultMutableTreeNode leaf = this.rootNode.getFirstLeaf();
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    nodeInfo = (NodeInfo)leaf.getUserObject();
                    if (nodeInfo.raidGroup == raidGroupDescriptor.raidGroup) {
                        this.treeModel.removeNodeFromParent(leaf);
                        break;
                    }
                    leaf = leaf.getNextLeaf();
                }
                if (leaf == null) break;
            } while (leaf != this.rootNode);
            ++count;
        }
        int count2 = 0;
        while (count2 < addList.size()) {
            nodeInfo = new NodeInfo();
            raidGroupDescriptor = (RaidGroupDescriptor)addList.get(count2);
            nodeInfo.title = raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")";
            if (raidGroupDescriptor.label.equals("") && raidGroupDescriptor.metadataFormat.equals("Old")) {
                nodeInfo.title = "Legacy RG " + raidGroupDescriptor.raidGroup;
            }
            nodeInfo.type = nodeInfo.RAID_GROUP_TYPE;
            nodeInfo.raidGroup = raidGroupDescriptor.raidGroup;
            if (raidGroupDescriptor.status.equals("Online")) {
                nodeInfo.icon = this.raidGroupGreenIcon;
            } else if (raidGroupDescriptor.status.equals("Reduced")) {
                nodeInfo.icon = this.raidGroupYellowIcon;
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(nodeInfo);
            DefaultMutableTreeNode leaf = this.rootNode.getFirstLeaf();
            if (leaf == this.rootNode) {
                this.treeModel.insertNodeInto(newNode, this.rootNode, 0);
                this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
            } else {
                NodeInfo newNodeInfo = null;
                index = 0;
                while (leaf != null) {
                    newNodeInfo = (NodeInfo)leaf.getUserObject();
                    if (newNodeInfo.raidGroup >= raidGroupDescriptor.raidGroup) {
                        this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                        this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                        newNode = null;
                        break;
                    }
                    if (++index >= this.rootNode.getChildCount()) break;
                    leaf = leaf.getNextLeaf();
                }
                if (newNode != null) {
                    this.treeModel.insertNodeInto(newNode, this.rootNode, this.rootNode.getChildCount());
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                }
            }
            ++count2;
        }
        DefaultMutableTreeNode leaf = this.rootNode.getFirstLeaf();
        while (leaf != null && leaf != this.rootNode) {
            boolean changed = false;
            NodeInfo nodeInfo2 = (NodeInfo)leaf.getUserObject();
            raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(nodeInfo2.raidGroup);
            if (raidGroupDescriptor.status.equals("Online")) {
                if (!nodeInfo2.icon.equals(this.raidGroupGreenIcon)) {
                    nodeInfo2.icon = this.raidGroupGreenIcon;
                    changed = true;
                }
            } else if (raidGroupDescriptor.status.equals("Reduced") && !nodeInfo2.icon.equals(this.raidGroupYellowIcon)) {
                nodeInfo2.icon = this.raidGroupYellowIcon;
                changed = true;
            }
            if (changed) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo2);
                TreeNode parent = leaf.getParent();
                int position = this.treeModel.getIndexOfChild(parent, leaf);
                this.treeModel.removeNodeFromParent(leaf);
                this.treeModel.insertNodeInto(node, this.rootNode, position);
            }
            leaf = leaf.getNextLeaf();
        }
        this.raidGroupList = newRaidGroupList;
        this.tree.setRowHeight(18);
        this.tree.setPreferredSize(this.tree.getPreferredSize());
        this.tree.repaint();
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        NodeInfo treeNode = (NodeInfo)nodeInfo;
        this.storageManagementUtility.deviceChannelPanel.highlightRaidGroupHandler(treeNode.raidGroup);
    }

    class NodeInfo {
        final int CONTROLLER_TYPE = 1;
        final int RAID_GROUP_TYPE = 0;
        ImageIcon icon;
        int raidGroup;
        String title = "?";
        int type;

        public String toString() {
            return this.title;
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)value;
            Object userObject = newNode.getUserObject();
            NodeInfo nodeInfo = (NodeInfo)userObject;
            if (nodeInfo.icon != null) {
                this.setIcon(nodeInfo.icon);
            }
            return this;
        }
    }

    private class MouseTreeListener
    extends MouseAdapter {
        private MouseTreeListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = RaidGroupTreePane.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1 || (e.getModifiers() & 4) == 0) {
                return;
            }
            RaidGroupTreePane.this.tree.setSelectionRow(selRow);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)RaidGroupTreePane.this.tree.getLastSelectedPathComponent();
            NodeInfo nodeInfo = (NodeInfo)node.getUserObject();
            if (nodeInfo.type == nodeInfo.CONTROLLER_TYPE) {
                RaidGroupTreePane.this.updateControllerPopupMenu();
                Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.controllerPopupMenu, e);
            } else if (nodeInfo.type == nodeInfo.RAID_GROUP_TYPE) {
                RaidGroupTreePane.this.selectedRaidGroupDescriptor = RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup];
                if (RaidGroupTreePane.this.selectedRaidGroupDescriptor.isLegacy()) {
                    RaidGroupTreePane.this.updateLegacyPopupMenu(RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.legacyRaidGroupPopupMenu, e);
                } else {
                    RaidGroupTreePane.this.updatePopupMenu(RaidGroupTreePane.this.raidGroupTable[nodeInfo.raidGroup]);
                    Utility.displayPopupMenu(RaidGroupTreePane.this, RaidGroupTreePane.this.raidGroupPopupMenu, e);
                }
            }
        }
    }
}

