/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class RaidGroupTable
extends JPanel
implements SortInterface,
GlobalConstants {
    DatabaseManager databaseManager;
    Object[] defaultColumns;
    int listSelection = 2;
    String metadataFormat = "All";
    Preferences preferences;
    JLabel raidGroupCountLabel;
    RaidGroupDatabase raidGroupDatabase;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    ArrayList raidGroupList;
    String raidGroupStatus = "All";
    KTable raidGroupTable;
    RaidGroupManagerTableModel raidGroupTableModel;
    JScrollPane scrollPane;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String raidGroupStatus, int listSelection) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.raidGroupStatus = raidGroupStatus;
        this.listSelection = listSelection;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, int listSelection) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.listSelection = listSelection;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.metadataFormat = metadataFormat;
        this.initRaidGroupTable(rowCount);
    }

    public RaidGroupTable(DatabaseManager databaseManager, Preferences preferences, int rowCount) {
        this.databaseManager = databaseManager;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.preferences = preferences;
        this.initRaidGroupTable(rowCount);
    }

    private JScrollPane buildTable(int rowCount) {
        this.raidGroupList = this.getRaidGroupList();
        this.raidGroupTableModel = new RaidGroupManagerTableModel();
        this.raidGroupTable = new KTable(this.raidGroupTableModel, rowCount);
        this.raidGroupTable.setSelectionMode(this.listSelection);
        this.raidGroupTable.getColumnModel().addColumnModelListener(new RaidGroupTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = RaidGroupTable.this.raidGroupTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = RaidGroupTable.this.raidGroupTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = RaidGroupTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = RaidGroupTable.this.raidGroupTableModel.getColumnName(column);
                    int count = 0;
                    while (count < RaidGroupDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(RaidGroupDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < RaidGroupDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        RaidGroupTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.raidGroupTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.raidGroupTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.raidGroupTable);
        this.scrollPane.getViewport().setBackground(this.raidGroupTable.getBackground());
        return this.scrollPane;
    }

    public void dispose() {
    }

    public synchronized ArrayList getRaidGroupList() {
        ArrayList newRaidGroupList = this.raidGroupStatus.equals("All") ? this.raidGroupDatabase.getRaidGroupList(false) : this.raidGroupDatabase.getRaidGroupList(this.raidGroupStatus);
        ArrayList<RaidGroupDescriptor> sortedList = new ArrayList<RaidGroupDescriptor>();
        int sourceIndex = 0;
        while (sourceIndex < newRaidGroupList.size()) {
            RaidGroupDescriptor sourceRaidGroup = (RaidGroupDescriptor)newRaidGroupList.get(sourceIndex);
            if (sourceRaidGroup.metadataFormat.equals(this.metadataFormat) || this.metadataFormat.equals("All")) {
                int destIndex = 0;
                while (destIndex < sortedList.size()) {
                    RaidGroupDescriptor destRaidGroup = (RaidGroupDescriptor)sortedList.get(destIndex);
                    int result = sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[0]);
                    if (result >= 1 || result == 0 && ((result = sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[1])) >= 1 || result == 0 && sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[2]) >= 1)) break;
                    ++destIndex;
                }
                sortedList.add(destIndex, sourceRaidGroup);
            }
            ++sourceIndex;
        }
        return sortedList;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public ArrayList getSelectedRaidGroups() {
        ArrayList<RaidGroupDescriptor> selectedList = new ArrayList<RaidGroupDescriptor>();
        int[] selectedRows = this.raidGroupTable.getSelectedRows();
        System.out.println("selected row count " + selectedRows.length);
        int count = 0;
        while (count < selectedRows.length) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)this.raidGroupList.get(selectedRows[count]);
            System.out.println("selected raid group " + raidGroupDescriptor.raidGroup);
            selectedList.add(raidGroupDescriptor);
            ++count;
        }
        return selectedList;
    }

    private void initRaidGroupTable(int rowCount) {
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    private void loadPreferences() {
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.preferences.get("Table Columns", "RAID Group,Configuration,Status,Capacity");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                int index = 0;
                while (index < RaidGroupDescriptor.fieldNames.length) {
                    if (RaidGroupDescriptor.fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "RAID Group,Configuration,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        this.defaultColumns = new Object[3];
        String[] defaultFields2 = new String[]{"RAID Group", "Configuration", "Status"};
        this.defaultColumns = defaultFields2;
        this.sortedList = new ArrayList();
        this.sortDescriptors = new SortDescriptor[3];
        String[] defaultFields = new String[]{"RAID Group", "Configuration", "Status"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            int index2 = 0;
            while (index2 < RaidGroupDescriptor.fieldNames.length) {
                if (RaidGroupDescriptor.fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        String columns = "";
        TableColumnModel tableColumnModel = this.raidGroupTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 3) {
            ++index2;
        }
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class RaidGroupManagerTableModel
    extends KTableModel {
        public RaidGroupManagerTableModel() {
            this.setColumns(RaidGroupDescriptor.reducedFieldNames, RaidGroupDescriptor.reducedMaxFieldText);
        }

        public Object[] getDefaultColumns() {
            return RaidGroupTable.this.defaultColumns;
        }

        public int getRowCount() {
            return RaidGroupTable.this.raidGroupList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= RaidGroupTable.this.raidGroupList.size()) {
                value = "";
            } else {
                RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(row);
                value = raidGroup.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (RaidGroupTable.this.raidGroupList.size() > 0) {
                this.fireTableRowsInserted(0, RaidGroupTable.this.raidGroupList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class RaidGroupTableColumnModelListener
    implements TableColumnModelListener {
        RaidGroupTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            RaidGroupTable.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            RaidGroupTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = RaidGroupTable.this.raidGroupTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < RaidGroupTable.this.raidGroupTable.getRowCount()) {
                RaidGroupTable.this.raidGroupTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(mouseSelectedRow);
            }
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newRaidGroupList = RaidGroupTable.this.getRaidGroupList();
            if (RaidGroupTable.this.raidGroupTable.getSelectedRow() == -1) {
                RaidGroupTable.this.raidGroupList = newRaidGroupList;
                RaidGroupTable.this.raidGroupTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = RaidGroupTable.this.raidGroupList.size();
                int oldTableSize = RaidGroupTable.this.raidGroupTableModel.getRowCount();
                int[] selectedRows = RaidGroupTable.this.raidGroupTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupTable.this.raidGroupList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newRaidGroupList.size()) {
                        RaidGroupDescriptor newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newRow);
                        if (newRaidGroupDescriptor.raidGroup != raidGroupDescriptor.raidGroup) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                RaidGroupTable.this.raidGroupList = newRaidGroupList;
                RaidGroupTable.this.raidGroupTable.clearSelection();
                RaidGroupTable.this.raidGroupTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        RaidGroupTable.this.raidGroupTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void terminate() {
            this.active = false;
        }
    }
}

