/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class RaidGroupSummaryPage
extends KFrame
implements SortInterface {
    Object[] defaultColumns;
    AbstractMessageHandler messageHandler;
    JLabel raidGroupCountLabel;
    RaidGroupDatabase raidGroupDatabase;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    ArrayList raidGroupList;
    KTable raidGroupTable;
    RaidGroupManagerTableModel raidGroupTableModel;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;

    public RaidGroupSummaryPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.loadPreferences();
        this.buildMenus();
        this.getContentPane().add((Component)this.buildTable(), "Center");
        this.buildStatusBar();
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RaidGroupSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(RaidGroupSummaryPage.this, RaidGroupSummaryPage.this.raidGroupTable, RaidGroupSummaryPage.this.raidGroupTableModel);
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(RaidGroupSummaryPage.this, RaidGroupDescriptor.fieldNames, RaidGroupSummaryPage.this.sortDescriptors);
                RaidGroupSummaryPage.this.raidGroupDatabaseUpdateListener.run();
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.raidGroupCountLabel = new JLabel(" RAID Group Count: 0");
        this.raidGroupCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.raidGroupCountLabel, "South");
    }

    private JScrollPane buildTable() {
        this.raidGroupList = this.getRaidGroupList();
        this.raidGroupTableModel = new RaidGroupManagerTableModel();
        this.raidGroupTable = new KTable(this.raidGroupTableModel, 24);
        this.raidGroupTable.setSelectionMode(0);
        this.raidGroupTable.getColumnModel().addColumnModelListener(new RaidGroupTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = RaidGroupSummaryPage.this.raidGroupTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = RaidGroupSummaryPage.this.raidGroupTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = RaidGroupSummaryPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = RaidGroupSummaryPage.this.raidGroupTableModel.getColumnName(column);
                    int count = 0;
                    while (count < RaidGroupDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(RaidGroupDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < RaidGroupDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        RaidGroupSummaryPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.raidGroupTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.raidGroupTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.raidGroupTable);
        scrollPane.getViewport().setBackground(this.raidGroupTable.getBackground());
        return scrollPane;
    }

    protected void closeFrame() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.completeFrameClosure();
    }

    public synchronized ArrayList getRaidGroupList() {
        ArrayList newRaidGroupList = this.raidGroupDatabase.getRaidGroupList(false);
        ArrayList<RaidGroupDescriptor> sortedList = new ArrayList<RaidGroupDescriptor>();
        int sourceIndex = 0;
        while (sourceIndex < newRaidGroupList.size()) {
            RaidGroupDescriptor sourceRaidGroup = (RaidGroupDescriptor)newRaidGroupList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                RaidGroupDescriptor destRaidGroup = (RaidGroupDescriptor)sortedList.get(destIndex);
                int result = sourceRaidGroup.compare(destRaidGroup, this.sortDescriptors[0]);
                if (result >= 1) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceRaidGroup);
            ++sourceIndex;
        }
        return sortedList;
    }

    private void loadPreferences() {
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.preferences.get("Table Columns", "RAID Group,Label,Configuration,Status,Capacity");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                int index = 0;
                while (index < RaidGroupDescriptor.fieldNames.length) {
                    if (RaidGroupDescriptor.fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "RAID Group,Label,Configuration,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        this.sortedList = new ArrayList();
        this.sortDescriptors = new SortDescriptor[1];
        String[] defaultFields = new String[]{"RAID Group"};
        String[] defaultDirection = new String[]{"Ascending"};
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            int index2 = 0;
            while (index2 < RaidGroupDescriptor.fieldNames.length) {
                if (RaidGroupDescriptor.fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        String columns = "";
        TableColumnModel tableColumnModel = this.raidGroupTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 1) {
            this.preferences.put("Table Sort Field" + index2, RaidGroupDescriptor.fieldNames[this.sortDescriptors[index2].field]);
            this.preferences.put("Table Sort Direction" + index2, this.sortDescriptors[index2].direction == 1 ? "Ascending" : "Descending");
            ++index2;
        }
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class RaidGroupManagerTableModel
    extends KTableModel {
        public RaidGroupManagerTableModel() {
            this.setColumns(RaidGroupDescriptor.reducedFieldNames, RaidGroupDescriptor.reducedMaxFieldText);
        }

        public Object[] getDefaultColumns() {
            return RaidGroupSummaryPage.this.defaultColumns;
        }

        public int getRowCount() {
            return RaidGroupSummaryPage.this.raidGroupList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= RaidGroupSummaryPage.this.raidGroupList.size()) {
                value = "";
            } else {
                RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(row);
                value = raidGroup.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (RaidGroupSummaryPage.this.raidGroupList.size() > 0) {
                this.fireTableRowsInserted(0, RaidGroupSummaryPage.this.raidGroupList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class RaidGroupTableColumnModelListener
    implements TableColumnModelListener {
        RaidGroupTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            RaidGroupSummaryPage.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            RaidGroupSummaryPage.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = RaidGroupSummaryPage.this.raidGroupTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < RaidGroupSummaryPage.this.raidGroupTable.getRowCount()) {
                RaidGroupSummaryPage.this.raidGroupTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(mouseSelectedRow);
            }
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newRaidGroupList = RaidGroupSummaryPage.this.getRaidGroupList();
            if (RaidGroupSummaryPage.this.raidGroupTable.getSelectedRow() == -1) {
                RaidGroupSummaryPage.this.raidGroupList = newRaidGroupList;
                RaidGroupSummaryPage.this.raidGroupTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = RaidGroupSummaryPage.this.raidGroupList.size();
                int oldTableSize = RaidGroupSummaryPage.this.raidGroupTableModel.getRowCount();
                int[] selectedRows = RaidGroupSummaryPage.this.raidGroupTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)RaidGroupSummaryPage.this.raidGroupList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newRaidGroupList.size()) {
                        RaidGroupDescriptor newRaidGroupDescriptor = (RaidGroupDescriptor)newRaidGroupList.get(newRow);
                        if (newRaidGroupDescriptor.raidGroup != raidGroupDescriptor.raidGroup) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                RaidGroupSummaryPage.this.raidGroupList = newRaidGroupList;
                RaidGroupSummaryPage.this.raidGroupTable.clearSelection();
                RaidGroupSummaryPage.this.raidGroupTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        RaidGroupSummaryPage.this.raidGroupTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
            RaidGroupSummaryPage.this.raidGroupCountLabel.setText(" RAID Group Count: " + RaidGroupSummaryPage.this.raidGroupList.size());
        }

        public void terminate() {
            this.active = false;
        }
    }
}

