/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.ArrayList;

public class RaidGroupDescriptor
extends AbstractDescriptor {
    public String capacity;
    public long capacityInBlocks;
    public String chunkSize;
    public String configuration;
    private String[] fieldNameLookUp = new String[]{"RaidGroup", "raidGroup", "Label", "label", "Status", "status", "Configuration", "configuration", "MemberCount", "memberCount", "ChunkSize", "chunkSize", "Capacity", "capacity", "MetadataFormat", "metadataFormat", "RebuildPriority", "rebuildPriority", "LogicalPathId", "logicalPathId", "LogicalTargetId", "logicalTargetId", "UpdateCount", "updateCount"};
    public static String[] fieldNames = new String[]{"RAID Group", "Label", "Status", "Configuration", "Member Count", "ChunkSize", "Capacity", "Metadata Format", "Rebuild Priority"};
    public String id;
    public String label;
    public int logicalPathId;
    public int logicalTargetId;
    public ArrayList memberArray;
    public String memberCount;
    public String metadataFormat;
    public int raidGroup;
    public String rebuildPriority;
    public static String[] reducedFieldNames = new String[]{"RAID Group", "Label", "Status", "Configuration", "Member Count", "ChunkSize", "Capacity", "Metadata Format", "Rebuild Priority"};
    public static String[] reducedMaxFieldText = new String[]{"XRAID GroupX", "X1234567890123456", "XReducedX", "XMirrored StripedX", "Member Count", "Chunk Size", "Capacity", "Metadata Format", "Rebuild Priority"};
    public String status;
    public String updateCount;

    RaidGroupDescriptor(String data) {
        this.nuke();
        this.parseXml(data);
    }

    RaidGroupDescriptor(int raidGroup) {
        this.nuke();
        this.raidGroup = raidGroup;
    }

    RaidGroupDescriptor() {
        this.nuke();
    }

    public synchronized Object clone() {
        RaidGroupDescriptor newDescriptor = new RaidGroupDescriptor();
        newDescriptor.raidGroup = this.raidGroup;
        newDescriptor.logicalPathId = this.logicalPathId;
        newDescriptor.logicalTargetId = this.logicalTargetId;
        newDescriptor.label = this.label;
        newDescriptor.id = this.id;
        newDescriptor.metadataFormat = this.metadataFormat;
        newDescriptor.updateCount = this.updateCount;
        newDescriptor.status = this.status;
        newDescriptor.configuration = this.configuration;
        newDescriptor.chunkSize = this.chunkSize;
        newDescriptor.capacity = this.capacity;
        newDescriptor.memberCount = this.memberCount;
        newDescriptor.rebuildPriority = this.rebuildPriority;
        int member = 0;
        while (member < this.memberArray.size()) {
            MemberDescriptor memberDescriptor = (MemberDescriptor)this.memberArray.get(member);
            newDescriptor.memberArray.add(memberDescriptor.clone());
            ++member;
        }
        return newDescriptor;
    }

    public int compare(RaidGroupDescriptor compareRaidGroup, SortDescriptor sortDescriptor) {
        if (compareRaidGroup == null) {
            return 0;
        }
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareRaidGroup);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    protected long compareFields(String fieldName, AbstractDescriptor compareDescriptor) {
        try {
            Class<?> className = this.getClass();
            Field field = className.getField(fieldName);
            String fieldType = field.getType().getName();
            Class<?> className2 = compareDescriptor.getClass();
            Field field2 = className.getField(fieldName);
            if (fieldType.equals("int")) {
                int first = field.getInt(this);
                int second = field2.getInt(compareDescriptor);
                return first - second;
            }
            if (fieldType.equals("long")) {
                long first = field.getLong(this);
                long second = field2.getLong(compareDescriptor);
                return first - second;
            }
            if (fieldType.equals("java.lang.String")) {
                String first = (String)field.get(this);
                String second = (String)field2.get(compareDescriptor);
                if (!fieldName.equals("chunkSize") && !fieldName.equals("capacity")) {
                    return first.compareToIgnoreCase(second);
                }
                int endIndex = first.indexOf(" ");
                if (endIndex == -1) {
                    endIndex = first.length();
                }
                first = first.substring(0, endIndex);
                endIndex = second.indexOf(" ");
                if (endIndex == -1) {
                    endIndex = second.length();
                }
                second = second.substring(0, endIndex);
                if (fieldName.equals("chunkSize") || first.indexOf(".") == -1 && second.indexOf(".") == -1) {
                    return Integer.parseInt(first) - Integer.parseInt(second);
                }
                String firstDecimal = "00";
                int startIndex = first.indexOf(".");
                if (startIndex != -1 && (firstDecimal = first.substring(startIndex + 1)).length() < 2) {
                    firstDecimal = firstDecimal + "0";
                }
                first = first.substring(0, startIndex) + firstDecimal;
                String secondDecimal = "00";
                startIndex = second.indexOf(".");
                if (startIndex != -1 && (secondDecimal = second.substring(startIndex + 1)).length() < 2) {
                    secondDecimal = secondDecimal + "0";
                }
                second = second.substring(0, startIndex) + secondDecimal;
                return Integer.parseInt(first) - Integer.parseInt(second);
            }
            if (fieldType.equals("boolean")) {
                boolean second;
                boolean first = field.getBoolean(this);
                if (first == (second = field2.getBoolean(compareDescriptor))) {
                    return 0L;
                }
                if (first) {
                    return 1L;
                }
                return -1L;
            }
        }
        catch (Exception e) {}
        return 0L;
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public boolean isLegacy() {
        return this.metadataFormat.equals("Old");
    }

    public void nuke() {
        this.raidGroup = -1;
        this.logicalPathId = -1;
        this.logicalTargetId = -1;
        this.label = "";
        this.status = "Unused";
        this.configuration = "Unknown";
        this.memberCount = "Unknown";
        this.chunkSize = "Unknown";
        this.capacity = "Unknown";
        this.id = "Unknown";
        this.metadataFormat = "Unknown";
        this.rebuildPriority = "1";
        this.updateCount = "Unknown";
        this.memberArray = new ArrayList();
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue) || !xmlData.element.equals("RaidAttributes")) continue;
            XmlData attributesXmlData = new XmlData(xmlData.elementValue);
            while (attributesXmlData.getNextElement()) {
                if (this.parseElement(this.fieldNameLookUp, attributesXmlData.element, attributesXmlData.elementValue) || !attributesXmlData.element.equals("RaidMemberInfo")) continue;
                this.memberArray.add(new MemberDescriptor(attributesXmlData.elementValue));
            }
        }
        this.memberCount = Integer.toString(this.memberArray.size());
        this.capacityInBlocks = Long.parseLong(this.capacity);
        this.capacity = Utility.blocksToBytes(this.capacityInBlocks);
        try {
            int chunkSizeInt = Integer.parseInt(this.chunkSize) >> 1;
            this.chunkSize = Integer.toString(chunkSizeInt) + " KB";
        }
        catch (Exception e) {
            ErrorLog.put(e, "");
        }
    }
}

