/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;

public class RaidGroupDatabase
extends AbstractDatabase {
    private RaidGroupDescriptor[] raidGroupArray;
    final String[] raidGroupDefaultLabels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    RaidGroupDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "RaidGroup");
        this.raidGroupArray = new RaidGroupDescriptor[16];
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            this.raidGroupArray[raidGroup] = new RaidGroupDescriptor(raidGroup);
            ++raidGroup;
        }
    }

    public String generateRaidGroupLabel(String[] raidGroupStatuses, int raidGroupNumber) {
        String raidGroupLabel = "Volume " + this.raidGroupDefaultLabels[raidGroupNumber];
        if (!this.raidGroupLabelExists(raidGroupStatuses, raidGroupLabel)) {
            return raidGroupLabel;
        }
        return "";
    }

    public String generateRaidGroupLabel(String[] raidGroupStatuses, String[] raidGroupNumbers) {
        int i = 0;
        while (i < raidGroupNumbers.length) {
            String raidGroupLabel = "Volume " + this.raidGroupDefaultLabels[Integer.parseInt(raidGroupNumbers[i])];
            if (!this.raidGroupLabelExists(raidGroupStatuses, raidGroupLabel)) {
                return raidGroupLabel;
            }
            ++i;
        }
        return "";
    }

    public RaidGroupDescriptor get(int raidGroup) {
        return (RaidGroupDescriptor)this.raidGroupArray[raidGroup].clone();
    }

    public synchronized String[] getAvailableLegacyRaidGroupNumbers() {
        int availableRaidGroupCount = 0;
        int maxLegacyRaidGroupCount = 4;
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if ((raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && raidGroupDescriptor.metadataFormat.equals("Old") && --maxLegacyRaidGroupCount == 0) break;
            ++raidGroup;
        }
        int raidGroup2 = 0;
        while (raidGroup2 < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup2];
            if (raidGroupDescriptor.status.equals("Unused") || raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.status.equals("Failed")) {
                ++availableRaidGroupCount;
            }
            ++raidGroup2;
        }
        if (availableRaidGroupCount < maxLegacyRaidGroupCount) {
            maxLegacyRaidGroupCount = availableRaidGroupCount;
        }
        String[] availableRaidGroupNumbers = new String[maxLegacyRaidGroupCount];
        availableRaidGroupCount = 0;
        if (availableRaidGroupNumbers.length > 0) {
            int raidGroup3 = 0;
            while (raidGroup3 < this.raidGroupArray.length) {
                RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup3];
                if (raidGroupDescriptor.status.equals("Unused") || raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.status.equals("Failed")) {
                    availableRaidGroupNumbers[availableRaidGroupCount++] = Integer.toString(raidGroup3);
                    if (availableRaidGroupCount >= maxLegacyRaidGroupCount) break;
                }
                ++raidGroup3;
            }
        }
        return availableRaidGroupNumbers;
    }

    public synchronized String[] getAvailableRaidGroupNumbers() {
        int availableRaidGroupCount = 0;
        int maxRaidGroupCount = this.databaseManager.maximumRaidGroups;
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if ((raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && --maxRaidGroupCount == 0) break;
            ++raidGroup;
        }
        int raidGroup2 = 0;
        while (raidGroup2 < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup2];
            if (raidGroupDescriptor.status.equals("Unused") || raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.status.equals("Failed")) {
                ++availableRaidGroupCount;
            }
            ++raidGroup2;
        }
        if (availableRaidGroupCount < maxRaidGroupCount) {
            maxRaidGroupCount = availableRaidGroupCount;
        }
        String[] availableRaidGroupNumbers = new String[maxRaidGroupCount];
        availableRaidGroupCount = 0;
        if (availableRaidGroupNumbers.length > 0) {
            int raidGroup3 = 0;
            while (raidGroup3 < this.raidGroupArray.length) {
                RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup3];
                if (raidGroupDescriptor.status.equals("Unused") || raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.status.equals("Failed")) {
                    availableRaidGroupNumbers[availableRaidGroupCount++] = Integer.toString(raidGroup3);
                    if (availableRaidGroupCount >= maxRaidGroupCount) break;
                }
                ++raidGroup3;
            }
        }
        return availableRaidGroupNumbers;
    }

    public synchronized int getLegacyRaidGroupCount() {
        int legacyRaidGroupCount = 0;
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if ((raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && raidGroupDescriptor.metadataFormat.equals("Old")) {
                ++legacyRaidGroupCount;
            }
            ++raidGroup;
        }
        return legacyRaidGroupCount;
    }

    public synchronized int getMultiMemRaidGroupCount() {
        int raidGroupCount = 0;
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if ((raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && raidGroupDescriptor.memberArray.size() > 1) {
                ++raidGroupCount;
            }
            ++raidGroup;
        }
        return raidGroupCount;
    }

    public synchronized int getNextAvailableRaidGroup() {
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (raidGroupDescriptor.status.equals("Unused") || raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.status.equals("Failed")) {
                return raidGroup;
            }
            ++raidGroup;
        }
        return -1;
    }

    public synchronized int getRaidGroupCount(String[] configurations) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            int count = 0;
            while (count < configurations.length) {
                if (!raidGroupDescriptor.status.equals("Unused") && !raidGroupDescriptor.status.equals("Offline") && configurations[count].equals(raidGroupDescriptor.configuration)) {
                    requestedRaidGroupList.add(raidGroupDescriptor.clone());
                    break;
                }
                ++count;
            }
            ++raidGroup;
        }
        return requestedRaidGroupList.size();
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses, boolean onlyRedundant, String metadataFormat) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            int count = 0;
            while (count < statuses.length) {
                if (statuses[count].equals(raidGroupDescriptor.status) && (!onlyRedundant || raidGroupDescriptor.configuration.equals("Mirrored") || raidGroupDescriptor.configuration.equals("Mirrored Striped") || raidGroupDescriptor.configuration.equals("Parity RAID")) && raidGroupDescriptor.metadataFormat.equals(metadataFormat)) {
                    requestedRaidGroupList.add(raidGroupDescriptor.clone());
                }
                ++count;
            }
            ++raidGroup;
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses, boolean onlyRedundant) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            int count = 0;
            while (count < statuses.length) {
                if (statuses[count].equals(raidGroupDescriptor.status) && (!onlyRedundant || raidGroupDescriptor.configuration.equals("Mirrored") || raidGroupDescriptor.configuration.equals("Mirrored Striped") || raidGroupDescriptor.configuration.equals("Parity RAID"))) {
                    requestedRaidGroupList.add(raidGroupDescriptor.clone());
                }
                ++count;
            }
            ++raidGroup;
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            int count = 0;
            while (count < statuses.length) {
                if (statuses[count].equals(raidGroupDescriptor.status)) {
                    requestedRaidGroupList.add(raidGroupDescriptor.clone());
                    break;
                }
                ++count;
            }
            ++raidGroup;
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String raidGroupStatus) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (raidGroupDescriptor.status.equals(raidGroupStatus)) {
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
            }
            ++raidGroup;
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(boolean onlyRedundant) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Unused") && !raidGroupDescriptor.status.equals("Offline") && (!onlyRedundant || raidGroupDescriptor.configuration.equals("Mirrored") || raidGroupDescriptor.configuration.equals("Mirrored Striped") || raidGroupDescriptor.configuration.equals("Parity RAID"))) {
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
            }
            ++raidGroup;
        }
        return requestedRaidGroupList;
    }

    public synchronized String[] getUsedRaidGroupNumbers(String[] metadataFormats, boolean onlyRedundant) {
        int usedRaidGroupCount = 0;
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            int formatCount = 0;
            while (formatCount < metadataFormats.length) {
                if ((metadataFormats[formatCount].equals(raidGroupDescriptor.metadataFormat) || metadataFormats[formatCount].equals("All")) && (raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && (!onlyRedundant || raidGroupDescriptor.configuration.equals("Mirrored") || raidGroupDescriptor.configuration.equals("Mirrored Striped") || raidGroupDescriptor.configuration.equals("Parity RAID"))) {
                    ++usedRaidGroupCount;
                }
                ++formatCount;
            }
            ++raidGroup;
        }
        String[] usedRaidGroupNumbers = new String[usedRaidGroupCount];
        usedRaidGroupCount = 0;
        int raidGroup2 = 0;
        while (raidGroup2 < this.raidGroupArray.length) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup2];
            int formatCount = 0;
            while (formatCount < metadataFormats.length) {
                if ((metadataFormats[formatCount].equals(raidGroupDescriptor.metadataFormat) || metadataFormats[formatCount].equals("All")) && (raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced")) && (!onlyRedundant || raidGroupDescriptor.configuration.equals("Mirrored") || raidGroupDescriptor.configuration.equals("Mirrored Striped") || raidGroupDescriptor.configuration.equals("Parity RAID"))) {
                    usedRaidGroupNumbers[usedRaidGroupCount++] = Integer.toString(raidGroup2);
                }
                ++formatCount;
            }
            ++raidGroup2;
        }
        return usedRaidGroupNumbers;
    }

    public void initialize() {
        super.initialize();
        this.raidGroupArray = new RaidGroupDescriptor[this.databaseManager.getSelectedController().maxRaidGroups];
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            this.raidGroupArray[raidGroup] = new RaidGroupDescriptor(raidGroup);
            ++raidGroup;
        }
        this.getFirst();
    }

    public synchronized boolean legacyRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        int raidGroupIndex = 0;
        while (raidGroupIndex < raidGroupList.size()) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (raidGroup.metadataFormat.equals("Old")) {
                return true;
            }
            ++raidGroupIndex;
        }
        return false;
    }

    public boolean legacyRaidGroupMaxReached() {
        return this.getLegacyRaidGroupCount() >= 4;
    }

    public synchronized boolean legacyReducedRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        int raidGroupIndex = 0;
        while (raidGroupIndex < raidGroupList.size()) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (raidGroup.metadataFormat.equals("Old") && raidGroup.status.equals("Reduced")) {
                return true;
            }
            ++raidGroupIndex;
        }
        return false;
    }

    public synchronized boolean newRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        int raidGroupIndex = 0;
        while (raidGroupIndex < raidGroupList.size()) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (raidGroup.metadataFormat.equals("New")) {
                return true;
            }
            ++raidGroupIndex;
        }
        return false;
    }

    public synchronized boolean newReducedRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        int raidGroupIndex = 0;
        while (raidGroupIndex < raidGroupList.size()) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (raidGroup.metadataFormat.equals("New") && raidGroup.status.equals("Reduced") && this.databaseManager.deviceDatabase.rebuildSegmentExists(raidGroup.raidGroup)) {
                return true;
            }
            ++raidGroupIndex;
        }
        return false;
    }

    public synchronized void nuke() {
        super.nuke();
        int raidGroup = 0;
        while (raidGroup < this.raidGroupArray.length) {
            this.raidGroupArray[raidGroup] = new RaidGroupDescriptor(raidGroup);
            ++raidGroup;
        }
        this.notifyListeners();
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing && faultDescriptor.reason.equals("None Found")) {
                        this.initializationComplete();
                    }
                } else if (xmlData.element.equals("RaidGroupInfo")) {
                    RaidGroupDescriptor raidGroupDescriptor;
                    this.raidGroupArray[raidGroupDescriptor.raidGroup] = raidGroupDescriptor = new RaidGroupDescriptor(xmlData.elementValue);
                    if (this.initializing) {
                        this.getNext(raidGroupDescriptor.raidGroup);
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "RAID Group Database Exception\nMessage " + message.response);
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            int raidGroup = 0;
            while (raidGroup < this.raidGroupArray.length) {
                this.raidGroupArray[raidGroup].receivedUpdateCount = false;
                ++raidGroup;
            }
            XmlData xmlData = new XmlData(data);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("RaidGroupUpdateCount")) continue;
                String raidGroup2 = null;
                String updateCount = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("RaidGroup")) {
                        raidGroup2 = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    updateCount = updateXmlData.elementValue;
                }
                if (raidGroup2 == null || updateCount == null) continue;
                RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[Integer.parseInt(raidGroup2)];
                raidGroupDescriptor.receivedUpdateCount = true;
                if (raidGroupDescriptor.updateCount.equals(updateCount)) continue;
                this.getThis(Integer.parseInt(raidGroup2));
            }
            int raidGroup3 = 0;
            while (raidGroup3 < this.raidGroupArray.length) {
                if (!(this.raidGroupArray[raidGroup3].receivedUpdateCount || this.raidGroupArray[raidGroup3].status.equals("Offline") || this.raidGroupArray[raidGroup3].status.equals("Unused"))) {
                    this.getThis(raidGroup3);
                }
                ++raidGroup3;
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "RAID Group Database Process Update Counts Exception\n " + data);
        }
    }

    public boolean raidGroupLabelExists(String[] raidGroupStatuses, String raidGroupLabel) {
        ArrayList raidGroupList = this.getRaidGroupList(raidGroupStatuses, false, "New");
        int raidGroup = 0;
        while (raidGroup < raidGroupList.size()) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            if (raidGroupDescriptor.label.equals(raidGroupLabel)) {
                return true;
            }
            ++raidGroup;
        }
        return false;
    }

    public void snapshot(FileOutputStream outputStream) {
    }
}

