/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PostponedConnectionTableBox
extends JDialog
implements GlobalConstants {
    private static final boolean DebugParam = false;
    private JButton addButton;
    private JButton cancelButton;
    private CommManager commManager;
    private KTable connectionTable;
    private ConnectionTableModel connectionTableModel;
    private ArrayList currentConnectionList;
    private JButton deleteButton;
    private JButton editButton;
    private HostConnectionManager hostConnectionManager;
    private final String moduleName = "ConnectionTableBox";
    private ArrayList newHostConnections;
    private JButton okButton;
    private JButton setPrefButton;
    private StorageManagementUtility storageManagementUtility;
    private boolean updateInProgress;

    public PostponedConnectionTableBox(StorageManagementUtility storageManagementUtility, HostConnectionManager hostConnectionManager) {
        super(storageManagementUtility, "Connection Table", true);
        this.hostConnectionManager = hostConnectionManager;
        this.commManager = hostConnectionManager.commManager;
        this.currentConnectionList = new ArrayList();
        this.newHostConnections = new ArrayList();
        try {
            this.getContentPane().add((Component)this.buildMainPanel(), "North");
        }
        catch (Exception e) {
            ErrorLog.put(e, "ConnectionTableBox: Constructor > buildMainPanel()");
        }
        try {
            this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        }
        catch (Exception e) {
            ErrorLog.put(e, "ConnectionTableBox: Constructor > buildButtonPanel()");
        }
        this.displayTableContents();
        try {
            this.pack();
        }
        catch (Exception e) {
            ErrorLog.put(e, "ConnectionTableBox: Constructor > pack()");
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getBounds().width) / 2, (screen.height - this.getBounds().height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PostponedConnectionTableBox.this.dispose();
            }
        });
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    public void addHostToConnectionList(HostConnectionDescriptor hostConnection) {
        ConnectionListNode connectionNode = new ConnectionListNode();
        connectionNode.alias = hostConnection.alias;
        connectionNode.type = hostConnection.type;
        connectionNode.ipAddress = hostConnection.ipAddress;
        connectionNode.serverPort = hostConnection.serverPort;
        connectionNode.preferred = hostConnection.preferred;
        connectionNode.reference = hostConnection;
        this.currentConnectionList.add(connectionNode);
    }

    public boolean aliasEntryExists(String alias) {
        if (alias.equals("")) {
            return false;
        }
        int curIndex = 0;
        while (curIndex < this.currentConnectionList.size()) {
            ConnectionListNode connectionNode = (ConnectionListNode)this.currentConnectionList.get(curIndex);
            if (connectionNode.alias == null) {
                connectionNode.alias = "";
            }
            if (connectionNode.alias.equals(alias)) {
                return true;
            }
            ++curIndex;
        }
        return false;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        ButtonPanel leftButtonPanel = new ButtonPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 0));
        this.addButton = new JButton("Add");
        this.setPrefButton = new JButton("Set Preferred");
        this.deleteButton = new JButton("Delete");
        this.editButton = new JButton("Edit");
        ButtonPanel rightButtonPanel = new ButtonPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 0));
        this.cancelButton = new JButton("Cancel");
        this.okButton = new JButton("OK");
        this.addButton.setMnemonic(65);
        this.setPrefButton.setMnemonic(83);
        this.deleteButton.setMnemonic(68);
        this.editButton.setMnemonic(69);
        this.cancelButton.setMnemonic(67);
        this.okButton.setMnemonic(79);
        this.addButton.addActionListener(new AddButtonActionListener());
        this.setPrefButton.addActionListener(new SetPreferredButtonActionListener());
        this.deleteButton.addActionListener(new DeleteButtonActionListener());
        this.editButton.addActionListener(new EditButtonActionListener());
        this.cancelButton.addActionListener(new CancelButtonActionListener());
        this.okButton.addActionListener(new OkButtonActionListener());
        int offset = UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel") ? 2 : 8;
        leftButtonPanel.add(this.addButton);
        leftButtonPanel.add(Box.createRigidArea(new Dimension(offset, 0)));
        leftButtonPanel.add(this.setPrefButton);
        leftButtonPanel.add(Box.createRigidArea(new Dimension(offset, 0)));
        leftButtonPanel.add(this.deleteButton);
        leftButtonPanel.add(Box.createRigidArea(new Dimension(offset, 0)));
        leftButtonPanel.add(this.editButton);
        rightButtonPanel.add(this.cancelButton);
        rightButtonPanel.add(Box.createRigidArea(new Dimension(offset, 0)));
        rightButtonPanel.add(this.okButton);
        buttonPanel.add((Component)leftButtonPanel, "West");
        buttonPanel.add((Component)rightButtonPanel, "East");
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 12, 12));
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        }
        return buttonPanel;
    }

    private JPanel buildConnectionPanel() {
        this.connectionTableModel = new ConnectionTableModel();
        this.connectionTable = new KTable(this.connectionTableModel, 10);
        this.connectionTable.setSelectionMode(0);
        this.connectionTable.addListSelectionListener(new ConnectionTableSelectionListener());
        JScrollPane scrollPane = new JScrollPane(this.connectionTable);
        scrollPane.getViewport().setBackground(this.connectionTable.getBackground());
        JPanel connectionsPanel = new JPanel();
        connectionsPanel.add(scrollPane);
        connectionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        connectionsPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder("Connections"), BorderFactory.createEmptyBorder(0, 0, 6, 0)));
        this.connectionTable.setPreferredTableWidth(550);
        return connectionsPanel;
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel connectionsPanel = this.buildConnectionPanel();
        mainPanel.add(connectionsPanel);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 4, 10));
        return mainPanel;
    }

    public boolean connectionNodeEntryExists(HostConnectionDescriptor compareNode) {
        int curIndex = 0;
        while (curIndex < this.currentConnectionList.size()) {
            ConnectionListNode connectionNode = (ConnectionListNode)this.currentConnectionList.get(curIndex);
            if (connectionNode.alias == null) {
                connectionNode.alias = "";
            }
            if (connectionNode.alias.equals(compareNode.alias) && connectionNode.ipAddress.equals(compareNode.ipAddress) && connectionNode.type == compareNode.type) {
                return true;
            }
            ++curIndex;
        }
        return false;
    }

    public void copyHostToConnectionList(HostConnectionDescriptor hostConnection, ConnectionListNode connectionNode) {
        connectionNode.alias = hostConnection.alias;
        connectionNode.type = hostConnection.type;
        connectionNode.ipAddress = hostConnection.ipAddress;
        connectionNode.serverPort = hostConnection.serverPort;
        connectionNode.preferred = hostConnection.preferred;
        connectionNode.reference = hostConnection;
    }

    public void displayPopUpErrorMessage(String errorText, String errorType) {
        JOptionPane.showMessageDialog(this, errorText, errorType, 0);
    }

    private synchronized void displayTableContents() {
        this.updateInProgress = true;
        this.currentConnectionList.clear();
        int index = 0;
        while (index < this.hostConnectionManager.getHostConnectionCount()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnectionManager.getHostConnection(index).clone();
            this.addHostToConnectionList(hostConnection);
            ++index;
        }
        this.setUpConnectionTableSelection();
        this.updateInProgress = false;
        this.updateButtonState();
    }

    public boolean ipAddressEntryExists(String ipAddress) {
        int curIndex = 0;
        while (curIndex < this.currentConnectionList.size()) {
            ConnectionListNode connectionNode = (ConnectionListNode)this.currentConnectionList.get(curIndex);
            if (connectionNode.ipAddress == null) {
                connectionNode.ipAddress = "";
            }
            if (connectionNode.ipAddress.equals(ipAddress)) {
                return true;
            }
            ++curIndex;
        }
        return false;
    }

    private void setUpConnectionTableSelection() {
        try {
            int connectionRow = this.connectionTable.getSelectedRow();
            this.connectionTable.clearSelection();
            this.connectionTableModel.updateDisplay();
            if (this.connectionTable.getRowCount() > 0) {
                if (connectionRow >= this.connectionTable.getRowCount()) {
                    --connectionRow;
                }
                if (connectionRow == -1) {
                    connectionRow = 0;
                }
                this.connectionTable.setRowSelectionInterval(connectionRow, connectionRow);
            }
        }
        catch (Exception e) {
            ErrorLog.put(e, "ConnectionTableBox: setUpConnectionTableSelection()");
        }
    }

    private synchronized void updateButtonState() {
        if (this.updateInProgress) {
            return;
        }
        if (this.currentConnectionList.size() > 0) {
            int connectionRow;
            if (!this.setPrefButton.isEnabled()) {
                this.setPrefButton.setEnabled(true);
            }
            if (!this.editButton.isEnabled()) {
                this.editButton.setEnabled(true);
            }
            if ((connectionRow = this.connectionTable.getSelectedRow()) != -1) {
                ConnectionListNode connectionNode = (ConnectionListNode)this.currentConnectionList.get(connectionRow);
                if (connectionNode.type.equals("Local")) {
                    if (this.deleteButton.isEnabled()) {
                        this.deleteButton.setEnabled(false);
                    }
                } else if (!this.deleteButton.isEnabled()) {
                    this.deleteButton.setEnabled(true);
                }
            }
        } else {
            if (this.setPrefButton.isEnabled()) {
                this.setPrefButton.setEnabled(false);
            }
            if (this.deleteButton.isEnabled()) {
                this.deleteButton.setEnabled(false);
            }
            if (this.editButton.isEnabled()) {
                this.editButton.setEnabled(false);
            }
        }
        if (this.currentConnectionList.size() >= 10) {
            this.addButton.setEnabled(false);
        } else if (!this.addButton.isEnabled()) {
            this.addButton.setEnabled(true);
        }
        if (!this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(true);
        }
    }

    class ConnectionTableModel
    extends KTableModel {
        public ConnectionTableModel() {
            String[] fieldNames = new String[]{"Alias", "Type", "IP Address", "Port", "Preferred"};
            String[] maxFieldText = new String[]{"1234567890123", "Remote", "123.123.123", "3200", "X"};
            this.setColumns(fieldNames, maxFieldText);
        }

        public int getRowCount() {
            return PostponedConnectionTableBox.this.currentConnectionList.size();
        }

        public Object getValueAt(int row, int column) {
            boolean ALIAS_COLUMN = false;
            boolean TYPE_COLUMN = true;
            int IP_ADDRESS_COLUMN = 2;
            int SERV_PORT_COLUMN = 3;
            int PREFERRED_COLUMN = 4;
            String[] fieldNames = new String[]{"Alias", "Type", "IP Address", "Port", "Preferred"};
            if (row < PostponedConnectionTableBox.this.currentConnectionList.size()) {
                ConnectionListNode connectionListNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.get(row);
                if (column == 0) {
                    if (connectionListNode.alias == null) {
                        return "";
                    }
                    return " " + connectionListNode.alias;
                }
                if (column == 1) {
                    return " " + connectionListNode.type;
                }
                if (column == 2) {
                    if (connectionListNode.ipAddress.equals("0.0.0.0")) {
                        return "";
                    }
                    return " " + connectionListNode.ipAddress;
                }
                if (column == 3) {
                    return " " + connectionListNode.serverPort;
                }
                if (column == 4) {
                    if (connectionListNode.preferred) {
                        return " *";
                    }
                    return "  ";
                }
            }
            return "";
        }

        public void updateDisplay() {
            try {
                if (PostponedConnectionTableBox.this.currentConnectionList.size() > 0) {
                    this.fireTableRowsInserted(0, PostponedConnectionTableBox.this.currentConnectionList.size() - 1);
                } else {
                    this.fireTableRowsDeleted(0, 0);
                }
            }
            catch (Exception e) {
                ErrorLog.put(e, "ConnectionTableBox: ConnectionTableModel.updateDisplay()");
            }
            PostponedConnectionTableBox.this.updateButtonState();
        }
    }

    class OkButtonActionListener
    implements ActionListener {
        OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PostponedConnectionTableBox.this.currentConnectionList.size() > 0) {
                PostponedConnectionTableBox.this.newHostConnections.clear();
                int index = 0;
                while (index < PostponedConnectionTableBox.this.currentConnectionList.size()) {
                    ConnectionListNode connectionNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.get(index);
                    HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)connectionNode.reference;
                    PostponedConnectionTableBox.this.newHostConnections.add(hostConnection);
                    ++index;
                }
                PostponedConnectionTableBox.this.hostConnectionManager.mergeHostConnections(PostponedConnectionTableBox.this.newHostConnections);
                PostponedConnectionTableBox.this.hostConnectionManager.saveHostConnectionPreferences();
            }
            PostponedConnectionTableBox.this.dispose();
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PostponedConnectionTableBox.this.dispose();
        }
    }

    class EditButtonActionListener
    implements ActionListener {
        EditButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PostponedConnectionTableBox.this.connectionTable != null) {
                if (PostponedConnectionTableBox.this.currentConnectionList.size() == 0) {
                    return;
                }
                int connectionRow = PostponedConnectionTableBox.this.connectionTable.getSelectedRow();
                if (connectionRow != -1) {
                    ConnectionListNode connectionNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.get(connectionRow);
                    new PostponedConnectionAddBox(PostponedConnectionTableBox.this.storageManagementUtility, PostponedConnectionTableBox.this, PostponedConnectionTableBox.this.hostConnectionManager, connectionNode);
                    PostponedConnectionTableBox.this.setUpConnectionTableSelection();
                    PostponedConnectionTableBox.this.updateButtonState();
                    PostponedConnectionTableBox.this.getContentPane().update(PostponedConnectionTableBox.this.getContentPane().getGraphics());
                }
            }
        }
    }

    class DeleteButtonActionListener
    implements ActionListener {
        DeleteButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PostponedConnectionTableBox.this.connectionTable != null) {
                if (PostponedConnectionTableBox.this.currentConnectionList.size() == 0) {
                    return;
                }
                int connectionRow = PostponedConnectionTableBox.this.connectionTable.getSelectedRow();
                if (connectionRow != -1) {
                    int answer = JOptionPane.showConfirmDialog(PostponedConnectionTableBox.this, "Are you sure you want to delete the selected connection?", "Delete Host Connection Verification", 0);
                    if (answer == 1) {
                        return;
                    }
                    ConnectionListNode connectionNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.remove(connectionRow);
                    PostponedConnectionTableBox.this.setUpConnectionTableSelection();
                    PostponedConnectionTableBox.this.updateButtonState();
                }
            }
        }
    }

    class SetPreferredButtonActionListener
    implements ActionListener {
        SetPreferredButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PostponedConnectionTableBox.this.connectionTable != null) {
                if (PostponedConnectionTableBox.this.currentConnectionList.size() == 0) {
                    return;
                }
                int connectionRow = PostponedConnectionTableBox.this.connectionTable.getSelectedRow();
                if (connectionRow != -1) {
                    HostConnectionDescriptor hostConnection;
                    ConnectionListNode connectionNode;
                    int index = 0;
                    while (index < PostponedConnectionTableBox.this.currentConnectionList.size()) {
                        connectionNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.get(index);
                        connectionNode.preferred = false;
                        hostConnection = (HostConnectionDescriptor)connectionNode.reference;
                        hostConnection.preferred = false;
                        ++index;
                    }
                    connectionNode = (ConnectionListNode)PostponedConnectionTableBox.this.currentConnectionList.get(connectionRow);
                    connectionNode.preferred = true;
                    hostConnection = (HostConnectionDescriptor)connectionNode.reference;
                    hostConnection.preferred = true;
                    PostponedConnectionTableBox.this.setUpConnectionTableSelection();
                    PostponedConnectionTableBox.this.updateButtonState();
                }
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new PostponedConnectionAddBox(PostponedConnectionTableBox.this.storageManagementUtility, PostponedConnectionTableBox.this, PostponedConnectionTableBox.this.hostConnectionManager);
            PostponedConnectionTableBox.this.setUpConnectionTableSelection();
            PostponedConnectionTableBox.this.updateButtonState();
            PostponedConnectionTableBox.this.getContentPane().update(PostponedConnectionTableBox.this.getContentPane().getGraphics());
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                // empty if block
            }
            PostponedConnectionTableBox.this.updateButtonState();
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }
    }

    class ConnectionTableSelectionListener
    implements ListSelectionListener {
        ConnectionTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            PostponedConnectionTableBox.this.updateButtonState();
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            PostponedConnectionTableBox.this.updateButtonState();
        }
    }

    class TextFieldKeyListener
    implements KeyListener {
        TextFieldKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            PostponedConnectionTableBox.this.updateButtonState();
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

