/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PostponedConnectionAddBox
extends JDialog
implements GlobalConstants {
    private JPanel addressPanel;
    private String alias = "";
    private LengthTextField aliasTextField;
    private String aliasWork = "";
    private JButton cancelButton;
    private ConnectionListNode connectionNode;
    private boolean editing = false;
    private HostConnectionManager hostConnectionManager;
    private String ipAddress = "0.0.0.0";
    private IntegerTextField[] ipAddressTextField;
    private String ipAddressWork = "0.0.0.0";
    private final String moduleName = "ConnectionAddBox";
    private JButton okButton;
    private PostponedConnectionTableBox parent;
    private String serverPort = Integer.toString(4242);
    private IntegerTextField serverPortTextField;
    private String serverPortWork = Integer.toString(4242);
    private StorageManagementUtility storageManagementUtility;

    public PostponedConnectionAddBox(StorageManagementUtility storageManagementUtility, PostponedConnectionTableBox parent, HostConnectionManager hostConnectionManager, ConnectionListNode connectionNode) {
        super(storageManagementUtility, "Add Connection Entry", true);
        this.storageManagementUtility = storageManagementUtility;
        this.parent = parent;
        this.hostConnectionManager = hostConnectionManager;
        this.connectionNode = connectionNode;
        this.alias = connectionNode.alias;
        this.ipAddress = connectionNode.ipAddress;
        this.serverPort = connectionNode.serverPort;
        this.aliasWork = this.alias;
        this.ipAddressWork = this.ipAddress;
        this.serverPortWork = this.serverPort;
        this.editing = true;
        this.buildConnectionAddBox();
    }

    public PostponedConnectionAddBox(StorageManagementUtility storageManagementUtility, PostponedConnectionTableBox parent, HostConnectionManager hostConnectionManager) {
        super(storageManagementUtility, "Add Connection Entry", true);
        this.storageManagementUtility = storageManagementUtility;
        this.parent = parent;
        this.hostConnectionManager = hostConnectionManager;
        this.buildConnectionAddBox();
    }

    private boolean applyParameterChanges() {
        ConnectionListNode saveConnectionNode = new ConnectionListNode();
        boolean result = false;
        if (this.editing) {
            this.connectionNode.copyTo(saveConnectionNode);
            this.connectionNode.nuke();
        }
        HostConnectionDescriptor hostConnection = new HostConnectionDescriptor();
        hostConnection.alias = this.alias;
        hostConnection.type = "Remote";
        hostConnection.ipAddress = this.ipAddress;
        hostConnection.serverPort = this.serverPort;
        hostConnection.preferred = false;
        hostConnection.controller = 0;
        if (this.parent.connectionNodeEntryExists(hostConnection)) {
            JOptionPane.showMessageDialog(null, "Identical Node already exists. Please change the entry.", "Duplicate Node Alert", 0);
        } else if (this.parent.aliasEntryExists(hostConnection.alias)) {
            JOptionPane.showMessageDialog(null, "Identical Alias already exists. Please change the entry.", "Duplicate Alias Alert", 0);
        } else if (this.parent.ipAddressEntryExists(hostConnection.ipAddress)) {
            JOptionPane.showMessageDialog(null, "Identical IP Address already exists. Please change the entry.", "Duplicate IP Address Alert", 0);
        } else {
            if (this.editing) {
                hostConnection.copyTo((HostConnectionDescriptor)saveConnectionNode.reference);
                this.parent.copyHostToConnectionList(hostConnection, this.connectionNode);
            } else {
                this.parent.addHostToConnectionList(hostConnection);
            }
            result = true;
        }
        if (!result && this.editing) {
            saveConnectionNode.copyTo(this.connectionNode);
        }
        return result;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        Insets insets = this.cancelButton.getMargin();
        insets.left = 6;
        insets.right = 6;
        this.okButton.setMargin(insets);
        this.cancelButton.setMargin(insets);
        Dimension dimension = this.cancelButton.getPreferredSize();
        this.okButton.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.okButton.addActionListener(new OkButtonActionListener());
        this.cancelButton.addActionListener(new CancelButtonActionListener());
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        }
        buttonPanel.add(this.cancelButton);
        this.okButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(7, 12, 12, 14));
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 6, 6, 7));
        }
        return buttonPanel;
    }

    private String buildCompleteIpAddress(JTextField[] addressTextField) {
        String ipAddress = "";
        String componentSep = ".";
        int component = 0;
        while (component < 4) {
            try {
                ipAddress = ipAddress + addressTextField[component].getText() + componentSep;
            }
            catch (Exception e) {
                ErrorLog.put(e, "ConnectionAddBox: buildCompleteIpAddress(): component = " + component);
            }
            if (component == 2) {
                componentSep = "";
            }
            ++component;
        }
        return ipAddress;
    }

    private void buildConnectionAddBox() {
        this.initializeComponents();
        this.getContentPane().add((Component)this.buildConnectionPane(), "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        InputFieldChangeListener inputFieldChangeListener = new InputFieldChangeListener();
        ParameterDocumentListener parameterDocumentListener = new ParameterDocumentListener();
        int index = 0;
        while (index < this.ipAddressTextField.length) {
            this.ipAddressTextField[index].getDocument().addDocumentListener(parameterDocumentListener);
            this.ipAddressTextField[index].addKeyListener(inputFieldChangeListener);
            this.ipAddressTextField[index].addFocusListener(inputFieldChangeListener);
            ++index;
        }
        this.aliasTextField.getDocument().addDocumentListener(parameterDocumentListener);
        this.aliasTextField.addKeyListener(inputFieldChangeListener);
        this.aliasTextField.addFocusListener(inputFieldChangeListener);
        this.serverPortTextField.getDocument().addDocumentListener(parameterDocumentListener);
        this.serverPortTextField.addKeyListener(inputFieldChangeListener);
        this.serverPortTextField.addFocusListener(inputFieldChangeListener);
        this.updateBoxContents();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((screen.width - this.getBounds().width) / 2, (screen.height - this.getBounds().height) / 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PostponedConnectionAddBox.this.closeBox();
            }
        });
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel buildConnectionPane() {
        JPanel connectionPanel = new JPanel();
        this.addressPanel = new JPanel();
        this.addressPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.addressPanel.setLayout(new BoxLayout(this.addressPanel, 1));
        this.addressPanel.add(this.buildTopParamsPanel(this.aliasTextField, this.serverPortTextField));
        this.addressPanel.add(this.buildEthernetParamsPanel(this.ipAddressTextField));
        connectionPanel.add(this.addressPanel);
        JPanel panel = new JPanel();
        panel.add(connectionPanel);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        return panel;
    }

    private JPanel buildEthernetParamsPanel(JTextField[] ipAddressTextField) {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        TitledBorder titled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "IP Address");
        titled.setTitlePosition(0);
        panel.setBorder(new CompoundBorder(titled, BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        int index = 0;
        while (index < ipAddressTextField.length) {
            Utility.addComponent(ipAddressTextField[index], panel, layout, constraints, 1 + index * 2, 0, 0, 8, 8, 12, 0.0);
            ++index;
        }
        return panel;
    }

    private JPanel buildTopParamsPanel(LengthTextField aliasTextField, IntegerTextField serverPortTextField) {
        JPanel panel1 = new JPanel();
        GridBagLayout layout1 = new GridBagLayout();
        GridBagConstraints constraints1 = new GridBagConstraints();
        constraints1.anchor = 17;
        panel1.setLayout(layout1);
        Utility.addComponent(aliasTextField, panel1, layout1, constraints1, 1, 0, 0, 8, 8, 12, 0.0);
        TitledBorder titled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Alias");
        titled.setTitlePosition(0);
        panel1.setBorder(new CompoundBorder(titled, BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        JPanel panel2 = new JPanel();
        GridBagLayout layout2 = new GridBagLayout();
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.anchor = 13;
        panel2.setLayout(layout2);
        Utility.addComponent(serverPortTextField, panel2, layout2, constraints2, 1, 0, 0, 8, 8, 12, 0.0);
        titled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Port");
        panel2.setBorder(new CompoundBorder(titled, BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        JPanel panel = new JPanel();
        panel.add((Component)panel1, "West");
        panel.add((Component)panel2, "East");
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return panel;
    }

    private void closeBox() {
        this.dispose();
    }

    public String getIpAddressComponent(String ipAdress, int index) {
        int startIndex = 0;
        int count = 0;
        while (count < 4) {
            int endIndex = ipAdress.indexOf(".", startIndex);
            if (endIndex == -1) {
                endIndex = ipAdress.length();
            }
            if (count == index) {
                return ipAdress.substring(startIndex, endIndex);
            }
            startIndex = endIndex + 1;
            ++count;
        }
        return null;
    }

    private void initializeComponents() {
        this.aliasTextField = new LengthTextField("", 13, 16);
        this.aliasTextField.setText(this.alias);
        this.ipAddressTextField = new IntegerTextField[4];
        int index = 0;
        while (index < this.ipAddressTextField.length) {
            this.ipAddressTextField[index] = new IntegerTextField(3, 0, 255);
            this.ipAddressTextField[index].setText(this.getIpAddressComponent(this.ipAddress, index));
            ++index;
        }
        this.serverPortTextField = new IntegerTextField(4, 0, 32000);
        this.serverPortTextField.setText(this.serverPort);
    }

    private synchronized void updateBoxContents() {
        this.addressPanel.validate();
        this.addressPanel.repaint();
        if (!this.ipAddress.equals("0.0.0.0")) {
            int index = 0;
            while (index < this.ipAddressTextField.length) {
                if (!this.ipAddressTextField[index].getText().equals("0")) {
                    return;
                }
                ++index;
            }
            int index2 = 0;
            while (index2 < this.ipAddressTextField.length) {
                this.ipAddressTextField[index2].setText(this.getIpAddressComponent(this.ipAddress, index2));
                ++index2;
            }
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PostponedConnectionAddBox.this.closeBox();
        }
    }

    class OkButtonActionListener
    implements ActionListener {
        OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!PostponedConnectionAddBox.this.applyParameterChanges()) {
                PostponedConnectionAddBox.this.ipAddressWork = PostponedConnectionAddBox.this.ipAddress;
                PostponedConnectionAddBox.this.aliasWork = PostponedConnectionAddBox.this.alias;
                PostponedConnectionAddBox.this.serverPortWork = PostponedConnectionAddBox.this.serverPort;
                PostponedConnectionAddBox.this.okButton.setEnabled(false);
            } else {
                PostponedConnectionAddBox.this.closeBox();
            }
        }
    }

    class InputFieldChangeListener
    implements ActionListener,
    KeyListener,
    FocusListener {
        InputFieldChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void focusGained(FocusEvent e) {
            ((JTextField)e.getSource()).selectAll();
        }

        public void focusLost(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class ParameterDocumentListener
    implements DocumentListener {
        ParameterDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.paramsDocumentChanged(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.paramsDocumentChanged(e);
        }

        private void paramsDocumentChanged(DocumentEvent e) {
            int index;
            boolean boxValid = true;
            if (PostponedConnectionAddBox.this.serverPortTextField.getText().length() == 0) {
                boxValid = false;
            }
            if (boxValid) {
                index = 0;
                while (index < PostponedConnectionAddBox.this.ipAddressTextField.length) {
                    if (PostponedConnectionAddBox.this.ipAddressTextField[index].getText().trim().length() == 0) {
                        boxValid = false;
                        break;
                    }
                    ++index;
                }
            }
            if (boxValid) {
                boxValid = false;
                index = 0;
                while (index < PostponedConnectionAddBox.this.ipAddressTextField.length) {
                    if (!PostponedConnectionAddBox.this.ipAddressTextField[index].getText().trim().equals("0")) {
                        boxValid = true;
                        break;
                    }
                    ++index;
                }
            }
            if (boxValid) {
                try {
                    PostponedConnectionAddBox.this.ipAddress = PostponedConnectionAddBox.this.buildCompleteIpAddress(PostponedConnectionAddBox.this.ipAddressTextField);
                    PostponedConnectionAddBox.this.alias = PostponedConnectionAddBox.this.aliasTextField.getText().trim();
                    PostponedConnectionAddBox.this.serverPort = PostponedConnectionAddBox.this.serverPortTextField.getText().trim();
                }
                catch (Exception ex) {
                    ErrorLog.put(ex, "ConnectionAddBox: paramsDocumentChanged() > field retrieval");
                }
                boxValid = !PostponedConnectionAddBox.this.ipAddress.equals(PostponedConnectionAddBox.this.ipAddressWork) || !PostponedConnectionAddBox.this.alias.equals(PostponedConnectionAddBox.this.aliasWork) || !PostponedConnectionAddBox.this.serverPort.equals(PostponedConnectionAddBox.this.serverPortWork);
            }
            if (PostponedConnectionAddBox.this.okButton.isEnabled() != boxValid) {
                PostponedConnectionAddBox.this.okButton.setEnabled(boxValid);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            this.paramsDocumentChanged(e);
        }
    }
}

