/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PopUpBox
extends KDialog
implements GlobalConstants {
    private EventDatabase eventDatabase;
    private JButton okButton;

    public PopUpBox(DatabaseManager databaseManager, EventDatabase eventDatabase, String title) {
        this.beginDialogInit(databaseManager, title, false);
        this.eventDatabase = eventDatabase;
        this.getContentPane().add((Component)this.buildPopUpMainPanel(), "Center");
        eventDatabase.setPopBoxState(true);
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(79);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopUpBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildPopUpLabelPanel() {
        JPanel paramsPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        paramsPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        Utility.addComponent(new JLabel("SAM (SiI Array Manager) detected a new event."), paramsPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Dimension dim = paramsPanel.getPreferredSize();
        dim.height *= 2;
        paramsPanel.setPreferredSize(dim);
        paramsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel compoundPanel = new JPanel();
        compoundPanel.add(paramsPanel);
        return compoundPanel;
    }

    protected JPanel buildPopUpMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.buildPopUpLabelPanel());
        mainPanel.add(this.buildButtonPanel());
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 8, 12, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "")));
        return mainPanel;
    }

    protected void closeDialog() {
        System.out.println("PoUpBox: closeDialog() entered");
        this.eventDatabase.setPopBoxState(false);
        this.dispose();
    }

    public void closePopUpBox() {
        this.closeDialog();
    }
}

