/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class ModifyTaskBox
extends KDialog
implements GlobalConstants {
    private JButton cancelButton;
    private String[] configurationStrings = new String[]{"Contiguous", "Striped", "Mirrored", "Mirrored Striped", "Parity RAID"};
    private JButton okButton;
    private String priority;
    private JComboBox priorityComboBox;
    private String[] priorityStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private TaskDescriptor taskDescriptor;

    public ModifyTaskBox(DatabaseManager databaseManager, String title, TaskDescriptor taskDescriptor) {
        this.beginDialogInit(databaseManager, title, true);
        this.taskDescriptor = taskDescriptor;
        this.initializeComponents();
        this.getContentPane().add((Component)this.buildPriorityPanel(), "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        Insets insets = this.cancelButton.getMargin();
        insets.left = 6;
        insets.right = 6;
        this.okButton.setMargin(insets);
        this.cancelButton.setMargin(insets);
        Dimension dimension = this.cancelButton.getPreferredSize();
        this.okButton.setPreferredSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.okButton.addActionListener(new OkButtonActionListener());
        this.cancelButton.addActionListener(new CancelButtonActionListener());
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        }
        buttonPanel.add(this.cancelButton);
        this.okButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(7, 12, 12, 14));
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 6, 6, 7));
        }
        return buttonPanel;
    }

    protected JPanel buildPriorityPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        JComboBox<String> configurationComboBox = new JComboBox<String>(this.configurationStrings);
        Utility.addComponent(new JLabel("Dynamic Priority: "), panel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.priorityComboBox, panel, layout, constraints, 1, 0, 0, 9, 4, 8, 1.0);
        this.priorityComboBox.setPreferredSize(configurationComboBox.getPreferredSize());
        TitledBorder titled = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Task Parameters");
        titled.setTitlePosition(0);
        panel.setBorder(new CompoundBorder(titled, BorderFactory.createEmptyBorder(0, 6, 8, 8)));
        JPanel returnPanel = new JPanel();
        returnPanel.add(panel);
        returnPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return returnPanel;
    }

    private void closeBox() {
        this.dispose();
    }

    protected void closeDialog() {
        System.out.println("closeDialog");
        this.dispose();
    }

    private void initializeComponents() {
        int taskIntPriority = 0;
        String priority = "1";
        if (this.taskDescriptor.priority.equals("N/A")) {
            this.taskDescriptor.priority = "0";
        }
        try {
            taskIntPriority = Integer.parseInt(this.taskDescriptor.priority);
            if (taskIntPriority == 0) {
                ++taskIntPriority;
            }
            priority = Integer.toString(taskIntPriority);
        }
        catch (Exception e) {
            System.err.println("ModifyTaskBox: initializeComponents: string-to-int conversion\nDetails: " + e);
            priority = "1";
        }
        int index = 0;
        while (index < this.priorityStrings.length) {
            if (priority.equals(this.priorityStrings[index])) break;
            ++index;
        }
        this.priorityComboBox = new JComboBox<String>(this.priorityStrings);
        this.priorityComboBox.setSelectedIndex(index);
        PriorityFieldActionListener priorityFieldActionListener = new PriorityFieldActionListener();
        this.priorityComboBox.addActionListener(priorityFieldActionListener);
    }

    private void priorityComponentChanged() {
        this.priority = (String)this.priorityComboBox.getSelectedItem();
        boolean boxValid = !this.priority.equals(this.taskDescriptor.priority);
        this.okButton.setEnabled(boxValid);
    }

    private void sendPrioritizeTaskRequest() {
        String request = "<si:Request><si:Type>PrioritizeTask</si:Type><si:Task>" + this.taskDescriptor.task + "</si:Task>" + "<si:Priority>" + this.priority + "</si:Priority>" + "</si:Request>";
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                ModifyTaskBox.this.databaseManager.storageManagementUtility.clearWait();
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(ModifyTaskBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Modify Task Error");
                }
            }
        };
        this.databaseManager.storageManagementUtility.setWait();
        this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ModifyTaskBox.this.closeBox();
        }
    }

    class OkButtonActionListener
    implements ActionListener {
        OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ModifyTaskBox.this.sendPrioritizeTaskRequest();
            ModifyTaskBox.this.closeBox();
        }
    }

    class PriorityFieldActionListener
    implements ActionListener {
        PriorityFieldActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ModifyTaskBox.this.priorityComponentChanged();
        }
    }
}

