/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class MemberTable
extends JPanel
implements SortInterface,
GlobalConstants {
    DatabaseManager databaseManager;
    Object[] defaultColumns;
    JLabel deviceCountLabel;
    DeviceDatabase deviceDatabase;
    String memberFields;
    ArrayList memberList;
    KTable memberTable;
    MemberTableModel memberTableModel;
    AbstractMessageHandler messageHandler;
    Preferences preferences;
    JScrollPane scrollPane;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;
    String[] statuses;

    public MemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] statuses, int rowCount) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.statuses = statuses;
        this.deviceDatabase = databaseManager.deviceDatabase;
        System.out.println("member fields = \"" + memberFields + "\"");
        this.loadPreferences();
        this.buildTable(rowCount);
        this.savePreferences();
    }

    private void buildTable(int rowCount) {
        this.memberList = this.getMemberList();
        this.memberTableModel = new MemberTableModel();
        this.memberTable = new KTable(this.memberTableModel, rowCount);
        this.memberTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = MemberTable.this.memberTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = MemberTable.this.memberTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = MemberTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = MemberTable.this.memberTableModel.getColumnName(column);
                    int count = 0;
                    while (count < DeviceDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        MemberTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.memberTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.memberTable);
        this.scrollPane.getViewport().setBackground(this.memberTable.getBackground());
    }

    protected void closeFrame() {
    }

    public void dispose() {
    }

    public synchronized ArrayList getMemberList() {
        ArrayList<Object> newMemberList = new ArrayList<Object>();
        ArrayList<MemberDescriptor> sortedList = new ArrayList<MemberDescriptor>();
        ArrayList raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(this.statuses);
        int raidGroup = 0;
        while (raidGroup < raidGroupList.size()) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            int member = 0;
            while (member < raidGroupDescriptor.memberArray.size()) {
                MemberDescriptor memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member);
                newMemberList.add(memberDescriptor.clone());
                ++member;
            }
            ++raidGroup;
        }
        int sourceIndex = 0;
        while (sourceIndex < newMemberList.size()) {
            MemberDescriptor sourceMember = (MemberDescriptor)newMemberList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                MemberDescriptor destMember = (MemberDescriptor)sortedList.get(destIndex);
                int result = sourceMember.compare(destMember, this.sortDescriptors[0]);
                if (result >= 1 || result == 0 && ((result = sourceMember.compare(destMember, this.sortDescriptors[1])) >= 1 || result == 0 && sourceMember.compare(destMember, this.sortDescriptors[2]) >= 1)) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceMember);
            ++sourceIndex;
        }
        return sortedList;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public ArrayList getSelectedMembers() {
        ArrayList<MemberDescriptor> selectedList = new ArrayList<MemberDescriptor>();
        int[] selectedRows = this.memberTable.getSelectedRows();
        System.out.println("selected row count " + selectedRows.length);
        int count = 0;
        while (count < selectedRows.length) {
            MemberDescriptor memberDescriptor = (MemberDescriptor)this.memberList.get(selectedRows[count]);
            selectedList.add(memberDescriptor);
            ++count;
        }
        return selectedList;
    }

    public KTable getTable() {
        return this.memberTable;
    }

    public MemberTableModel getTableModel() {
        return this.memberTableModel;
    }

    private void loadPreferences() {
        String[] fieldNames = MemberDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.memberFields != null ? this.memberFields : this.preferences.get("Table Columns", "Member,Status,StartingPlbn");
            System.out.println("columns = \"" + columns + "\"");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                System.out.println("columnName = " + columnName);
                int index = 0;
                while (index < fieldNames.length) {
                    if (fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            System.out.println("done with column name extraction");
            if (fieldList.size() > 0) break;
            if (this.memberFields != null) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Device,Status,Capacity");
        }
        System.out.println("fieldList size = " + fieldList.size());
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        String[] defaultFields = new String[]{"RAID Group", "Member", "Device"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.memberFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            int index2 = 0;
            while (index2 < fieldNames.length) {
                if (fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        if (this.memberFields != null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.memberTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 3) {
            this.preferences.put("Table Sort Field" + index2, MemberDescriptor.fieldNames[this.sortDescriptors[index2].field]);
            this.preferences.put("Table Sort Direction" + index2, this.sortDescriptors[index2].direction == 1 ? "Ascending" : "Descending");
            ++index2;
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.memberTable.setSelectionMode(selectionMode);
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.memberList = this.getMemberList();
        this.memberTableModel.updateDisplay();
        this.savePreferences();
    }

    class MemberTableModel
    extends KTableModel {
        public MemberTableModel() {
            this.setColumns(MemberDescriptor.fieldNames, MemberDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return MemberTable.this.defaultColumns;
        }

        public int getRowCount() {
            return MemberTable.this.memberList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= MemberTable.this.memberList.size()) {
                value = "";
            } else {
                MemberDescriptor segment = (MemberDescriptor)MemberTable.this.memberList.get(row);
                value = segment.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (MemberTable.this.memberList.size() > 0) {
                this.fireTableRowsInserted(0, MemberTable.this.memberList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            MemberTable.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            MemberTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

