/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.JDialog;

public abstract class KDialog
extends JDialog
implements GlobalConstants {
    protected final String FRAME_HEIGHT = "Frame Height";
    protected final String FRAME_OPEN = "Frame Open";
    protected final String FRAME_WIDTH = "Frame Width";
    protected final String FRAME_X = "Frame X";
    protected final String FRAME_Y = "Frame Y";
    protected CommManager commManager;
    protected DatabaseManager databaseManager;
    protected Preferences preferences;
    protected StorageManagementUtility storageManagementUtility;
    protected Preferences systemPreferences;

    protected void beginDialogInit(DatabaseManager databaseManager, String title, boolean modal) {
        this.databaseManager = databaseManager;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        this.setTitle(title);
        this.setModal(modal);
        this.systemPreferences = Preferences.userRoot().node("/Sam/System");
        this.preferences = Preferences.userRoot().node("/Sam/" + title.replace('/', '-'));
    }

    protected abstract void closeDialog();

    protected void completeDialogInit(boolean autoCenter) {
        this.pack();
        Rectangle rectangle = Utility.getCenteredBounds(this);
        if (!autoCenter && this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                KDialog.this.closeDialog();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    protected void saveFrameBounds() {
        Rectangle rectangle = this.getBounds();
        this.preferences.putInt("Frame Width", rectangle.width);
        this.preferences.putInt("Frame Height", rectangle.height);
        this.preferences.putInt("Frame X", rectangle.x);
        this.preferences.putInt("Frame Y", rectangle.y);
    }
}

