/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class HostConnectionTreePane
extends JScrollPane
implements GlobalConstants,
TreeSelectionListener {
    private JMenuItem closeConnectionMenuItem;
    private ImageIcon controllerGreenIcon;
    private ImageIcon controllerYellowIcon;
    private DatabaseManager databaseManager;
    private ImageIcon guiIcon;
    private ArrayList hostConnectionList;
    private HostConnectionManager hostConnectionManager;
    private JPopupMenu hostConnectionPopupMenu;
    private ImageIcon localConnectionGreenIcon;
    private ImageIcon localConnectionYellowIcon;
    private JMenuItem openConnectionMenuItem;
    private NodeInfo previouslySelectedControllerNode;
    private NodeInfo previouslySelectedHostNode;
    private ImageIcon remoteConnectionGreenIcon;
    private ImageIcon remoteConnectionYellowIcon;
    private DefaultMutableTreeNode rootNode;
    private NodeInfo selectedControllerNode;
    private HostConnectionDescriptor selectedHostConnectionDescriptor;
    private NodeInfo selectedHostNode;
    private StorageManagementUtility storageManagementUtility;
    private JTree tree;
    private DefaultTreeModel treeModel;

    public HostConnectionTreePane(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        this.hostConnectionManager = databaseManager.hostConnectionManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.guiIcon = imageIconLoader.loadImageIcon("samIcon.gif");
        this.localConnectionGreenIcon = imageIconLoader.loadImageIcon("localSystem.gif");
        this.localConnectionYellowIcon = imageIconLoader.loadImageIcon("deviceYellow.gif");
        this.remoteConnectionGreenIcon = imageIconLoader.loadImageIcon("fibreGreen.gif");
        this.remoteConnectionYellowIcon = imageIconLoader.loadImageIcon("fibreYellow.gif");
        this.controllerGreenIcon = imageIconLoader.loadImageIcon("controllerGreen.gif");
        this.controllerYellowIcon = imageIconLoader.loadImageIcon("controllerYellow.gif");
        this.selectedHostNode = new NodeInfo();
        this.selectedControllerNode = new NodeInfo();
        this.buildTree();
        AbstractListener hostConnectionDatabaseChangeHandler = new AbstractListener(){

            public void processChange() {
                HostConnectionTreePane.this.updateHostConnectionNodes();
            }
        };
        this.hostConnectionManager.addUpdateListener(hostConnectionDatabaseChangeHandler);
        hostConnectionDatabaseChangeHandler.processChange();
    }

    private void buildTree() {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.title = "SAM";
        nodeInfo.nodeType = nodeInfo.ROOT_TYPE;
        nodeInfo.icon = this.guiIcon;
        this.rootNode = new DefaultMutableTreeNode(nodeInfo);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        Nexus nexus = this.hostConnectionManager.getNexus();
        int hostConnection = 0;
        while (hostConnection < this.hostConnectionManager.getHostConnectionCount()) {
            HostConnectionDescriptor hostConnectionDescriptor = this.hostConnectionManager.getHostConnection(hostConnection);
            nodeInfo = new NodeInfo();
            nodeInfo.nodeType = nodeInfo.HOST_TYPE;
            nodeInfo.controllers = hostConnectionDescriptor.controllers;
            nodeInfo.controller = hostConnectionDescriptor.controller;
            nodeInfo.type = hostConnectionDescriptor.type;
            nodeInfo.ipAddress = hostConnectionDescriptor.ipAddress;
            nodeInfo.hostConnectionDescriptor = hostConnectionDescriptor;
            if (hostConnectionDescriptor.type.equals("Local")) {
                nodeInfo.title = "Local Host";
                nodeInfo.icon = this.localConnectionYellowIcon;
                if (nexus.local) {
                    nodeInfo.icon = this.localConnectionGreenIcon;
                    this.previouslySelectedHostNode = nodeInfo;
                }
            } else if (hostConnectionDescriptor.type.equals("Remote")) {
                nodeInfo.title = nodeInfo.ipAddress;
                if (!hostConnectionDescriptor.alias.equals("")) {
                    nodeInfo.title = hostConnectionDescriptor.alias;
                }
                nodeInfo.icon = this.remoteConnectionYellowIcon;
                if (hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress) && !nexus.local) {
                    nodeInfo.icon = this.remoteConnectionGreenIcon;
                    this.previouslySelectedHostNode = nodeInfo;
                }
            }
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo);
            if (hostConnectionDescriptor.controllers != -1) {
                int controller = 0;
                while (controller < hostConnectionDescriptor.controllers) {
                    NodeInfo newNodeInfo = new NodeInfo();
                    newNodeInfo.title = "Controller " + Integer.toString(controller);
                    newNodeInfo.nodeType = nodeInfo.CNTR_TYPE;
                    newNodeInfo.controllers = nodeInfo.controllers;
                    newNodeInfo.controller = controller;
                    newNodeInfo.type = nodeInfo.type;
                    newNodeInfo.ipAddress = nodeInfo.ipAddress;
                    newNodeInfo.hostConnectionDescriptor = hostConnectionDescriptor;
                    newNodeInfo.icon = this.controllerYellowIcon;
                    if (hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress) && controller == nexus.controller) {
                        newNodeInfo.icon = this.controllerGreenIcon;
                        this.previouslySelectedControllerNode = newNodeInfo;
                    }
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newNodeInfo);
                    node.add(newNode);
                    ++controller;
                }
            }
            this.treeModel.insertNodeInto(node, this.rootNode, this.rootNode.getChildCount());
            TreePath treePath = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(treePath);
            if (hostConnectionDescriptor.type.equals(nexus.local ? "Local" : "Remote") && hostConnectionDescriptor.ipAddress.equals(nexus.ipAddress)) {
                this.tree.expandPath(treePath);
            }
            ++hostConnection;
        }
        this.hostConnectionList = this.hostConnectionManager.getHostConnectionList();
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(new MouseTreeListener());
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setRowHeight(18);
        Dimension d = this.tree.getPreferredSize();
        d.width = (int)((double)d.width * 1.25);
        this.tree.setPreferredSize(d);
        this.setViewportView(this.tree);
    }

    private HostConnectionDescriptor findHostConnectionFromNodeInfo(NodeInfo nodeInfo) {
        ArrayList hostConnections = this.hostConnectionManager.getHostConnectionList();
        int index = 0;
        while (index < hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)hostConnections.get(index);
            if (hostConnection.type.equals(nodeInfo.type) && hostConnection.ipAddress.equals(nodeInfo.ipAddress)) {
                return hostConnection;
            }
            ++index;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void updateHostConnectionNodes() {
        newConnectionList = this.hostConnectionManager.getHostConnectionList();
        removeList = new ArrayList<HostConnectionDescriptor>();
        index = 0;
        while (index < this.hostConnectionList.size()) {
            hostConnectionDescriptor = (HostConnectionDescriptor)this.hostConnectionList.get(index);
            found = false;
            newIndex = 0;
            while (newIndex < newConnectionList.size()) {
                newHostConnectionDescriptor = (HostConnectionDescriptor)newConnectionList.get(newIndex);
                if (hostConnectionDescriptor.alias.equals(newHostConnectionDescriptor.alias) && hostConnectionDescriptor.type.equals(newHostConnectionDescriptor.type) && hostConnectionDescriptor.ipAddress.equals(newHostConnectionDescriptor.ipAddress)) {
                    found = true;
                    break;
                }
                ++newIndex;
            }
            if (!found) {
                removeList.add(hostConnectionDescriptor);
            }
            ++index;
        }
        addList = new ArrayList<HostConnectionDescriptor>();
        newIndex = 0;
        while (newIndex < newConnectionList.size()) {
            newHostConnectionDescriptor = (HostConnectionDescriptor)newConnectionList.get(newIndex);
            found = false;
            index = 0;
            while (index < this.hostConnectionList.size()) {
                hostConnectionDescriptor = (HostConnectionDescriptor)this.hostConnectionList.get(index);
                if (hostConnectionDescriptor.alias.equals(newHostConnectionDescriptor.alias) && hostConnectionDescriptor.type.equals(newHostConnectionDescriptor.type) && hostConnectionDescriptor.ipAddress.equals(newHostConnectionDescriptor.ipAddress)) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) {
                addList.add(newHostConnectionDescriptor);
            }
            ++newIndex;
        }
        count = 0;
        while (count < removeList.size()) {
            hostConnectionDescriptor = (HostConnectionDescriptor)removeList.get(count);
            childCount = hostConnectionDescriptor.controllers;
            leaf = this.rootNode.getFirstLeaf();
            while (leaf != null && leaf != this.rootNode && childCount > 0) {
                nodeInfo = (NodeInfo)leaf.getUserObject();
                if (nodeInfo.type.equals(hostConnectionDescriptor.type) && nodeInfo.ipAddress.equals(hostConnectionDescriptor.ipAddress)) {
                    treeNode = leaf.getPreviousNode();
                    parentInfo = treeNode.getUserObject();
                    parentNodeInfo = (NodeInfo)parentInfo;
                    while (parentNodeInfo.nodeType != parentNodeInfo.HOST_TYPE) {
                        treeNode = treeNode.getPreviousNode();
                        parentInfo = treeNode.getUserObject();
                        parentNodeInfo = (NodeInfo)parentInfo;
                    }
                    treeNode.removeAllChildren();
                    break;
                }
                leaf = leaf.getNextLeaf();
            }
            leaf = this.rootNode.getFirstLeaf();
            if (true) ** GOTO lbl71
            do {
                nodeInfo = (NodeInfo)leaf.getUserObject();
                if (nodeInfo.type.equals(hostConnectionDescriptor.type) && nodeInfo.ipAddress.equals(hostConnectionDescriptor.ipAddress)) {
                    this.treeModel.removeNodeFromParent(leaf);
                    break;
                }
                leaf = leaf.getNextLeaf();
lbl71:
                // 2 sources

                if (leaf == null) break;
            } while (leaf != this.rootNode);
            ++count;
        }
        count = 0;
        while (count < addList.size()) {
            nodeInfo = new NodeInfo();
            hostConnectionDescriptor = (HostConnectionDescriptor)addList.get(count);
            nodeInfo.nodeType = nodeInfo.HOST_TYPE;
            nodeInfo.controllers = hostConnectionDescriptor.controllers;
            nodeInfo.controller = hostConnectionDescriptor.controller;
            nodeInfo.type = hostConnectionDescriptor.type;
            nodeInfo.ipAddress = hostConnectionDescriptor.ipAddress;
            nodeInfo.hostConnectionDescriptor = hostConnectionDescriptor;
            if (hostConnectionDescriptor.type.equals("Local")) {
                nodeInfo.title = "Local Host";
                nodeInfo.icon = this.localConnectionYellowIcon;
            } else if (hostConnectionDescriptor.type.equals("Remote")) {
                nodeInfo.title = nodeInfo.ipAddress;
                if (!hostConnectionDescriptor.alias.equals("")) {
                    nodeInfo.title = hostConnectionDescriptor.alias;
                }
                nodeInfo.icon = this.remoteConnectionYellowIcon;
            }
            newNode = new DefaultMutableTreeNode(nodeInfo);
            leaf = this.rootNode.getFirstLeaf();
            if (leaf == this.rootNode) {
                this.treeModel.insertNodeInto(newNode, this.rootNode, 0);
                this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
            } else {
                newNodeInfo = null;
                index = 0;
                while (leaf != null) {
                    newNodeInfo = (NodeInfo)leaf.getUserObject();
                    if (newNodeInfo.type.equals("Local")) {
                        this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                        this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                        newNode = null;
                        break;
                    }
                    if (newNodeInfo.ipAddress.compareToIgnoreCase(hostConnectionDescriptor.ipAddress) >= 1) {
                        this.treeModel.insertNodeInto(newNode, this.rootNode, index);
                        this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                        newNode = null;
                        break;
                    }
                    if (++index >= this.rootNode.getChildCount()) break;
                    leaf = leaf.getNextLeaf();
                }
                if (newNode != null) {
                    this.treeModel.insertNodeInto(newNode, this.rootNode, this.rootNode.getChildCount());
                    this.tree.scrollPathToVisible(new TreePath(newNode.getPath()));
                }
            }
            ++count;
        }
        this.hostConnectionList = newConnectionList;
        this.tree.setRowHeight(18);
        d = this.tree.getPreferredSize();
        d.width = (int)((double)d.width * 1.25);
        this.tree.setPreferredSize(d);
        this.tree.repaint();
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object treeInfo = node.getUserObject();
        NodeInfo nodeInfo = (NodeInfo)treeInfo;
        if (nodeInfo.nodeType == nodeInfo.HOST_TYPE) {
            if (!nodeInfo.same(this.selectedHostNode)) {
                int status = this.hostConnectionManager.openNewHostConnection(nodeInfo.hostConnectionDescriptor, nodeInfo.controller);
                if (status == 0) {
                    if (nodeInfo.controllers == -1) {
                        int controllers = nodeInfo.hostConnectionDescriptor.controllers;
                        int controller = 0;
                        while (controller < controllers) {
                            NodeInfo newNodeInfo = new NodeInfo();
                            newNodeInfo.title = "Controller " + Integer.toString(controller);
                            newNodeInfo.nodeType = nodeInfo.CNTR_TYPE;
                            newNodeInfo.controllers = nodeInfo.controllers;
                            newNodeInfo.controller = controller;
                            newNodeInfo.type = nodeInfo.type;
                            newNodeInfo.ipAddress = nodeInfo.ipAddress;
                            newNodeInfo.hostConnectionDescriptor = nodeInfo.hostConnectionDescriptor;
                            newNodeInfo.icon = this.controllerYellowIcon;
                            if (controller == 0) {
                                newNodeInfo.icon = this.controllerGreenIcon;
                            }
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newNodeInfo);
                            node.add(newNode);
                            nodeInfo.controllers = controllers;
                            ++controller;
                        }
                        this.updateHostConnectionNodes();
                    }
                    this.previouslySelectedControllerNode.icon = this.controllerYellowIcon;
                    this.previouslySelectedHostNode.icon = this.previouslySelectedHostNode.type.equals("Local") ? this.localConnectionYellowIcon : this.remoteConnectionYellowIcon;
                    nodeInfo.icon = nodeInfo.type.equals("Local") ? this.localConnectionGreenIcon : this.remoteConnectionGreenIcon;
                    nodeInfo.cloneTo(this.selectedHostNode);
                    this.previouslySelectedHostNode = nodeInfo;
                    if (node.getChildCount() > 0) {
                        DefaultMutableTreeNode firstChild = node.getFirstLeaf();
                        Object childInfo = firstChild.getUserObject();
                        nodeInfo = (NodeInfo)childInfo;
                        nodeInfo.icon = this.controllerGreenIcon;
                        nodeInfo.cloneTo(this.selectedControllerNode);
                        this.previouslySelectedControllerNode = nodeInfo;
                    }
                    TreePath treePath = new TreePath(node.getPath());
                    this.tree.scrollPathToVisible(treePath);
                    this.tree.expandPath(treePath);
                    this.updateHostConnectionNodes();
                } else {
                    this.hostConnectionManager.reconnectPreviousConnection();
                }
            }
        } else if (nodeInfo.nodeType == nodeInfo.CNTR_TYPE && !nodeInfo.same(this.selectedControllerNode)) {
            int status = this.hostConnectionManager.openNewHostConnection(nodeInfo.hostConnectionDescriptor, nodeInfo.controller);
            if (status == 0) {
                DefaultMutableTreeNode treeNode = node.getPreviousNode();
                Object parentInfo = treeNode.getUserObject();
                NodeInfo parentNodeInfo = (NodeInfo)parentInfo;
                while (parentNodeInfo.nodeType != parentNodeInfo.HOST_TYPE) {
                    treeNode = treeNode.getPreviousNode();
                    parentInfo = treeNode.getUserObject();
                    parentNodeInfo = (NodeInfo)parentInfo;
                }
                if (!parentNodeInfo.same(this.selectedHostNode)) {
                    this.previouslySelectedHostNode.icon = this.previouslySelectedHostNode.type.equals("Local") ? this.localConnectionYellowIcon : this.remoteConnectionYellowIcon;
                    parentNodeInfo.icon = parentNodeInfo.type.equals("Local") ? this.localConnectionGreenIcon : this.remoteConnectionGreenIcon;
                    parentNodeInfo.cloneTo(this.selectedHostNode);
                    this.previouslySelectedHostNode = parentNodeInfo;
                }
                this.previouslySelectedControllerNode.icon = this.controllerYellowIcon;
                nodeInfo.icon = this.controllerGreenIcon;
                nodeInfo.cloneTo(this.selectedControllerNode);
                this.previouslySelectedControllerNode = nodeInfo;
                this.updateHostConnectionNodes();
            } else {
                this.hostConnectionManager.reconnectPreviousConnection();
            }
        }
    }

    class NodeInfo {
        final int CNTR_TYPE = 0;
        final int HOST_TYPE = 1;
        final int ROOT_TYPE = 2;
        int controller = -1;
        int controllers = -1;
        HostConnectionDescriptor hostConnectionDescriptor;
        ImageIcon icon;
        String ipAddress = "0.0.0.0";
        int nodeType = -1;
        String title = "?";
        String type = "?";

        public synchronized Object clone() {
            NodeInfo newNode = new NodeInfo();
            newNode.nodeType = this.nodeType;
            newNode.controllers = this.controllers;
            newNode.controller = this.controller;
            newNode.type = this.type;
            newNode.ipAddress = this.ipAddress;
            newNode.title = this.title;
            newNode.hostConnectionDescriptor = this.hostConnectionDescriptor;
            newNode.icon = this.icon;
            return newNode;
        }

        public synchronized void cloneTo(NodeInfo node) {
            node.nodeType = this.nodeType;
            node.controllers = this.controllers;
            node.controller = this.controller;
            node.type = this.type;
            node.ipAddress = this.ipAddress;
            node.title = this.title;
            node.hostConnectionDescriptor = this.hostConnectionDescriptor;
            node.icon = this.icon;
        }

        public synchronized boolean same(NodeInfo node) {
            if (node.nodeType != this.nodeType) {
                return false;
            }
            if (node.controllers != this.controllers) {
                return false;
            }
            if (node.controller != this.controller) {
                return false;
            }
            if (!node.type.equals(this.type)) {
                return false;
            }
            if (!node.ipAddress.equals(this.ipAddress)) {
                return false;
            }
            if (!node.title.equals(this.title)) {
                return false;
            }
            return node.hostConnectionDescriptor == this.hostConnectionDescriptor;
        }

        public String toString() {
            return this.title;
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode newNode = (DefaultMutableTreeNode)value;
            Object userObject = newNode.getUserObject();
            NodeInfo nodeInfo = (NodeInfo)userObject;
            if (nodeInfo.icon != null) {
                this.setIcon(nodeInfo.icon);
            }
            return this;
        }
    }

    private class MouseTreeListener
    extends MouseAdapter {
        private MouseTreeListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = HostConnectionTreePane.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1 || (e.getModifiers() & 4) == 0) {
                return;
            }
            HostConnectionTreePane.this.tree.setSelectionRow(selRow);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)HostConnectionTreePane.this.tree.getLastSelectedPathComponent();
            NodeInfo nodeInfo = (NodeInfo)node.getUserObject();
        }
    }
}

