/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class HostConnectionManager
implements GlobalConstants {
    public CommManager commManager;
    private int currentConnectionIndex;
    private final String hostConnectionManager = "HostConnectionManager Exception\n";
    private ArrayList hostConnections;
    private boolean localHostConnection = false;
    private Nexus nexus;
    protected ArrayList notifyList;
    private int numberOfConnections;
    private final String retrieval = " retrieval from preferences";
    public StorageManagementUtility storageManagementUtility;

    public HostConnectionManager(StorageManagementUtility storageManagementUtility) {
        boolean verbose = false;
        this.storageManagementUtility = storageManagementUtility;
        this.nexus = new Nexus();
        this.notifyList = new ArrayList();
        this.commManager = new CommManager(storageManagementUtility, this, verbose);
        this.hostConnections = new ArrayList();
        this.currentConnectionIndex = -1;
        int status = this.commManager.openLocalConnection(0);
        if (status == 0) {
            this.localHostConnection = true;
            HostConnectionDescriptor hostConnection = new HostConnectionDescriptor();
            hostConnection.setNumberOfControllers(this.commManager.getControllerCount());
            hostConnection.alias = "Local Host";
            hostConnection.type = "Local";
            hostConnection.controller = 0;
            this.hostConnections.add(hostConnection);
            this.commManager.closeConnection();
        } else {
            System.out.println("HostConnectionManager: No controllers found in the Local host");
            JOptionPane.showMessageDialog(null, "No SiI controller was found in the system. Press the button to exit the application.", "Controller Not Found Error", 0);
            System.exit(0);
        }
        ArrayList retrievedConnections = this.retrieveHostConnectionPreferences();
        int numberOfRetrievedConnections = retrievedConnections.size();
        boolean preferredFound = false;
        int preferredIndex = 0;
        int index = 0;
        while (index < numberOfRetrievedConnections) {
            HostConnectionDescriptor retrievedConnection = (HostConnectionDescriptor)retrievedConnections.get(index);
            if (retrievedConnection.type.equals("Local")) {
                if (this.localHostConnection) {
                    HostConnectionDescriptor localConnection = (HostConnectionDescriptor)this.hostConnections.get(0);
                    localConnection.preferred = retrievedConnection.preferred;
                    if (retrievedConnection.preferred) {
                        preferredFound = true;
                        preferredIndex = index;
                    }
                }
            } else {
                if (retrievedConnection.preferred) {
                    preferredFound = true;
                    preferredIndex = this.hostConnections.size();
                }
                this.hostConnections.add(retrievedConnection);
            }
            ++index;
        }
        if (this.hostConnections.size() > 0) {
            if (preferredFound) {
                status = this.openNewHostConnection((HostConnectionDescriptor)retrievedConnections.get(preferredIndex), 0);
                if (status != 0 && this.localHostConnection) {
                    this.tryLocalConnection();
                }
            } else if (this.localHostConnection) {
                this.tryLocalConnection();
            }
        } else if (this.localHostConnection) {
            this.tryLocalConnection();
        } else {
            new ImmediateConnectionTableBox(storageManagementUtility, this);
        }
        this.numberOfConnections = this.hostConnections.size();
        if (this.numberOfConnections > 0) {
            if (!(this.currentConnectionIndex != -1 || preferredFound && preferredIndex == 0 || (status = this.openNewHostConnection((HostConnectionDescriptor)this.hostConnections.get(0), 0)) == 0)) {
                new ImmediateConnectionTableBox(storageManagementUtility, this);
                if (this.hostConnections.size() > 0 && this.currentConnectionIndex == -1) {
                    int tablePreferredIndex = this.getPreferredConnectionIndex();
                    if (tablePreferredIndex == -1) {
                        ++tablePreferredIndex;
                    }
                    if (!(preferredFound && preferredIndex == tablePreferredIndex || (status = this.openNewHostConnection((HostConnectionDescriptor)this.hostConnections.get(tablePreferredIndex), 0)) == 0)) {
                        System.exit(0);
                    }
                }
            }
            HostConnectionDescriptor currentConnection = (HostConnectionDescriptor)this.hostConnections.get(this.currentConnectionIndex);
            this.setNexusToConnection(currentConnection.type.equals("Local"), currentConnection.ipAddress, currentConnection.controller);
        } else {
            System.exit(0);
        }
    }

    public void addHostConnection(HostConnectionDescriptor connection, boolean notify) {
        this.hostConnections.add(connection);
        if (notify) {
            this.notifyListeners();
        }
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public int findHostConnectionIndex(HostConnectionDescriptor connection) {
        int index = 0;
        while (index < this.hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (hostConnection.same(connection)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public CommManager getCommManager() {
        return this.commManager;
    }

    public int getControllerCount() {
        return this.commManager.getControllerCount();
    }

    public int getControllerCount(String ipAddress, int serverPort) {
        int status = this.commManager.openRemoteConnection(ipAddress, 0, serverPort);
        int controllerCount = -1;
        if (status == 0) {
            controllerCount = this.commManager.getControllerCount();
            this.commManager.closeConnection();
        }
        return controllerCount;
    }

    public HostConnectionDescriptor getCurrentHostConnection() {
        return this.getHostConnection(this.currentConnectionIndex);
    }

    public HostConnectionDescriptor getHostConnection(int connectionIndex) {
        return (HostConnectionDescriptor)this.hostConnections.get(connectionIndex);
    }

    public int getHostConnectionCount() {
        return this.hostConnections.size();
    }

    public ArrayList getHostConnectionList() {
        ArrayList<Object> returnHostConnectionList = new ArrayList<Object>();
        int connectionIndex = 0;
        while (connectionIndex < this.hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(connectionIndex);
            returnHostConnectionList.add(hostConnection.clone());
            ++connectionIndex;
        }
        return returnHostConnectionList;
    }

    public Nexus getNexus() {
        return (Nexus)this.nexus.clone();
    }

    public int getNexusController() {
        return this.nexus.getController();
    }

    public String getNexusIpAddress() {
        return this.nexus.getIpAddress();
    }

    public boolean getNexusLocal() {
        return this.nexus.getLocal();
    }

    private int getPreferredConnectionIndex() {
        if (this.hostConnections.size() == 0) {
            return -1;
        }
        int index = 0;
        while (index < this.hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (hostConnection.preferred) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    private boolean localConnectionExists() {
        int index = 0;
        while (index < this.hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (hostConnection.type.equals("Local")) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public void mergeHostConnections(ArrayList newHostConnections) {
        if (newHostConnections.size() == 0) {
            return;
        }
        if (this.hostConnections.size() == 0) {
            while (newHostConnections.size() > 0) {
                HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)newHostConnections.remove(0);
                this.hostConnections.add(hostConnection);
            }
            this.notifyListeners();
            return;
        }
        int srcIndex = 0;
        while (srcIndex < newHostConnections.size()) {
            HostConnectionDescriptor hostSrcConnection = (HostConnectionDescriptor)newHostConnections.get(srcIndex);
            boolean found = false;
            int hostConnectionsSize = this.hostConnections.size();
            int mstIndex = 0;
            while (mstIndex < hostConnectionsSize) {
                HostConnectionDescriptor hostMstConnection = (HostConnectionDescriptor)this.hostConnections.get(mstIndex);
                if (hostSrcConnection.same(hostMstConnection)) {
                    found = true;
                    break;
                }
                ++mstIndex;
            }
            if (!found) {
                this.addHostConnection((HostConnectionDescriptor)hostSrcConnection.clone(), false);
            }
            ++srcIndex;
        }
        int mstIndex = 0;
        while (mstIndex < this.hostConnections.size()) {
            HostConnectionDescriptor hostMstConnection = (HostConnectionDescriptor)this.hostConnections.get(mstIndex);
            boolean found = false;
            int srcIndex2 = 0;
            while (srcIndex2 < newHostConnections.size()) {
                HostConnectionDescriptor hostSrcConnection = (HostConnectionDescriptor)newHostConnections.get(srcIndex2);
                if (hostMstConnection.same(hostSrcConnection)) {
                    found = true;
                    break;
                }
                ++srcIndex2;
            }
            if (!found) {
                this.removeHostConnection(hostMstConnection, false);
                --mstIndex;
            }
            ++mstIndex;
        }
        this.notifyListeners();
    }

    public void notifyListeners() {
        int index = 0;
        while (index < this.notifyList.size()) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
            ++index;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int openNewHostConnection(HostConnectionDescriptor connection, int controller) {
        block10: {
            this.commManager.closeConnection();
            retStatus = 0;
            answer = 0;
            if (!connection.type.equals("Local")) ** GOTO lbl36
            this.storageManagementUtility.setCursor(new Cursor(3));
            retStatus = this.commManager.openLocalConnection(controller);
            this.storageManagementUtility.setCursor(new Cursor(0));
            if (retStatus != 2) break block10;
            System.out.println("HostConnectionManager: No controllers found on the Local link");
            JOptionPane.showMessageDialog(null, "Invalid Local Connection. No controllers were found in the system", "Invalid Local Connection Error", 0);
            break block10;
lbl-1000:
            // 1 sources

            {
                answer = 1;
                this.storageManagementUtility.setCursor(new Cursor(3));
                retStatus = this.commManager.openRemoteConnection(connection.ipAddress, controller, Integer.parseInt(connection.serverPort));
                this.storageManagementUtility.setCursor(new Cursor(0));
                if (retStatus == 1) {
                    lastError = this.commManager.getLastError();
                    index = lastError.indexOf("Connection timed out");
                    if (index != -1) {
                        lastError = "The connection timed out.";
                    } else {
                        index = lastError.indexOf("Connection refused");
                        if (index != -1) {
                            lastError = "The connection was refused.\nThe server agent could be inactive, or another connection could already be open.";
                        }
                    }
                    answer = JOptionPane.showConfirmDialog(null, "Attempt to open the " + connection.ipAddress + " connection failed. " + lastError + "\nDo you wish to retry the operation?", "Failed Open operation", 0);
                    continue;
                }
                if (retStatus != 2) continue;
                System.out.println("HostConnectionManager: No controllers found on the opened link");
                JOptionPane.showMessageDialog(null, "No controllers found on the " + connection.ipAddress + " connection", "Invalid Connection Error", 0);
lbl36:
                // 4 sources

                ** while (answer == 0)
            }
lbl37:
            // 1 sources

        }
        if (retStatus == 0) {
            connection.setNumberOfControllers(this.commManager.getControllerCount());
            index = this.findHostConnectionIndex(connection);
            if (index != -1) {
                this.currentConnectionIndex = index;
            }
            this.notifyListeners();
        }
        return retStatus;
    }

    private boolean preferredConnectionExists() {
        int index = 0;
        while (index < this.hostConnections.size()) {
            HostConnectionDescriptor hostConnection = (HostConnectionDescriptor)this.hostConnections.get(index);
            if (hostConnection.preferred) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public synchronized void reconnectPreviousConnection() {
        System.out.println("reconnectPreviousConnection entered");
        this.commManager.reconnectConnection();
    }

    public void removeHostConnection(int connectionIndex, boolean notify) {
        if (connectionIndex == this.currentConnectionIndex) {
            this.commManager.closeConnection();
        }
        this.hostConnections.remove(connectionIndex);
        if (notify) {
            this.notifyListeners();
        }
    }

    public void removeHostConnection(HostConnectionDescriptor connection, boolean notify) {
        int connectionIndex = this.findHostConnectionIndex(connection);
        this.removeHostConnection(connectionIndex, notify);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        int index = 0;
        while (index < this.notifyList.size()) {
            if ((Runnable)this.notifyList.get(index) == updateListener) {
                this.notifyList.remove(index);
                break;
            }
            ++index;
        }
    }

    private synchronized ArrayList retrieveHostConnectionPreferences() {
        Preferences connectionPreferences;
        ArrayList<HostConnectionDescriptor> retrievedConnections = new ArrayList<HostConnectionDescriptor>();
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
            connectionPreferences.sync();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            System.out.println("HostConnectionManager: connection preferences retrieval exception");
            return retrievedConnections;
        }
        int numberOfConnections = connectionPreferences.getInt("NumberOfConnections", 0);
        int index = 0;
        while (index < numberOfConnections) {
            block8: {
                Preferences connectionNode;
                HostConnectionDescriptor connectionDescriptor;
                block7: {
                    String ipAddress;
                    String connection = "Connection";
                    connectionDescriptor = new HostConnectionDescriptor();
                    try {
                        connectionNode = connectionPreferences.node(connection + Integer.toString(index));
                        connectionNode.sync();
                    }
                    catch (Exception exception) {
                        ErrorLog.put(exception, "HostConnectionManager Exception\n" + connection + " Node" + " retrieval from preferences");
                        System.out.println("HostConnectionManager: connection node preferences retrieval exception");
                        retrievedConnections.clear();
                        return retrievedConnections;
                    }
                    connectionDescriptor.alias = connectionNode.get("Alias", "");
                    connectionDescriptor.type = connectionNode.get("Type", "");
                    connectionDescriptor.controller = 0;
                    if (!connectionDescriptor.type.equals("Remote")) break block7;
                    connectionDescriptor.ipAddress = ipAddress = connectionNode.get("IpAddress", "0.0.0.0");
                    if (!connectionDescriptor.disassembleAndSetEtherPortAddress(ipAddress)) break block8;
                    connectionDescriptor.serverPort = connectionNode.get("ServerPort", Integer.toString(4242));
                }
                connectionDescriptor.preferred = connectionNode.get("Preferred", "").equals("Y");
                retrievedConnections.add(connectionDescriptor);
            }
            ++index;
        }
        return retrievedConnections;
    }

    public void saveHostConnectionPreferences() {
        Preferences connectionPreferences;
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            System.out.println("HostConnectionManager: connection preferences retrieval exception");
            return;
        }
        try {
            connectionPreferences.removeNode();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences clearing");
            System.out.println("HostConnectionManager: connection preferences clearing exception");
            return;
        }
        try {
            connectionPreferences.flush();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences flush after remove");
            System.out.println("HostConnectionManager: connection preferences flush after remove exception");
        }
        try {
            connectionPreferences = Preferences.userRoot().node("/Sam/System/Connections");
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences retrieval");
            System.out.println("HostConnectionManager: connection preferences retrieval exception");
            return;
        }
        int numberOfConnections = this.hostConnections.size();
        connectionPreferences.putInt("NumberOfConnections", numberOfConnections);
        numberOfConnections = this.hostConnections.size();
        int index = 0;
        while (index < numberOfConnections) {
            Preferences connectionNode;
            String connection = "Connection";
            try {
                connectionNode = connectionPreferences.node(connection + Integer.toString(index));
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "HostConnectionManager Exception\n" + connection + " Node creation");
                System.out.println("HostConnectionManager: connection preferences node creation exception");
                return;
            }
            HostConnectionDescriptor connectionDescriptor = (HostConnectionDescriptor)this.hostConnections.get(index);
            connectionNode.put("Alias", connectionDescriptor.alias);
            connectionNode.put("Type", connectionDescriptor.type);
            connectionNode.put("IpAddress", connectionDescriptor.ipAddress);
            connectionNode.put("Preferred", connectionDescriptor.preferred ? "Y" : "N");
            connectionNode.put("ServerPort", connectionDescriptor.serverPort);
            try {
                connectionNode.flush();
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "HostConnectionManager Exception\nconnection node flush");
                System.out.println("HostConnectionManager: connection node flush exception");
            }
            ++index;
        }
        try {
            connectionPreferences.flush();
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "HostConnectionManager Exception\nconnection preferences flush");
            System.out.println("HostConnectionManager: connection preferences flush exception");
        }
    }

    public void setNexusToConnection(boolean local, String ipAddress, int controller) {
        this.nexus.setLocal(local);
        this.nexus.setIpAddress(ipAddress);
        this.nexus.setController(controller);
        System.out.println("::::::::: setNexusToConnection: nexus set to: type = " + (local ? "Local" : "Remote") + " ipAddress = " + ipAddress + " controller = " + controller);
    }

    private void tryLocalConnection() {
        int status = this.commManager.openLocalConnection(0);
        if (status != 0) {
            new ImmediateConnectionTableBox(this.storageManagementUtility, this);
        } else {
            this.currentConnectionIndex = 0;
        }
    }
}

