/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ExtendedMemberTable
extends JPanel
implements SortInterface,
GlobalConstants {
    DatabaseManager databaseManager;
    Object[] defaultColumns;
    ArrayList extendedMemberList;
    KTable extendedMemberTable;
    ExtendedMemberTableModel extendedMemberTableModel;
    String memberFields;
    String memberStatus;
    AbstractMessageHandler messageHandler;
    String metadataFormat;
    protected ArrayList notifyList;
    boolean onlyRedundant;
    Preferences preferences;
    RaidGroupDatabase raidGroupDatabase;
    RaidGroupDatabaseUpdateListener raidGroupDatabaseUpdateListener;
    String[] raidGroupStatuses;
    JScrollPane scrollPane;
    String[] sortDefaultFields;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;

    public ExtendedMemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] raidGroupStatuses, String memberStatus, String[] sortDefaultFields, boolean onlyRedundant, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.raidGroupStatuses = raidGroupStatuses;
        this.sortDefaultFields = sortDefaultFields;
        this.memberStatus = memberStatus;
        this.onlyRedundant = onlyRedundant;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.metadataFormat = metadataFormat;
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public ExtendedMemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] raidGroupStatuses, String memberStatus, String[] sortDefaultFields, int rowCount, String metadataFormat) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.raidGroupStatuses = raidGroupStatuses;
        this.sortDefaultFields = sortDefaultFields;
        this.memberStatus = memberStatus;
        this.onlyRedundant = false;
        this.raidGroupDatabase = databaseManager.raidGroupDatabase;
        this.metadataFormat = metadataFormat;
        this.loadPreferences();
        this.buildTable(rowCount);
        this.raidGroupDatabaseUpdateListener = new RaidGroupDatabaseUpdateListener();
        this.raidGroupDatabase.addUpdateListener(this.raidGroupDatabaseUpdateListener);
        this.raidGroupDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public void addRowSelectionInterval(int selectionIndex0, int selectionIndex1) {
        this.extendedMemberTable.addRowSelectionInterval(selectionIndex0, selectionIndex1);
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    private void buildTable(int rowCount) {
        this.notifyList = new ArrayList();
        this.extendedMemberList = this.getExtendedMemberList();
        this.extendedMemberTableModel = new ExtendedMemberTableModel();
        this.extendedMemberTable = new KTable(this.extendedMemberTableModel, rowCount);
        this.extendedMemberTable.getColumnModel().addColumnModelListener(new ExtendedMemberTableColumnModelListener());
        this.extendedMemberTable.addListSelectionListener(new TableSelectionListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = ExtendedMemberTable.this.extendedMemberTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = ExtendedMemberTable.this.extendedMemberTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = ExtendedMemberTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = ExtendedMemberTable.this.extendedMemberTableModel.getColumnName(column);
                    int count = 0;
                    while (count < DeviceDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        ExtendedMemberTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.extendedMemberTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.extendedMemberTable);
        this.scrollPane.getViewport().setBackground(this.extendedMemberTable.getBackground());
    }

    protected void closeFrame() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
    }

    public void dispose() {
        this.raidGroupDatabase.removeUpdateListener(this.raidGroupDatabaseUpdateListener);
    }

    public ExtendedMemberDescriptor getExtendedMemberDescriptor(int row) {
        return (ExtendedMemberDescriptor)this.extendedMemberList.get(row);
    }

    public synchronized ArrayList getExtendedMemberList() {
        ArrayList<ExtendedMemberDescriptor> newMemberList = new ArrayList<ExtendedMemberDescriptor>();
        ArrayList<ExtendedMemberDescriptor> sortedList = new ArrayList<ExtendedMemberDescriptor>();
        ArrayList raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(this.raidGroupStatuses, this.onlyRedundant, this.metadataFormat);
        int raidGroup = 0;
        while (raidGroup < raidGroupList.size()) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            String memberCapacity = "N/A";
            int member = 0;
            while (member < raidGroupDescriptor.memberArray.size()) {
                MemberDescriptor memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member);
                if (memberDescriptor.status.equals("Online")) {
                    memberCapacity = memberDescriptor.getCapacity(this.databaseManager);
                    break;
                }
                ++member;
            }
            int member2 = 0;
            while (member2 < raidGroupDescriptor.memberArray.size()) {
                MemberDescriptor memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member2);
                if (memberDescriptor.status.equals(this.memberStatus)) {
                    ExtendedMemberDescriptor extendedMemberDescriptor = new ExtendedMemberDescriptor();
                    extendedMemberDescriptor.member = memberDescriptor.member;
                    extendedMemberDescriptor.status = memberDescriptor.status;
                    extendedMemberDescriptor.pathId = memberDescriptor.pathId;
                    extendedMemberDescriptor.targetId = memberDescriptor.targetId;
                    extendedMemberDescriptor.startingPlbn = memberDescriptor.startingPlbn;
                    extendedMemberDescriptor.capacity = memberCapacity;
                    extendedMemberDescriptor.device = Integer.toString(memberDescriptor.getDevice(this.databaseManager));
                    extendedMemberDescriptor.raidGroup = Integer.toString(raidGroupDescriptor.raidGroup);
                    newMemberList.add(extendedMemberDescriptor);
                }
                ++member2;
            }
            ++raidGroup;
        }
        int sourceIndex = 0;
        while (sourceIndex < newMemberList.size()) {
            ExtendedMemberDescriptor sourceMember = (ExtendedMemberDescriptor)newMemberList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                ExtendedMemberDescriptor destMember = (ExtendedMemberDescriptor)sortedList.get(destIndex);
                int result = sourceMember.compare(destMember, this.sortDescriptors[0]);
                if (result >= 1 || result == 0 && ((result = sourceMember.compare(destMember, this.sortDescriptors[1])) >= 1 || result == 0 && sourceMember.compare(destMember, this.sortDescriptors[2]) >= 1)) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceMember);
            ++sourceIndex;
        }
        return sortedList;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public ArrayList getSelectedExtendedMembers() {
        ArrayList<ExtendedMemberDescriptor> selectedList = new ArrayList<ExtendedMemberDescriptor>();
        int[] selectedRows = this.extendedMemberTable.getSelectedRows();
        System.out.println("selected row count " + selectedRows.length);
        int count = 0;
        while (count < selectedRows.length) {
            ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)this.extendedMemberList.get(selectedRows[count]);
            selectedList.add(extendedMemberDescriptor);
            ++count;
        }
        return selectedList;
    }

    public int getSelectedRow() {
        return this.extendedMemberTable.getSelectedRow();
    }

    public KTable getTable() {
        return this.extendedMemberTable;
    }

    public ExtendedMemberTableModel getTableModel() {
        return this.extendedMemberTableModel;
    }

    private void loadPreferences() {
        String[] fieldNames = ExtendedMemberDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.memberFields != null ? this.memberFields : this.preferences.get("Table Columns", "RAID Group,Member,Status,Capacity");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                int index = 0;
                while (index < fieldNames.length) {
                    if (fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            if (fieldList.size() > 0) break;
            if (this.memberFields.equals(null)) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = this.sortDefaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.memberFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, this.sortDefaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            int index2 = 0;
            while (index2 < fieldNames.length) {
                if (fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void notifyListeners() {
        int index = 0;
        while (index < this.notifyList.size()) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
            ++index;
        }
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        int index = 0;
        while (index < this.notifyList.size()) {
            if ((Runnable)this.notifyList.get(index) == updateListener) {
                this.notifyList.remove(index);
                break;
            }
            ++index;
        }
    }

    private void savePreferences() {
        if (this.memberFields != null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.extendedMemberTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 3) {
            this.preferences.put("Table Sort Field" + index2, ExtendedMemberDescriptor.fieldNames[this.sortDescriptors[index2].field]);
            this.preferences.put("Table Sort Direction" + index2, this.sortDescriptors[index2].direction == 1 ? "Ascending" : "Descending");
            ++index2;
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.extendedMemberTable.setSelectionMode(selectionMode);
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.raidGroupDatabaseUpdateListener.run();
        this.extendedMemberList = this.getExtendedMemberList();
        this.extendedMemberTableModel.updateDisplay();
        this.savePreferences();
    }

    class ExtendedMemberTableModel
    extends KTableModel {
        public ExtendedMemberTableModel() {
            this.setColumns(ExtendedMemberDescriptor.fieldNames, ExtendedMemberDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return ExtendedMemberTable.this.defaultColumns;
        }

        public int getRowCount() {
            return ExtendedMemberTable.this.extendedMemberList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= ExtendedMemberTable.this.extendedMemberList.size()) {
                value = "";
            } else {
                ExtendedMemberDescriptor extendedMember = (ExtendedMemberDescriptor)ExtendedMemberTable.this.extendedMemberList.get(row);
                value = extendedMember.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (ExtendedMemberTable.this.extendedMemberList.size() > 0) {
                this.fireTableRowsInserted(0, ExtendedMemberTable.this.extendedMemberList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class ExtendedMemberTableColumnModelListener
    implements TableColumnModelListener {
        ExtendedMemberTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            ExtendedMemberTable.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            ExtendedMemberTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    protected class RaidGroupDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newExtendedMemberList = ExtendedMemberTable.this.getExtendedMemberList();
            if (ExtendedMemberTable.this.extendedMemberTable.getSelectedRow() == -1) {
                ExtendedMemberTable.this.extendedMemberList = newExtendedMemberList;
                ExtendedMemberTable.this.extendedMemberTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = ExtendedMemberTable.this.extendedMemberList.size();
                int oldTableSize = ExtendedMemberTable.this.extendedMemberTableModel.getRowCount();
                int[] selectedRows = ExtendedMemberTable.this.extendedMemberTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    ExtendedMemberDescriptor extendedMemberDescriptor = (ExtendedMemberDescriptor)ExtendedMemberTable.this.extendedMemberList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newExtendedMemberList.size()) {
                        ExtendedMemberDescriptor newExtendedMemberDescriptor = (ExtendedMemberDescriptor)newExtendedMemberList.get(newRow);
                        if (!newExtendedMemberDescriptor.same(extendedMemberDescriptor)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                ExtendedMemberTable.this.extendedMemberList = newExtendedMemberList;
                ExtendedMemberTable.this.extendedMemberTable.clearSelection();
                ExtendedMemberTable.this.extendedMemberTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        ExtendedMemberTable.this.extendedMemberTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
        }

        public void terminate() {
            this.active = false;
        }
    }

    protected class TableSelectionListener
    implements ListSelectionListener {
        protected TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            System.out.println("TableSelectionListener() entered");
            ExtendedMemberTable.this.notifyListeners();
        }
    }
}

