/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;

public class EventDatabase
extends AbstractDatabase {
    public static int CurrentEvent;
    public static int Event;
    public static int EventTableIndex;
    public static int EventsExpected;
    public static int EventsReceived;
    private DatabaseManager databaseManager;
    private static EventDatabase eventDatabase;
    Runnable eventDatabaseChangeHandler;
    private ListTable eventTable;
    private PopUpBox popUpBox;
    private boolean popUpBoxActive;
    final char unitSeparator = (char)31;

    static {
        Event = 0;
        EventsReceived = 0;
        EventsExpected = 0;
        CurrentEvent = 0;
        EventTableIndex = 0;
    }

    EventDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Event");
        this.databaseManager = databaseManager;
    }

    public void UpdateApplicationEvents(String EventLevel, String EventMessage) {
        String dateSeparator = "/";
        GregorianCalendar calendar = new GregorianCalendar();
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        String filler = "";
        int monthInt = calendar.get(2);
        if (++monthInt < 10) {
            filler = "0";
        }
        String month = filler + Integer.toString(monthInt);
        filler = "";
        int dayInt = calendar.get(5);
        if (dayInt < 10) {
            filler = "0";
        }
        String day = filler + Integer.toString(dayInt);
        filler = "";
        int yearInt = calendar.get(1) % 100;
        if (yearInt < 10) {
            filler = "0";
        }
        String year = filler + Integer.toString(yearInt);
        String date = month + dateSeparator + day + dateSeparator + year;
        filler = "";
        int hourInt = calendar.get(10);
        if (hourInt < 10) {
            filler = "0";
        }
        String hour = filler + Integer.toString(hourInt);
        filler = "";
        int minuteInt = calendar.get(12);
        if (minuteInt < 10) {
            filler = "0";
        }
        String minute = filler + Integer.toString(minuteInt);
        filler = "";
        int secondInt = calendar.get(13);
        if (secondInt < 10) {
            filler = "0";
        }
        String second = filler + Integer.toString(secondInt);
        String amPm = calendar.get(9) == 0 ? "AM" : "PM";
        String time = hour + ":" + minute + "." + second + " " + amPm;
        EventDescriptor eventDescriptor = new EventDescriptor();
        eventDescriptor.EventDate = date;
        eventDescriptor.EventTime = time;
        eventDescriptor.EventType = "Application";
        eventDescriptor.EventLevel = EventLevel;
        eventDescriptor.EventMessage = EventMessage;
        this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), eventDescriptor);
        String logEvent = "\u001f" + eventDescriptor.EventDate + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventTime + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventType + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventLevel + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventMessage + '\u001f' + "\n";
        this.appendLogFile(logEvent);
        this.notifyListeners();
    }

    private void appendLogFile(String logMessage) {
        System.out.println("EventDatabase: appendLogFile() entered");
        if (!this.databaseManager.storageManagementUtility.logFileGen) {
            return;
        }
        File logFile = new File(this.databaseManager.storageManagementUtility.logFilePath);
        try {
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            FileOutputStream eventLogFileOutputStream = new FileOutputStream(logFile, true);
            eventLogFileOutputStream.write(logMessage.getBytes());
            eventLogFileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized EventDescriptor getEvent(int event) {
        return (EventDescriptor)((EventDescriptor)this.eventTable.get(event)).clone();
    }

    protected int getEventLevelValue(String eventLevel) {
        int eventLevelValue = 0;
        if (!eventLevel.equals("Disabled")) {
            ++eventLevelValue;
            if (!eventLevel.equals("Error")) {
                ++eventLevelValue;
                if (!eventLevel.equals("Warning")) {
                    ++eventLevelValue;
                }
            }
        }
        return eventLevelValue;
    }

    public synchronized ArrayList getEventList() {
        ArrayList<Object> requestedEventList = new ArrayList<Object>();
        int event = 0;
        while (event < this.eventTable.size()) {
            requestedEventList.add(((EventDescriptor)this.eventTable.get(event)).clone());
            ++event;
        }
        return requestedEventList;
    }

    public void initialize() {
        super.initialize();
        this.eventTable = new ListTable();
        this.popUpBoxActive = false;
        if (this.databaseManager.storageManagementUtility.logFileGen) {
            this.readLogFile();
        }
        if (this.updateCount > 0L) {
            this.getNew();
        } else {
            this.initializationComplete();
        }
    }

    public synchronized void nuke() {
        System.out.println("EventDatabase: nuke() entered");
        this.eventTable.clear();
        if (this.popUpBoxActive) {
            this.popUpBox.closePopUpBox();
        }
        EventTableIndex = 0;
        this.notifyListeners();
    }

    protected int popUpDamagedFileWarning() {
        int answer = JOptionPane.showConfirmDialog(null, "File holding the saved events appears to be damaged.\nIf you choose to continue, the rest of the event log file will be skipped.\nIf you choose not to continue, the application will exit back to the system.\nAre you sure you want to continue?", "Event File Damage Warning", 0);
        return answer;
    }

    protected synchronized void processNewData(Message message) {
        int appEventLevel = this.getEventLevelValue(this.databaseManager.storageManagementUtility.popUpLevel);
        if (this.databaseManager.state != 3 && !this.initializing) {
            return;
        }
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                } else if (xmlData.element.equals("EventInfo")) {
                    EventDescriptor eventDescriptor = new EventDescriptor(xmlData.elementValue);
                    String logEvent = "\u001f" + eventDescriptor.EventDate + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventTime + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventType + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventLevel + '\u001f' + "\t" + '\u001f' + eventDescriptor.EventMessage + '\u001f' + "\n";
                    this.appendLogFile(logEvent);
                    this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), eventDescriptor);
                    int eventLevel = this.getEventLevelValue(eventDescriptor.EventLevel);
                    if (eventLevel <= appEventLevel) {
                        if (!this.popUpBoxActive) {
                            this.popUpBox = new PopUpBox(this.databaseManager, this, GlobalConstants.popUpLevelStrings[eventLevel] + " Event Notification");
                        } else {
                            this.popUpBox.toFront();
                        }
                    }
                    if ((long)(++EventsReceived) < this.updateCount) {
                        this.getNew();
                    } else {
                        if (this.initializing) {
                            this.initializationComplete();
                        }
                        EventsReceived = 0;
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.UpdateApplicationEvents("Error", "EventDatabase Process New Event Exception");
            ErrorLog.put(exception, "EventDatabase Process New Event Exception\nMessage " + message.response);
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            XmlData xmlData = new XmlData(data);
            while (xmlData.getNextElement()) {
                if (this.updateCount <= 0L) continue;
                this.getNew();
            }
        }
        catch (Exception exception) {
            this.UpdateApplicationEvents("Error", "Event Database Process Update Counts Exception " + data);
            ErrorLog.put(exception, "Event Database Process Update Counts Exception\nController " + data);
        }
    }

    public void purgeWithAppendSave(String logFilePath, String backupFilePath) {
        System.out.println("EventDatabase: purgeWithAppendSave() entered");
        boolean beginIndex = false;
        boolean endIndex = false;
        boolean append = true;
        try {
            File logFile = new File(logFilePath);
            File backupFile = new File(backupFilePath);
            int bytesRead = 0;
            int fileSize = (int)logFile.length();
            char[] logData = new char[fileSize];
            FileReader logFileReader = new FileReader(logFile);
            FileWriter backupFileWriter = new FileWriter(backupFile, append);
            while (logFileReader.ready()) {
                bytesRead += logFileReader.read(logData, bytesRead, fileSize - bytesRead);
            }
            logFileReader.close();
            backupFileWriter.write(logData);
            backupFileWriter.close();
            logFile.delete();
            logFile.createNewFile();
            this.nuke();
        }
        catch (IOException e) {
            System.out.println("EventDatabase: purgeWithAppendSave() exception caught");
        }
    }

    public void purgeWithDeleteAndSave(String logFilePath, String backupFilePath) {
        System.out.println("EventDatabase: purgeWithDeleteAndSave() entered");
        File backupFile = new File(backupFilePath);
        File logFile = new File(logFilePath);
        try {
            backupFile.delete();
            logFile.renameTo(backupFile);
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void purgeWithSave(String logFilePath, String saveFilePath) {
        System.out.println("EventDatabase: purgeWithSave() entered");
        File saveFile = new File(saveFilePath);
        File logFile = new File(logFilePath);
        try {
            logFile.renameTo(saveFile);
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void purgeWithoutSave(String logFilePath) {
        System.out.println("EventDatabase: purgeWithoutSave() entered");
        File logFile = new File(logFilePath);
        try {
            logFile.delete();
            logFile.createNewFile();
            this.nuke();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readLogFile() {
        System.out.println("EventDatabase: readLogFile() entered");
        int beginIndex = 0;
        int endIndex = 0;
        try {
            System.out.println("readLogFile(): logFileName = '" + this.databaseManager.storageManagementUtility.logFilePath + "'");
            File logFile = new File(this.databaseManager.storageManagementUtility.logFilePath);
            int fileSize = (int)logFile.length();
            char[] logData = new char[fileSize];
            FileReader logFileReader = new FileReader(logFile);
            int bytesRead = 0;
            while (logFileReader.ready()) {
                bytesRead += logFileReader.read(logData, bytesRead, fileSize - bytesRead);
            }
            logFileReader.close();
            String logDataString = new String(logData, 0, fileSize);
            while (endIndex <= fileSize) {
                EventDescriptor logFileEventDescriptor = new EventDescriptor();
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0) {
                    return;
                }
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    System.exit(0);
                }
                logFileEventDescriptor.EventDate = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    System.exit(0);
                }
                logFileEventDescriptor.EventTime = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    System.exit(0);
                }
                logFileEventDescriptor.EventType = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    System.exit(0);
                }
                logFileEventDescriptor.EventLevel = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                beginIndex = logDataString.indexOf(31, beginIndex);
                endIndex = logDataString.indexOf(31, beginIndex + 1);
                if (beginIndex < 0 || endIndex < 0) {
                    if (this.popUpDamagedFileWarning() == 0) {
                        return;
                    }
                    System.exit(0);
                }
                logFileEventDescriptor.EventMessage = logDataString.substring(beginIndex + 1, endIndex);
                beginIndex = endIndex + 1;
                this.eventTable.put(this.eventTable.size(), Integer.toString(EventTableIndex++), logFileEventDescriptor);
            }
        }
        catch (IOException e) {
        }
    }

    public synchronized void refreshPopUpBox() {
        if (this.popUpBoxActive) {
            this.popUpBox.toFront();
        }
    }

    public synchronized void reloadLogFile() {
        System.out.println("EventDatabase: reloadLogFile() entered");
        this.nuke();
        this.readLogFile();
        this.notifyListeners();
    }

    public synchronized void setPopBoxState(boolean state) {
        this.popUpBoxActive = state;
    }
}

