/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class DeviceSummaryPage
extends KFrame
implements SortInterface {
    Object[] defaultColumns;
    JLabel deviceCountLabel;
    DeviceDatabase deviceDatabase;
    DeviceDatabaseUpdateListener deviceDatabaseUpdateListener;
    ArrayList deviceList;
    KTable deviceTable;
    DeviceManagerTableModel deviceTableModel;
    AbstractMessageHandler messageHandler;
    SortDescriptor[] sortDescriptors;
    ArrayList sortedList;

    public DeviceSummaryPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.loadPreferences();
        this.buildMenus();
        this.buildTable();
        this.buildStatusBar();
        this.deviceDatabaseUpdateListener = new DeviceDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.deviceDatabaseUpdateListener);
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeviceSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(DeviceSummaryPage.this, DeviceSummaryPage.this.deviceTable, DeviceSummaryPage.this.deviceTableModel);
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(DeviceSummaryPage.this, DeviceDescriptor.fieldNames, DeviceSummaryPage.this.sortDescriptors);
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.deviceCountLabel = new JLabel(" Device Count: 0");
        this.deviceCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.deviceCountLabel, "South");
    }

    private void buildTable() {
        this.deviceList = this.getDeviceList();
        this.deviceTableModel = new DeviceManagerTableModel();
        this.deviceTable = new KTable(this.deviceTableModel, 24);
        this.deviceTable.setSelectionMode(0);
        this.deviceTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = DeviceSummaryPage.this.deviceTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = DeviceSummaryPage.this.deviceTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    SortDescriptor[] sorters = DeviceSummaryPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = DeviceSummaryPage.this.deviceTableModel.getColumnName(column);
                    int count = 0;
                    while (count < DeviceDescriptor.fieldNames.length) {
                        if (name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count])) break;
                        ++count;
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            int offset = 1;
                            while (offset >= 0) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                                --offset;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        DeviceSummaryPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.deviceTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.deviceTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.deviceTable);
        scrollPane.getViewport().setBackground(this.deviceTable.getBackground());
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    protected void closeFrame() {
        this.deviceDatabase.removeUpdateListener(this.deviceDatabaseUpdateListener);
        this.completeFrameClosure();
    }

    public synchronized ArrayList getDeviceList() {
        ArrayList newDeviceList = this.deviceDatabase.getDeviceList();
        ArrayList<DeviceDescriptor> sortedList = new ArrayList<DeviceDescriptor>();
        int sourceIndex = 0;
        while (sourceIndex < newDeviceList.size()) {
            DeviceDescriptor sourceDevice = (DeviceDescriptor)newDeviceList.get(sourceIndex);
            int destIndex = 0;
            while (destIndex < sortedList.size()) {
                DeviceDescriptor destDevice = (DeviceDescriptor)sortedList.get(destIndex);
                int result = sourceDevice.compare(destDevice, this.sortDescriptors[0]);
                if (result >= 1) break;
                ++destIndex;
            }
            sortedList.add(destIndex, sourceDevice);
            ++sourceIndex;
        }
        return sortedList;
    }

    private void loadPreferences() {
        String[] fieldNames = DeviceDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            String columns = this.preferences.get("Table Columns", "Path ID, Target ID,Status,Capacity,Model,Version");
            int startIndex = 0;
            do {
                int endIndex;
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                int index = 0;
                while (index < fieldNames.length) {
                    if (fieldNames[index].trim().equals(columnName.trim())) {
                        fieldList.add(columnName);
                    }
                    ++index;
                }
                startIndex = endIndex + 1;
            } while (startIndex < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "Path ID, Target ID,Status,Capacity,Model,Version");
        }
        this.defaultColumns = new Object[fieldList.size()];
        int index = 0;
        while (index < fieldList.size()) {
            this.defaultColumns[index] = fieldList.get(index);
            ++index;
        }
        String[] defaultFields = new String[]{"Device"};
        String[] defaultDirection = new String[]{"Ascending"};
        this.sortDescriptors = new SortDescriptor[1];
        int sorter = 0;
        while (sorter < this.sortDescriptors.length) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            int index2 = 0;
            while (index2 < fieldNames.length) {
                if (fieldNames[index2].equals(fields)) {
                    this.sortDescriptors[sorter] = new SortDescriptor(index2, direction.equals("Ascending") ? 1 : 0);
                    break;
                }
                ++index2;
            }
            ++sorter;
        }
    }

    private void savePreferences() {
        String columns = "";
        TableColumnModel tableColumnModel = this.deviceTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        int index = 0;
        while (index < tableColumnModel.getColumnCount()) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
            ++index;
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        int index2 = 0;
        while (index2 < 1) {
            this.preferences.put("Table Sort Field" + index2, DeviceDescriptor.fieldNames[this.sortDescriptors[index2].field]);
            this.preferences.put("Table Sort Direction" + index2, this.sortDescriptors[index2].direction == 1 ? "Ascending" : "Descending");
            ++index2;
        }
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class DeviceManagerTableModel
    extends KTableModel {
        public DeviceManagerTableModel() {
            this.setColumns(DeviceDescriptor.fieldNames, DeviceDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return DeviceSummaryPage.this.defaultColumns;
        }

        public int getRowCount() {
            return DeviceSummaryPage.this.deviceList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= DeviceSummaryPage.this.deviceList.size()) {
                value = "";
            } else {
                DeviceDescriptor device = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(row);
                value = device.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }

        public void updateDisplay() {
            if (DeviceSummaryPage.this.deviceList.size() > 0) {
                this.fireTableRowsInserted(0, DeviceSummaryPage.this.deviceList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = DeviceSummaryPage.this.deviceTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < DeviceSummaryPage.this.deviceTable.getRowCount()) {
                DeviceSummaryPage.this.deviceTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(mouseSelectedRow);
            }
        }
    }

    protected class DeviceDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newDeviceList = DeviceSummaryPage.this.getDeviceList();
            if (DeviceSummaryPage.this.deviceTable.getSelectedRow() == -1) {
                DeviceSummaryPage.this.deviceList = newDeviceList;
                DeviceSummaryPage.this.deviceTableModel.updateDisplay();
            } else {
                int newRow;
                int oldListSize = DeviceSummaryPage.this.deviceList.size();
                int oldTableSize = DeviceSummaryPage.this.deviceTableModel.getRowCount();
                int[] selectedRows = DeviceSummaryPage.this.deviceTable.getSelectedRows();
                int selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    DeviceDescriptor deviceDescriptor = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    newRow = 0;
                    while (newRow < newDeviceList.size()) {
                        DeviceDescriptor newDeviceDescriptor = (DeviceDescriptor)newDeviceList.get(newRow);
                        if (newDeviceDescriptor.serialNumber.equals(deviceDescriptor.serialNumber)) {
                            found = true;
                            break;
                        }
                        ++newRow;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                    ++selectedIndex;
                }
                DeviceSummaryPage.this.deviceList = newDeviceList;
                DeviceSummaryPage.this.deviceTable.clearSelection();
                DeviceSummaryPage.this.deviceTableModel.updateDisplay();
                selectedIndex = 0;
                while (selectedIndex < selectedRows.length) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow != -1) {
                        DeviceSummaryPage.this.deviceTable.addRowSelectionInterval(newRow, newRow);
                    }
                    ++selectedIndex;
                }
            }
            DeviceSummaryPage.this.deviceCountLabel.setText(" Device Count: " + DeviceSummaryPage.this.deviceList.size());
        }

        public void terminate() {
            this.active = false;
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            DeviceSummaryPage.this.savePreferences();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            DeviceSummaryPage.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

