/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class DeviceDescriptor
extends AbstractDescriptor {
    public String capacity;
    public int device;
    private String[] fieldNameLookUp = new String[]{"Device", "device", "PathId", "pathId", "TargetId", "targetId", "Status", "status", "Capacity", "capacity", "ModelNumber", "modelNumber", "FirmwareRevision", "firmwareRevision", "SerialNumber", "serialNumber", "UpdateCount", "updateCount"};
    public static final String[] fieldNames = new String[]{"Device", "Path ID", "Target ID", "Status", "Capacity", "Model", "Version", "Serial Number"};
    public String firmwareRevision;
    public static final String[] maxFieldText = new String[]{"XDeviceX", "XPath IDX", "XTarget IDX", "XFormattingX", "XX Capacity XX", "X XXXXXXXXXXXXXXXX X", "XXXXVersionXXXX", "X XXXXXXXXXXXXXXXX X", "Unsupported"};
    public String modelNumber;
    public int pathId;
    public ArrayList segmentArray;
    public String serialNumber;
    public String status;
    public int targetId;
    public String updateCount;

    DeviceDescriptor(String data) {
        this.nuke();
        this.parseXml(data);
    }

    DeviceDescriptor(int pathId, int targetId) {
        this.nuke();
        this.pathId = pathId;
        this.targetId = targetId;
    }

    DeviceDescriptor(int pathId, int targetId, int device) {
        this.nuke();
        this.device = device;
        this.pathId = pathId;
        this.targetId = targetId;
    }

    DeviceDescriptor() {
        this.nuke();
    }

    public synchronized Object clone() {
        DeviceDescriptor newDescriptor = new DeviceDescriptor();
        newDescriptor.device = this.device;
        newDescriptor.pathId = this.pathId;
        newDescriptor.targetId = this.targetId;
        newDescriptor.status = this.status;
        newDescriptor.serialNumber = this.serialNumber;
        newDescriptor.modelNumber = this.modelNumber;
        newDescriptor.firmwareRevision = this.firmwareRevision;
        newDescriptor.capacity = this.capacity;
        newDescriptor.updateCount = this.updateCount;
        int index = 0;
        while (index < this.segmentArray.size()) {
            newDescriptor.segmentArray.add(((SegmentDescriptor)this.segmentArray.get(index)).clone());
            ++index;
        }
        return newDescriptor;
    }

    public int compare(DeviceDescriptor compareDevice, SortDescriptor sortDescriptor) {
        long result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareDevice);
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    public String getFieldName(int fieldIndicator) {
        return fieldNames[fieldIndicator];
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public void nuke() {
        this.device = -1;
        this.pathId = -1;
        this.targetId = -1;
        this.status = "Empty";
        this.serialNumber = "Unknown";
        this.modelNumber = "Unknown";
        this.firmwareRevision = "Unknown";
        this.capacity = "Unknown";
        this.updateCount = "Unknown";
        this.segmentArray = new ArrayList();
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue) || !xmlData.element.equals("SegmentInfo")) continue;
            this.segmentArray.add(new SegmentDescriptor(this.device, xmlData.elementValue));
        }
        this.serialNumber = this.serialNumber.trim();
        this.modelNumber = this.modelNumber.trim();
        this.firmwareRevision = this.firmwareRevision.trim();
    }
}

