/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;

public class DeviceDatabase
extends AbstractDatabase {
    private DeviceDescriptor[] deviceArray;
    private final String[] legacySegmentStatuses = new String[]{"Legacy Spare"};
    private final String[] newSegmentStatuses = new String[]{"Global Spare", "Dedicated Spare"};
    private final String[] segmentStatuses = new String[]{"Available"};

    DeviceDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Device");
    }

    public synchronized boolean availableLbn0SegmentExists() {
        String[] segmentStatuses = new String[]{"Available"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        int index = 0;
        while (index < segmentList.size()) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(index);
            try {
                if (segmentDescriptor.status.equals("Available") && Integer.parseInt(segmentDescriptor.startingPlbn, 16) == 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "");
            }
            ++index;
        }
        return false;
    }

    public synchronized boolean availableSegmentExists() {
        String[] segmentStatuses = new String[]{"Available"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized int getBootableSegmentCount() {
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        int bootableSegments = 0;
        if (lastIndex > 4) {
            lastIndex = 4;
        }
        int deviceIndex = 0;
        while (deviceIndex < lastIndex) {
            DeviceDescriptor device = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (!device.status.equals("Empty")) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)device.segmentArray.get(0);
                try {
                    if (segmentDescriptor != null && Integer.parseInt(segmentDescriptor.startingPlbn, 16) == 0 && segmentDescriptor.status.equals("Available")) {
                        ++bootableSegments;
                    }
                }
                catch (Exception exception) {
                    ErrorLog.put(exception, "");
                }
            }
            ++deviceIndex;
        }
        return bootableSegments;
    }

    public int getCapacityInBlocks(String inCapacityStr) {
        int capacityBlocks;
        block7: {
            String capacityString = inCapacityStr.toUpperCase();
            capacityBlocks = 0;
            int decIndex = capacityString.indexOf(".");
            try {
                int endIndex;
                if (decIndex != -1) {
                    String newCapacityString = capacityString.substring(0, decIndex);
                    int capacityInt = Integer.parseInt(newCapacityString) + 1;
                    newCapacityString = Integer.toString(capacityInt);
                    int suffixMBStartIndex = capacityString.indexOf(" MB");
                    int suffixGBStartIndex = capacityString.indexOf(" GB");
                    int suffixEndIndex = capacityString.length();
                    if (suffixMBStartIndex != -1 || suffixGBStartIndex != -1) {
                        String suffixString = suffixMBStartIndex != -1 ? capacityString.substring(suffixMBStartIndex, suffixEndIndex) : capacityString.substring(suffixGBStartIndex, suffixEndIndex);
                        capacityString = newCapacityString + suffixString;
                    }
                }
                if ((endIndex = capacityString.indexOf(" MB")) == -1) {
                    endIndex = capacityString.indexOf(" GB");
                    if (endIndex == -1) {
                        endIndex = capacityString.length();
                        capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
                    } else {
                        capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 0x200000;
                    }
                    break block7;
                }
                capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "");
            }
        }
        return capacityBlocks;
    }

    public synchronized DeviceDescriptor getDevice(int device) {
        return (DeviceDescriptor)this.deviceArray[device].clone();
    }

    public synchronized ArrayList getDeviceList() {
        ArrayList<Object> requestedDeviceList = new ArrayList<Object>();
        int device = 0;
        while (device < this.deviceArray.length) {
            if (!this.deviceArray[device].status.equals("Unknown")) {
                requestedDeviceList.add(this.deviceArray[device].clone());
            }
            ++device;
        }
        return requestedDeviceList;
    }

    public synchronized ArrayList getLegacySegmentList(String[] statuses) {
        ArrayList<Object> requestedSegmentList = new ArrayList<Object>();
        ArrayList deviceList = this.getDeviceList();
        int lastIndex = deviceList.size();
        if (lastIndex > 4) {
            lastIndex = 4;
        }
        int deviceIndex = 0;
        while (deviceIndex < lastIndex) {
            DeviceDescriptor device = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (!device.status.equals("Empty")) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)device.segmentArray.get(0);
                try {
                    if (segmentDescriptor != null && Integer.parseInt(segmentDescriptor.startingPlbn, 16) == 0) {
                        int count = 0;
                        while (count < statuses.length) {
                            if (statuses[count].equals(segmentDescriptor.status)) {
                                requestedSegmentList.add(segmentDescriptor.clone());
                            }
                            ++count;
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorLog.put(exception, "");
                }
            }
            ++deviceIndex;
        }
        return requestedSegmentList;
    }

    public synchronized int getNumberOfLegacySpares() {
        ArrayList segmentList = this.getSegmentList(this.legacySegmentStatuses);
        return segmentList.size();
    }

    public synchronized int getNumberOfNewSpares() {
        ArrayList segmentList = this.getSegmentList(this.newSegmentStatuses);
        return segmentList.size();
    }

    public synchronized ArrayList getRebuildSegmentList(int raidGroup) {
        ArrayList segmentList = this.getSegmentList(this.segmentStatuses);
        int index = 0;
        while (index < segmentList.size()) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(index);
            DeviceDescriptor deviceDescriptor = this.getDevice(Integer.parseInt(segmentDescriptor.device));
            if (deviceDescriptor.status.equals("Healthy")) {
                int segment = 0;
                while (segment < deviceDescriptor.segmentArray.size()) {
                    SegmentDescriptor devSegmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segment);
                    if (!devSegmentDescriptor.raidGroup.equals("N/A")) {
                        RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(devSegmentDescriptor.raidGroup));
                        if (raidGroupDescriptor.raidGroup == raidGroup && (raidGroupDescriptor.status.equals("Online") || raidGroupDescriptor.status.equals("Reduced"))) {
                            segmentList.remove(index--);
                            break;
                        }
                    }
                    ++segment;
                }
            }
            ++index;
        }
        return segmentList;
    }

    public synchronized ArrayList getSegmentList(String[] statuses) {
        ArrayList<Object> requestedSegmentList = new ArrayList<Object>();
        int device = 0;
        while (device < this.deviceArray.length) {
            if (!this.deviceArray[device].status.equals("Unknown")) {
                int index = 0;
                while (index < this.deviceArray[device].segmentArray.size()) {
                    SegmentDescriptor segmentDescriptor = (SegmentDescriptor)this.deviceArray[device].segmentArray.get(index);
                    if (statuses == null) {
                        requestedSegmentList.add(segmentDescriptor.clone());
                    } else {
                        int count = 0;
                        while (count < statuses.length) {
                            if (statuses[count].equals(segmentDescriptor.status)) {
                                requestedSegmentList.add(segmentDescriptor.clone());
                            }
                            ++count;
                        }
                    }
                    ++index;
                }
            }
            ++device;
        }
        return requestedSegmentList;
    }

    public void initialize() {
        super.initialize();
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        this.deviceArray = new DeviceDescriptor[controllerDescriptor.pathIdCount * controllerDescriptor.targetIdCount];
        int device = 0;
        int pathId = 0;
        while (pathId < controllerDescriptor.pathIdCount) {
            int TargetId = 0;
            while (TargetId < controllerDescriptor.targetIdCount) {
                this.deviceArray[device] = new DeviceDescriptor(pathId, TargetId, device++);
                ++TargetId;
            }
            ++pathId;
        }
        this.getFirst();
    }

    public synchronized boolean legacyBootSupportable() {
        return this.getBootableSegmentCount() > 0;
    }

    public synchronized boolean legacySpareExists() {
        ArrayList segmentList = this.getSegmentList(this.legacySegmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized boolean newSpareExists() {
        ArrayList segmentList = this.getSegmentList(this.newSegmentStatuses);
        return segmentList.size() > 0;
    }

    public synchronized void nuke() {
        super.nuke();
        ControllerDescriptor controllerDescriptor = this.databaseManager.getSelectedController();
        int device = 0;
        int pathId = 0;
        while (pathId < controllerDescriptor.pathIdCount) {
            int TargetId = 0;
            while (TargetId < controllerDescriptor.targetIdCount) {
                this.deviceArray[device] = new DeviceDescriptor(pathId, TargetId, device++);
                ++TargetId;
            }
            ++pathId;
        }
        this.notifyListeners();
    }

    public synchronized boolean orphanedSegmentExists() {
        String[] segmentStatuses = new String[]{"Orphan"};
        ArrayList segmentList = this.getSegmentList(segmentStatuses);
        return segmentList.size() > 0;
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing && faultDescriptor.reason.equals("None Found")) {
                        this.initializationComplete();
                    }
                } else if (xmlData.element.equals("DeviceInfo")) {
                    DeviceDescriptor deviceDescriptor;
                    this.deviceArray[deviceDescriptor.device] = deviceDescriptor = new DeviceDescriptor(xmlData.elementValue);
                    if (this.initializing) {
                        this.getNext(deviceDescriptor.device);
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "DeviceDatabase Exception\nMessage " + message.response);
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            int device = 0;
            while (device < this.deviceArray.length) {
                this.deviceArray[device].receivedUpdateCount = false;
                ++device;
            }
            XmlData xmlData = new XmlData(data);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("DeviceUpdateCount")) continue;
                String device2 = null;
                String updateCount = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("Device")) {
                        device2 = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    updateCount = updateXmlData.elementValue;
                }
                if (device2 == null || updateCount == null) continue;
                DeviceDescriptor deviceDescriptor = this.deviceArray[Integer.parseInt(device2)];
                deviceDescriptor.receivedUpdateCount = true;
                if (deviceDescriptor.updateCount.equals(updateCount)) continue;
                this.getThis(Integer.parseInt(device2));
            }
            int device3 = 0;
            while (device3 < this.deviceArray.length) {
                if (!(this.deviceArray[device3].receivedUpdateCount || this.deviceArray[device3].status.equals("Failed") || this.deviceArray[device3].status.equals("Unused"))) {
                    this.getThis(device3);
                }
                ++device3;
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "Device Database Process Update Counts Exception\nController " + data);
        }
    }

    public synchronized boolean rebuildSegmentExists(int raidGroup) {
        ArrayList segmentList = this.getRebuildSegmentList(raidGroup);
        return segmentList.size() > 0;
    }

    public void snapshot(FileOutputStream outputStream) {
    }
}

