/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public class DeviceChannelPanel
extends JPanel
implements MouseListener,
GlobalConstants {
    int COLUMN_OFFSET = 48;
    int COLUMN_WIDTH = 50;
    final int HORIZONTAL_OFFSET = 20;
    int ROW_HEIGHT = 30;
    int ROW_OFFSET = 36;
    final int SLOT_BORDER_WIDTH = 4;
    int SLOT_HEIGHT;
    int SLOT_WIDTH;
    int TITLE_WIDTH = 30;
    final int VERTICAL_OFFSET = 30;
    DatabaseManager databaseManager;
    Runnable deviceDatabaseChangeHandler;
    final String emptyString = "Empty";
    JTree jTree1;
    boolean popupEnabled;
    int raidGroupInFocus = -1;
    StorageManagementUtility storageManagementUtility;
    Color textColor = Color.black;

    public DeviceChannelPanel(StorageManagementUtility storageManagementUtility, DatabaseManager databaseManager) {
        this.jTree1 = new JTree();
        this.storageManagementUtility = storageManagementUtility;
        this.databaseManager = databaseManager;
        ImageIconLoader imageIconLoader = new ImageIconLoader();
        this.SLOT_WIDTH = 102;
        this.SLOT_HEIGHT = 500;
        this.popupEnabled = true;
        this.deviceDatabaseChangeHandler = new DeviceDatabaseChangeHandler();
        databaseManager.deviceDatabase.addUpdateListener(this.deviceDatabaseChangeHandler);
        Dimension d = new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
        this.setPreferredSize(d);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseListener(this);
        ControllerUpdateListener controllerUpdateListener = new ControllerUpdateListener();
        databaseManager.deviceDatabase.addUpdateListener(controllerUpdateListener);
        databaseManager.raidGroupDatabase.addUpdateListener(controllerUpdateListener);
        databaseManager.controllerDatabase.addUpdateListener(controllerUpdateListener);
    }

    public void finalize() {
        this.databaseManager.deviceDatabase.removeUpdateListener(this.deviceDatabaseChangeHandler);
    }

    public int getHorizontalScrollUnitIncrement() {
        return this.SLOT_WIDTH;
    }

    public int getPreferredHeight() {
        return 500;
    }

    public int getPreferredWidth() {
        return 480;
    }

    public int getVerticalScrollUnitIncrement() {
        return this.SLOT_HEIGHT;
    }

    public void highlightRaidGroupHandler(int raidGroup) {
        this.raidGroupInFocus = raidGroup;
        SwingUtilities.invokeLater(this.deviceDatabaseChangeHandler);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int verticalOffset = 30;
        int horizontalOffset = 20;
        int segmentHeight = 50;
        Font hexFont = new Font("Dialog", 0, 12);
        FontMetrics fontMetrics = g.getFontMetrics(hexFont);
        g.setFont(hexFont);
        Point topLeft = new Point(horizontalOffset, verticalOffset);
        Point topRight = new Point(horizontalOffset + 4, verticalOffset);
        int count = 0;
        while (count < 4) {
            int length = this.SLOT_HEIGHT;
            DeviceDescriptor deviceDescriptor = this.databaseManager.deviceDatabase.getDevice(count);
            if (deviceDescriptor.status.equals("Empty")) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.lightGray);
            }
            g.fillRect(topLeft.x, topLeft.y, this.SLOT_WIDTH, this.SLOT_HEIGHT);
            g.setColor(Color.black);
            g.drawRect(topLeft.x, topLeft.y, this.SLOT_WIDTH, this.SLOT_HEIGHT);
            g.drawString("Device " + count, topLeft.x, topLeft.y - 5);
            int index = 0;
            while (index < deviceDescriptor.segmentArray.size()) {
                RaidGroupDescriptor raidGroupDescriptor;
                SegmentDescriptor segment = (SegmentDescriptor)deviceDescriptor.segmentArray.get(index);
                if (segment.status.equals("Member")) {
                    raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segment.raidGroup));
                    g.setColor(Color.green);
                    if (raidGroupDescriptor.status.equals("Reduced")) {
                        g.setColor(Color.yellow);
                    }
                    g.fillRect(topLeft.x, topLeft.y + segmentHeight * index, this.SLOT_WIDTH, length);
                    g.setColor(this.textColor);
                    if (raidGroupDescriptor.metadataFormat.equals("Old")) {
                        g.drawString("Legacy RG " + segment.raidGroup, topLeft.x + 6, topLeft.y + 16 + segmentHeight * index);
                    } else {
                        g.drawString(raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")", topLeft.x + 6, topLeft.y + 16 + segmentHeight * index);
                    }
                    g.drawString(raidGroupDescriptor.configuration, topLeft.x + 6, topLeft.y + 44 + segmentHeight * index);
                    if (raidGroupDescriptor.raidGroup == this.raidGroupInFocus) {
                        if (raidGroupDescriptor.metadataFormat.equals("Old")) {
                            g.drawRect(topLeft.x + 1, topLeft.y + segmentHeight * index - 1, this.SLOT_WIDTH - 2, length);
                            g.drawRect(topLeft.x + 2, topLeft.y + segmentHeight * index - 2, this.SLOT_WIDTH - 4, length);
                        } else {
                            g.drawRect(topLeft.x + 1, topLeft.y + segmentHeight * index - 1, this.SLOT_WIDTH - 2, segmentHeight);
                            g.drawRect(topLeft.x + 2, topLeft.y + segmentHeight * index - 2, this.SLOT_WIDTH - 4, segmentHeight);
                        }
                    }
                } else if (segment.status.endsWith("Spare")) {
                    g.setColor(Color.green.darker());
                    if (segment.status.startsWith("Dedicated")) {
                        raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(Integer.parseInt(segment.raidGroup));
                        g.fillRect(topLeft.x, topLeft.y + segmentHeight * index, this.SLOT_WIDTH, length);
                        g.setColor(this.textColor);
                        if (raidGroupDescriptor.metadataFormat.equals("Old")) {
                            g.drawString("Legacy RG " + segment.raidGroup, topLeft.x + 6, topLeft.y + 16 + segmentHeight * index);
                        } else {
                            g.drawString(raidGroupDescriptor.label + " (RG" + raidGroupDescriptor.raidGroup + ")", topLeft.x + 6, topLeft.y + 16 + segmentHeight * index);
                        }
                        g.setColor(Color.white);
                    } else {
                        g.fillRect(topLeft.x, topLeft.y + segmentHeight * index, this.SLOT_WIDTH, length);
                        g.setColor(this.textColor);
                    }
                    g.setColor(this.textColor);
                    g.drawString(segment.status, topLeft.x + 6, topLeft.y + 44 + segmentHeight * index);
                } else {
                    g.setColor(Color.lightGray);
                    g.fillRect(topLeft.x, topLeft.y + segmentHeight * index, this.SLOT_WIDTH, length);
                    g.setColor(this.textColor);
                    g.drawString(segment.status, topLeft.x + 6, topLeft.y + 44 + segmentHeight * index);
                }
                g.setColor(this.textColor);
                g.drawRect(topLeft.x, topLeft.y + segmentHeight * index, this.SLOT_WIDTH, length);
                g.drawString(segment.capacity, topLeft.x + 6, topLeft.y + 30 + segmentHeight * index);
                length -= segmentHeight;
                ++index;
            }
            topLeft.x += this.SLOT_WIDTH + 20;
            ++count;
        }
    }

    public void setPopupEnabled(boolean enabled) {
        this.popupEnabled = enabled;
    }

    public void setSelected(int slot) {
    }

    private class DeviceDatabaseChangeHandler
    implements Runnable {
        private DeviceDatabaseChangeHandler() {
        }

        public void run() {
            DeviceChannelPanel.this.repaint();
        }
    }

    private class ControllerUpdateListener
    implements Runnable {
        private ControllerUpdateListener() {
        }

        public void run() {
            DeviceChannelPanel.this.repaint();
        }
    }
}

