/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteRaidGroupBox
extends KDialog {
    String metadataFormat;
    private RaidGroupTable raidGroupTable;
    private RemoveMultipleThread removeMultipleThread;
    private RemovePopUpBox removePopUpBox;
    private RemovePopUpThread removePopUpThread;
    private RemoveSingleThread removeSingleThread;
    private int selectedRaidGroup;

    public DeleteRaidGroupBox(DatabaseManager databaseManager, int selectedRaidGroup, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.metadataFormat = metadataFormat;
        this.selectedRaidGroup = selectedRaidGroup;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        this.removePopUpThread = new RemovePopUpThread();
        this.removePopUpThread.start();
        this.removeSingleThread = new RemoveSingleThread();
        this.removeSingleThread.start();
    }

    public DeleteRaidGroupBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildRaidGroupTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton deleteButton = new JButton("Delete");
        JButton cancelButton = new JButton("Cancel");
        deleteButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(DeleteRaidGroupBox.this, "Are you sure you want to delete specified RAID Group(s)?", "Delete RAID Group Verification", 0);
                if (answer == 0) {
                    DeleteRaidGroupBox.this.sendRequest();
                }
                DeleteRaidGroupBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(deleteButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildRaidGroupTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.raidGroupTable = new RaidGroupTable(this.databaseManager, this.preferences, 12, this.metadataFormat);
        tablePanel.add(new JLabel("Select RAID Groups(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.raidGroupTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    protected void closeDialog() {
        System.out.println("DeleteRaidGroup: closeDialog() entered");
        this.raidGroupTable.dispose();
        this.dispose();
    }

    public void sendRequest(int raidGroup) {
        String request = "<si:Request><si:Type>DeleteRaidGroup</si:Type><si:RaidGroupParams><si:RaidGroup>" + raidGroup + "</si:RaidGroup>" + "</si:RaidGroupParams>" + "</si:Request>";
        System.out.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(DeleteRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Delete RAID Group Error");
                }
                DeleteRaidGroupBox.this.databaseManager.refresh();
            }
        };
        int controller = this.storageManagementUtility.hostConnectionManager.getNexusController();
        RaidGroupDescriptor raidDescriptor = this.databaseManager.raidGroupDatabase.get(raidGroup);
        this.storageManagementUtility.commManager.commLink.removeDriveDirect(controller, raidDescriptor.logicalPathId, raidDescriptor.logicalTargetId);
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private void sendRequest() {
        this.removePopUpThread = new RemovePopUpThread();
        this.removePopUpThread.start();
        this.removeMultipleThread = new RemoveMultipleThread();
        this.removeMultipleThread.start();
    }

    private class RemoveMultipleThread
    extends Thread {
        private RemoveMultipleThread() {
        }

        public void run() {
            DeleteRaidGroupBox.this.storageManagementUtility.setWait();
            DeleteRaidGroupBox.this.setCursor(new Cursor(3));
            ArrayList raidGroupList = DeleteRaidGroupBox.this.raidGroupTable.getSelectedRaidGroups();
            int count = 0;
            while (count < raidGroupList.size()) {
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(count);
                DeleteRaidGroupBox.this.sendRequest(raidGroupDescriptor.raidGroup);
                ++count;
            }
            DeleteRaidGroupBox.this.setCursor(new Cursor(0));
            DeleteRaidGroupBox.this.storageManagementUtility.clearWait();
            DeleteRaidGroupBox.this.removePopUpBox.closeRemovePopUpBox();
        }
    }

    private class RemoveSingleThread
    extends Thread {
        private RemoveSingleThread() {
        }

        public void run() {
            DeleteRaidGroupBox.this.storageManagementUtility.setWait();
            DeleteRaidGroupBox.this.setCursor(new Cursor(3));
            DeleteRaidGroupBox.this.sendRequest(DeleteRaidGroupBox.this.selectedRaidGroup);
            DeleteRaidGroupBox.this.setCursor(new Cursor(0));
            DeleteRaidGroupBox.this.storageManagementUtility.clearWait();
            DeleteRaidGroupBox.this.removePopUpBox.closeRemovePopUpBox();
        }
    }

    private class RemovePopUpThread
    extends Thread {
        private RemovePopUpThread() {
        }

        public void run() {
            DeleteRaidGroupBox.this.removePopUpBox = new RemovePopUpBox(DeleteRaidGroupBox.this.databaseManager, "Removing deleted RAID Groups");
            DeleteRaidGroupBox.this.removePopUpBox.repaint();
        }
    }
}

