/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteOrphanBox
extends KDialog {
    String metadataFormat;
    private SegmentTable orphanTable;
    private String segmentFields = "Device,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Orphan"};
    private ArrayList spareList;

    public DeleteOrphanBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildSegmentTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton deleteButton = new JButton("Delete");
        JButton cancelButton = new JButton("Cancel");
        deleteButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(DeleteOrphanBox.this, "Are you sure you want to delete specified Orphan(s)?", "Delete Orphan Verification", 0);
                if (answer == 0) {
                    DeleteOrphanBox.this.sendRequest();
                }
                DeleteOrphanBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteOrphanBox.this.closeDialog();
            }
        });
        buttonPanel.add(deleteButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.orphanTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, this.metadataFormat);
        tablePanel.add(new JLabel("Select Orphan(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.orphanTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    protected void closeDialog() {
        this.orphanTable.dispose();
        this.dispose();
    }

    protected void completeDialogInit(boolean autoCenter) {
        this.pack();
        Rectangle rectangle = Utility.getCenteredBounds(this);
        if (!autoCenter && this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DeleteOrphanBox.this.closeDialog();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private void sendRequest() {
        ArrayList selectedList = this.orphanTable.getSelectedSegments();
        int selectedIndex = 0;
        while (selectedIndex < selectedList.size()) {
            SegmentDescriptor segment = (SegmentDescriptor)selectedList.get(selectedIndex);
            String request = "<si:Request><si:Type>DeleteOrphan</si:Type><si:OrphanParams><si:Device>" + segment.device + "</si:Device>" + "<si:StartingPlbn>" + segment.startingPlbn + "</si:StartingPlbn>" + "</si:OrphanParams>" + "</si:Request>";
            System.out.println(request);
            AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

                public void handleMessage(Message message) {
                    DeleteOrphanBox.this.databaseManager.refresh();
                    DeleteOrphanBox.this.storageManagementUtility.clearWait();
                    XmlData xmlData = new XmlData(message.response);
                    if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(DeleteOrphanBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Delete Orphan Error");
                    }
                }
            };
            this.storageManagementUtility.setWait();
            this.commManager.sendMessage("Execute", request, responseMessageHandler);
            ++selectedIndex;
        }
    }
}

