/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class DatabaseManager
implements GlobalConstants {
    public static boolean RemoteAccessAllowed = false;
    public static boolean RemoteAccessWanted = false;
    public CommManager commManager;
    public ControllerDatabase controllerDatabase;
    private AbstractDatabase[] databaseComponents;
    public DeviceDatabase deviceDatabase;
    public EventDatabase eventDatabase;
    public HostConnectionManager hostConnectionManager;
    static CommLinkChangeEvent localEvent;
    public int maximumRaidGroups;
    private boolean outstandingUpdateCountRequest;
    private boolean pendingUpdateCountRequest;
    public RaidGroupDatabase raidGroupDatabase;
    public int selectedController;
    public boolean snapshot;
    public int state;
    public StorageManagementUtility storageManagementUtility;
    public TaskDatabase taskDatabase;
    private Timer updateCountPollTimer;

    public DatabaseManager(StorageManagementUtility storageManagementUtility, HostConnectionManager hostConnectionManager) {
        this.storageManagementUtility = storageManagementUtility;
        this.hostConnectionManager = hostConnectionManager;
        this.commManager = hostConnectionManager.commManager;
        this.maximumRaidGroups = 0;
        this.controllerDatabase = new ControllerDatabase(this);
        this.deviceDatabase = new DeviceDatabase(this);
        this.raidGroupDatabase = new RaidGroupDatabase(this);
        this.taskDatabase = new TaskDatabase(this);
        this.eventDatabase = new EventDatabase(this);
        this.databaseComponents = new AbstractDatabase[5];
        this.databaseComponents[0] = this.controllerDatabase;
        this.databaseComponents[1] = this.deviceDatabase;
        this.databaseComponents[2] = this.raidGroupDatabase;
        this.databaseComponents[3] = this.taskDatabase;
        this.databaseComponents[4] = this.eventDatabase;
        localEvent = new CommLinkChangeEvent();
        LinkChangeListener changeListener = new LinkChangeListener();
        this.commManager.addChangeListener(changeListener);
        ControllerUpdateListener controllerUpdateListener = new ControllerUpdateListener();
        this.controllerDatabase.addUpdateListener(controllerUpdateListener);
        this.updateCountPollTimer = new Timer(5000, new TimerActionListener());
        this.startUpInitialization();
    }

    public int getControllerCount() {
        return this.commManager.getControllerCount();
    }

    public Nexus getNexus() {
        return this.hostConnectionManager.getNexus();
    }

    public int getNexusController() {
        return this.hostConnectionManager.getNexusController();
    }

    public String getNexusIpAddress() {
        return this.hostConnectionManager.getNexusIpAddress();
    }

    public ControllerDescriptor getSelectedController() {
        return this.controllerDatabase.getConnectedController();
    }

    private void getUpdateCounts(boolean first) {
        String request = "<si:Request><si:Type>MasterUpdateCounts</si:Type></si:Request>";
        this.outstandingUpdateCountRequest = true;
        this.commManager.sendMessage("Get", request, new UpdateCountMessageHandler(first));
    }

    public synchronized void initializationComplete(String completionSource) {
        if (completionSource.equals("UpdateCounts")) {
            this.controllerDatabase.initialize();
        } else if (completionSource.equals("ControllerDatabase")) {
            this.deviceDatabase.initialize();
        } else if (completionSource.equals("DeviceDatabase")) {
            this.raidGroupDatabase.initialize();
        } else if (completionSource.equals("RaidGroupDatabase")) {
            this.taskDatabase.initialize();
        } else if (completionSource.equals("TaskDatabase")) {
            this.eventDatabase.initialize();
        } else if (completionSource.equals("EventDatabase")) {
            this.state = 3;
            this.storageManagementUtility.databaseInitialized();
            this.eventDatabase.UpdateApplicationEvents("Informational", "Database initialized..");
        }
    }

    public boolean isNexusLocal() {
        return this.hostConnectionManager.getNexusLocal();
    }

    public void nukeDatabase() {
        System.out.println("nukeDatabase() entered");
        this.updateCountPollTimer.stop();
        int index = 0;
        while (index < this.databaseComponents.length) {
            this.databaseComponents[index].nuke();
            ++index;
        }
        this.maximumRaidGroups = 0;
        this.state = 0;
    }

    public void refresh() {
        this.getUpdateCounts(false);
    }

    private void resumeDatabase() {
        System.out.println("resumeDatabase() entered");
        this.getUpdateCounts(false);
        int index = 0;
        while (index < this.databaseComponents.length) {
            this.databaseComponents[index].resume();
            ++index;
        }
        this.updateCountPollTimer.start();
        this.state = 3;
    }

    private void startUpInitialization() {
        if (this.getControllerCount() == 0) {
            RemoteAccessAllowed = false;
            RemoteAccessWanted = true;
        }
        this.state = 1;
        this.updateCountPollTimer.start();
        this.getUpdateCounts(true);
    }

    private void suspendDatabase() {
        System.out.println("suspendDatabase() entered");
        this.updateCountPollTimer.stop();
        int index = 0;
        while (index < this.databaseComponents.length) {
            this.databaseComponents[index].suspend();
            ++index;
        }
        this.state = 2;
    }

    private class LinkChangeListener
    extends CommLinkChangeListener {
        private LinkChangeListener() {
        }

        public void linkDown(CommLinkChangeEvent event) {
            System.out.println("LinkChangeListener(): linkDown() entered");
            if (DatabaseManager.this.state == 3) {
                DatabaseManager.this.suspendDatabase();
            } else if (DatabaseManager.this.state == 1) {
                DatabaseManager.this.nukeDatabase();
            }
            event.copyTo(localEvent);
        }

        public void linkUp(CommLinkChangeEvent event) {
            System.out.println("LinkChangeListener(): linkUp() entered");
            if (!localEvent.same(event)) {
                event.copyTo(localEvent);
                DatabaseManager.this.nukeDatabase();
                DatabaseManager.this.hostConnectionManager.setNexusToConnection(event.local, event.ipAddress, event.controller);
                DatabaseManager.this.startUpInitialization();
            } else if (DatabaseManager.this.state == 2) {
                DatabaseManager.this.resumeDatabase();
            }
        }
    }

    private class ControllerUpdateListener
    extends AbstractListener {
        private ControllerUpdateListener() {
        }

        public void processChange() {
            System.out.println("ControllerUpdateListener(): processChange() entered");
            ControllerDescriptor controllerDescriptor = DatabaseManager.this.controllerDatabase.getConnectedController();
            DatabaseManager.this.maximumRaidGroups = controllerDescriptor.maxRaidGroups;
        }
    }

    private class UpdateCountMessageHandler
    extends AbstractMessageHandler {
        boolean firstTime;
        final String[] updateCountNames = new String[]{"Controller", "Device", "RaidGroup", "Task", "Event"};
        long[] updateCounts;

        public UpdateCountMessageHandler(boolean firstTime) {
            this.firstTime = firstTime;
            this.updateCounts = new long[this.updateCountNames.length];
        }

        public void handleError(Message message) {
            DatabaseManager.this.outstandingUpdateCountRequest = false;
        }

        public void handleMessage(Message message) {
            DatabaseManager.this.outstandingUpdateCountRequest = false;
            try {
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    } else if (xmlData.element.equals("MasterUpdateCounts")) {
                        int index;
                        xmlData = new XmlData(xmlData.elementValue);
                        block2: while (xmlData.getNextElement()) {
                            index = 0;
                            while (index < this.updateCountNames.length) {
                                if (xmlData.element.equalsIgnoreCase(this.updateCountNames[index])) {
                                    this.updateCounts[index] = Long.parseLong(xmlData.elementValue);
                                    continue block2;
                                }
                                ++index;
                            }
                        }
                        if (this.firstTime) {
                            DatabaseManager.this.initializationComplete("UpdateCounts");
                            index = 0;
                            while (index < DatabaseManager.this.databaseComponents.length) {
                                DatabaseManager.this.databaseComponents[index].setInitialUpdateCount(this.updateCounts[index]);
                                ++index;
                            }
                        } else {
                            index = 0;
                            while (index < DatabaseManager.this.databaseComponents.length) {
                                DatabaseManager.this.databaseComponents[index].processUpdateCount(this.updateCounts[index]);
                                ++index;
                            }
                        }
                    }
                }
                if (DatabaseManager.this.pendingUpdateCountRequest) {
                    DatabaseManager.this.pendingUpdateCountRequest = false;
                    DatabaseManager.this.getUpdateCounts(false);
                }
            }
            catch (Exception exception) {
                ErrorLog.put(exception, "DatabaseManager Exception\nMessage " + message.response);
            }
        }
    }

    private class TimerActionListener
    implements ActionListener {
        private TimerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (DatabaseManager.this.state == 3) {
                DatabaseManager.this.getUpdateCounts(false);
            }
        }
    }
}

