/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateSpareBox
extends KDialog {
    private JPanel borderPanel;
    private int[] capacities;
    private JComboBox capacityComboBox;
    private String[] capacityStrings;
    private JButton createButton;
    private String[] metadataFormats;
    private JComboBox raidGroupComboBox;
    private RaidGroupComboBoxListener raidGroupComboBoxListener;
    private String[] raidGroupStrings;
    private String segmentFields = "Device,Capacity,Starting LBN";
    private String[] segmentStatuses;
    private SegmentTable segmentTable;
    private JComboBox spareTypeComboBox;
    private String[] spareTypeStrings = new String[]{"Global", "Dedicated"};
    private SpareUpdateListener spareUpdateListener;
    private String[] usedRaidGroupNumbers;

    public CreateSpareBox(DatabaseManager databaseManager, String title) {
        this.segmentStatuses = new String[]{"Available"};
        this.metadataFormats = new String[]{"New"};
        this.usedRaidGroupNumbers = new String[16];
        this.capacityStrings = new String[]{"128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "3 GB", "4 GB", "5 GB", "6 GB", "7 GB", "8 GB", "9 GB", "10 GB", "20 GB", "40 GB", "60 GB", "80 GB", "100 GB", "HALF", "MAX"};
        this.capacities = new int[]{262144, 524288, 0x100000, 0x200000, 0x400000, 0x600000, 0x800000, 0xA00000, 0xC00000, 0xE00000, 0x1000000, 0x1200000, 0x1400000, 0x2800000, 0x5000000, 0x7800000, 0xA000000, 0xC800000, -2, -1};
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildSpareTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.spareUpdateListener = new SpareUpdateListener();
        this.raidGroupComboBoxListener = new RaidGroupComboBoxListener();
        this.raidGroupComboBox.addActionListener(this.raidGroupComboBoxListener);
        databaseManager.raidGroupDatabase.addUpdateListener(this.spareUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.spareUpdateListener);
        this.usedRaidGroupNumbers = this.getRaidGroupNumbers();
        this.initializeParameterPanel(Integer.toString(databaseManager.maximumRaidGroups));
        this.completeDialogInit(true);
    }

    static /* synthetic */ String[] access$802(CreateSpareBox x0, String[] x1) {
        x0.usedRaidGroupNumbers = x1;
        return x1;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateSpareBox.this.sendRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateSpareBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildParametersPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        this.capacityComboBox.setEditable(true);
        this.capacityComboBox.setSelectedIndex(1);
        this.spareTypeComboBox = new JComboBox<String>(this.spareTypeStrings);
        Utility.addComponent(new JLabel("Spare Type:"), panel, layout, constraints, 0, 0, 0, 0, 8, 10, 0.0);
        Utility.addComponent(this.spareTypeComboBox, panel, layout, constraints, 1, 0, 0, 0, 4, 10, 1.0);
        this.raidGroupStrings = new String[this.databaseManager.maximumRaidGroups];
        this.raidGroupComboBox = new JComboBox<String>(this.getRaidGroupNumbers());
        Utility.addComponent(new JLabel("RAID Group:"), panel, layout, constraints, 0, 1, 9, 0, 8, 10, 0.0);
        Utility.addComponent(this.raidGroupComboBox, panel, layout, constraints, 1, 1, 9, 0, 4, 10, 1.0);
        this.raidGroupComboBox.setEnabled(false);
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        Utility.addComponent(new JLabel("Capacity:"), panel, layout, constraints, 0, 2, 9, 9, 8, 10, 0.0);
        Utility.addComponent(this.capacityComboBox, panel, layout, constraints, 1, 2, 9, 9, 4, 10, 1.0);
        Dimension dimension = this.spareTypeComboBox.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 1.5);
        this.spareTypeComboBox.setPreferredSize(dimension);
        this.raidGroupComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(panel);
        this.spareTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CreateSpareBox.this.spareTypeComboBox.isEnabled()) {
                    if (CreateSpareBox.this.spareTypeComboBox.getSelectedItem().equals("Global")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(false);
                    } else if (CreateSpareBox.this.spareTypeComboBox.getSelectedItem().equals("Dedicated")) {
                        CreateSpareBox.this.raidGroupComboBox.setEnabled(true);
                    }
                    CreateSpareBox.this.updateSegmentTable();
                }
            }
        });
        this.raidGroupComboBoxListener = new RaidGroupComboBoxListener();
        return this.borderPanel;
    }

    protected JPanel buildSpareTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "New");
        this.segmentTable.setSelectionMode(0);
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    protected void closeDialog() {
        System.out.println("closeDialog");
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.spareUpdateListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.spareUpdateListener);
        this.segmentTable.dispose();
        this.dispose();
    }

    private void disableDedicatedOption() {
        if (!this.borderPanel.isEnabled()) {
            return;
        }
        this.spareTypeComboBox.setEnabled(false);
        this.spareTypeComboBox.removeAllItems();
        this.spareTypeComboBox.addItem("Global");
        this.spareTypeComboBox.setSelectedIndex(0);
        this.spareTypeComboBox.setEnabled(true);
        this.raidGroupComboBox.setEnabled(false);
    }

    private String[] getRaidGroupNumbers() {
        int count = 0;
        String[] statuses = new String[]{"Dedicated Spare"};
        String[] usedRaidGroups = new String[16];
        usedRaidGroups = this.databaseManager.raidGroupDatabase.getUsedRaidGroupNumbers(this.metadataFormats, true);
        ArrayList dedicatedSpares = this.databaseManager.deviceDatabase.getSegmentList(statuses);
        int index = 0;
        while (index < usedRaidGroups.length) {
            boolean found = false;
            int spare = 0;
            while (spare < dedicatedSpares.size()) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)dedicatedSpares.get(spare);
                if (segmentDescriptor.raidGroup.equals(usedRaidGroups[index])) {
                    found = true;
                    break;
                }
                ++spare;
            }
            if (!found) {
                ++count;
            }
            ++index;
        }
        if (count == 0) {
            return new String[0];
        }
        String[] usedRaidGroupsNoSpare = new String[count];
        count = 0;
        int index2 = 0;
        while (index2 < usedRaidGroups.length) {
            boolean found = false;
            int spare = 0;
            while (spare < dedicatedSpares.size()) {
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)dedicatedSpares.get(spare);
                if (segmentDescriptor.raidGroup.equals(usedRaidGroups[index2])) {
                    found = true;
                    break;
                }
                ++spare;
            }
            if (!found) {
                usedRaidGroupsNoSpare[count++] = usedRaidGroups[index2];
            }
            ++index2;
        }
        return usedRaidGroupsNoSpare;
    }

    private void initializeParameterPanel(String raidToSkip) {
        int dimension = this.usedRaidGroupNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(this.databaseManager.maximumRaidGroups))) {
            ++dimension;
        }
        String[] newUsedRaidGroupNumbers = new String[dimension];
        this.raidGroupComboBox.removeActionListener(this.raidGroupComboBoxListener);
        this.raidGroupComboBox.removeAllItems();
        int index = 0;
        int i = 0;
        while (i < this.usedRaidGroupNumbers.length) {
            if (!raidToSkip.equals(this.usedRaidGroupNumbers[i])) {
                this.raidGroupComboBox.addItem(this.usedRaidGroupNumbers[i]);
                newUsedRaidGroupNumbers[index++] = this.usedRaidGroupNumbers[i];
            }
            ++i;
        }
        this.usedRaidGroupNumbers = newUsedRaidGroupNumbers;
        this.raidGroupComboBox.addActionListener(this.raidGroupComboBoxListener);
        if (this.usedRaidGroupNumbers.length == 0) {
            this.disableDedicatedOption();
        }
        this.updateSegmentTable();
    }

    private void sendRequest() {
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        String spareType = (String)this.spareTypeComboBox.getSelectedItem();
        String capacityString = (String)this.capacityComboBox.getSelectedItem();
        int capacityIndex = 0;
        capacityIndex = 0;
        while (capacityIndex < this.capacityStrings.length) {
            if (capacityString.equals(this.capacityStrings[capacityIndex])) break;
            ++capacityIndex;
        }
        int capacityBlocks = this.capacities[capacityIndex];
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(0);
        String request = "<si:Request><si:Type>CreateSpare</si:Type><si:SpareParams><si:Type>" + spareType + "</si:Type>" + "<si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>";
        if (spareType.equals("Dedicated")) {
            request = request + "<si:RaidGroup>" + (String)this.raidGroupComboBox.getSelectedItem() + "</si:RaidGroup>";
        }
        request = request + "</si:SpareParams>";
        request = request + "</si:Request>";
        System.out.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateSpareBox.this.databaseManager.refresh();
                CreateSpareBox.this.setCursor(new Cursor(0));
                CreateSpareBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement()) {
                    if (xmlData.element.equals("Fault")) {
                        FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                        new ErrorMessageBox(CreateSpareBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Spare Error");
                    } else if (CreateSpareBox.this.databaseManager.deviceDatabase.getNumberOfNewSpares() >= CreateSpareBox.this.databaseManager.maximumRaidGroups - 1) {
                        CreateSpareBox.this.setControlCompoundPanel(false);
                        CreateSpareBox.this.createButton.setEnabled(false);
                    } else if (((String)CreateSpareBox.this.spareTypeComboBox.getSelectedItem()).equals("Dedicated")) {
                        CreateSpareBox.this.initializeParameterPanel((String)CreateSpareBox.this.raidGroupComboBox.getSelectedItem());
                    }
                }
            }
        };
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private void setControlCompoundPanel(boolean control) {
        this.spareTypeComboBox.setEnabled(control);
        this.raidGroupComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
    }

    private void updateSegmentTable() {
        if (this.spareTypeComboBox.getSelectedItem().equals("Dedicated")) {
            int raidGroup = Integer.parseInt((String)this.raidGroupComboBox.getSelectedItem());
            this.segmentTable.segmentTableSpareUpdate(raidGroup);
        } else {
            this.segmentTable.segmentTableUpdate();
        }
    }

    private class SpareUpdateListener
    implements Runnable {
        private SpareUpdateListener() {
        }

        public void run() {
            String[] newUsedRaidGroupNumbers = CreateSpareBox.this.getRaidGroupNumbers();
            String[] segmentStatuses = new String[]{"Dedicated Spare"};
            ArrayList segmentList = CreateSpareBox.this.databaseManager.deviceDatabase.getSegmentList(segmentStatuses);
            int spareTypeIndex = CreateSpareBox.this.spareTypeComboBox.getSelectedIndex();
            if (newUsedRaidGroupNumbers.length == 0) {
                CreateSpareBox.this.disableDedicatedOption();
            } else {
                if (CreateSpareBox.this.spareTypeComboBox.getItemCount() == 1) {
                    CreateSpareBox.this.spareTypeComboBox.setEnabled(false);
                    CreateSpareBox.this.spareTypeComboBox.removeAllItems();
                    CreateSpareBox.this.spareTypeComboBox.addItem("Global");
                    CreateSpareBox.this.spareTypeComboBox.addItem("Dedicated");
                    CreateSpareBox.this.spareTypeComboBox.setSelectedIndex(0);
                    CreateSpareBox.this.spareTypeComboBox.setEnabled(true);
                }
                CreateSpareBox.access$802(CreateSpareBox.this, newUsedRaidGroupNumbers);
            }
            CreateSpareBox.this.updateSegmentTable();
        }
    }

    private class RaidGroupComboBoxListener
    implements ActionListener {
        private RaidGroupComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CreateSpareBox.this.updateSegmentTable();
        }
    }
}

