/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class CreateRaidGroupBox
extends KDialog
implements GlobalConstants {
    private JPanel advancedFeatures;
    private JPanel advancedPanel;
    private String[] availableRaidGroupNumbers;
    private JPanel borderPanel;
    private JPanel buttonPanel;
    private int[] capacities;
    private JComboBox capacityComboBox;
    private CapacityComboBoxPollingThread capacityComboBoxPollingThread;
    private String[] capacityStrings;
    private JComboBox chunkSizeComboBox;
    private String[] chunkSizeStrings;
    private int[] chunkSizes;
    private JPanel compoundPanel;
    private ConfigComboBoxListener configComboBoxListener;
    private JComboBox configurationComboBox;
    private String[] configurationStrings = new String[]{"Contiguous", "Striped", "Mirrored", "Mirrored Striped", "Parity RAID"};
    private JButton createButton;
    private boolean improperShutdownBoxVisible;
    private String[] memberCountStrings;
    private JPanel parameterPanel;
    private JRadioButton[] parityMethodButton;
    private JPanel parityPanel;
    private String[] priorityStrings;
    private String raidGroup;
    private JTextField raidGroupLabelField;
    private JComboBox raidGroupNumberComboBox;
    private JPanel raidGroupPanel;
    private String[] raidGroupStatuses;
    private RaidGroupUpdateListener raidGroupUpdateListener;
    private JComboBox rebuildPriorityComboBox;
    private boolean responseOk;
    private JRadioButton[] restoreMethodButton;
    private JPanel restorePanel;
    private String segmentFields = "Device,Capacity,Starting LBN";
    private JPanel segmentPanel;
    private String[] segmentStatuses;
    private SegmentTable segmentTable;

    public CreateRaidGroupBox(DatabaseManager databaseManager, String title) {
        this.chunkSizeStrings = new String[]{"8 KB", "16 KB", "32 KB", "64 KB", "128 KB"};
        this.chunkSizes = new int[]{16, 32, 64, 128, 256};
        this.memberCountStrings = new String[]{"1", "2", "3", "4"};
        this.priorityStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.segmentStatuses = new String[]{"Available"};
        this.raidGroupStatuses = new String[]{"Online", "Reduced"};
        this.availableRaidGroupNumbers = new String[16];
        this.capacityStrings = new String[]{"1 GB", "2 GB", "3 GB", "4 GB", "5 GB", "6 GB", "7 GB", "8 GB", "9 GB", "10 GB", "20 GB", "40 GB", "60 GB", "80 GB", "100 GB", "HALF", "MAX"};
        this.capacities = new int[]{0x200000, 0x400000, 0x600000, 0x800000, 0xA00000, 0xC00000, 0xE00000, 0x1000000, 0x1200000, 0x1400000, 0x2800000, 0x5000000, 0x7800000, 0xA000000, 0xC800000, -2, -1};
        this.beginDialogInit(databaseManager, title, true);
        this.raidGroupPanel = this.buildRaidGroupPanel();
        this.segmentPanel = this.buildSegmentTablePanel();
        this.buttonPanel = this.buildButtonPanel();
        this.getContentPane().add((Component)this.raidGroupPanel, "North");
        this.getContentPane().add((Component)this.segmentPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.configComboBoxListener = new ConfigComboBoxListener();
        this.raidGroupLabelField.addCaretListener(new LabelFieldCaretListener());
        this.raidGroupUpdateListener = new RaidGroupUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.raidGroupUpdateListener);
        this.availableRaidGroupNumbers = databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers();
        this.initializeParameterPanel(Integer.toString(databaseManager.maximumRaidGroups));
        this.capacityComboBox.getEditor().getEditorComponent().addKeyListener(new CapacityComboKeyListener());
        this.capacityComboBox.setEditable(true);
        this.createButton.setEnabled(false);
        this.capacityComboBoxPollingThread = new CapacityComboBoxPollingThread();
        this.capacityComboBoxPollingThread.start();
        this.storageManagementUtility.createdRaidGroupCount = 0;
        this.completeDialogInit(true);
    }

    static /* synthetic */ JComboBox access$1400(CreateRaidGroupBox x0) {
        return x0.capacityComboBox;
    }

    static /* synthetic */ String[] access$902(CreateRaidGroupBox x0, String[] x1) {
        x0.availableRaidGroupNumbers = x1;
        return x1;
    }

    protected JPanel buildAdvancedFeaturesPanel() {
        this.initializeAdvancedPanel();
        this.restorePanel = this.buildRestoreMethodPanel();
        this.parityPanel = this.buildParityMethodPanel();
        this.advancedPanel = new JPanel();
        this.advancedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Improper Shutdown Policy"));
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 0));
        this.advancedPanel.add(this.restorePanel);
        this.advancedPanel.add(this.parityPanel);
        JPanel returnPanel = new JPanel();
        returnPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        returnPanel.add(this.advancedPanel);
        Dimension dimA = this.advancedPanel.getPreferredSize();
        Dimension dimB = this.compoundPanel.getPreferredSize();
        dimB.width = dimA.width;
        this.compoundPanel.setPreferredSize(dimB);
        return returnPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.sendCreateRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildParametersPanel() {
        this.compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        this.compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.raidGroupLabelField = new LengthTextField("", 10, 8);
        this.raidGroupNumberComboBox = new JComboBox<String>(this.databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers());
        this.configurationComboBox = new JComboBox<String>(this.configurationStrings);
        this.chunkSizeComboBox = new JComboBox<String>(this.chunkSizeStrings);
        this.chunkSizeComboBox.setEnabled(false);
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        this.rebuildPriorityComboBox = new JComboBox<String>(this.priorityStrings);
        this.rebuildPriorityComboBox.setSelectedIndex(this.priorityStrings.length - 1);
        int gap = 30;
        Utility.addComponent(new JLabel("RAID Group Label:"), this.compoundPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupLabelField, this.compoundPanel, layout, constraints, 1, 0, 0, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("RAID Group:"), this.compoundPanel, layout, constraints, 0, 1, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupNumberComboBox, this.compoundPanel, layout, constraints, 1, 1, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Configuration:"), this.compoundPanel, layout, constraints, 0, 2, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.configurationComboBox, this.compoundPanel, layout, constraints, 1, 2, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Capacity:"), this.compoundPanel, layout, constraints, 0, 3, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.capacityComboBox, this.compoundPanel, layout, constraints, 1, 3, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Chunk Size:"), this.compoundPanel, layout, constraints, 0, 4, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.chunkSizeComboBox, this.compoundPanel, layout, constraints, 1, 4, 9, 0, gap, 8, 1.0);
        Utility.addComponent(new JLabel("Rebuild Priority:"), this.compoundPanel, layout, constraints, 0, 5, 9, 9, 8, 8, 0.0);
        Utility.addComponent(this.rebuildPriorityComboBox, this.compoundPanel, layout, constraints, 1, 5, 9, 9, gap, 8, 1.0);
        Dimension dimension = this.configurationComboBox.getPreferredSize();
        this.raidGroupLabelField.setPreferredSize(dimension);
        this.raidGroupNumberComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        this.chunkSizeComboBox.setPreferredSize(dimension);
        this.configurationComboBox.setPreferredSize(dimension);
        this.rebuildPriorityComboBox.setPreferredSize(dimension);
        this.compoundPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(this.compoundPanel);
        this.raidGroupLabelField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRaidGroupBox.this.updateButtonState();
            }
        });
        return this.borderPanel;
    }

    private JPanel buildParityMethodPanel() {
        String[] radioButtonTextArray = new String[]{"Return Dirty Data", "Offline Raid Grp"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        int count = 0;
        while (count < this.parityMethodButton.length) {
            this.parityMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.parityMethodButton[count]);
            ++count;
        }
        Utility.addComponent(this.parityMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.parityMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.parityMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parity"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    protected JPanel buildRaidGroupPanel() {
        this.parameterPanel = this.buildParametersPanel();
        this.advancedFeatures = this.buildAdvancedFeaturesPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.parameterPanel);
        this.improperShutdownBoxVisible = false;
        return panel;
    }

    private JPanel buildRestoreMethodPanel() {
        String[] radioButtonTextArray = new String[]{"On (Quick Restore)", "Off (Best I/O Perf)"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        int count = 0;
        while (count < this.restoreMethodButton.length) {
            this.restoreMethodButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.restoreMethodButton[count]);
            ++count;
        }
        Utility.addComponent(this.restoreMethodButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.restoreMethodButton[1], radioPanel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 0, 0, 0, 1.0);
        this.restoreMethodButton[0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Check Pointing"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "New");
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    private boolean checkCapacityValidity() {
        String digits;
        int digitsLen;
        String suffix;
        String capacityString = this.capacityComboBox.getEditor().getItem().toString().toUpperCase().trim();
        if (capacityString.equals("MAX") || capacityString.equals("HALF")) {
            return true;
        }
        int endIndex = capacityString.indexOf(" MB");
        if (endIndex == -1) {
            endIndex = capacityString.indexOf(" GB");
            if (endIndex == -1) {
                return false;
            }
            suffix = capacityString.substring(endIndex);
            if (suffix.length() > 3) {
                return false;
            }
        } else {
            suffix = capacityString.substring(endIndex, capacityString.length());
            if (suffix.length() > 3) {
                return false;
            }
        }
        if ((digitsLen = (digits = capacityString.substring(0, endIndex).trim()).length()) == 0 || digitsLen > 3) {
            return false;
        }
        int index = 0;
        while (index < digits.length()) {
            char digit = digits.charAt(index);
            if (digit < '0' || digit > '9') {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected void closeDialog() {
        this.capacityComboBoxPollingThread = null;
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.raidGroupUpdateListener);
        this.segmentTable.dispose();
        this.dispose();
    }

    private void initializeAdvancedPanel() {
        this.restoreMethodButton = new JRadioButton[2];
        this.parityMethodButton = new JRadioButton[2];
    }

    private void initializeParameterPanel(String raidToSkip) {
        int dimension = this.availableRaidGroupNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(this.databaseManager.maximumRaidGroups))) {
            ++dimension;
        }
        String[] newAvailableRaidGroupNumbers = new String[dimension];
        this.raidGroupNumberComboBox.removeAllItems();
        this.raidGroupLabelField.setText("");
        int index = 0;
        int i = 0;
        while (i < this.availableRaidGroupNumbers.length) {
            if (!raidToSkip.equals(this.availableRaidGroupNumbers[i])) {
                this.raidGroupNumberComboBox.addItem(this.availableRaidGroupNumbers[i]);
                newAvailableRaidGroupNumbers[index++] = this.availableRaidGroupNumbers[i];
            }
            ++i;
        }
        this.availableRaidGroupNumbers = newAvailableRaidGroupNumbers;
        if (this.availableRaidGroupNumbers.length == 0) {
            this.setControlCompoundPanel(false);
        } else {
            this.updateConfigComboBoxAndSegmentTable();
            this.raidGroupLabelField.setText(this.databaseManager.raidGroupDatabase.generateRaidGroupLabel(this.raidGroupStatuses, this.availableRaidGroupNumbers));
        }
    }

    private void sendCreateRequest() {
        String raidGroupLabel = this.raidGroupLabelField.getText();
        if (this.databaseManager.raidGroupDatabase.raidGroupLabelExists(this.raidGroupStatuses, raidGroupLabel)) {
            JOptionPane.showMessageDialog(null, "Identical Label already exists. Please change the entry.", "Duplicate Label Alert", 0);
            return;
        }
        this.raidGroup = (String)this.raidGroupNumberComboBox.getSelectedItem();
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        String capacityString = ((String)this.capacityComboBox.getSelectedItem()).toUpperCase();
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        int chunkSize = this.chunkSizes[this.chunkSizeComboBox.getSelectedIndex()];
        System.out.println("chunk size in blocks " + chunkSize);
        String rebuildPriority = (String)this.rebuildPriorityComboBox.getSelectedItem();
        int capacityBlocks = 0;
        boolean found = false;
        int capacityIndex = 0;
        while (capacityIndex < this.capacityStrings.length) {
            if (capacityString.equals(this.capacityStrings[capacityIndex])) {
                found = true;
                break;
            }
            ++capacityIndex;
        }
        if (found) {
            capacityBlocks = this.capacities[capacityIndex];
        } else {
            int endIndex = capacityString.indexOf(" MB");
            if (endIndex == -1) {
                endIndex = capacityString.indexOf(" GB");
                if (endIndex == -1) {
                    endIndex = capacityString.length();
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
                } else {
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 0x200000;
                }
            } else {
                capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
            }
        }
        if (!capacityString.equals("MAX") && !capacityString.equals("HALF")) {
            int capacityPerMember;
            int memberCount = segmentList.size();
            int stripeWidth = 1;
            if (configuration.equals("Parity RAID")) {
                stripeWidth = memberCount - 1;
            } else if (configuration.equals("Mirrored")) {
                stripeWidth = 1;
            } else if (configuration.equals("Mirrored Striped")) {
                stripeWidth = memberCount / 2;
            } else if (configuration.equals("Striped")) {
                stripeWidth = memberCount;
            } else if (configuration.equals("Contiguous")) {
                stripeWidth = 1;
            }
            if (stripeWidth == 0) {
                ++stripeWidth;
            }
            if (((capacityPerMember = capacityBlocks / stripeWidth) & chunkSize - 1) != 0) {
                capacityPerMember = capacityPerMember + chunkSize & ~(chunkSize - 1);
            }
            capacityBlocks = capacityPerMember * stripeWidth;
            System.out.println("capacity per member " + capacityPerMember);
        }
        System.out.println("capacity " + capacityString + " " + capacityBlocks);
        String memberInfo = "";
        boolean foundMemberCount = false;
        int count = 0;
        while (count < segmentList.size()) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(count);
            memberInfo = memberInfo + "<si:RaidMemberInfo><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "</si:RaidMemberInfo>";
            ++count;
        }
        String checkPointing = this.restoreMethodButton[0].isSelected() ? "Yes" : "No";
        String dirtyData = this.parityMethodButton[0].isSelected() ? "Yes" : "No";
        String request = "<si:Request><si:Type>CreateRaidGroup</si:Type><si:RaidGroupParams><si:Label>" + raidGroupLabel + "</si:Label>" + "<si:RaidGroup>" + this.raidGroup + "</si:RaidGroup>" + "<si:Configuration>" + configuration + "</si:Configuration>" + "<si:ChunkSize>" + chunkSize + "</si:ChunkSize>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>" + "<si:RebuildPriority>" + rebuildPriority + "</si:RebuildPriority>" + "<si:MetadataFormat>New</si:MetadataFormat>" + "<si:WriteCheckPointing>" + checkPointing + "</si:WriteCheckPointing>" + "<si:ReturnDirtyData>" + dirtyData + "</si:ReturnDirtyData>" + memberInfo + "</si:RaidGroupParams>" + "</si:Request>";
        System.out.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateRaidGroupBox.this.databaseManager.refresh();
                CreateRaidGroupBox.this.setCursor(new Cursor(0));
                CreateRaidGroupBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(CreateRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create RAID Group Error");
                    CreateRaidGroupBox.this.responseOk = false;
                }
            }
        };
        this.responseOk = true;
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
        while (!this.borderPanel.isEnabled()) {
        }
        if (this.responseOk) {
            ++this.storageManagementUtility.createdRaidGroupCount;
            this.initializeParameterPanel(this.raidGroup);
            this.updateButtonState();
        }
        this.raidGroupLabelField.requestFocus();
    }

    private void setControlCompoundPanel(boolean control) {
        this.raidGroupLabelField.setEnabled(control);
        this.raidGroupNumberComboBox.setEnabled(control);
        this.configurationComboBox.setEnabled(control);
        this.chunkSizeComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.rebuildPriorityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
        this.updateCreateButtonState(control);
    }

    private void updateAdvancedPanel() {
        if (this.storageManagementUtility.advancedRaidOption) {
            String configuration = (String)this.configurationComboBox.getSelectedItem();
            if (configuration.equals("Contiguous") || configuration.equals("Striped")) {
                if (this.improperShutdownBoxVisible) {
                    this.getContentPane().removeAll();
                    this.raidGroupPanel.removeAll();
                    this.raidGroupPanel.add(this.parameterPanel);
                    this.getContentPane().add((Component)this.raidGroupPanel, "North");
                    this.getContentPane().add((Component)this.segmentPanel, "Center");
                    this.getContentPane().add((Component)this.buttonPanel, "South");
                    this.pack();
                    this.setResizable(false);
                    ((Component)this).setVisible(true);
                    this.improperShutdownBoxVisible = false;
                }
            } else {
                if (!this.improperShutdownBoxVisible) {
                    this.getContentPane().removeAll();
                    this.raidGroupPanel.removeAll();
                    this.raidGroupPanel.add(this.parameterPanel);
                    this.raidGroupPanel.add(this.advancedFeatures);
                    this.getContentPane().add((Component)this.raidGroupPanel, "North");
                    this.getContentPane().add((Component)this.segmentPanel, "Center");
                    this.getContentPane().add((Component)this.buttonPanel, "South");
                    this.pack();
                    this.setResizable(false);
                    ((Component)this).setVisible(true);
                    this.improperShutdownBoxVisible = true;
                }
                boolean control = false;
                if (configuration.equals("Parity RAID")) {
                    control = true;
                }
                Utility.enableContainer(this.parityPanel, control);
            }
        }
    }

    private void updateButtonState() {
        if (!this.capacityComboBox.isEnabled()) {
            return;
        }
        if (this.raidGroupLabelField.getText().trim().length() == 0 || !this.checkCapacityValidity()) {
            this.updateCreateButtonState(false);
        } else {
            this.updateCreateButtonState(true);
        }
    }

    private void updateConfigComboBoxAndSegmentTable() {
        String[] configurations = new String[]{"Contiguous"};
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        int numMultiMemRaidGrps = this.databaseManager.raidGroupDatabase.getMultiMemRaidGroupCount();
        if (numMultiMemRaidGrps >= this.databaseManager.controllerDatabase.getMaxMultiMemRaidGrps()) {
            this.configurationComboBox.setEnabled(false);
            this.configurationComboBox.removeAllItems();
            this.configurationComboBox.addItem(configurations[0]);
            this.configurationComboBox.setSelectedIndex(0);
            this.configurationComboBox.setEnabled(true);
        } else {
            int numContRaidGrps = this.databaseManager.raidGroupDatabase.getRaidGroupCount(configurations);
            if (numContRaidGrps >= this.databaseManager.controllerDatabase.getMaxNumberContRaidGrps()) {
                int selectedIndex = this.configurationComboBox.getSelectedIndex();
                this.configurationComboBox.removeItemAt(0);
                if (--selectedIndex < 0) {
                    selectedIndex = 0;
                }
                this.configurationComboBox.setSelectedIndex(selectedIndex);
            }
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Contiguous") || configuration.equals("Mirrored")) {
            control = false;
        }
        if (this.chunkSizeComboBox.isEnabled() != control) {
            this.chunkSizeComboBox.setEnabled(control);
        }
        if (configuration.equals("Contiguous")) {
            this.updateAdvancedPanel();
            this.segmentTable.segmentTableCreateUpdate(this.databaseManager.controllerDatabase.getMaxContRaidGrpsPerDev());
        } else {
            this.segmentTable.segmentTableUpdate();
        }
    }

    private void updateCreateButtonState(boolean newState) {
        if (this.createButton.isEnabled() != newState) {
            this.createButton.setEnabled(newState);
        }
    }

    private class ConfigComboBoxListener
    implements ActionListener {
        private ConfigComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String configuration = (String)CreateRaidGroupBox.this.configurationComboBox.getSelectedItem();
            boolean control = true;
            if (configuration.equals("Contiguous") || configuration.equals("Mirrored")) {
                control = false;
            }
            if (CreateRaidGroupBox.this.chunkSizeComboBox.isEnabled() != control) {
                CreateRaidGroupBox.this.chunkSizeComboBox.setEnabled(control);
            }
            CreateRaidGroupBox.this.updateAdvancedPanel();
            CreateRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private class CapacityComboBoxPollingThread
    extends Thread {
        private CapacityComboBoxPollingThread() {
        }

        public void run() {
            while (CreateRaidGroupBox.this.capacityComboBoxPollingThread != null) {
                try {
                    Thread.sleep(500L);
                    CreateRaidGroupBox.this.updateButtonState();
                }
                catch (Exception e) {
                }
            }
        }
    }

    private class LabelFieldCaretListener
    implements CaretListener {
        private LabelFieldCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            CreateRaidGroupBox.this.updateButtonState();
        }
    }

    private class CapacityComboKeyListener
    implements KeyListener {
        private CapacityComboKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * Unable to fully structure code
         */
        public void keyTyped(KeyEvent e) {
            digit = e.getKeyChar();
            System.out.println("keyTyped entered with '" + digit + "'");
            capacityString = CreateRaidGroupBox.access$1400(CreateRaidGroupBox.this).getEditor().getItem().toString().trim();
            if (digit == '\b') ** GOTO lbl-1000
            if (digit == '\t') ** GOTO lbl-1000
            if (digit == ' ') ** GOTO lbl-1000
            if (digit == '%') ** GOTO lbl-1000
            if (digit == '\'') ** GOTO lbl-1000
            if (digit == '\u00e2') ** GOTO lbl-1000
            if (digit != '\u00e2' && digit != 'G' && digit != 'B' && digit != 'g' && digit != 'b') {
                if (digit < '0' || digit > '9') {
                    e.consume();
                    return;
                }
            } else lbl-1000:
            // 7 sources

            {
                if (digit == 'G' && (capacityString.indexOf("G") != -1 || capacityString.indexOf("g") != -1) || digit == 'g' && (capacityString.indexOf("g") != -1 || capacityString.indexOf("G") != -1)) {
                    e.consume();
                    return;
                }
                if (digit == 'B' && (capacityString.indexOf("B") != -1 || capacityString.indexOf("b") != -1) || digit == 'b' && (capacityString.indexOf("b") != -1 || capacityString.indexOf("B") != -1)) {
                    e.consume();
                    return;
                }
            }
            if (digit != '\b' && capacityString.length() > 5) {
                e.consume();
                return;
            }
        }
    }

    private class RaidGroupUpdateListener
    implements Runnable {
        private RaidGroupUpdateListener() {
        }

        public void run() {
            CreateRaidGroupBox.access$902(CreateRaidGroupBox.this, CreateRaidGroupBox.this.databaseManager.raidGroupDatabase.getAvailableRaidGroupNumbers());
            if (CreateRaidGroupBox.this.availableRaidGroupNumbers.length == 0) {
                CreateRaidGroupBox.this.setControlCompoundPanel(false);
            } else {
                CreateRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
                CreateRaidGroupBox.this.raidGroupLabelField.setText(CreateRaidGroupBox.this.databaseManager.raidGroupDatabase.generateRaidGroupLabel(CreateRaidGroupBox.this.raidGroupStatuses, CreateRaidGroupBox.this.availableRaidGroupNumbers));
            }
        }
    }
}

