/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateLegacySpareBox
extends KDialog {
    private JPanel borderPanel;
    private int[] capacities;
    private JComboBox capacityComboBox;
    private String[] capacityStrings;
    private JButton createButton;
    private LegacySpareUpdateListener legacySpareUpdateListener;
    private String[] metadataFormats;
    private String segmentFields = "Device,Capacity,Starting LBN";
    private String[] segmentStatuses = new String[]{"Available"};
    private SegmentTable spareTable;

    public CreateLegacySpareBox(DatabaseManager databaseManager, String title) {
        this.metadataFormats = new String[]{"Old"};
        this.capacityStrings = new String[]{"128 MB", "256 MB", "512 MB", "1 GB", "2 GB", "3 GB", "4 GB", "5 GB", "6 GB", "7 GB", "8 GB", "9 GB", "10 GB", "20 GB", "40 GB", "60 GB", "80 GB", "100 GB", "HALF", "MAX"};
        this.capacities = new int[]{262144, 524288, 0x100000, 0x200000, 0x400000, 0x600000, 0x800000, 0xA00000, 0xC00000, 0xE00000, 0x1000000, 0x1200000, 0x1400000, 0x2800000, 0x5000000, 0x7800000, 0xA000000, 0xC800000, -2, -1};
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildSpareTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.legacySpareUpdateListener = new LegacySpareUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.legacySpareUpdateListener);
        databaseManager.deviceDatabase.addUpdateListener(this.legacySpareUpdateListener);
        this.legacySpareUpdateListener.run();
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        JButton closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacySpareBox.this.sendRequest();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacySpareBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildParametersPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        this.capacityComboBox.setEditable(true);
        this.capacityComboBox.setSelectedIndex(1);
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        Utility.addComponent(new JLabel("Capacity:"), panel, layout, constraints, 0, 2, 9, 9, 8, 10, 0.0);
        Utility.addComponent(this.capacityComboBox, panel, layout, constraints, 1, 2, 9, 9, 4, 10, 1.0);
        Dimension dimension = this.capacityComboBox.getPreferredSize();
        dimension.width = (int)((double)dimension.width * 2.0);
        this.capacityComboBox.setPreferredSize(dimension);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(panel);
        return this.borderPanel;
    }

    protected JPanel buildSpareTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.spareTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "Old");
        this.spareTable.setSelectionMode(0);
        tablePanel.add(this.spareTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    protected void closeDialog() {
        System.out.println("closeDialog");
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.legacySpareUpdateListener);
        this.databaseManager.deviceDatabase.removeUpdateListener(this.legacySpareUpdateListener);
        this.spareTable.dispose();
        this.dispose();
    }

    private void sendRequest() {
        ArrayList segmentList = this.spareTable.getSelectedSegments();
        String capacityString = (String)this.capacityComboBox.getSelectedItem();
        int capacityIndex = 0;
        capacityIndex = 0;
        while (capacityIndex < this.capacityStrings.length) {
            if (capacityString.equals(this.capacityStrings[capacityIndex])) break;
            ++capacityIndex;
        }
        int capacityBlocks = this.capacities[capacityIndex];
        SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(0);
        String request = "<si:Request><si:Type>CreateSpare</si:Type><si:SpareParams><si:Type>Legacy</si:Type><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>" + "</si:SpareParams>" + "</si:Request>";
        System.out.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateLegacySpareBox.this.databaseManager.refresh();
                CreateLegacySpareBox.this.setCursor(new Cursor(0));
                CreateLegacySpareBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(CreateLegacySpareBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Spare Error");
                }
            }
        };
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private class LegacySpareUpdateListener
    implements Runnable {
        private LegacySpareUpdateListener() {
        }

        public void run() {
            String[] segmentStatuses = new String[]{"Legacy Spare"};
            ArrayList segmentList = CreateLegacySpareBox.this.databaseManager.deviceDatabase.getSegmentList(segmentStatuses);
            if (segmentList.size() >= 2) {
                CreateLegacySpareBox.this.capacityComboBox.setEnabled(false);
                CreateLegacySpareBox.this.borderPanel.setEnabled(false);
                CreateLegacySpareBox.this.createButton.setEnabled(false);
            }
        }
    }
}

