/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CreateLegacyRaidGroupBox
extends KDialog
implements GlobalConstants {
    private String[] availableLegacyNumbers;
    private JPanel borderPanel;
    private int[] capacities;
    private JComboBox capacityComboBox;
    private CapacityComboBoxPollingThread capacityComboBoxPollingThread;
    private String[] capacityStrings;
    private JComboBox chunkSizeComboBox;
    private String[] chunkSizeStrings;
    private int[] chunkSizes;
    private JButton closeButton;
    private ConfigComboBoxListener configComboBoxListener;
    private JComboBox configurationComboBox;
    private String[] configurationStrings = new String[]{"Contiguous", "Striped", "Mirrored", "Mirrored Striped", "Parity RAID"};
    private JButton createButton;
    private LegacyRaidGroupUpdateListener legacyRaidGroupUpdateListener;
    private String[] memberCountStrings;
    private String[] priorityStrings;
    private String raidGroup;
    private JComboBox raidGroupNumberComboBox;
    private String[] raidGroupStatuses;
    private JComboBox rebuildPriorityComboBox;
    private boolean responseOk;
    private String segmentFields = "Device,Capacity,Starting LBN";
    private String[] segmentStatuses;
    private SegmentTable segmentTable;

    public CreateLegacyRaidGroupBox(DatabaseManager databaseManager, String title) {
        this.chunkSizeStrings = new String[]{"8 KB", "16 KB", "32 KB", "64 KB", "128 KB"};
        this.chunkSizes = new int[]{16, 32, 64, 128, 256};
        this.memberCountStrings = new String[]{"1", "2", "3", "4"};
        this.priorityStrings = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        this.segmentStatuses = new String[]{"Available"};
        this.raidGroupStatuses = new String[]{"Online", "Reduced"};
        this.availableLegacyNumbers = new String[4];
        this.capacityStrings = new String[]{"1 GB", "2 GB", "3 GB", "4 GB", "5 GB", "6 GB", "7 GB", "8 GB", "9 GB", "10 GB", "20 GB", "40 GB", "60 GB", "80 GB", "100 GB", "HALF", "MAX"};
        this.capacities = new int[]{0x200000, 0x400000, 0x600000, 0x800000, 0xA00000, 0xC00000, 0xE00000, 0x1000000, 0x1200000, 0x1400000, 0x2800000, 0x5000000, 0x7800000, 0xA000000, 0xC800000, -2, -1};
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildParametersPanel(), "North");
        this.getContentPane().add((Component)this.buildSegmentTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.configComboBoxListener = new ConfigComboBoxListener();
        this.legacyRaidGroupUpdateListener = new LegacyRaidGroupUpdateListener();
        databaseManager.raidGroupDatabase.addUpdateListener(this.legacyRaidGroupUpdateListener);
        this.availableLegacyNumbers = databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers();
        this.initializeParameterPanel(Integer.toString(4));
        this.capacityComboBox.getEditor().getEditorComponent().addKeyListener(new CapacityComboKeyListener());
        this.capacityComboBox.setEditable(true);
        this.createButton.setEnabled(false);
        this.capacityComboBoxPollingThread = new CapacityComboBoxPollingThread();
        this.capacityComboBoxPollingThread.start();
        this.completeDialogInit(true);
    }

    static /* synthetic */ JComboBox access$1000(CreateLegacyRaidGroupBox x0) {
        return x0.capacityComboBox;
    }

    static /* synthetic */ String[] access$702(CreateLegacyRaidGroupBox x0, String[] x1) {
        x0.availableLegacyNumbers = x1;
        return x1;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.createButton = new JButton("Create");
        this.closeButton = new JButton("Close");
        this.createButton.setMnemonic(69);
        this.closeButton.setMnemonic(88);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacyRaidGroupBox.this.sendCreateRequest();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLegacyRaidGroupBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.createButton);
        buttonPanel.add(this.closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildParametersPanel() {
        JPanel compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.raidGroupNumberComboBox = new JComboBox<String>(this.databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers());
        this.configurationComboBox = new JComboBox<String>(this.configurationStrings);
        this.chunkSizeComboBox = new JComboBox<String>(this.chunkSizeStrings);
        this.chunkSizeComboBox.setEnabled(false);
        this.capacityComboBox = new JComboBox<String>(this.capacityStrings);
        this.rebuildPriorityComboBox = new JComboBox<String>(this.priorityStrings);
        this.rebuildPriorityComboBox.setSelectedIndex(this.priorityStrings.length - 1);
        Utility.addComponent(new JLabel("RAID Group:"), compoundPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(this.raidGroupNumberComboBox, compoundPanel, layout, constraints, 1, 0, 0, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Configuration:"), compoundPanel, layout, constraints, 0, 1, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.configurationComboBox, compoundPanel, layout, constraints, 1, 1, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Capacity:"), compoundPanel, layout, constraints, 0, 2, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.capacityComboBox, compoundPanel, layout, constraints, 1, 2, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Chunk Size:"), compoundPanel, layout, constraints, 0, 3, 9, 0, 8, 8, 0.0);
        Utility.addComponent(this.chunkSizeComboBox, compoundPanel, layout, constraints, 1, 3, 9, 0, 4, 8, 1.0);
        Utility.addComponent(new JLabel("Rebuild Priority:"), compoundPanel, layout, constraints, 0, 4, 9, 9, 8, 8, 0.0);
        Utility.addComponent(this.rebuildPriorityComboBox, compoundPanel, layout, constraints, 1, 4, 9, 9, 4, 8, 1.0);
        Dimension dimension = this.configurationComboBox.getPreferredSize();
        this.raidGroupNumberComboBox.setPreferredSize(dimension);
        this.capacityComboBox.setPreferredSize(dimension);
        this.chunkSizeComboBox.setPreferredSize(dimension);
        this.configurationComboBox.setPreferredSize(dimension);
        this.rebuildPriorityComboBox.setPreferredSize(dimension);
        compoundPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parameters"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(compoundPanel);
        return this.borderPanel;
    }

    private JPanel buildSegmentTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.segmentTable = new SegmentTable(this.databaseManager, null, this.segmentFields, this.segmentStatuses, 6, "Old");
        tablePanel.add(this.segmentTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(8, 14, 4, 14));
        return tablePanel;
    }

    private boolean checkCapacityValidity() {
        String digits;
        int digitsLen;
        String suffix;
        String capacityString = this.capacityComboBox.getEditor().getItem().toString().toUpperCase().trim();
        if (capacityString.equals("MAX") || capacityString.equals("HALF")) {
            return true;
        }
        int endIndex = capacityString.indexOf(" MB");
        if (endIndex == -1) {
            endIndex = capacityString.indexOf(" GB");
            if (endIndex == -1) {
                return false;
            }
            suffix = capacityString.substring(endIndex);
            if (suffix.length() > 3) {
                return false;
            }
        } else {
            suffix = capacityString.substring(endIndex, capacityString.length());
            if (suffix.length() > 3) {
                return false;
            }
        }
        if ((digitsLen = (digits = capacityString.substring(0, endIndex).trim()).length()) == 0 || digitsLen > 3) {
            return false;
        }
        int index = 0;
        while (index < digits.length()) {
            char digit = digits.charAt(index);
            if (digit < '0' || digit > '9') {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected void closeDialog() {
        this.capacityComboBoxPollingThread = null;
        this.databaseManager.raidGroupDatabase.removeUpdateListener(this.legacyRaidGroupUpdateListener);
        this.dispose();
    }

    private synchronized void initializeParameterPanel(String raidToSkip) {
        int dimension = this.availableLegacyNumbers.length - 1;
        if (raidToSkip.equals(Integer.toString(4))) {
            ++dimension;
        }
        String[] newAvailableLegacyNumbers = new String[dimension];
        this.raidGroupNumberComboBox.removeAllItems();
        int index = 0;
        int i = 0;
        while (i < this.availableLegacyNumbers.length) {
            if (!raidToSkip.equals(this.availableLegacyNumbers[i])) {
                this.raidGroupNumberComboBox.addItem(this.availableLegacyNumbers[i]);
                newAvailableLegacyNumbers[index++] = this.availableLegacyNumbers[i];
            }
            ++i;
        }
        this.availableLegacyNumbers = newAvailableLegacyNumbers;
        if (this.availableLegacyNumbers.length == 0 || !this.databaseManager.deviceDatabase.legacyBootSupportable()) {
            this.setControlCompoundPanel(false);
        } else {
            this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private void sendCreateRequest() {
        this.raidGroup = (String)this.raidGroupNumberComboBox.getSelectedItem();
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        String capacityString = ((String)this.capacityComboBox.getSelectedItem()).toUpperCase();
        ArrayList segmentList = this.segmentTable.getSelectedSegments();
        int chunkSize = this.chunkSizes[this.chunkSizeComboBox.getSelectedIndex()];
        System.out.println("chunk size in blocks " + chunkSize);
        String rebuildPriority = (String)this.rebuildPriorityComboBox.getSelectedItem();
        int capacityBlocks = 0;
        boolean found = false;
        int capacityIndex = 0;
        while (capacityIndex < this.capacityStrings.length) {
            if (capacityString.equals(this.capacityStrings[capacityIndex])) {
                found = true;
                break;
            }
            ++capacityIndex;
        }
        if (found) {
            capacityBlocks = this.capacities[capacityIndex];
        } else {
            int endIndex = capacityString.indexOf(" MB");
            if (endIndex == -1) {
                endIndex = capacityString.indexOf(" GB");
                if (endIndex == -1) {
                    endIndex = capacityString.length();
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
                } else {
                    capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 0x200000;
                }
            } else {
                capacityBlocks = Integer.parseInt(capacityString.substring(0, endIndex)) * 2048;
            }
        }
        if (!capacityString.equals("MAX") && !capacityString.equals("HALF")) {
            int capacityPerMember;
            int memberCount = segmentList.size();
            int stripeWidth = 1;
            if (configuration.equals("Parity RAID")) {
                stripeWidth = memberCount - 1;
            } else if (configuration.equals("Mirrored")) {
                if (memberCount > 2) {
                    new ErrorMessageBox(this, "Create RAID Group Error", "Please retry by selecting 2 mirror members");
                    return;
                }
                stripeWidth = 1;
            } else if (configuration.equals("Mirrored Striped")) {
                stripeWidth = memberCount / 2;
            } else if (configuration.equals("Striped")) {
                stripeWidth = memberCount;
            } else if (configuration.equals("Contiguous")) {
                stripeWidth = 1;
            }
            if (stripeWidth == 0) {
                ++stripeWidth;
            }
            if (((capacityPerMember = capacityBlocks / stripeWidth) & chunkSize - 1) != 0) {
                capacityPerMember = capacityPerMember + chunkSize & ~(chunkSize - 1);
            }
            capacityBlocks = capacityPerMember * stripeWidth;
            System.out.println("capacity per member " + capacityPerMember);
        }
        System.out.println("capacity " + capacityString + " " + capacityBlocks);
        String memberInfo = "";
        boolean foundMemberCount = false;
        int count = 0;
        while (count < segmentList.size()) {
            SegmentDescriptor segmentDescriptor = (SegmentDescriptor)segmentList.get(count);
            memberInfo = memberInfo + "<si:RaidMemberInfo><si:Device>" + segmentDescriptor.device + "</si:Device>" + "<si:StartingPlbn>" + segmentDescriptor.startingPlbn + "</si:StartingPlbn>" + "</si:RaidMemberInfo>";
            ++count;
        }
        String checkPointing = "Yes";
        String dirtyData = "Yes";
        String request = "<si:Request><si:Type>CreateRaidGroup</si:Type><si:RaidGroupParams><si:RaidGroup>" + this.raidGroup + "</si:RaidGroup>" + "<si:Label></si:Label>" + "<si:Configuration>" + configuration + "</si:Configuration>" + "<si:ChunkSize>" + chunkSize + "</si:ChunkSize>" + "<si:Capacity>" + capacityBlocks + "</si:Capacity>" + "<si:RebuildPriority>" + rebuildPriority + "</si:RebuildPriority>" + "<si:MetadataFormat>Old</si:MetadataFormat>" + "<si:WriteCheckPointing>" + checkPointing + "</si:WriteCheckPointing>" + "<si:ReturnDirtyData>" + dirtyData + "</si:ReturnDirtyData>" + memberInfo + "</si:RaidGroupParams>" + "</si:Request>";
        System.out.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                CreateLegacyRaidGroupBox.this.databaseManager.refresh();
                CreateLegacyRaidGroupBox.this.setCursor(new Cursor(0));
                CreateLegacyRaidGroupBox.this.borderPanel.setEnabled(true);
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(CreateLegacyRaidGroupBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Create Legacy RAID Group Error");
                    CreateLegacyRaidGroupBox.this.responseOk = false;
                }
            }
        };
        this.responseOk = true;
        this.borderPanel.setEnabled(false);
        this.setCursor(new Cursor(3));
        this.databaseManager.commManager.sendMessage("Execute", request, responseMessageHandler);
        while (!this.borderPanel.isEnabled()) {
        }
        if (this.responseOk) {
            ++this.storageManagementUtility.createdRaidGroupCount;
            this.initializeParameterPanel(this.raidGroup);
            this.updateButtonState();
        }
    }

    private void setControlCompoundPanel(boolean control) {
        this.raidGroupNumberComboBox.setEnabled(control);
        this.configurationComboBox.setEnabled(control);
        this.chunkSizeComboBox.setEnabled(control);
        this.capacityComboBox.setEnabled(control);
        this.rebuildPriorityComboBox.setEnabled(control);
        this.borderPanel.setEnabled(control);
        this.updateCreateButtonState(control);
    }

    private void updateButtonState() {
        if (!this.capacityComboBox.isEnabled()) {
            return;
        }
        if (!this.checkCapacityValidity()) {
            this.updateCreateButtonState(false);
        } else {
            this.updateCreateButtonState(true);
        }
    }

    private void updateConfigComboBoxAndSegmentTable() {
        String[] configurations = new String[]{"Contiguous"};
        this.configurationComboBox.removeActionListener(this.configComboBoxListener);
        int legacyRaidGrps = this.databaseManager.raidGroupDatabase.getLegacyRaidGroupCount();
        if (legacyRaidGrps >= 2) {
            this.configurationComboBox.setEnabled(false);
            this.configurationComboBox.removeAllItems();
            this.configurationComboBox.addItem(configurations[0]);
            this.configurationComboBox.setSelectedIndex(0);
            this.configurationComboBox.setEnabled(true);
        } else {
            int numContRaidGrps = this.databaseManager.raidGroupDatabase.getRaidGroupCount(configurations);
            if (numContRaidGrps >= this.databaseManager.controllerDatabase.getMaxNumberContRaidGrps()) {
                int selectedIndex = this.configurationComboBox.getSelectedIndex();
                this.configurationComboBox.removeItemAt(0);
                if (--selectedIndex < 0) {
                    selectedIndex = 0;
                }
                this.configurationComboBox.setSelectedIndex(selectedIndex);
            }
        }
        this.configurationComboBox.addActionListener(this.configComboBoxListener);
        boolean control = true;
        String configuration = (String)this.configurationComboBox.getSelectedItem();
        if (configuration.equals("Contiguous") || configuration.equals("Mirrored")) {
            control = false;
        }
        if (this.chunkSizeComboBox.isEnabled() != control) {
            this.chunkSizeComboBox.setEnabled(control);
        }
        if (configuration.equals("Contiguous")) {
            this.segmentTable.segmentTableCreateUpdate(this.databaseManager.controllerDatabase.getMaxContRaidGrpsPerDev());
        } else {
            this.segmentTable.segmentTableUpdate();
        }
    }

    private void updateCreateButtonState(boolean newState) {
        if (this.createButton.isEnabled() != newState) {
            this.createButton.setEnabled(newState);
        }
    }

    private class ConfigComboBoxListener
    implements ActionListener {
        private ConfigComboBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String configuration = (String)CreateLegacyRaidGroupBox.this.configurationComboBox.getSelectedItem();
            boolean control = true;
            if (configuration.equals("Contiguous") || configuration.equals("Mirrored")) {
                control = false;
            }
            if (CreateLegacyRaidGroupBox.this.chunkSizeComboBox.isEnabled() != control) {
                CreateLegacyRaidGroupBox.this.chunkSizeComboBox.setEnabled(control);
            }
            CreateLegacyRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
        }
    }

    private class CapacityComboBoxPollingThread
    extends Thread {
        private CapacityComboBoxPollingThread() {
        }

        public void run() {
            while (CreateLegacyRaidGroupBox.this.capacityComboBoxPollingThread != null) {
                try {
                    Thread.sleep(500L);
                    CreateLegacyRaidGroupBox.this.updateButtonState();
                }
                catch (Exception e) {
                }
            }
        }
    }

    private class CapacityComboKeyListener
    implements KeyListener {
        private CapacityComboKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        /*
         * Unable to fully structure code
         */
        public void keyTyped(KeyEvent e) {
            digit = e.getKeyChar();
            capacityString = CreateLegacyRaidGroupBox.access$1000(CreateLegacyRaidGroupBox.this).getEditor().getItem().toString().trim();
            if (digit == '\b') ** GOTO lbl-1000
            if (digit == '\t') ** GOTO lbl-1000
            if (digit == ' ') ** GOTO lbl-1000
            if (digit == '%') ** GOTO lbl-1000
            if (digit == '\'') ** GOTO lbl-1000
            if (digit == '\u00e2') ** GOTO lbl-1000
            if (digit != '\u00e2' && digit != 'G' && digit != 'B' && digit != 'g' && digit != 'b') {
                if (digit < '0' || digit > '9') {
                    e.consume();
                    return;
                }
            } else lbl-1000:
            // 7 sources

            {
                if (digit == 'G' && (capacityString.indexOf("G") != -1 || capacityString.indexOf("g") != -1) || digit == 'g' && (capacityString.indexOf("g") != -1 || capacityString.indexOf("G") != -1)) {
                    e.consume();
                    return;
                }
                if (digit == 'B' && (capacityString.indexOf("B") != -1 || capacityString.indexOf("b") != -1) || digit == 'b' && (capacityString.indexOf("b") != -1 || capacityString.indexOf("B") != -1)) {
                    e.consume();
                    return;
                }
            }
            if (digit != '\b' && capacityString.length() > 5) {
                e.consume();
                return;
            }
        }
    }

    private class LegacyRaidGroupUpdateListener
    implements Runnable {
        private LegacyRaidGroupUpdateListener() {
        }

        public void run() {
            CreateLegacyRaidGroupBox.access$702(CreateLegacyRaidGroupBox.this, CreateLegacyRaidGroupBox.this.databaseManager.raidGroupDatabase.getAvailableLegacyRaidGroupNumbers());
            if (CreateLegacyRaidGroupBox.this.availableLegacyNumbers.length == 0 || !CreateLegacyRaidGroupBox.this.databaseManager.deviceDatabase.legacyBootSupportable()) {
                CreateLegacyRaidGroupBox.this.setControlCompoundPanel(false);
            } else {
                CreateLegacyRaidGroupBox.this.updateConfigComboBoxAndSegmentTable();
            }
        }
    }
}

