/*
 * Decompiled with CFR 0.152.
 */
public class ControllerDescriptor
extends AbstractDescriptor {
    public String chipRevision;
    public String chipType;
    public int controller;
    public String controllerId;
    public String driverType;
    private String[] fieldNameLookUp = new String[]{"ControllerId", "controllerId", "Type", "chipType", "Revision", "chipRevision", "BusNum", "pciBusNumber", "DevNum", "pciDevNumber", "IrqNum", "irqNumber", "Status", "pciStatus", "DriverType", "driverType", "PathIdCount", "pathIdCount", "TargetIdCount", "targetIdCount", "MaxRaidGroups", "maxRaidGroups", "MaxMemberCount", "maxMemberCount", "MaxMembersPerDevice", "maxMembersPerDevice", "MaxMultiMemRaidGrps", "maxMultiMemRaidGrps", "MaxContRaidGrpsPerDev", "maxContRaidGrpsPerDev", "UpdateCount", "updateCount"};
    public String irqNumber;
    public int maxContRaidGrpsPerDev;
    public int maxMemberCount;
    public int maxMembersPerDevice;
    public int maxMultiMemRaidGrps;
    public int maxRaidGroups;
    public int pathIdCount;
    public String pciBusNumber;
    public String pciDevNumber;
    public String pciStatus;
    public int targetIdCount;
    public String updateCount;

    ControllerDescriptor(int controller, String data) {
        this.nuke();
        this.controller = controller;
        this.parseXml(data);
    }

    ControllerDescriptor(int controller) {
        this.nuke();
        this.controller = controller;
    }

    ControllerDescriptor() {
        this.nuke();
    }

    public synchronized Object clone() {
        ControllerDescriptor newDescriptor = new ControllerDescriptor();
        newDescriptor.controller = this.controller;
        newDescriptor.controllerId = this.controllerId;
        newDescriptor.chipType = this.chipType;
        newDescriptor.chipRevision = this.chipRevision;
        newDescriptor.driverType = this.driverType;
        newDescriptor.irqNumber = this.irqNumber;
        newDescriptor.pciStatus = this.pciStatus;
        newDescriptor.pciBusNumber = this.pciBusNumber;
        newDescriptor.pciDevNumber = this.pciDevNumber;
        newDescriptor.pathIdCount = this.pathIdCount;
        newDescriptor.targetIdCount = this.targetIdCount;
        newDescriptor.maxRaidGroups = this.maxRaidGroups;
        newDescriptor.maxMemberCount = this.maxMemberCount;
        newDescriptor.maxMembersPerDevice = this.maxMembersPerDevice;
        newDescriptor.maxMultiMemRaidGrps = this.maxMultiMemRaidGrps;
        newDescriptor.maxContRaidGrpsPerDev = this.maxContRaidGrpsPerDev;
        newDescriptor.updateCount = this.updateCount;
        return newDescriptor;
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length >> 1) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public void nuke() {
        this.controller = -1;
        this.controllerId = "Unknown";
        this.chipType = "Unknown";
        this.chipRevision = "Unknown";
        this.driverType = "Unknown";
        this.pciStatus = "Unknown";
        this.irqNumber = "Unknown";
        this.pciBusNumber = "Unknown";
        this.pciDevNumber = "Unknown";
        this.pathIdCount = -1;
        this.targetIdCount = -1;
        this.maxRaidGroups = -1;
        this.maxMemberCount = -1;
        this.maxMembersPerDevice = -1;
        this.maxMultiMemRaidGrps = -1;
        this.maxContRaidGrpsPerDev = -1;
        this.updateCount = "Unknown";
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            if (this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue)) continue;
            if (xmlData.element.equals("ChipInfo")) {
                XmlData chipInfoXmlData = new XmlData(xmlData.elementValue);
                while (chipInfoXmlData.getNextElement()) {
                    this.parseElement(this.fieldNameLookUp, chipInfoXmlData.element, chipInfoXmlData.elementValue);
                }
                continue;
            }
            if (xmlData.element.equals("PciInfo")) {
                XmlData pciInfoXmlData = new XmlData(xmlData.elementValue);
                while (pciInfoXmlData.getNextElement()) {
                    this.parseElement(this.fieldNameLookUp, pciInfoXmlData.element, pciInfoXmlData.elementValue);
                }
                continue;
            }
            if (!xmlData.element.equals("Constraints")) continue;
            XmlData constraintsXmlData = new XmlData(xmlData.elementValue);
            while (constraintsXmlData.getNextElement()) {
                this.parseElement(this.fieldNameLookUp, constraintsXmlData.element, constraintsXmlData.elementValue);
            }
        }
    }
}

