/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;

public class ControllerDatabase
extends AbstractDatabase {
    private ControllerDescriptor[] controllerArray;

    ControllerDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "Controller");
    }

    public ControllerDescriptor getConnectedController() {
        return (ControllerDescriptor)this.controllerArray[this.databaseManager.getNexusController()].clone();
    }

    public ControllerDescriptor getController(int controller) {
        return (ControllerDescriptor)this.controllerArray[controller].clone();
    }

    private void getControllerInfo(int controller) {
        String request = "<si:Request><si:Type>ControllerInfo</si:Type></si:Request>";
        this.databaseManager.commManager.sendMessage(controller, "Get", request, this.infoMessageHandler);
    }

    public synchronized int getMaxContRaidGrpsPerDev() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxContRaidGrpsPerDev;
    }

    public synchronized int getMaxMultiMemRaidGrps() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.maxMultiMemRaidGrps;
    }

    public synchronized int getMaxNumberContRaidGrps() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.pathIdCount * controller.targetIdCount * controller.maxContRaidGrpsPerDev;
    }

    public int getMaxNumberPhysDevs() {
        ControllerDescriptor controller = this.getConnectedController();
        return controller.pathIdCount * controller.targetIdCount;
    }

    public void initialize() {
        super.initialize();
        this.controllerArray = new ControllerDescriptor[this.databaseManager.getControllerCount()];
        int controller = 0;
        while (controller < this.controllerArray.length) {
            this.controllerArray[controller] = new ControllerDescriptor(controller);
            ++controller;
        }
        this.getControllerInfo(0);
    }

    public synchronized void nuke() {
        super.nuke();
        int controller = 0;
        while (controller < this.controllerArray.length) {
            this.controllerArray[controller] = new ControllerDescriptor(controller);
            ++controller;
        }
        this.notifyListeners();
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                } else if (xmlData.element.equals("ControllerInfo")) {
                    ControllerDescriptor controllerDescriptor;
                    this.controllerArray[controllerDescriptor.controller] = controllerDescriptor = new ControllerDescriptor(message.controller, xmlData.elementValue);
                    if (this.initializing) {
                        if (controllerDescriptor.controller < this.controllerArray.length - 1) {
                            this.getControllerInfo(controllerDescriptor.controller + 1);
                        } else {
                            this.initializationComplete();
                        }
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "Controller Database Exception\nMessage " + message.response);
        }
    }

    public void snapshot(FileOutputStream outputStream) {
    }
}

