/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ConfigurationBox
extends KDialog
implements GlobalConstants {
    private static final int EVENT_LEVEL_SLIDER_MAXIMUM = 30;
    private static final int EVENT_LEVEL_SLIDER_MINIMUM = 0;
    private static final int EVENT_LEVEL_SLIDER_STEPPING = 10;
    private static final int FILE_SPEC_MAX_FIELD_COLMNS = 20;
    private JButton browseButton;
    private JTabbedPane configurationPane;
    private Runnable databaseChangeHandler;
    private JCheckBox deleteMemberCheckBox;
    private JPanel disabledLevelPanel;
    private JPanel errorLevelPanel;
    private JRadioButton[] fileControlButton;
    private JPanel infoPanel;
    private JPanel informationalLevelPanel;
    private boolean initialDeleteMember;
    private boolean initialLegacySupport;
    private boolean initialLogFileGen;
    private String initialLogFilePath;
    private String initialPopUpLevel;
    private String initialPurgeFilePath;
    private boolean initialRaidFeatures;
    private boolean initialResourceInfo;
    private JPanel instructionPanel;
    private JCheckBox legacySupportCheckBox;
    private JPanel levelInfoPanel;
    private JTextField locationField;
    private String logFileLocation;
    private String logFileName;
    private JPanel logFilePanel;
    private String logFilePath;
    private JPanel logFileSpecPanel;
    private boolean logFileSpecPanelEnabled;
    private boolean logFileSpecified;
    private boolean mouseDragged;
    private int mouseDraggedCount;
    private JTextField nameField;
    private JSlider popUpLevelSlider;
    private JPanel popUpPanel;
    private JButton purgeButton;
    private String purgeFileLocation;
    private String purgeFileName;
    private String purgeFilePath;
    private boolean purgeFileSpecified;
    private JCheckBox raidFeaturesCheckBox;
    private JCheckBox resourceInfoCheckBox;
    private SliderListener sliderListener;
    private int sliderValue;
    private JPanel warningLevelPanel;

    public ConfigurationBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.initializeComponents();
        this.getContentPane().add((Component)this.buildConfigurationPane(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        ParameterChangeListener parameterChangeListener = new ParameterChangeListener();
        int index = 0;
        while (index < this.fileControlButton.length) {
            this.fileControlButton[index].addActionListener(parameterChangeListener);
            ++index;
        }
        this.nameField.addActionListener(parameterChangeListener);
        this.locationField.addActionListener(parameterChangeListener);
        this.updateBoxContents(true);
        this.completeDialogInit(true);
    }

    private JPanel addEventLevelPanel() {
        if (this.sliderValue == 0) {
            return this.disabledLevelPanel;
        }
        if (this.sliderValue == 10) {
            return this.errorLevelPanel;
        }
        if (this.sliderValue == 20) {
            return this.warningLevelPanel;
        }
        if (this.sliderValue == 30) {
            return this.informationalLevelPanel;
        }
        return null;
    }

    private JPanel buildAdvancedOptionsLeftPanel() {
        JPanel compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        Utility.addComponent(this.legacySupportCheckBox, compoundPanel, layout, constraints, 0, 0, 0, 0, 4, 8, 0.0);
        Utility.addComponent(new JLabel("Legacy (Bootable) Support"), compoundPanel, layout, constraints, 1, 0, 0, 4, 0, 8, 1.0);
        Utility.addComponent(this.raidFeaturesCheckBox, compoundPanel, layout, constraints, 0, 1, 0, 0, 4, 8, 0.0);
        Utility.addComponent(new JLabel("Advanced RAID Features"), compoundPanel, layout, constraints, 1, 1, 0, 4, 0, 8, 1.0);
        JPanel borderPanel = new JPanel();
        borderPanel.add((Component)compoundPanel, "North");
        return borderPanel;
    }

    private JPanel buildAdvancedOptionsPanel() {
        JPanel advancedOptionsTextPanel = this.buildAdvancedOptionsTextPanel();
        JPanel advancedOptionsSpecPanel = this.buildAdvancedOptionsSpecPanel();
        JPanel advancedOptionsPanel = new JPanel();
        advancedOptionsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        advancedOptionsPanel.setLayout(new BoxLayout(advancedOptionsPanel, 1));
        advancedOptionsPanel.add(advancedOptionsTextPanel);
        advancedOptionsPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        advancedOptionsPanel.add(advancedOptionsSpecPanel);
        return advancedOptionsPanel;
    }

    private JPanel buildAdvancedOptionsRightPanel() {
        JPanel panel = new JPanel();
        JPanel compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        Utility.addComponent(this.deleteMemberCheckBox, compoundPanel, layout, constraints, 0, 0, 0, 0, 4, 8, 0.0);
        Utility.addComponent(new JLabel("Delete Member Support"), compoundPanel, layout, constraints, 1, 0, 0, 4, 0, 8, 1.0);
        Utility.addComponent(this.resourceInfoCheckBox, compoundPanel, layout, constraints, 0, 1, 0, 0, 4, 8, 0.0);
        Utility.addComponent(new JLabel("Resources Info Support"), compoundPanel, layout, constraints, 1, 1, 0, 4, 0, 8, 1.0);
        JPanel borderPanel = new JPanel();
        borderPanel.add((Component)compoundPanel, "North");
        return borderPanel;
    }

    private JPanel buildAdvancedOptionsSpecPanel() {
        JPanel advancedOptionsPanel = new JPanel();
        advancedOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Advanced Options Specification"));
        advancedOptionsPanel.setLayout(new BoxLayout(advancedOptionsPanel, 0));
        advancedOptionsPanel.add(this.buildAdvancedOptionsLeftPanel());
        advancedOptionsPanel.add(this.buildAdvancedOptionsRightPanel());
        return advancedOptionsPanel;
    }

    private JPanel buildAdvancedOptionsTextPanel() {
        String fileInfo0 = "This configuration panel allows users to control advanced features";
        String fileInfo1 = "of the RAID driver. Please consult manual for information about each";
        String fileInfo2 = "option.";
        String fileInfo3 = "       ";
        String fileInfo4 = "WARNING: Incorrect usage of some options could result in data loss.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo2), panel, layout, constraints, 0, 2, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo3), panel, layout, constraints, 0, 3, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo4), panel, layout, constraints, 0, 4, 0, 8, 4, 0, 0.0);
        JPanel textPanel = new JPanel();
        textPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Advanced Options Information"));
        textPanel.add((Component)panel, "North");
        return textPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setMnemonic(79);
        cancelButton.setMnemonic(67);
        Dimension dimension = cancelButton.getPreferredSize();
        okButton.setPreferredSize(dimension);
        cancelButton.setPreferredSize(dimension);
        okButton.addActionListener(new OkButtonActionListener());
        cancelButton.addActionListener(new CancelButtonActionListener());
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        }
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(7, 12, 12, 14));
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(1, 6, 6, 7));
        }
        return buttonPanel;
    }

    private JPanel buildConfigurationPane() {
        this.configurationPane = new JTabbedPane();
        this.configurationPane.addTab("Log File", this.buildLogFileConfigPanel());
        this.configurationPane.addTab("Popup", this.buildPopUpConfigPanel());
        this.configurationPane.addTab("Advanced Options", this.buildAdvancedOptionsPanel());
        JPanel panel = new JPanel();
        panel.add(this.configurationPane);
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        return panel;
    }

    private JPanel buildLogFileConfigPanel() {
        JPanel logFileTextPanel = this.buildLogFileTextPanel();
        JPanel logFileControlPanel = this.buildLogFileControlPanel();
        this.logFileSpecPanel = this.buildLogFileSpecPanel();
        this.logFilePanel = new JPanel();
        this.logFilePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.logFilePanel.setLayout(new BoxLayout(this.logFilePanel, 1));
        this.logFilePanel.add(logFileTextPanel);
        this.logFilePanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.logFilePanel.add(logFileControlPanel);
        this.logFilePanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.logFilePanel.add(this.logFileSpecPanel);
        return this.logFilePanel;
    }

    private JPanel buildLogFileControlPanel() {
        String[] radioButtonTextArray = new String[]{"Disabled", "Enabled"};
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel radioPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        radioPanel.setLayout(layout);
        int count = 0;
        while (count < this.fileControlButton.length) {
            this.fileControlButton[count] = new JRadioButton(radioButtonTextArray[count]);
            buttonGroup.add(this.fileControlButton[count]);
            ++count;
        }
        Utility.addComponent(this.fileControlButton[0], radioPanel, layout, constraints, 0, 0, 0, 0, 12, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 0, 0, 0, 0, 0, 1.0);
        Utility.addComponent(this.fileControlButton[1], radioPanel, layout, constraints, 0, 1, 0, 4, 12, 0, 0.0);
        Utility.addComponent(new JLabel(""), radioPanel, layout, constraints, 1, 1, 0, 4, 0, 0, 1.0);
        this.fileControlButton[this.initialLogFileGen ? 1 : 0].setSelected(true);
        radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Log File Generation"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(radioPanel);
        return panel;
    }

    private JPanel buildLogFileSpecPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Log File Specification"));
        Dimension dimension = this.browseButton.getPreferredSize();
        this.browseButton.setPreferredSize(dimension);
        this.purgeButton.setPreferredSize(dimension);
        Utility.addComponent(new JLabel("Name:    "), panel, layout, constraints, 0, 0, 0, 8, 4, 0, 0.0);
        Utility.addComponent(this.nameField, panel, layout, constraints, 1, 0, 0, 8, 8, 0, 0.0);
        Utility.addComponent(this.browseButton, panel, layout, constraints, 2, 0, 0, 8, 8, 0, 0.0);
        Utility.addComponent(new JLabel("Location:"), panel, layout, constraints, 0, 1, 0, 8, 4, 0, 0.0);
        Utility.addComponent(this.locationField, panel, layout, constraints, 1, 1, 0, 8, 8, 0, 0.0);
        Utility.addComponent(this.purgeButton, panel, layout, constraints, 2, 1, 0, 8, 8, 0, 0.0);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer;
                String path;
                JFileChooser fc = new JFileChooser();
                FormattedTextFileFilter filter = new FormattedTextFileFilter();
                fc.setFileFilter(filter);
                fc.setDialogTitle("Open");
                fc.setCurrentDirectory(new File(ConfigurationBox.this.logFileLocation));
                fc.setSelectedFile(new File(ConfigurationBox.this.logFileName));
                int returnVal = fc.showOpenDialog(ConfigurationBox.this);
                if (returnVal == 0 && new File(path = fc.getSelectedFile().getPath()).exists() && (answer = JOptionPane.showConfirmDialog(ConfigurationBox.this, path + " already exists.\n Do you want to overwrite it?\n\n" + "Click YES to overwrite the existent file.\n" + "Click NO to append to end of the file.\n\n", "New Event Log File Validation", 1, 1)) != 2) {
                    ConfigurationBox.this.logFileSpecified = true;
                    ConfigurationBox.this.logFilePath = path;
                    int lastIndex = ConfigurationBox.this.logFilePath.lastIndexOf(GlobalConstants.separatorChar);
                    ConfigurationBox.this.logFileName = ConfigurationBox.this.logFilePath.substring(lastIndex + 1);
                    ConfigurationBox.this.logFileLocation = ConfigurationBox.this.logFilePath.substring(0, lastIndex);
                    System.out.println("new logFileName     = '" + ConfigurationBox.this.logFileName + "'");
                    System.out.println("new logFileLocation = '" + ConfigurationBox.this.logFileLocation + "'");
                    System.out.println("new logFilePath     = '" + ConfigurationBox.this.logFilePath + "'");
                    ConfigurationBox.this.storageManagementUtility.saveLogFilePathConfiguration(ConfigurationBox.this.logFilePath);
                    if (answer == 0) {
                        if (path.equals(ConfigurationBox.this.logFilePath)) {
                            ConfigurationBox.this.databaseManager.eventDatabase.purgeWithoutSave(ConfigurationBox.this.logFilePath);
                        }
                    } else {
                        ConfigurationBox.this.databaseManager.eventDatabase.reloadLogFile();
                    }
                    ConfigurationBox.this.nameField.setText(ConfigurationBox.this.logFileName);
                    ConfigurationBox.this.locationField.setText(ConfigurationBox.this.logFileLocation);
                }
            }
        });
        this.purgeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(ConfigurationBox.this, "Do you want to save a copy of the events before purging them?", "Purge Events Validation", 1, 1);
                if (answer == 0) {
                    System.out.println("PURGE: user wants to save the events");
                    JFileChooser fc = new JFileChooser();
                    BackupTextFileFilter filter = new BackupTextFileFilter();
                    fc.setFileFilter(filter);
                    fc.setDialogTitle("Save As");
                    fc.setCurrentDirectory(new File(ConfigurationBox.this.purgeFileLocation));
                    fc.setSelectedFile(new File(ConfigurationBox.this.purgeFileName));
                    int returnVal = fc.showSaveDialog(ConfigurationBox.this);
                    if (returnVal == 0) {
                        ConfigurationBox.this.setCursor(new Cursor(3));
                        String newPurgeFilePath = fc.getSelectedFile().getPath();
                        System.out.println("Selected file: '" + newPurgeFilePath + "'");
                        if (new File(newPurgeFilePath).exists()) {
                            System.out.println("PURGE: specified filename already exists!!!");
                            answer = JOptionPane.showConfirmDialog(ConfigurationBox.this, newPurgeFilePath + " already exists.\n Do you want to overwrite it?\n\n" + "Click YES to overwrite the existent file.\n" + "Click NO to append to end of the file.\n\n", "New Event Log Backup File Validation", 1, 1);
                            if (answer != 2) {
                                if (answer == 0) {
                                    ConfigurationBox.this.databaseManager.eventDatabase.purgeWithDeleteAndSave(ConfigurationBox.this.logFilePath, ConfigurationBox.this.purgeFilePath);
                                } else {
                                    ConfigurationBox.this.databaseManager.eventDatabase.purgeWithAppendSave(ConfigurationBox.this.logFilePath, ConfigurationBox.this.purgeFilePath);
                                }
                                if (!newPurgeFilePath.equals(ConfigurationBox.this.purgeFilePath)) {
                                    ConfigurationBox.this.purgeFileSpecified = true;
                                    ConfigurationBox.this.purgeFilePath = newPurgeFilePath;
                                    int lastIndex = ConfigurationBox.this.purgeFilePath.lastIndexOf(GlobalConstants.separatorChar);
                                    ConfigurationBox.this.purgeFileName = ConfigurationBox.this.purgeFilePath.substring(lastIndex + 1);
                                    ConfigurationBox.this.purgeFileLocation = ConfigurationBox.this.purgeFilePath.substring(0, lastIndex);
                                    System.out.println("new purgeFileName     = '" + ConfigurationBox.this.purgeFileName + "'");
                                    System.out.println("new purgeFileLocation = '" + ConfigurationBox.this.purgeFileLocation + "'");
                                    System.out.println("new purgeFilePath     = '" + ConfigurationBox.this.purgeFilePath + "'");
                                    ConfigurationBox.this.storageManagementUtility.savePurgeFilePathConfiguration(ConfigurationBox.this.purgeFilePath);
                                }
                            }
                        } else {
                            System.out.println("PURGE: specified filename does NOT exist");
                            ConfigurationBox.this.purgeFilePath = newPurgeFilePath;
                            int lastIndex = ConfigurationBox.this.purgeFilePath.lastIndexOf(GlobalConstants.separatorChar);
                            ConfigurationBox.this.purgeFileName = ConfigurationBox.this.purgeFilePath.substring(lastIndex + 1);
                            ConfigurationBox.this.purgeFileLocation = ConfigurationBox.this.purgeFilePath.substring(0, lastIndex);
                            System.out.println("new purgeFileName     = '" + ConfigurationBox.this.purgeFileName + "'");
                            System.out.println("new purgeFileLocation = '" + ConfigurationBox.this.purgeFileLocation + "'");
                            System.out.println("new purgeFilePath     = '" + ConfigurationBox.this.purgeFilePath + "'");
                            ConfigurationBox.this.storageManagementUtility.savePurgeFilePathConfiguration(ConfigurationBox.this.purgeFilePath);
                            ConfigurationBox.this.databaseManager.eventDatabase.purgeWithSave(ConfigurationBox.this.logFilePath, ConfigurationBox.this.purgeFilePath);
                        }
                        ConfigurationBox.this.setCursor(new Cursor(0));
                    }
                } else if (answer == 1) {
                    System.out.println("PURGE: user doesn't want to save the events");
                    ConfigurationBox.this.databaseManager.eventDatabase.purgeWithoutSave(ConfigurationBox.this.logFilePath);
                }
            }
        });
        return panel;
    }

    private JPanel buildLogFileTextPanel() {
        String fileInfo0 = "The log file is used to preserve events received from the RAID driver.";
        String fileInfo1 = "Contents of the log file can be viewed via the 'Event Log' option of ";
        String fileInfo2 = "the 'Window' menu. The log file generation can be controlled via the ";
        String fileInfo3 = "radio buttons in the 'Log File Generation' section of this screen. The";
        String fileInfo4 = "file name and location can be set  in  the  'Log File Specification'";
        String fileInfo5 = "section of this screen.  Contents of the log file can be purged into";
        String fileInfo6 = "another  file  or  permanently deleted via the 'Purge' button in the";
        String fileInfo7 = "'Log File Specification' section of this screen.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Log File Information"));
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo2), panel, layout, constraints, 0, 2, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo3), panel, layout, constraints, 0, 3, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo4), panel, layout, constraints, 0, 4, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo5), panel, layout, constraints, 0, 5, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo6), panel, layout, constraints, 0, 6, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo7), panel, layout, constraints, 0, 7, 0, 8, 4, 0, 0.0);
        return panel;
    }

    private JPanel buildPopUpConfigPanel() {
        JPanel popUpTextPanel = this.buildPopUpTextPanel();
        JPanel popUpControlPanel = this.buildPopUpControlPanel();
        this.popUpPanel = new JPanel();
        this.popUpPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.popUpPanel.setLayout(new BoxLayout(this.popUpPanel, 1));
        this.popUpPanel.add(popUpTextPanel);
        this.popUpPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.popUpPanel.add(popUpControlPanel);
        return this.popUpPanel;
    }

    private JPanel buildPopUpControlPanel() {
        this.mouseDragged = false;
        this.mouseDraggedCount = 0;
        int level = 0;
        this.sliderValue = 0;
        if (this.initialPopUpLevel.equals(GlobalConstants.popUpLevelStrings[++level])) {
            this.sliderValue = 10 * level;
        } else if (this.initialPopUpLevel.equals(GlobalConstants.popUpLevelStrings[++level])) {
            this.sliderValue = 10 * level;
        } else if (this.initialPopUpLevel.equals(GlobalConstants.popUpLevelStrings[++level])) {
            this.sliderValue = 30;
        }
        this.popUpLevelSlider = new JSlider(1, 0, 30, this.sliderValue);
        this.popUpLevelSlider.setMajorTickSpacing(10);
        this.popUpLevelSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel(" " + GlobalConstants.popUpLevelStrings[0]));
        labelTable.put(new Integer(10), new JLabel(" " + GlobalConstants.popUpLevelStrings[1]));
        labelTable.put(new Integer(20), new JLabel(" " + GlobalConstants.popUpLevelStrings[2]));
        labelTable.put(new Integer(30), new JLabel(" " + GlobalConstants.popUpLevelStrings[3]));
        this.popUpLevelSlider.setLabelTable(labelTable);
        this.popUpLevelSlider.setPaintLabels(true);
        this.popUpLevelSlider.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 20));
        this.levelInfoPanel = this.buildPopUpLevelInfoPanel();
        JPanel compoundSliderPanel = new JPanel();
        compoundSliderPanel.setLayout(new BoxLayout(compoundSliderPanel, 0));
        compoundSliderPanel.add(this.popUpLevelSlider);
        compoundSliderPanel.add(this.levelInfoPanel);
        compoundSliderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Event Level Control"));
        this.sliderListener = new SliderListener();
        this.popUpLevelSlider.addChangeListener(this.sliderListener);
        this.popUpLevelSlider.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                ConfigurationBox.this.popUpLevelSlider.setSnapToTicks(true);
                ConfigurationBox.this.mouseDragged = true;
                ConfigurationBox.this.mouseDraggedCount++;
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        return compoundSliderPanel;
    }

    private JPanel buildPopUpDisabledLevelInfoPanel() {
        String fileInfo0 = "The popup window will be disabled";
        String fileInfo1 = "and will not be displayed.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 8, 4, 0, 0.0);
        JPanel disablePanel = new JPanel();
        disablePanel.add((Component)panel, "North");
        disablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Disabled Event Level")));
        return disablePanel;
    }

    private JPanel buildPopUpErrorLevelInfoPanel() {
        String fileInfo0 = "The popup window will be displayed";
        String fileInfo1 = "when an ERROR event is generated.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 8, 4, 0, 0.0);
        JPanel errorPanel = new JPanel();
        errorPanel.add((Component)panel, "North");
        errorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Error Event Level")));
        return errorPanel;
    }

    private JPanel buildPopUpInformationalLevelInfoPanel() {
        String fileInfo0 = "The popup window will be displayed";
        String fileInfo1 = "when INFORMATIONAL, WARNING,";
        String fileInfo2 = "or ERROR event is generated.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo2), panel, layout, constraints, 0, 2, 0, 8, 4, 0, 0.0);
        JPanel informatPanel = new JPanel();
        informatPanel.add((Component)panel, "North");
        informatPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Informational Event Level")));
        return informatPanel;
    }

    private JPanel buildPopUpInstructionPanel() {
        String fileInfo0 = "Move the slider to set notification level";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 8, 4, 0, 0.0);
        JPanel returnPanel = new JPanel();
        returnPanel.add((Component)panel, "North");
        return returnPanel;
    }

    private JPanel buildPopUpLevelInfoPanel() {
        this.instructionPanel = this.buildPopUpInstructionPanel();
        this.disabledLevelPanel = this.buildPopUpDisabledLevelInfoPanel();
        this.errorLevelPanel = this.buildPopUpErrorLevelInfoPanel();
        this.warningLevelPanel = this.buildPopUpWarningLevelInfoPanel();
        this.informationalLevelPanel = this.buildPopUpInformationalLevelInfoPanel();
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoPanel.add(this.instructionPanel);
        this.infoPanel.add(this.addEventLevelPanel());
        return this.infoPanel;
    }

    private JPanel buildPopUpTextPanel() {
        String fileInfo0 = "Popup window is a visual notification that an event has occurred.";
        String fileInfo1 = "The popup window can be disabled or set to pop up for only certain";
        String fileInfo2 = "event levels.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Popup Window Information"));
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo2), panel, layout, constraints, 0, 2, 0, 8, 4, 0, 0.0);
        return panel;
    }

    private JPanel buildPopUpWarningLevelInfoPanel() {
        String fileInfo0 = "The popup window will be displayed";
        String fileInfo1 = "when a WARNING or ERROR event is";
        String fileInfo2 = "generated.";
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        panel.setLayout(layout);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Utility.addComponent(new JLabel(fileInfo0), panel, layout, constraints, 0, 0, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo1), panel, layout, constraints, 0, 1, 0, 0, 4, 0, 0.0);
        Utility.addComponent(new JLabel(fileInfo2), panel, layout, constraints, 0, 2, 0, 8, 4, 0, 0.0);
        JPanel warningPanel = new JPanel();
        warningPanel.add((Component)panel, "North");
        warningPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Warning Event Level")));
        return warningPanel;
    }

    protected void closeDialog() {
        System.out.println("closeDialog");
        this.dispose();
    }

    private void getConfigurationVariables() {
        this.logFilePath = this.storageManagementUtility.logFilePath;
        int lastIndex = this.logFilePath.lastIndexOf(GlobalConstants.separatorChar);
        this.logFileName = this.logFilePath.substring(lastIndex + 1);
        this.logFileLocation = this.logFilePath.substring(0, lastIndex);
        System.out.println("loadPreferences(): logFileName     = '" + this.logFileName + "'");
        System.out.println("loadPreferences(): logFileLocation = '" + this.logFileLocation + "'");
        System.out.println("loadPreferences(): logFilePath     = '" + this.logFilePath + "'");
        this.purgeFilePath = this.storageManagementUtility.purgeFilePath;
        lastIndex = this.purgeFilePath.lastIndexOf(GlobalConstants.separatorChar);
        this.purgeFileName = this.purgeFilePath.substring(lastIndex + 1);
        this.purgeFileLocation = this.purgeFilePath.substring(0, lastIndex);
        System.out.println("loadPreferences(): purgeFileName     = '" + this.purgeFileName + "'");
        System.out.println("loadPreferences(): purgeFileLocation = '" + this.purgeFileLocation + "'");
        System.out.println("loadPreferences(): purgeFilePath     = '" + this.purgeFilePath + "'");
        this.initialLogFileGen = this.storageManagementUtility.logFileGen;
        this.initialLogFilePath = this.storageManagementUtility.logFilePath;
        this.initialPurgeFilePath = this.storageManagementUtility.purgeFilePath;
        this.initialPopUpLevel = this.storageManagementUtility.popUpLevel;
        this.initialLegacySupport = this.storageManagementUtility.legacySupportOption;
        this.initialDeleteMember = this.storageManagementUtility.deleteMemberOption;
        this.initialResourceInfo = this.storageManagementUtility.resourceInfoOption;
        this.initialRaidFeatures = this.storageManagementUtility.advancedRaidOption;
    }

    private void initializeComponents() {
        this.getConfigurationVariables();
        this.fileControlButton = new JRadioButton[2];
        this.browseButton = new JButton("Browse");
        this.purgeButton = new JButton("Purge");
        this.logFileSpecified = false;
        this.purgeFileSpecified = false;
        this.logFileSpecPanelEnabled = true;
        this.nameField = new JTextField(20);
        this.locationField = new JTextField(20);
        this.nameField.setText(this.logFileName);
        this.locationField.setText(this.logFileLocation);
        this.nameField.setEditable(false);
        this.locationField.setEditable(false);
        this.databaseChangeHandler = new DatabaseChangeHandler();
        this.legacySupportCheckBox = new JCheckBox("", this.initialLegacySupport);
        this.deleteMemberCheckBox = new JCheckBox("", this.initialDeleteMember);
        this.resourceInfoCheckBox = new JCheckBox("", this.initialResourceInfo);
        this.raidFeaturesCheckBox = new JCheckBox("", this.initialRaidFeatures);
    }

    private synchronized void updateBoxContents(boolean changeInfoPanels) {
        if (this.logFileSpecPanelEnabled && this.fileControlButton[0].isSelected()) {
            this.logFileSpecPanelEnabled = false;
            Utility.enableContainer(this.logFileSpecPanel, false);
        } else if (!this.logFileSpecPanelEnabled && this.fileControlButton[1].isSelected()) {
            this.logFileSpecPanelEnabled = true;
            Utility.enableContainer(this.logFileSpecPanel, true);
        }
    }

    private void updateInfoPanel() {
        this.infoPanel.removeAll();
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoPanel.add(this.instructionPanel);
        this.infoPanel.add(this.addEventLevelPanel());
        this.infoPanel.validate();
        this.infoPanel.repaint();
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (ConfigurationBox.this.popUpLevelSlider.getValueIsAdjusting()) {
                return;
            }
            int newSliderValue = ConfigurationBox.this.popUpLevelSlider.getValue();
            int valueWhole = newSliderValue / 10;
            int valueFraction = newSliderValue % 10;
            if (!ConfigurationBox.this.mouseDragged || ConfigurationBox.this.mouseDragged && ConfigurationBox.this.mouseDraggedCount < 10) {
                ConfigurationBox.this.popUpLevelSlider.removeChangeListener(ConfigurationBox.this.sliderListener);
                ConfigurationBox.this.popUpLevelSlider.setSnapToTicks(false);
                if (newSliderValue == 0) {
                    ++newSliderValue;
                }
                if (newSliderValue > ConfigurationBox.this.sliderValue) {
                    ConfigurationBox.this.sliderValue += 10;
                    if (ConfigurationBox.this.sliderValue > 30) {
                        ConfigurationBox.this.sliderValue = 30;
                    }
                } else if (newSliderValue < ConfigurationBox.this.sliderValue) {
                    ConfigurationBox.this.sliderValue -= 10;
                    if (ConfigurationBox.this.sliderValue < 0) {
                        ConfigurationBox.this.sliderValue = 0;
                    }
                }
                ConfigurationBox.this.popUpLevelSlider.setValue(ConfigurationBox.this.sliderValue);
                ConfigurationBox.this.popUpLevelSlider.addChangeListener(ConfigurationBox.this.sliderListener);
            }
            ConfigurationBox.this.mouseDragged = false;
            ConfigurationBox.this.mouseDraggedCount = 0;
            ConfigurationBox.this.popUpLevelSlider.setSnapToTicks(false);
            ConfigurationBox.this.sliderValue = ConfigurationBox.this.popUpLevelSlider.getValue();
            ConfigurationBox.this.updateInfoPanel();
        }
    }

    public class BackupTextFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String path = f.getPath().toLowerCase();
            return path.endsWith(".bak");
        }

        public String getDescription() {
            return "Saved Event Log (*.bak)";
        }
    }

    public class FormattedTextFileFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String path = f.getPath().toLowerCase();
            return path.endsWith(".evl");
        }

        public String getDescription() {
            return "Event Log (*.evl)";
        }
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!ConfigurationBox.this.logFileSpecified && !ConfigurationBox.this.purgeFileSpecified) {
                ConfigurationBox.this.storageManagementUtility.logFileGen = ConfigurationBox.this.initialLogFileGen;
            }
            if (!ConfigurationBox.this.logFileSpecified) {
                ConfigurationBox.this.storageManagementUtility.logFilePath = ConfigurationBox.this.initialLogFilePath;
            }
            if (!ConfigurationBox.this.purgeFileSpecified) {
                ConfigurationBox.this.storageManagementUtility.purgeFilePath = ConfigurationBox.this.initialPurgeFilePath;
            }
            ConfigurationBox.this.storageManagementUtility.popUpLevel = ConfigurationBox.this.initialPopUpLevel;
            ConfigurationBox.this.storageManagementUtility.legacySupportOption = ConfigurationBox.this.initialLegacySupport;
            ConfigurationBox.this.storageManagementUtility.deleteMemberOption = ConfigurationBox.this.initialDeleteMember;
            ConfigurationBox.this.storageManagementUtility.resourceInfoOption = ConfigurationBox.this.initialResourceInfo;
            ConfigurationBox.this.storageManagementUtility.advancedRaidOption = ConfigurationBox.this.initialRaidFeatures;
            ConfigurationBox.this.storageManagementUtility.saveConfigurationPreferences();
            ConfigurationBox.this.closeDialog();
        }
    }

    class OkButtonActionListener
    implements ActionListener {
        OkButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean currentLgFileGen;
            ConfigurationBox.this.databaseChangeHandler = null;
            boolean bl = currentLgFileGen = !ConfigurationBox.this.fileControlButton[0].isSelected();
            if (ConfigurationBox.this.initialLogFileGen != currentLgFileGen) {
                if (currentLgFileGen) {
                    ConfigurationBox.this.storageManagementUtility.logFileGen = currentLgFileGen;
                    ConfigurationBox.this.databaseManager.eventDatabase.UpdateApplicationEvents("Informational", "Event Writer starting up");
                } else {
                    ConfigurationBox.this.databaseManager.eventDatabase.UpdateApplicationEvents("Informational", "Event Writer shutting down");
                    ConfigurationBox.this.storageManagementUtility.logFileGen = currentLgFileGen;
                }
            }
            int currentSliderValue = ConfigurationBox.this.popUpLevelSlider.getValue() / 10;
            ConfigurationBox.this.storageManagementUtility.popUpLevel = GlobalConstants.popUpLevelStrings[currentSliderValue];
            System.out.println("OkButtonListener(): popUpLevelStrings[" + currentSliderValue + "] = '" + GlobalConstants.popUpLevelStrings[currentSliderValue] + "'");
            ConfigurationBox.this.storageManagementUtility.legacySupportOption = ConfigurationBox.this.legacySupportCheckBox.isSelected();
            ConfigurationBox.this.storageManagementUtility.advancedRaidOption = ConfigurationBox.this.raidFeaturesCheckBox.isSelected();
            ConfigurationBox.this.storageManagementUtility.deleteMemberOption = ConfigurationBox.this.deleteMemberCheckBox.isSelected();
            ConfigurationBox.this.storageManagementUtility.resourceInfoOption = ConfigurationBox.this.resourceInfoCheckBox.isSelected();
            ConfigurationBox.this.storageManagementUtility.saveConfigurationPreferences();
            ConfigurationBox.this.closeDialog();
        }
    }

    private class DatabaseChangeHandler
    implements Runnable {
        private DatabaseChangeHandler() {
        }

        public void run() {
            ConfigurationBox.this.updateBoxContents(false);
        }
    }

    class ParameterChangeListener
    implements ActionListener,
    KeyListener,
    FocusListener {
        ParameterChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ConfigurationBox.this.updateBoxContents(false);
        }

        public void focusGained(FocusEvent e) {
            ((JTextField)e.getSource()).selectAll();
        }

        public void focusLost(FocusEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }
}

