/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class CommManager
implements GlobalConstants {
    public CommLink commLink;
    private DatabaseManager databaseManager;
    private String enclosure;
    private HostConnectionManager hostConnectionManager;
    private JavaToIdeComm ideCommPort;
    private ArrayList listenerList;
    private String logFileName;
    private MessageQueue mailbox;
    private MessageProcessingThread messageProcessingThread;
    private ArrayList notifyList;
    private StorageManagementUtility storageManagementUtility;

    public CommManager(StorageManagementUtility storageManagementUtility, HostConnectionManager hostConnectionManager, boolean verbose) {
        this.storageManagementUtility = storageManagementUtility;
        this.hostConnectionManager = hostConnectionManager;
        this.mailbox = new MessageQueue();
        this.notifyList = new ArrayList();
        this.listenerList = new ArrayList();
        this.ideCommPort = new JavaToIdeComm();
        try {
            this.commLink = new CommLink(this, this.mailbox, this.ideCommPort, verbose);
        }
        catch (Exception e) {
        }
        MessageProcessingThread messageProcessingThread = new MessageProcessingThread();
        messageProcessingThread.start();
        File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "debug.txt");
        this.logFileName = file.exists() ? "CommLog.xml" : null;
        if (this.logFileName != null) {
            ApplicationLog.flush(this.logFileName);
        }
    }

    public synchronized void addChangeListener(CommLinkChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void addDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public void addMessageHandler(String action, AbstractMessageHandler messageHandler) {
        Message message = new Message();
        message.request = "AddMessageHandler";
        message.messageHandler = messageHandler;
        this.mailbox.putMessage(message);
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public void closeConnection() {
        if (this.commLink.enabled) {
            this.commLink.closeLink();
        }
    }

    public CommLink getCommLink() {
        if (this.commLink.upDownStatus.equals("Up")) {
            return this.commLink;
        }
        return null;
    }

    public int getControllerCount() {
        return this.commLink.getControllerCount();
    }

    public String getLastError() {
        return this.commLink.getLastError();
    }

    public boolean linkActive() {
        return this.commLink.upDownStatus.equals("Up");
    }

    public void linkStatusChange(CommLinkChangeEvent event, String change) {
        int index;
        if (event != null) {
            index = 0;
            while (index < this.listenerList.size()) {
                CommLinkChangeListener listener = (CommLinkChangeListener)this.listenerList.get(index);
                if (change.equals("LinkUp")) {
                    listener.linkUp((CommLinkChangeEvent)event.clone());
                } else {
                    listener.linkDown((CommLinkChangeEvent)event.clone());
                }
                ++index;
            }
        }
        index = 0;
        while (index < this.notifyList.size()) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
            ++index;
        }
    }

    public int openLocalConnection(int controller) {
        return this.commLink.openLocalLink(controller);
    }

    public int openRemoteConnection(String ipAddress, int controller, int serverPort) {
        return this.commLink.openEthernetLink(ipAddress, controller, serverPort);
    }

    public void reconnectConnection() {
        this.commLink.reconnect();
    }

    public synchronized void removeChangeListener(CommLinkChangeListener listener) {
        ((AbstractCollection)this.listenerList).remove(listener);
    }

    public void removeDriveRequest(int controller, int pathId, int targetId) {
        this.commLink.removeDrive(controller, pathId, targetId);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        int index = 0;
        while (index < this.notifyList.size()) {
            if ((Runnable)this.notifyList.get(index) == updateListener) {
                this.notifyList.remove(index);
                break;
            }
            ++index;
        }
    }

    public void resetLink() {
        this.commLink.resetLink();
    }

    public void scanDriveRequest() {
        this.commLink.scanDrive();
    }

    public void sendMessage(String action, String request, AbstractMessageHandler handler) {
        Message message = new Message();
        message.mailSort = 1;
        message.controller = this.hostConnectionManager.getNexusController();
        message.action = action;
        message.request = request;
        message.messageHandler = handler;
        this.sendMessage(message);
    }

    public void sendMessage(int controller, String action, String request, AbstractMessageHandler handler) {
        Message message = new Message();
        message.mailSort = 1;
        message.controller = controller;
        message.action = action;
        message.request = request;
        message.messageHandler = handler;
        this.sendMessage(message);
    }

    public void sendMessage(Message message) {
        if (this.commLink != null && this.commLink.isConnected()) {
            if (message.mainPageWait) {
                this.storageManagementUtility.setWait();
            }
            this.commLink.sendMessage(message);
        } else {
            message.status = 1;
            if (message.messageHandler != null) {
                message.messageHandler.dispatchErrorHandler(message);
            }
        }
    }

    private class MessageProcessingThread
    extends Thread {
        static final String commThread = "CommManager Thread - ";

        private MessageProcessingThread() {
        }

        public void run() {
            while (true) {
                Message message = null;
                try {
                    message = (Message)CommManager.this.mailbox.getMessage(true);
                    if (message.status != 0) {
                        System.out.println("CommManager Thread - No Good Status: " + message.status);
                        if (message.mainPageWait) {
                            CommManager.this.storageManagementUtility.clearWait();
                        }
                        if (message.messageHandler != null) {
                            System.out.println("CommManager Thread - Calling error handler method for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller:" + message.controller);
                            message.messageHandler.dispatchErrorHandler(message);
                            continue;
                        }
                        System.out.println("CommManager Thread - No Message Handler Specified for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                        continue;
                    }
                    if (message != null && message.messageHandler != null) {
                        if (message.mainPageWait) {
                            CommManager.this.storageManagementUtility.clearWait();
                        }
                        message.messageHandler.dispatchMessageHandler(message);
                        continue;
                    }
                    if (message == null) {
                        System.out.println("CommManager Thread - Null message received");
                        continue;
                    }
                    System.out.println("CommManager Thread - No Message Handler Specified for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                    continue;
                }
                catch (Exception exception) {
                    if (message != null) {
                        ErrorLog.put(exception, "CommManager Thread - Exception: Message Received:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                        continue;
                    }
                    ErrorLog.put(exception, "CommManager Thread - Exception");
                    continue;
                }
                break;
            }
        }
    }
}

