/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class CommLink
implements GlobalConstants {
    public static final int COM_LINK_STAT_ERR_NO_CONTROLLER = 2;
    public static final int COM_LINK_STAT_ERR_OPEN_FAILED = 1;
    public static final int COM_LINK_STAT_GOOD = 0;
    private static final boolean DebugComm = true;
    public static final int LOCAL_CONNECTION = 0;
    public static final int MAX_SENT = 4;
    public static final int REMOTE_CONNECTION = 1;
    public static final int STATE_ATTEMPTING_CONNECTION = 4;
    public static final int STATE_ATTEMPTING_OPEN = 1;
    public static final int STATE_ATTEMPTING_REOPEN = 2;
    public static final int STATE_CONNECTED = 7;
    public static final int STATE_INACTIVE = 0;
    private static final boolean abreviate = true;
    private final String blankString = " ";
    public int commErrors;
    private CommManager commManager;
    private MessageQueue commManagerMailbox;
    private MessageQueue commQueue;
    public String connectionType;
    public int connectionTypeIndex;
    public static final String[] connectionTypeStrings = new String[]{"Local", "Remote"};
    public int controller;
    private int controllerCount;
    public String controllerLabel;
    private final String controllerLabelString = "Controller";
    public boolean enabled;
    EventEmail eventEmail;
    private JavaToIdeComm ideCommPort;
    public int initCount;
    public String ipAddress;
    public String lastError;
    public int lastEvent;
    public long lastMessagesReceived;
    public long lastTransactions;
    private int linkState;
    private LinkThread linkThread;
    public boolean local;
    private String logFileName;
    public long messagesReceived;
    public int newController;
    private int newControllerCount;
    public String newIpAddress;
    public int newServerPort;
    public String offlineDetails;
    public String offlineStatus;
    private final String pingString = String.valueOf('\u0005');
    private int prevController;
    private String prevControllerLabel;
    private String prevIpAddress;
    private int prevLinkState;
    private String prevOfflineDetails;
    private String prevOfflineStatus;
    private String prevUpDownStatus;
    private int previousLinkState;
    private int receivedByteCount;
    public int serverPort;
    private int tag;
    public Date timeStamp;
    public int transactions;
    public long transferred;
    private int transmittedByteCount;
    public String upDownStatus;
    private boolean verbose;

    CommLink(CommManager commManager, MessageQueue commManagerMailbox, JavaToIdeComm ideCommPort, boolean verbose) {
        this.eventEmail = new EventEmail();
        this.commManager = commManager;
        this.commManagerMailbox = commManagerMailbox;
        this.ideCommPort = ideCommPort;
        this.verbose = verbose;
        this.linkState = 0;
        this.upDownStatus = "Down";
        this.ipAddress = "0.0.0.0";
        this.controller = 0;
        this.controllerCount = 0;
        this.controllerLabel = " ";
        this.offlineStatus = "Link Disabled";
        this.offlineDetails = " ";
        File file = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + "debug.txt");
        this.logFileName = file.exists() ? "CommLog.xml" : null;
        if (this.logFileName != null) {
            ApplicationLog.flush(this.logFileName);
        }
        this.commQueue = new MessageQueue();
        this.linkThread = new LinkThread();
        this.linkThread.start();
    }

    private void changeIpAddress(String newIpAddress) {
        this.ipAddress = newIpAddress;
        this.commManager.linkStatusChange(null, null);
    }

    public void closeLink() {
        System.out.println("received close link request");
        this.enabled = false;
        this.offlineStatus = "Closing link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "CloseLink"));
    }

    public int getControllerCount() {
        System.out.println("received get controller count request");
        return this.controllerCount;
    }

    private CommLinkChangeEvent getEvent() {
        CommLinkChangeEvent event = new CommLinkChangeEvent();
        event.local = this.local;
        event.ipAddress = this.ipAddress;
        event.controller = this.controller;
        return event;
    }

    public String getLastError() {
        return this.lastError;
    }

    public int getLinkState() {
        return this.linkState;
    }

    public String getLinkTime() {
        if (this.upDownStatus.equals("Up")) {
            GregorianCalendar c = new GregorianCalendar();
            Date newDate = c.getTime();
            int time = (int)(newDate.getTime() - this.timeStamp.getTime()) / 1000;
            return Utility.covertSecondsToHourMinuteSecond(time);
        }
        return " ";
    }

    public String getTransferred() {
        return Utility.byteCountLongToString(this.transferred);
    }

    public String getUpDownStatus() {
        return this.upDownStatus;
    }

    public synchronized boolean isConnected() {
        return this.linkState == 7;
    }

    public int openEthernetLink(String newIpAddress, int controller, int serverPort) {
        System.out.println("received open link (ethernet) request");
        MessageQueue callBackMailBox = new MessageQueue();
        Message message = new Message(3, "OpenLink");
        message.payload = newIpAddress;
        message.controller = controller;
        message.argument0 = serverPort;
        message.callBackMailBox = callBackMailBox;
        message.callBackValid = true;
        this.commQueue.putMessage(message);
        message = (Message)callBackMailBox.getMessage(true);
        System.out.println("openEthernetLink: received the callBack message with the status of: " + message.responseStatus);
        return message.responseStatus;
    }

    public int openLocalLink(int controller) {
        System.out.println("received open link (local) request");
        MessageQueue callBackMailBox = new MessageQueue();
        Message message = new Message(3, "DirectConnect");
        message.controller = controller;
        message.callBackMailBox = callBackMailBox;
        message.callBackValid = true;
        this.commQueue.putMessage(message);
        message = (Message)callBackMailBox.getMessage(true);
        System.out.println("openLocalLink: received the callBack message with the status of: " + message.responseStatus);
        return message.responseStatus;
    }

    private synchronized void preserveCurrentState() {
        this.prevLinkState = this.linkState;
        this.prevUpDownStatus = this.upDownStatus;
        this.prevIpAddress = this.ipAddress;
        this.prevController = this.controller;
        this.prevControllerLabel = this.controllerLabel;
        this.prevOfflineStatus = this.offlineStatus;
        this.prevOfflineDetails = this.offlineDetails;
    }

    public void reconnect() {
        System.out.println("AAAAAA received reconnect request");
        this.offlineStatus = "Reconnecting";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "Reconnect"));
    }

    private synchronized void recoverPreviousState() {
        this.linkState = this.prevLinkState;
        this.upDownStatus = this.prevUpDownStatus;
        this.ipAddress = this.prevIpAddress;
        this.controller = this.prevController;
        this.controllerLabel = this.prevControllerLabel;
        this.offlineStatus = this.prevOfflineStatus;
        this.offlineDetails = this.prevOfflineDetails;
    }

    public void removeDrive(int controller, int pathId, int targetId) {
        Message message = new Message(3, "RemoveDrive");
        message.controller = controller;
        message.argument0 = pathId;
        message.argument1 = targetId;
        this.commQueue.putMessage(message);
    }

    public void removeDriveDirect(int controller, int pathId, int targetId) {
        System.out.println("+++ removeDriveDirect - calling RemoveDrive");
        this.ideCommPort.RemoveDrive(controller, pathId, targetId);
        System.out.println("+++ removeDriveDirect - back from RemoveDrive");
    }

    public void resetLink() {
        this.offlineStatus = "Resetting link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "ResetLink"));
    }

    public void resetLinkState() {
        this.offlineStatus = "Resetting link";
        this.offlineDetails = " ";
        this.commManager.linkStatusChange(null, null);
        this.commQueue.putMessage(new Message(3, "ResetLink"));
    }

    public void scanDrive() {
        this.commQueue.putMessage(new Message(3, "ScanDrive"));
    }

    public boolean scanDriveDirect() {
        System.out.println("=== scanDriveDirect - calling ScanDrive");
        boolean result = this.ideCommPort.ScanDrive();
        System.out.println("=== scanDriveDirect - back from ScanDrive");
        return result;
    }

    public void sendMessage(Message message) {
        this.commQueue.putMessage(message);
    }

    class LinkThread
    extends Thread {
        final int MAX_OUTSTANDING_MESSAGES = 8;
        String NewXMLLine = "";
        final String StartOfEnvelope = "<?xml version='1.0' ?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" env:encodingStyle=\"http://www.w3.org/2003/05/soap-encoding\" si=\"http://www.siliconimage.com\">";
        File XMLLogFile;
        FileOutputStream outputStream = null;
        String resp = null;
        LinkedList sentList;
        Timer timer;
        LinkedList waitingToSendList;

        public LinkThread() {
            String completeFilename = System.getProperty("user.dir") + System.getProperty("file.separator") + "xmlcomm.xml";
            this.XMLLogFile = new File(completeFilename);
            if (this.XMLLogFile.exists()) {
                this.XMLLogFile.delete();
            }
            try {
                this.XMLLogFile.createNewFile();
                this.outputStream = new FileOutputStream(completeFilename, true);
            }
            catch (Exception e) {
                ErrorLog.put(e, "CommLink: LinkThread(): Failed creating session file");
                System.out.println("CommLink: LinkThread(): Failed creating session file");
            }
            this.sentList = new LinkedList();
            this.waitingToSendList = new LinkedList();
            this.timer = new Timer(3000, new ActionListener(this){
                private final /* synthetic */ LinkThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    CommLink.access$100(LinkThread.access$000(this.this$1)).putMessage(new Message(3, "ExpiredTimer"));
                }
            });
        }

        static /* synthetic */ CommLink access$000(LinkThread x0) {
            return x0.CommLink.this;
        }

        private void establishConnection(int newConnectionTypeIndex, int newController) {
            CommLink.this.upDownStatus = "Up";
            CommLink.this.linkState = 7;
            CommLink.this.controller = newController;
            CommLink.this.ipAddress = CommLink.this.newIpAddress;
            CommLink.this.serverPort = CommLink.this.newServerPort;
            CommLink.this.controllerCount = CommLink.this.newControllerCount;
            CommLink.this.controllerLabel = "Controller";
            CommLink.this.connectionTypeIndex = newConnectionTypeIndex;
            ApplicationLog.put("Link logged in to " + CommLink.this.controllerLabel + Integer.toString(CommLink.this.controller));
            System.out.println("Link logged in to " + CommLink.this.controllerLabel + Integer.toString(CommLink.this.controller));
            CommLink.this.enabled = true;
            CommLink.this.local = CommLink.this.connectionTypeIndex == 0;
            CommLink.this.connectionType = connectionTypeStrings[CommLink.this.connectionTypeIndex];
            if (CommLink.this.local) {
                CommLink.this.ipAddress = "0.0.0.0";
            }
            GregorianCalendar c = new GregorianCalendar();
            CommLink.this.timeStamp = c.getTime();
            CommLink.this.offlineStatus = "Connection Established with " + CommLink.this.controllerLabel;
            CommLink.this.offlineDetails = " ";
            System.out.println("CommLink: establishConnection(): invoking LinkUp linkStatusChange");
            CommLink.this.commManager.linkStatusChange(CommLink.this.getEvent(), "LinkUp");
        }

        private String getBodyContents(String payload) {
            XmlData xmlData = new XmlData(payload);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("Body")) continue;
                xmlData.nest();
                return xmlData.elementStream;
            }
            return "";
        }

        private void goToSleep(int sleepDuration) {
            try {
                Thread.sleep(sleepDuration);
            }
            catch (Exception e) {
            }
        }

        private void processCloseLink(boolean userSelected) {
            Message message;
            boolean supressNotification = userSelected && CommLink.this.upDownStatus.equals("Down");
            int previousLinkState = CommLink.this.linkState;
            CommLink.this.linkState = 0;
            System.out.println("closed link");
            this.timer.stop();
            CommLink.this.receivedByteCount = 0;
            CommLink.this.transmittedByteCount = 0;
            CommLink.this.transactions = 0;
            CommLink.this.transferred = 0L;
            CommLink.this.controllerLabel = "None";
            CommLink.this.upDownStatus = "Down";
            CommLink.this.offlineStatus = userSelected ? "Closed by user" : (previousLinkState == 7 ? "Connection lost" : (previousLinkState == 4 ? "Connection attempt Failed" : "Resetting link"));
            CommLink.this.offlineDetails = " ";
            if (supressNotification) {
                CommLink.this.commManager.linkStatusChange(null, "LinkDown");
            } else {
                CommLink.this.commManager.linkStatusChange(CommLink.this.getEvent(), "LinkDown");
            }
            while (this.sentList.size() > 0) {
                message = (Message)this.sentList.remove(0);
                message.status = 1;
                System.out.println("Return with error from sent list: \n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller: " + message.controller);
                CommLink.this.commManagerMailbox.putMessage(message);
            }
            while (this.waitingToSendList.size() > 0) {
                message = (Message)this.waitingToSendList.remove(0);
                message.status = 1;
                System.out.println("Return with error from wait list: \n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller: " + message.controller);
                CommLink.this.commManagerMailbox.putMessage(message);
            }
        }

        private void processExpiredTimer() {
            boolean newMessagesReceived = CommLink.this.messagesReceived != CommLink.this.lastMessagesReceived;
            CommLink.this.messagesReceived = CommLink.this.lastMessagesReceived;
            if (CommLink.this.linkState == 7) {
                CommLink.this.transferred = CommLink.this.receivedByteCount + CommLink.this.transmittedByteCount;
            }
            if (this.sentList.size() > 0) {
                Message sentMessage = (Message)this.sentList.get(0);
                if (newMessagesReceived) {
                    sentMessage.ticker = 0;
                } else {
                    ScheduleTime c = new ScheduleTime();
                    System.out.println(c.toString() + ": inactive " + CommLink.this.lastTransactions + " ticker " + sentMessage.ticker);
                    if (++sentMessage.ticker > 5) {
                        System.out.println("Timed out response ");
                        if (CommLink.this.linkState == 4) {
                            System.out.println("reset the Ethernet port");
                            this.processInternalResetLink();
                        }
                    }
                }
            }
        }

        private int processGetControllerCount() {
            System.out.println("CommLink: processGetControllerCount() host is connected: " + (CommLink.this.isConnected() ? "true" : "false"));
            System.out.println("CommLink: processGetControllerCount() entered");
            return CommLink.this.ideCommPort.getHandleCount();
        }

        private void processIncomingMessage(Message message) {
            int offset = message.payload.indexOf("<env:Header>");
            if (offset == -1) {
                System.out.println("CommLink: Invalid Message Received " + message.payload);
            } else {
                String resp = message.payload.substring(offset, message.payload.length());
                message.response = this.getBodyContents(resp);
                if (CommLink.this.linkState == 7) {
                    ++CommLink.this.transactions;
                    ++CommLink.this.messagesReceived;
                }
                CommLink.this.commManagerMailbox.putMessage(message);
            }
            if (this.waitingToSendList.size() > 0) {
                Message newMessage = (Message)this.waitingToSendList.remove(0);
                newMessage.tag = Integer.toString(CommLink.this.tag++);
                newMessage.ticker = 0;
                this.sentList.add(newMessage);
                this.transmitMessage(newMessage);
            }
        }

        private void processInternalMessage(Message message) {
            if (!message.request.equals("ExpiredTimer")) {
                System.out.println("CommLink: processInternalMessage() for request: " + message.request);
            }
            if (message.request.equals("ExpiredTimer")) {
                this.processExpiredTimer();
            } else if (message.request.equals("DirectConnect")) {
                message.responseStatus = this.processOpenDirectConnect(message.controller);
            } else if (message.request.equals("OpenLink")) {
                message.responseStatus = this.processOpenLink(1, message.payload, message.controller, message.argument0);
            } else if (message.request.equals("CloseLink")) {
                System.out.println("was told to close link");
                this.processCloseLink(true);
            } else if (message.request.equals("ControllerCount")) {
                message.responseStatus = this.processGetControllerCount();
            } else if (message.request.equals("ResetLink")) {
                this.processInternalResetLink();
            } else if (message.request.equals("Reconnect")) {
                System.out.println("was told to reconnect link");
                this.processCloseLink(false);
                this.goToSleep(1000);
                if (CommLink.this.local && CommLink.this.ipAddress.equals("0.0.0.0")) {
                    this.processOpenDirectConnect(CommLink.this.controller);
                } else {
                    this.processOpenLink(2, CommLink.this.ipAddress, CommLink.this.controller, CommLink.this.serverPort);
                }
            } else if (message.request.equals("ScanDrive")) {
                this.processInternalScanDrive();
            } else if (message.request.equals("RemoveDrive")) {
                this.processInternalRemoveDrive(message);
            }
            if (message.callBackValid) {
                System.out.println("CommLink: processInternalMessage(): callBack is being invoked for request: " + message.request);
                message.callBackMailBox.putMessage(message);
            }
        }

        private void processInternalRemoveDrive(Message message) {
            System.out.println("Removing drive");
            int pathId = message.argument0;
            int targetId = message.argument1;
            CommLink.this.ideCommPort.RemoveDrive(message.controller, pathId, targetId);
        }

        private void processInternalResetLink() {
            System.out.println("Resetting the link");
            int closingLinkState = CommLink.this.linkState;
            this.processCloseLink(false);
            this.goToSleep(1000);
            if (closingLinkState == 4) {
                this.processOpenLink(1, CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            } else {
                this.processOpenLink(2, CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            }
        }

        private void processInternalScanDrive() {
            System.out.println("Scanning drive");
            CommLink.this.ideCommPort.ScanDrive();
        }

        private void processMessageResponse(String resp, Message message) {
            message.mailSort = 2;
            message.payload = resp;
            if (CommLink.this.logFileName != null) {
                int offset = resp.indexOf("<env:Body>");
                if (offset == -1) {
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: **** ERROR: <env:Body> not found");
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: " + resp);
                } else {
                    ApplicationLog.put(CommLink.this.logFileName, "Rcvd: " + resp.substring(offset, resp.length()));
                }
            }
            CommLink.this.commQueue.putMessage(message);
        }

        private int processOpenDirectConnect(int controller) {
            int returnStatus = 0;
            String openedLocal = "CommLink: successfully opened local connection";
            String failedLocal = "CommLink: failed to open local connection";
            CommLink.this.preserveCurrentState();
            CommLink.this.ideCommPort.directConnect();
            if (this.validateConnection()) {
                ApplicationLog.put(openedLocal);
                System.out.println(openedLocal);
                CommLink.this.commManager.linkStatusChange(null, null);
                this.establishConnection(0, controller);
            } else {
                ApplicationLog.put(failedLocal);
                System.out.println(failedLocal);
                CommLink.this.recoverPreviousState();
                returnStatus = 2;
            }
            return returnStatus;
        }

        private int processOpenEthernetLink(String ipAddress, int controller, int serverPort) {
            int returnStatus = 0;
            String openedSocket = "CommLink: successfully opened socket to ";
            String failedSocket = "CommLink: failed to open socket to ";
            if (CommLink.this.ideCommPort.netConnect(ipAddress, serverPort)) {
                if (this.validateConnection()) {
                    ApplicationLog.put(openedSocket + ipAddress);
                    System.out.println(openedSocket + ipAddress);
                    CommLink.this.offlineStatus = CommLink.this.linkState == 2 ? "Attempting to reconnect to controller..." : "Attempting connection to controller...";
                    CommLink.this.linkState = 4;
                    CommLink.this.offlineDetails = " ";
                    CommLink.this.commManager.linkStatusChange(null, null);
                    this.establishConnection(1, controller);
                } else {
                    returnStatus = 2;
                }
            } else {
                CommLink.this.lastError = CommLink.this.ideCommPort.getErrorLog();
                ApplicationLog.put(failedSocket + CommLink.this.newIpAddress + ".\nReturned error: " + CommLink.this.lastError);
                System.out.println(failedSocket + CommLink.this.newIpAddress + ".\nReturned error: " + CommLink.this.lastError);
                returnStatus = 1;
            }
            return returnStatus;
        }

        private int processOpenLink(int state, String ipAddress, int controller, int serverPort) {
            String type = "connection...";
            CommLink.this.preserveCurrentState();
            CommLink.this.offlineStatus = state == 2 ? "Attempting to reopen " + CommLink.this.connectionType + " " + type : "Attempting to open " + CommLink.this.connectionType + " " + type;
            CommLink.this.offlineDetails = " ";
            CommLink.this.linkState = state;
            CommLink.this.newIpAddress = ipAddress;
            CommLink.this.newController = controller;
            CommLink.this.newServerPort = serverPort;
            CommLink.this.commManager.linkStatusChange(null, null);
            this.timer.start();
            int retStatus = this.processOpenEthernetLink(CommLink.this.newIpAddress, CommLink.this.newController, CommLink.this.newServerPort);
            if (retStatus != 0) {
                this.timer.stop();
                CommLink.this.recoverPreviousState();
            }
            return retStatus;
        }

        private void processOutgoingMessage(Message message) {
            this.waitingToSendList.add(message);
            if (this.waitingToSendList.size() == 1 && this.sentList.size() < 4) {
                message = (Message)this.waitingToSendList.remove(0);
                message.tag = Integer.toString(CommLink.this.tag++);
                message.ticker = 0;
                this.sentList.add(message);
                this.transmitMessage(message);
            }
        }

        private void processRemoteInput() {
            CommLink.this.eventEmail = EventEmail.getEventEmail();
            EventEmail cfr_ignored_0 = CommLink.this.eventEmail;
            String resp = EventEmail.Receive(" ", "");
            if (resp != null) {
                this.processMessageResponse(resp, new Message());
            }
        }

        public void run() {
            while (true) {
                if (!DatabaseManager.RemoteAccessAllowed && DatabaseManager.RemoteAccessWanted) {
                    this.processRemoteInput();
                    continue;
                }
                Message message = (Message)CommLink.this.commQueue.getMessage(true);
                if (message.mailSort == 3) {
                    this.processInternalMessage(message);
                    continue;
                }
                if (message.mailSort == 1) {
                    this.processOutgoingMessage(message);
                    continue;
                }
                if (message.mailSort == 2) {
                    this.processIncomingMessage(message);
                    continue;
                }
                System.out.println("CommLink: Invalid Mail Sort Indicator: " + message.mailSort);
            }
        }

        private void transmitMessage(Message message) {
            String header = "<env:Header><si:Reference>" + message.tag + "</si:Reference>" + "<si:Direction>Request</si:Direction>" + "<si:Action>" + message.action + "</si:Action>" + "</env:Header>";
            String xmlMessage = "<?xml version='1.0' ?><env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\" env:encodingStyle=\"http://www.w3.org/2003/05/soap-encoding\" si=\"http://www.siliconimage.com\">" + header + "<env:Body>" + message.request + "</env:Body></env:Envelope>";
            try {
                int offset;
                if (CommLink.this.logFileName != null) {
                    offset = xmlMessage.indexOf("<env:Body>");
                    ApplicationLog.put(CommLink.this.logFileName, "Sent: " + xmlMessage.substring(offset, xmlMessage.length()));
                }
                offset = xmlMessage.indexOf("<env:Body>");
                System.out.println("Sent:" + xmlMessage.substring(offset, xmlMessage.length()));
                String resp = CommLink.this.ideCommPort.exchange(message.controller, xmlMessage);
                if (resp == null || resp.equals("")) {
                    CommLink.this.lastError = CommLink.this.ideCommPort.getErrorLog();
                    if (CommLink.this.lastError == null || CommLink.this.lastError.equals("")) {
                        JOptionPane.showMessageDialog(null, "Error was reported from the transport layer, and the error description could not be retrieved!\nMessage was lost.", "Double Error", 0);
                        CommLink.this.lastError = "";
                    } else {
                        JOptionPane.showMessageDialog(null, "Error was reported from the transport layer!\nError description:\n" + CommLink.this.lastError + "\nMessage was lost.", "Error", 0);
                    }
                    Message newMessage = (Message)this.sentList.remove(0);
                    return;
                }
                int offset2 = resp.indexOf("<env:Body>");
                if (offset2 == -1) {
                    System.out.println("Rcvd: **** ERROR: <env:Body> not found");
                    System.out.println("Rcvd: " + resp);
                } else {
                    System.out.println("Rcvd: " + resp.substring(offset2, resp.length()));
                }
                this.NewXMLLine = resp + "\n";
                try {
                    this.outputStream = new FileOutputStream(this.XMLLogFile);
                    this.outputStream.write(this.NewXMLLine.getBytes());
                    this.outputStream.close();
                }
                catch (Exception e) {
                    ErrorLog.put(e, "CommLink: transmitMessage(): Failed writing session file");
                    System.out.println("CommLink: transmitMessage(): Failed writing session file");
                }
                if (DatabaseManager.RemoteAccessAllowed) {
                    CommLink.this.eventEmail = EventEmail.getEventEmail();
                    EventEmail cfr_ignored_0 = CommLink.this.eventEmail;
                    EventEmail.Send(resp);
                }
                Message newMessage = (Message)this.sentList.remove(0);
                this.processMessageResponse(resp, newMessage);
            }
            catch (Exception exception) {
                if (message != null) {
                    ErrorLog.put(exception, "Message Received: " + message.response);
                }
                ErrorLog.put(exception, "");
            }
        }

        private boolean validateConnection() {
            String noControllers = "CommLink: no controllers found on the opened link";
            CommLink.this.newControllerCount = CommLink.this.ideCommPort.getHandleCount();
            if (CommLink.this.newControllerCount == 0) {
                ApplicationLog.put(noControllers);
                System.out.println(noControllers);
                return false;
            }
            return true;
        }
    }
}

