/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdvancedOptionsBox
extends KDialog
implements GlobalConstants {
    private JPanel borderPanel;
    private JCheckBox deleteMemberCheckBox;
    private boolean initialDeleteMember;
    private boolean initialLegacySupport;
    private boolean initialResourceInfo;
    private JCheckBox legacySupportCheckBox;
    private JButton okButton;
    private JCheckBox resourceInfoCheckBox;

    public AdvancedOptionsBox(DatabaseManager databaseManager, String title) {
        this.beginDialogInit(databaseManager, title, true);
        this.initialLegacySupport = this.storageManagementUtility.legacySupportOption;
        this.initialDeleteMember = this.storageManagementUtility.deleteMemberOption;
        this.initialResourceInfo = this.storageManagementUtility.resourceInfoOption;
        this.getContentPane().add((Component)this.buildOptionsPanel(), "North");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        this.okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        this.okButton.setMnemonic(79);
        cancelButton.setMnemonic(67);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsBox.this.storageManagementUtility.legacySupportOption = AdvancedOptionsBox.this.initialLegacySupport;
                AdvancedOptionsBox.this.storageManagementUtility.deleteMemberOption = AdvancedOptionsBox.this.initialDeleteMember;
                AdvancedOptionsBox.this.storageManagementUtility.resourceInfoOption = AdvancedOptionsBox.this.initialResourceInfo;
                AdvancedOptionsBox.this.closeDialog();
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected JPanel buildOptionsPanel() {
        JPanel compoundPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        compoundPanel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.legacySupportCheckBox = new JCheckBox("", this.initialLegacySupport);
        this.deleteMemberCheckBox = new JCheckBox("", this.initialDeleteMember);
        this.resourceInfoCheckBox = new JCheckBox("", this.initialResourceInfo);
        Utility.addComponent(this.legacySupportCheckBox, compoundPanel, layout, constraints, 0, 0, 0, 0, 8, 8, 0.0);
        Utility.addComponent(new JLabel("Legacy (Bootable) Support"), compoundPanel, layout, constraints, 1, 0, 0, 9, 8, 8, 1.0);
        Utility.addComponent(this.deleteMemberCheckBox, compoundPanel, layout, constraints, 0, 1, 0, 0, 8, 8, 0.0);
        Utility.addComponent(new JLabel("Delete Member Support"), compoundPanel, layout, constraints, 1, 1, 0, 9, 8, 8, 1.0);
        Utility.addComponent(this.resourceInfoCheckBox, compoundPanel, layout, constraints, 0, 2, 0, 0, 8, 8, 0.0);
        Utility.addComponent(new JLabel("Resources Info Support"), compoundPanel, layout, constraints, 1, 2, 0, 9, 8, 8, 1.0);
        Dimension dimension = this.legacySupportCheckBox.getPreferredSize();
        this.legacySupportCheckBox.setPreferredSize(dimension);
        this.deleteMemberCheckBox.setPreferredSize(dimension);
        this.resourceInfoCheckBox.setPreferredSize(dimension);
        compoundPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Advanced Options"));
        this.borderPanel = new JPanel();
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.borderPanel.add(compoundPanel);
        this.legacySupportCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsBox.this.storageManagementUtility.legacySupportOption = AdvancedOptionsBox.this.legacySupportCheckBox.isSelected();
            }
        });
        this.deleteMemberCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsBox.this.storageManagementUtility.deleteMemberOption = AdvancedOptionsBox.this.deleteMemberCheckBox.isSelected();
            }
        });
        this.resourceInfoCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsBox.this.storageManagementUtility.resourceInfoOption = AdvancedOptionsBox.this.resourceInfoCheckBox.isSelected();
            }
        });
        return this.borderPanel;
    }

    protected void closeDialog() {
        System.out.println("closeDialog");
        this.dispose();
    }
}

